/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2023-04-25 17:28:54 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `bd_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bd_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bd_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

CREATE TABLE `bd_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bd_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=2579 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bd_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=398 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bd_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=85 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bd_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bd_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bd_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bd_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bd_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bd_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bd_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT '0',
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wfblocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  `expiration` bigint(20) unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `real_path` text NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wfhits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT '0',
  `statusCode` int(11) NOT NULL DEFAULT '200',
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wfhoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wfissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wfknownfilelist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `wordpress_path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wflogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wfls_2fa_secrets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `vtime` int(10) unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=MEMORY DEFAULT CHARSET=latin1;

CREATE TABLE `bd_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '1000',
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wfpendingissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wfsnipcache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wfstatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bd_wftrafficrates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bdp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bdp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bdp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bdp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=7974 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bdp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=209 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bdp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bdp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bdp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bdp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bdp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bdp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `bdp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: bd_duplicator_packages */
INSERT INTO `bd_duplicator_packages` VALUES("5", "20230425_locationdevoituredeluxe", "bba81e9323c55ed48825_20230425172801", "-1", "2023-04-25 17:28:11", "us88766765323", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-04-25 17:28:01\";s:7:\"Version\";s:7:\"1.5.3.1\";s:9:\"VersionWP\";s:3:\"6.2\";s:9:\"VersionDB\";s:6:\"5.7.41\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:5;s:4:\"Name\";s:32:\"20230425_locationdevoituredeluxe\";s:4:\"Hash\";s:35:\"bba81e9323c55ed48825_20230425172801\";s:8:\"NameHash\";s:68:\"20230425_locationdevoituredeluxe_bba81e9323c55ed48825_20230425172801\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:78:\"20230425_locationdevoituredeluxe_bba81e9323c55ed48825_20230425172801_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"-1.0\";s:6:\"WPUser\";s:13:\"us88766765323\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:80:\"20230425_locationdevoituredeluxe_bba81e9323c55ed48825_20230425172801_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:18:\"/home/jrmaour/test\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:623;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:4488;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-04-25 17:28:01\";s:7:\"Version\";s:7:\"1.5.3.1\";s:9:\"VersionWP\";s:3:\"6.2\";s:9:\"VersionDB\";s:6:\"5.7.41\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:32:\"20230425_locationdevoituredeluxe\";s:4:\"Hash\";s:35:\"bba81e9323c55ed48825_20230425172801\";s:8:\"NameHash\";s:68:\"20230425_locationdevoituredeluxe_bba81e9323c55ed48825_20230425172801\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:86:\"20230425_locationdevoituredeluxe_bba81e9323c55ed48825_20230425172801_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:32:\"/home/jrmaour/test/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:81:\"20230425_locationdevoituredeluxe_bba81e9323c55ed48825_20230425172801_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:18:\"varLowerCaseTables\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:132:\"/home/jrmaour/test/wp-content/backups-dup-lite/tmp/20230425_locationdevoituredeluxe_bba81e9323c55ed48825_20230425172801_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:27:\"/home/jrmaour/test/wp-admin\";i:1;s:30:\"/home/jrmaour/test/wp-includes\";i:2;s:39:\"/home/jrmaour/test/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:18:\"/home/jrmaour/test\";i:1;s:18:\"/home/jrmaour/test\";i:2;s:29:\"/home/jrmaour/test/wp-content\";i:3;s:37:\"/home/jrmaour/test/wp-content/uploads\";i:4;s:37:\"/home/jrmaour/test/wp-content/plugins\";i:5;s:40:\"/home/jrmaour/test/wp-content/mu-plugins\";i:6;s:36:\"/home/jrmaour/test/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:50:\"/home/jrmaour/test/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");
INSERT INTO `bd_duplicator_packages` VALUES("6", "20230425_locationdevoituredeluxe", "be689cc76328c5568622_20230425172839", "20", "2023-04-25 17:28:53", "us88766765323", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-04-25 17:28:39\";s:7:\"Version\";s:7:\"1.5.3.1\";s:9:\"VersionWP\";s:3:\"6.2\";s:9:\"VersionDB\";s:6:\"5.7.41\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:6;s:4:\"Name\";s:32:\"20230425_locationdevoituredeluxe\";s:4:\"Hash\";s:35:\"be689cc76328c5568622_20230425172839\";s:8:\"NameHash\";s:68:\"20230425_locationdevoituredeluxe_be689cc76328c5568622_20230425172839\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:78:\"20230425_locationdevoituredeluxe_be689cc76328c5568622_20230425172839_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.4\";s:6:\"WPUser\";s:13:\"us88766765323\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:80:\"20230425_locationdevoituredeluxe_be689cc76328c5568622_20230425172839_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:18:\"/home/jrmaour/test\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:623;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:4488;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-04-25 17:28:39\";s:7:\"Version\";s:7:\"1.5.3.1\";s:9:\"VersionWP\";s:3:\"6.2\";s:9:\"VersionDB\";s:6:\"5.7.41\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:32:\"20230425_locationdevoituredeluxe\";s:4:\"Hash\";s:35:\"be689cc76328c5568622_20230425172839\";s:8:\"NameHash\";s:68:\"20230425_locationdevoituredeluxe_be689cc76328c5568622_20230425172839\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:86:\"20230425_locationdevoituredeluxe_be689cc76328c5568622_20230425172839_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:32:\"/home/jrmaour/test/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:81:\"20230425_locationdevoituredeluxe_be689cc76328c5568622_20230425172839_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:18:\"varLowerCaseTables\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:132:\"/home/jrmaour/test/wp-content/backups-dup-lite/tmp/20230425_locationdevoituredeluxe_be689cc76328c5568622_20230425172839_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:27:\"/home/jrmaour/test/wp-admin\";i:1;s:30:\"/home/jrmaour/test/wp-includes\";i:2;s:39:\"/home/jrmaour/test/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:18:\"/home/jrmaour/test\";i:1;s:18:\"/home/jrmaour/test\";i:2;s:29:\"/home/jrmaour/test/wp-content\";i:3;s:37:\"/home/jrmaour/test/wp-content/uploads\";i:4;s:37:\"/home/jrmaour/test/wp-content/plugins\";i:5;s:40:\"/home/jrmaour/test/wp-content/mu-plugins\";i:6;s:36:\"/home/jrmaour/test/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:50:\"/home/jrmaour/test/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: bd_options */
INSERT INTO `bd_options` VALUES("1", "siteurl", "http://yomi-avis.fr/", "yes");
INSERT INTO `bd_options` VALUES("2", "home", "https://yomi-avis.fr", "yes");
INSERT INTO `bd_options` VALUES("3", "blogname", "Location de voiture de luxe", "yes");
INSERT INTO `bd_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `bd_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `bd_options` VALUES("6", "admin_email", "webclient.locationluxe@gmail.com", "yes");
INSERT INTO `bd_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `bd_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `bd_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `bd_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `bd_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `bd_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `bd_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `bd_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `bd_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `bd_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `bd_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `bd_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `bd_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `bd_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `bd_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `bd_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `bd_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `bd_options` VALUES("24", "time_format", "G\\hi", "yes");
INSERT INTO `bd_options` VALUES("25", "links_updated_date_format", "d F Y G\\hi", "yes");
INSERT INTO `bd_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `bd_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `bd_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `bd_options` VALUES("29", "rewrite_rules", "a:119:{s:10:\"voiture/?$\";s:27:\"index.php?post_type=voiture\";s:40:\"voiture/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=voiture&feed=$matches[1]\";s:35:\"voiture/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=voiture&feed=$matches[1]\";s:27:\"voiture/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=voiture&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:35:\"voiture/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"voiture/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"voiture/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"voiture/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"voiture/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"voiture/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"voiture/([^/]+)/embed/?$\";s:40:\"index.php?voiture=$matches[1]&embed=true\";s:28:\"voiture/([^/]+)/trackback/?$\";s:34:\"index.php?voiture=$matches[1]&tb=1\";s:48:\"voiture/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?voiture=$matches[1]&feed=$matches[2]\";s:43:\"voiture/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?voiture=$matches[1]&feed=$matches[2]\";s:36:\"voiture/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?voiture=$matches[1]&paged=$matches[2]\";s:43:\"voiture/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?voiture=$matches[1]&cpage=$matches[2]\";s:32:\"voiture/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?voiture=$matches[1]&page=$matches[2]\";s:24:\"voiture/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"voiture/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"voiture/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"voiture/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"voiture/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"voiture/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `bd_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `bd_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `bd_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `bd_options` VALUES("33", "active_plugins", "a:3:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:25:\"duplicator/duplicator.php\";i:3;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";}", "yes");
INSERT INTO `bd_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `bd_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `bd_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `bd_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `bd_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `bd_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `bd_options` VALUES("40", "template", "theme location luxe/location-de-voiture-de-luxe", "yes");
INSERT INTO `bd_options` VALUES("41", "stylesheet", "theme location luxe/location-de-voiture-de-luxe", "yes");
INSERT INTO `bd_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `bd_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `bd_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `bd_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `bd_options` VALUES("46", "db_version", "53496", "yes");
INSERT INTO `bd_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `bd_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `bd_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `bd_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `bd_options` VALUES("51", "show_on_front", "posts", "yes");
INSERT INTO `bd_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `bd_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `bd_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `bd_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `bd_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `bd_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `bd_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `bd_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `bd_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `bd_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `bd_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `bd_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `bd_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `bd_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `bd_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `bd_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `bd_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `bd_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `bd_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `bd_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `bd_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `bd_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `bd_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `bd_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `bd_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bd_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bd_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bd_options` VALUES("79", "uninstall_plugins", "a:1:{s:39:\"copy-delete-posts/copy-delete-posts.php\";a:2:{i:0;s:15:\"Account\\Account\";i:1;s:25:\"onUninstallPluginListener\";}}", "no");
INSERT INTO `bd_options` VALUES("80", "timezone_string", "Europe/Paris", "yes");
INSERT INTO `bd_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `bd_options` VALUES("82", "page_on_front", "0", "yes");
INSERT INTO `bd_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `bd_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `bd_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `bd_options` VALUES("86", "site_icon", "69", "yes");
INSERT INTO `bd_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `bd_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `bd_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `bd_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `bd_options` VALUES("91", "admin_email_lifespan", "1689792655", "yes");
INSERT INTO `bd_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `bd_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `bd_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `bd_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `bd_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `bd_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `bd_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `bd_options` VALUES("99", "initial_db_version", "53496", "yes");
INSERT INTO `bd_options` VALUES("100", "bd_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:65:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:15:\"manage_security\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `bd_options` VALUES("101", "fresh_site", "0", "yes");
INSERT INTO `bd_options` VALUES("102", "WPLANG", "fr_FR", "yes");
INSERT INTO `bd_options` VALUES("103", "user_count", "1", "no");
INSERT INTO `bd_options` VALUES("104", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Articles récents</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:233:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Commentaires récents</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:151:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Catégories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bd_options` VALUES("105", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `bd_options` VALUES("106", "cron", "a:11:{i:1682443919;a:2:{s:20:\"rsssl_every_day_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"rsssl_daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:29:\"rsssl_every_five_minutes_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:18:\"rsssl_five_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1682445056;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1682448656;a:5:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1682448662;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1682448663;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1682450607;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1682450639;a:1:{s:24:\"jp_purge_transients_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1682794256;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1682962319;a:1:{s:21:\"rsssl_every_week_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:12:\"rsssl_weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1683573954;a:1:{s:28:\"jetpack_recommend_videopress\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `bd_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bd_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bd_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bd_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bd_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bd_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bd_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bd_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bd_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bd_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bd_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bd_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bd_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bd_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bd_options` VALUES("124", "theme_mods_twentytwentythree", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1674243715;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "yes");
INSERT INTO `bd_options` VALUES("127", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `bd_options` VALUES("128", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `bd_options` VALUES("146", "can_compress_scripts", "0", "no");
INSERT INTO `bd_options` VALUES("165", "finished_updating_comment_type", "1", "yes");
INSERT INTO `bd_options` VALUES("168", "current_theme", "location de voiture", "yes");
INSERT INTO `bd_options` VALUES("169", "theme_mods_mngt-wp-theme-v4-mtp-clientcom-v2", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1674243782;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "yes");
INSERT INTO `bd_options` VALUES("170", "theme_switched", "", "yes");
INSERT INTO `bd_options` VALUES("173", "category_children", "a:0:{}", "yes");
INSERT INTO `bd_options` VALUES("175", "theme_mods_theme mngt-MODIFABLE - Copie/mngt-wp-theme-v4-mtp", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1676054856;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "yes");
INSERT INTO `bd_options` VALUES("176", "recovery_mode_email_last_sent", "1676058279", "yes");
INSERT INTO `bd_options` VALUES("185", "recently_activated", "a:3:{s:19:\"jetpack/jetpack.php\";i:1682364486;s:23:\"wordfence/wordfence.php\";i:1682364146;s:16:\"gotmls/index.php\";i:1682363554;}", "yes");
INSERT INTO `bd_options` VALUES("188", "auto_update_plugins", "a:3:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:2;s:25:\"duplicator/duplicator.php\";}", "no");
INSERT INTO `bd_options` VALUES("189", "acf_version", "6.1.4", "yes");
INSERT INTO `bd_options` VALUES("190", "rsssl_activated_plugin", "1", "yes");
INSERT INTO `bd_options` VALUES("191", "rlrsssl_options", "a:16:{s:12:\"site_has_ssl\";b:1;s:4:\"hsts\";b:0;s:22:\"htaccess_warning_shown\";b:0;s:19:\"review_notice_shown\";b:0;s:25:\"ssl_success_message_shown\";b:0;s:26:\"autoreplace_insecure_links\";b:1;s:17:\"plugin_db_version\";s:5:\"5.3.1\";s:20:\"do_not_edit_htaccess\";b:0;s:17:\"htaccess_redirect\";b:0;s:11:\"ssl_enabled\";b:1;s:19:\"javascript_redirect\";b:0;s:11:\"wp_redirect\";b:1;s:31:\"switch_mixed_content_fixer_hook\";b:0;s:19:\"dismiss_all_notices\";b:0;s:13:\"high_contrast\";b:0;s:21:\"dismiss_review_notice\";b:0;}", "yes");
INSERT INTO `bd_options` VALUES("192", "rsssl_remaining_tasks", "1", "yes");
INSERT INTO `bd_options` VALUES("203", "rsssl_current_version", "6.2.4", "no");
INSERT INTO `bd_options` VALUES("206", "https_migration_required", "1", "yes");
INSERT INTO `bd_options` VALUES("207", "rsssl_activation_timestamp", "1682364659", "no");
INSERT INTO `bd_options` VALUES("218", "rsssl_port_check_2082", "fail", "yes");
INSERT INTO `bd_options` VALUES("219", "rsssl_port_check_8443", "fail", "yes");
INSERT INTO `bd_options` VALUES("220", "rsssl_port_check_2222", "fail", "yes");
INSERT INTO `bd_options` VALUES("240", "analyst_cache", "s:6:\"a:0:{}\";", "yes");
INSERT INTO `bd_options` VALUES("242", "_cdp_review", "a:2:{s:9:\"installed\";i:1674244877;s:5:\"users\";a:0:{}}", "yes");
INSERT INTO `bd_options` VALUES("243", "_cdp_globals", "a:1:{s:6:\"others\";a:14:{s:17:\"cdp-content-pages\";s:4:\"true\";s:17:\"cdp-content-posts\";s:4:\"true\";s:18:\"cdp-content-custom\";s:4:\"true\";s:17:\"cdp-display-posts\";s:4:\"true\";s:16:\"cdp-display-edit\";s:4:\"true\";s:17:\"cdp-display-admin\";s:4:\"true\";s:16:\"cdp-display-bulk\";s:4:\"true\";s:21:\"cdp-display-gutenberg\";s:4:\"true\";s:19:\"cdp-references-post\";s:5:\"false\";s:19:\"cdp-references-edit\";s:5:\"false\";s:18:\"cdp-premium-import\";s:5:\"false\";s:24:\"cdp-premium-hide-tooltip\";s:5:\"false\";s:26:\"cdp-premium-replace-domain\";s:5:\"false\";s:20:\"cdp-menu-in-settings\";s:5:\"false\";}}", "yes");
INSERT INTO `bd_options` VALUES("244", "_cdp_profiles", "a:1:{s:7:\"default\";a:25:{s:5:\"title\";s:4:\"true\";s:4:\"date\";s:5:\"false\";s:6:\"status\";s:5:\"false\";s:4:\"slug\";s:4:\"true\";s:7:\"excerpt\";s:4:\"true\";s:7:\"content\";s:4:\"true\";s:7:\"f_image\";s:4:\"true\";s:8:\"template\";s:4:\"true\";s:6:\"format\";s:4:\"true\";s:6:\"author\";s:4:\"true\";s:8:\"password\";s:4:\"true\";s:11:\"attachments\";s:5:\"false\";s:8:\"children\";s:5:\"false\";s:8:\"comments\";s:5:\"false\";s:10:\"menu_order\";s:4:\"true\";s:8:\"category\";s:4:\"true\";s:8:\"post_tag\";s:4:\"true\";s:8:\"taxonomy\";s:4:\"true\";s:8:\"nav_menu\";s:4:\"true\";s:13:\"link_category\";s:4:\"true\";s:12:\"all_metadata\";s:5:\"false\";s:5:\"names\";a:5:{s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:10:\"#[Counter]\";s:6:\"format\";s:1:\"1\";s:6:\"custom\";s:5:\"m/d/Y\";s:7:\"display\";s:7:\"Default\";}s:9:\"usmplugin\";s:5:\"false\";s:5:\"yoast\";s:5:\"false\";s:3:\"woo\";s:5:\"false\";}}", "yes");
INSERT INTO `bd_options` VALUES("245", "_cdp_default_setup", "1", "yes");
INSERT INTO `bd_options` VALUES("246", "_irb_h_bn_review", "a:2:{s:5:\"users\";a:0:{}s:17:\"copy-delete-posts\";i:1674244877;}", "yes");
INSERT INTO `bd_options` VALUES("247", "_cdp_preselections", "a:1:{i:1;s:7:\"default\";}", "yes");
INSERT INTO `bd_options` VALUES("249", "cdp_copy_logs_times", "a:1:{i:0;a:6:{s:6:\"amount\";s:1:\"1\";s:4:\"time\";d:0.03424715995788574;s:6:\"perOne\";d:0.03424715995788574;s:4:\"data\";i:1674244901;s:6:\"memory\";i:39889488;s:4:\"peak\";i:2097152;}}", "yes");
INSERT INTO `bd_options` VALUES("285", "rsssl_show_onboarding", "1", "no");
INSERT INTO `bd_options` VALUES("286", "rsssl_options", "a:19:{s:11:\"ssl_enabled\";b:1;s:19:\"mixed_content_fixer\";b:1;s:8:\"redirect\";s:11:\"wp_redirect\";s:20:\"do_not_edit_htaccess\";b:0;s:19:\"dismiss_all_notices\";b:0;s:31:\"switch_mixed_content_fixer_hook\";b:0;s:12:\"site_has_ssl\";s:1:\"1\";s:24:\"send_notifications_email\";i:1;s:19:\"review_notice_shown\";s:1:\"1\";s:20:\"disable_file_editing\";i:1;s:28:\"block_code_execution_uploads\";i:1;s:22:\"hide_wordpress_version\";i:1;s:22:\"disable_login_feedback\";i:1;s:16:\"disable_indexing\";i:1;s:24:\"disable_user_enumeration\";i:1;s:17:\"rename_admin_user\";i:1;s:14:\"disable_xmlrpc\";i:1;s:22:\"block_display_is_login\";i:1;s:13:\"include_alias\";i:1;}", "yes");
INSERT INTO `bd_options` VALUES("1092", "theme_mods_theme mngt-MODIFABLE - Copie/location-de-voiture-de-luxe", "a:18:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:11:\"custom_logo\";i:43;s:29:\"mon_thème_couleur_principale\";s:7:\"#eeee22\";s:16:\"header_textcolor\";s:6:\"eeee22\";s:29:\"mon_thème_couleur_secondaire\";s:7:\"#1e73be\";s:28:\"mon_thème_couleur_tertiaire\";s:7:\"#dd3333\";s:28:\"mon_theme_couleur_principale\";s:7:\"#2453e2\";s:18:\"ma_image_de_fond_1\";s:57:\"http://yomi-avis.fr/wp-content/uploads/2023/02/cla-bg.jpg\";s:28:\"mon_theme_couleur_secondaire\";s:7:\"#a5319e\";s:18:\"ma_image_de_fond_2\";s:59:\"http://yomi-avis.fr/wp-content/uploads/2023/02/cla-bg-2.jpg\";s:13:\"villenamelong\";s:8:\"à Paris\";s:14:\"villenamecourt\";s:5:\"Paris\";s:8:\"snaplink\";s:0:\"\";s:8:\"snapmenu\";s:10:\"bdprestige\";s:27:\"mon_theme_couleur_tertiaire\";s:7:\"#e27f34\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1682358588;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "yes");
INSERT INTO `bd_options` VALUES("1519", "analyst_accounts_data", "s:400:\"O:26:\"Account\\AccountDataFactory\":1:{s:11:\"\0*\0accounts\";a:1:{i:0;O:19:\"Account\\AccountData\":7:{s:5:\"\0*\0id\";s:16:\"ovgxe3xq075ladbp\";s:9:\"\0*\0secret\";s:40:\"b4de5ed2ba7be687e233d152ec1e8fd116052ab0\";s:7:\"\0*\0path\";s:77:\"/home/jrmaour/test/wp-content/plugins/copy-delete-posts/copy-delete-posts.php\";s:14:\"\0*\0isInstalled\";b:0;s:12:\"\0*\0isOptedIn\";b:0;s:11:\"\0*\0isSigned\";b:0;s:20:\"\0*\0isInstallResolved\";N;}}}\";", "yes");
INSERT INTO `bd_options` VALUES("1533", "duplicator_version_plugin", "1.5.3.1", "yes");
INSERT INTO `bd_options` VALUES("1534", "duplicator_activated", "a:1:{s:4:\"lite\";i:1676563423;}", "yes");
INSERT INTO `bd_options` VALUES("2050", "duplicator_pro_exe_safe_mode", "0", "yes");
INSERT INTO `bd_options` VALUES("2051", "duplicator_activate_plugins_after_installation", "a:0:{}", "yes");
INSERT INTO `bd_options` VALUES("2053", "duplicator_migration_data", "{\n    \"time\": 1682357200,\n    \"installType\": -1,\n    \"restoreBackupMode\": false,\n    \"recoveryMode\": false,\n    \"archivePath\": \"\\/home\\/jrmaour\\/test\\/20230216_web_formation_v5_ff96e2f5c0b9e3fa3331_20230227150132_archive.zip\",\n    \"packageHash\": \"ff96e2f-27150132\",\n    \"installerPath\": \"\\/home\\/jrmaour\\/test\\/installer.php\",\n    \"installerBootLog\": \"\\/home\\/jrmaour\\/test\\/dup-installer-bootlog__85afd3a-27150132.txt\",\n    \"installerLog\": \"\\/home\\/jrmaour\\/test\\/dup-installer\\/dup-installer-log__85afd3a-27150132.txt\",\n    \"dupInstallerPath\": \"\\/home\\/jrmaour\\/test\\/dup-installer\",\n    \"origFileFolderPath\": \"\\/home\\/jrmaour\\/test\\/dup-installer\\/original_files_ff96e2f-27150132\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true\n}", "no");
INSERT INTO `bd_options` VALUES("2071", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:29:\"project.loc.contact@gmail.com\";s:7:\"version\";s:3:\"6.2\";s:9:\"timestamp\";i:1682357225;}", "no");
INSERT INTO `bd_options` VALUES("2072", "_site_transient_timeout_php_check_990bfacb848fa087bcfc06850f5e4447", "1682962026", "no");
INSERT INTO `bd_options` VALUES("2073", "_site_transient_php_check_990bfacb848fa087bcfc06850f5e4447", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "no");
INSERT INTO `bd_options` VALUES("2074", "_transient_health-check-site-status-result", "{\"good\":\"19\",\"recommended\":\"4\",\"critical\":\"0\"}", "yes");
INSERT INTO `bd_options` VALUES("2075", "duplicator_uninstall_package", "1", "yes");
INSERT INTO `bd_options` VALUES("2076", "duplicator_uninstall_settings", "1", "yes");
INSERT INTO `bd_options` VALUES("2077", "duplicator_settings", "a:19:{s:7:\"version\";s:7:\"1.5.3.1\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";s:1:\"0\";s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";s:1:\"0\";s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";s:1:\"2\";s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:6;i:0;b:0;s:12:\"last_updated\";s:19:\"2023-04-25-17-28-30\";s:18:\"package_ui_created\";s:1:\"1\";}", "yes");
INSERT INTO `bd_options` VALUES("2083", "rsssl_previous_version", "6.2.0", "no");
INSERT INTO `bd_options` VALUES("2089", "_transient_timeout_rsssl_curl_error", "1682443919", "no");
INSERT INTO `bd_options` VALUES("2090", "_transient_rsssl_curl_error", "cURL error 60: SSL: no alternative certificate subject name matches target host name \'yomi-avis.fr\'", "no");
INSERT INTO `bd_options` VALUES("2093", "_transient_timeout_rsssl_can_use_curl_headers_check", "1682962319", "no");
INSERT INTO `bd_options` VALUES("2094", "_transient_rsssl_can_use_curl_headers_check", "a:7:{i:0;s:25:\"Upgrade Insecure Requests\";i:1;s:16:\"X-XSS protection\";i:2;s:22:\"X-Content Type Options\";i:3;s:15:\"Referrer-Policy\";i:4;s:15:\"X-Frame-Options\";i:5;s:18:\"Permissions-Policy\";i:6;s:30:\"HTTP Strict Transport Security\";}", "no");
INSERT INTO `bd_options` VALUES("2100", "rsssl_6_notice_dismissed", "1", "no");
INSERT INTO `bd_options` VALUES("2107", "rsssl_last_tested_http_method", "19", "no");
INSERT INTO `bd_options` VALUES("2108", "rsssl_http_methods_allowed", "a:2:{s:11:\"not-allowed\";a:4:{i:0;s:3:\"GET\";i:1;s:4:\"POST\";i:2;s:3:\"PUT\";i:3;s:6:\"DELETE\";}s:7:\"allowed\";a:14:{i:0;s:4:\"HEAD\";i:1;s:7:\"OPTIONS\";i:2;s:7:\"CONNECT\";i:3;s:5:\"TRACE\";i:4;s:5:\"TRACK\";i:5;s:5:\"PATCH\";i:6;s:4:\"COPY\";i:7;s:4:\"LINK\";i:8;s:6:\"UNLINK\";i:9;s:5:\"PURGE\";i:10;s:4:\"LOCK\";i:11;s:6:\"UNLOCK\";i:12;s:8:\"PROPFIND\";i:13;s:4:\"VIEW\";}}", "no");
INSERT INTO `bd_options` VALUES("2111", "rsssl_onboarding_dismissed", "1", "no");
INSERT INTO `bd_options` VALUES("2120", "_site_transient_timeout_browser_d9c544d0aaddfd20c051a0811f2f382d", "1682963319", "no");
INSERT INTO `bd_options` VALUES("2121", "_site_transient_browser_d9c544d0aaddfd20c051a0811f2f382d", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"112.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `bd_options` VALUES("2135", "theme_mods_theme location luxe/location-de-voiture-de-luxe", "a:22:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:18:\"ma_image_de_fond_1\";s:57:\"http://yomi-avis.fr/wp-content/uploads/2023/02/cla-bg.jpg\";s:18:\"ma_image_de_fond_2\";s:59:\"http://yomi-avis.fr/wp-content/uploads/2023/02/cla-bg-2.jpg\";s:28:\"mon_theme_couleur_principale\";s:7:\"#81d742\";s:28:\"mon_theme_couleur_secondaire\";s:7:\"#1e73be\";s:27:\"mon_theme_couleur_tertiaire\";s:7:\"#dd9933\";s:10:\"nomsociete\";s:12:\"MOTORS INDUS\";s:13:\"villenamelong\";s:7:\"à Lyon\";s:14:\"villenamecourt\";s:4:\"Lyon\";s:9:\"numtela0e\";s:14:\"07 65 77 44 77\";s:8:\"numtels0\";s:9:\"765774477\";s:4:\"mail\";s:20:\"motorsindus@indus.fr\";s:8:\"snaplink\";s:0:\"\";s:8:\"snapname\";s:11:\"motorsindus\";s:8:\"snapmenu\";s:11:\"motorsindus\";s:9:\"instalink\";s:26:\"https://www.instagram.com/\";s:12:\"nom_director\";s:15:\"Cronou Henrique\";s:13:\"formjuridique\";s:3:\"SAS\";s:18:\"adressesiegesocial\";s:30:\"20 rue des chanisih LYON 69000\";s:13:\"selected_font\";s:7:\"Georgia\";}", "yes");
INSERT INTO `bd_options` VALUES("2140", "new_admin_email", "webclient.locationluxe@gmail.com", "yes");
INSERT INTO `bd_options` VALUES("2158", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1682373972", "no");
INSERT INTO `bd_options` VALUES("2159", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:6064;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4820;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2788;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2672;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2051;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1915;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1904;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1638;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1565;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1554;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1548;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1515;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1503;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1478;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1363;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1316;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1270;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1175;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1156;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1147;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:1051;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:1019;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:999;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:965;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:903;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:887;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:878;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:876;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:876;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:867;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:867;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:827;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:796;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:788;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:781;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:777;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:766;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:766;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:733;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:732;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:729;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:727;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:723;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:687;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:686;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:685;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:674;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:666;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:632;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:622;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:616;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:610;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:608;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:607;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:597;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:592;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:592;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:589;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:577;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:569;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:567;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:567;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:565;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:554;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:553;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:541;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:540;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:533;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:530;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:530;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:527;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:518;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:512;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:509;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:508;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:504;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:482;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:475;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:474;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:467;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:449;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:448;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:448;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:437;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:432;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:426;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:425;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:424;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:420;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:420;}s:7:\"gateway\";a:3:{s:4:\"name\";s:7:\"gateway\";s:4:\"slug\";s:7:\"gateway\";s:5:\"count\";i:420;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:419;}s:8:\"payments\";a:3:{s:4:\"name\";s:8:\"payments\";s:4:\"slug\";s:8:\"payments\";s:5:\"count\";i:417;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:412;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:406;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:398;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:395;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:394;}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";i:390;}s:8:\"checkout\";a:3:{s:4:\"name\";s:8:\"checkout\";s:4:\"slug\";s:8:\"checkout\";s:5:\"count\";i:390;}}", "no");
INSERT INTO `bd_options` VALUES("2165", "GOTMLS_settings_array", "a:11:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:28:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"svg\";i:9;s:4:\"webp\";i:10;s:3:\"doc\";i:11;s:4:\"docx\";i:12;s:3:\"ttf\";i:13;s:3:\"fla\";i:14;s:3:\"flv\";i:15;s:3:\"mov\";i:16;s:3:\"mp3\";i:17;s:3:\"pdf\";i:18;s:3:\"css\";i:19;s:3:\"pot\";i:20;s:2:\"po\";i:21;s:2:\"mo\";i:22;s:2:\"so\";i:23;s:3:\"exe\";i:24;s:3:\"zip\";i:25;s:2:\"7z\";i:26;s:2:\"gz\";i:27;s:3:\"rar\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:10:\"scan_level\";i:3;s:5:\"check\";a:1:{i:0;s:9:\"potential\";}s:10:\"dont_check\";a:0:{}s:15:\"skip_quarantine\";i:0;}", "yes");
INSERT INTO `bd_options` VALUES("2166", "GOTMLS_nonce_blob", "YToxOntzOjMyOiIyZjUwZWYxMjEwMDFjNGZhZDQzZWM5MDQ2YzE2MTkzOSI7aTo=NjczMjM7fQ3", "yes");
INSERT INTO `bd_options` VALUES("2167", "GOTMLS_scan_log/90.59.117.218/1682363323.5672", "a:2:{s:8:\"settings\";a:11:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:28:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"svg\";i:9;s:4:\"webp\";i:10;s:3:\"doc\";i:11;s:4:\"docx\";i:12;s:3:\"ttf\";i:13;s:3:\"fla\";i:14;s:3:\"flv\";i:15;s:3:\"mov\";i:16;s:3:\"mp3\";i:17;s:3:\"pdf\";i:18;s:3:\"css\";i:19;s:3:\"pot\";i:20;s:2:\"po\";i:21;s:2:\"mo\";i:22;s:2:\"so\";i:23;s:3:\"exe\";i:24;s:3:\"zip\";i:25;s:2:\"7z\";i:26;s:2:\"gz\";i:27;s:3:\"rar\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:10:\"scan_level\";i:3;s:5:\"check\";a:1:{i:0;s:9:\"potential\";}s:10:\"dont_check\";a:0:{}s:15:\"skip_quarantine\";i:0;}s:4:\"scan\";a:7:{s:3:\"dir\";s:18:\"/home/jrmaour/test\";s:5:\"start\";i:1682363323;s:4:\"type\";s:13:\"Complete Scan\";s:9:\"microtime\";d:115;s:7:\"percent\";i:-1;s:11:\"last_threat\";d:1682363438.717895;s:6:\"finish\";i:1682363438;}}", "yes");
INSERT INTO `bd_options` VALUES("2173", "wfls_last_role_change", "1682364069", "no");
INSERT INTO `bd_options` VALUES("2174", "wordfence_version", "7.9.2", "yes");
INSERT INTO `bd_options` VALUES("2175", "wordfence_case", "1", "yes");
INSERT INTO `bd_options` VALUES("2176", "wordfence_installed", "1", "yes");
INSERT INTO `bd_options` VALUES("2177", "wordfenceActivated", "0", "yes");
INSERT INTO `bd_options` VALUES("2178", "wf_plugin_act_error", "", "yes");
INSERT INTO `bd_options` VALUES("2182", "_transient_timeout_wfRegistrationToken", "1682450532", "no");
INSERT INTO `bd_options` VALUES("2183", "_transient_wfRegistrationToken", "lIY5IDuHw9cRNJe1ABtt5j8yU-ZH84IFAfTYpzsWE1k", "no");
INSERT INTO `bd_options` VALUES("2188", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:63:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.2.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:63:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.2.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:3:\"6.2\";s:7:\"version\";s:3:\"6.2\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1682405890;s:15:\"version_checked\";s:3:\"6.2\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `bd_options` VALUES("2189", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1682405890;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:3:{s:30:\"advanced-custom-fields/acf.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:36:\"w.org/plugins/advanced-custom-fields\";s:4:\"slug\";s:22:\"advanced-custom-fields\";s:6:\"plugin\";s:30:\"advanced-custom-fields/acf.php\";s:11:\"new_version\";s:5:\"6.1.4\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/advanced-custom-fields/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/advanced-custom-fields.6.1.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:75:\"https://ps.w.org/advanced-custom-fields/assets/icon-256x256.png?rev=1082746\";s:2:\"1x\";s:75:\"https://ps.w.org/advanced-custom-fields/assets/icon-128x128.png?rev=1082746\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:78:\"https://ps.w.org/advanced-custom-fields/assets/banner-1544x500.jpg?rev=2892919\";s:2:\"1x\";s:77:\"https://ps.w.org/advanced-custom-fields/assets/banner-772x250.jpg?rev=2892919\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.7\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:7:\"1.5.3.1\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/duplicator.1.5.3.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2605836\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2605835\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2085472\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:31:\"w.org/plugins/really-simple-ssl\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:6:\"plugin\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:11:\"new_version\";s:5:\"6.2.4\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/really-simple-ssl/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/really-simple-ssl.6.2.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-256x256.png?rev=2839720\";s:2:\"1x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-128x128.png?rev=2839720\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/really-simple-ssl/assets/banner-1544x500.png?rev=2810049\";s:2:\"1x\";s:72:\"https://ps.w.org/really-simple-ssl/assets/banner-772x250.png?rev=2810049\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.7\";}}s:7:\"checked\";a:3:{s:30:\"advanced-custom-fields/acf.php\";s:5:\"6.1.4\";s:25:\"duplicator/duplicator.php\";s:7:\"1.5.3.1\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:5:\"6.2.4\";}}", "no");
INSERT INTO `bd_options` VALUES("2190", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1682405890;s:7:\"checked\";a:1:{s:47:\"theme location luxe/location-de-voiture-de-luxe\";s:5:\"1.0.0\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:0:{}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `bd_options` VALUES("2197", "_transient_jetpack_autoloader_plugin_paths", "a:0:{}", "yes");
INSERT INTO `bd_options` VALUES("2198", "_transient_timeout_jetpack_file_data_12.0", "1684870009", "no");
INSERT INTO `bd_options` VALUES("2199", "_transient_jetpack_file_data_12.0", "a:1:{s:32:\"3fd340ad52927afb3bbb9e98575eccfd\";a:15:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:24:\"requires_user_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}}", "no");
INSERT INTO `bd_options` VALUES("2201", "jetpack_connection_active_plugins", "a:1:{s:7:\"jetpack\";a:1:{s:4:\"name\";s:7:\"Jetpack\";}}", "yes");
INSERT INTO `bd_options` VALUES("2203", "do_activate", "0", "yes");
INSERT INTO `bd_options` VALUES("2204", "_transient_timeout_jetpack_https_test", "1682450608", "no");
INSERT INTO `bd_options` VALUES("2205", "_transient_jetpack_https_test", "1", "no");
INSERT INTO `bd_options` VALUES("2206", "_transient_timeout_jetpack_https_test_message", "1682450608", "no");
INSERT INTO `bd_options` VALUES("2207", "_transient_jetpack_https_test_message", "", "no");
INSERT INTO `bd_options` VALUES("2213", "_transient_jetpack_assumed_site_creation_date", "2023-01-20 18:50:55", "yes");
INSERT INTO `bd_options` VALUES("2254", "jetpack_plugin_api_action_links", "a:3:{s:25:\"duplicator/duplicator.php\";a:1:{s:14:\"Upgrade to Pro\";s:124:\"https://snapcreek.com/lite-upgrade/?utm_medium=plugin-actions-link&utm_content=&utm_source=WordPress&utm_campaign=liteplugin\";}s:19:\"jetpack/jetpack.php\";a:2:{s:9:\"Réglages\";s:62:\"https://yomi-avis.fr/wp-admin/admin.php?page=jetpack#/settings\";s:7:\"Support\";s:61:\"https://yomi-avis.fr/wp-admin/admin.php?page=jetpack-debugger\";}s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";a:3:{s:43:\"Améliorez la sécurité - Mettez à niveau\";s:116:\"https://really-simple-ssl.com/pro/?mtm_campaign=notification&mtm_source=free&mtm_medium=settings&mtm_content=upgrade\";s:7:\"Support\";s:55:\"https://wordpress.org/support/plugin/really-simple-ssl/\";s:9:\"Réglages\";s:77:\"https://yomi-avis.fr/wp-admin/options-general.php?page=really-simple-security\";}}", "yes");
INSERT INTO `bd_options` VALUES("2255", "jetpack_search_plan_info", "a:3:{s:23:\"supports_instant_search\";b:0;s:28:\"supports_only_classic_search\";b:0;s:15:\"supports_search\";b:0;}", "yes");
INSERT INTO `bd_options` VALUES("2258", "_transient_timeout_jetpack_sync_dedicated_sync_spawn_check", "1682367826", "no");
INSERT INTO `bd_options` VALUES("2260", "_transient_jetpack_sync_dedicated_sync_spawn_check", "DEDICATED SYNC OK", "no");
INSERT INTO `bd_options` VALUES("2262", "jp_sync_last_success_immediate-send", "1682364358.5608", "no");
INSERT INTO `bd_options` VALUES("2277", "_transient_timeout_jetpack_is_single_user", "1682407426", "no");
INSERT INTO `bd_options` VALUES("2278", "_transient_jetpack_is_single_user", "1", "no");
INSERT INTO `bd_options` VALUES("2320", "jpsq_sync_checkout", "0:0", "no");
INSERT INTO `bd_options` VALUES("2322", "jp_sync_lock_full_sync", "", "no");
INSERT INTO `bd_options` VALUES("2325", "jp_sync_last_success_sync", "1682364389.7435", "no");
INSERT INTO `bd_options` VALUES("2327", "jp_sync_retry_after_immediate-send", "", "no");
INSERT INTO `bd_options` VALUES("2328", "jp_sync_error_log_immediate-send", "a:3:{s:15:\"1682364227.5696\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:24:\"concurrent_request_error\";a:1:{i:0;s:53:\"There is another request running for the same blog ID\";}}s:10:\"error_data\";a:1:{s:24:\"concurrent_request_error\";a:5:{s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Mon, 24 Apr 2023 19:23:47 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:8:\"x-hacker\";s:108:\"If you\'re reading this, you should visit automattic.com/jobs and apply to join the fun, mention this header.\";s:11:\"host-header\";s:13:\"WordPress.com\";s:11:\"retry-after\";s:1:\"5\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"x-ac\";s:17:\"4.cdg _dca BYPASS\";s:25:\"strict-transport-security\";s:16:\"max-age=31536000\";}s:4:\"body\";s:461:\"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<methodResponse>\n  <fault>\n    <value>\n      <struct>\n        <member>\n          <name>faultCode</name>\n          <value><int>400</int></value>\n        </member>\n        <member>\n          <name>faultString</name>\n          <value><string>Jetpack: [concurrent_request_error] There is another request running for the same blog ID</string></value>\n        </member>\n      </struct>\n    </value>\n  </fault>\n</methodResponse>\n\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;}}s:18:\"\0*\0additional_data\";a:1:{s:24:\"concurrent_request_error\";a:1:{i:0;i:400;}}}s:15:\"1682364228.1452\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:24:\"concurrent_request_error\";a:1:{i:0;s:53:\"There is another request running for the same blog ID\";}}s:10:\"error_data\";a:1:{s:24:\"concurrent_request_error\";a:5:{s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Mon, 24 Apr 2023 19:23:48 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:8:\"x-hacker\";s:108:\"If you\'re reading this, you should visit automattic.com/jobs and apply to join the fun, mention this header.\";s:11:\"host-header\";s:13:\"WordPress.com\";s:11:\"retry-after\";s:1:\"5\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"x-ac\";s:17:\"4.cdg _dca BYPASS\";s:25:\"strict-transport-security\";s:16:\"max-age=31536000\";}s:4:\"body\";s:461:\"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<methodResponse>\n  <fault>\n    <value>\n      <struct>\n        <member>\n          <name>faultCode</name>\n          <value><int>400</int></value>\n        </member>\n        <member>\n          <name>faultString</name>\n          <value><string>Jetpack: [concurrent_request_error] There is another request running for the same blog ID</string></value>\n        </member>\n      </struct>\n    </value>\n  </fault>\n</methodResponse>\n\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;}}s:18:\"\0*\0additional_data\";a:1:{s:24:\"concurrent_request_error\";a:1:{i:0;i:400;}}}s:15:\"1682364228.3984\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:24:\"concurrent_request_error\";a:1:{i:0;s:53:\"There is another request running for the same blog ID\";}}s:10:\"error_data\";a:1:{s:24:\"concurrent_request_error\";a:5:{s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Mon, 24 Apr 2023 19:23:48 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:8:\"x-hacker\";s:108:\"If you\'re reading this, you should visit automattic.com/jobs and apply to join the fun, mention this header.\";s:11:\"host-header\";s:13:\"WordPress.com\";s:11:\"retry-after\";s:1:\"5\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"x-ac\";s:17:\"4.cdg _dca BYPASS\";s:25:\"strict-transport-security\";s:16:\"max-age=31536000\";}s:4:\"body\";s:461:\"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<methodResponse>\n  <fault>\n    <value>\n      <struct>\n        <member>\n          <name>faultCode</name>\n          <value><int>400</int></value>\n        </member>\n        <member>\n          <name>faultString</name>\n          <value><string>Jetpack: [concurrent_request_error] There is another request running for the same blog ID</string></value>\n        </member>\n      </struct>\n    </value>\n  </fault>\n</methodResponse>\n\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;}}s:18:\"\0*\0additional_data\";a:1:{s:24:\"concurrent_request_error\";a:1:{i:0;i:400;}}}}", "yes");
INSERT INTO `bd_options` VALUES("2331", "jetpack_content_post_details_date", "1", "yes");
INSERT INTO `bd_options` VALUES("2332", "jetpack_content_post_details_categories", "1", "yes");
INSERT INTO `bd_options` VALUES("2333", "jetpack_content_post_details_tags", "1", "yes");
INSERT INTO `bd_options` VALUES("2334", "jetpack_content_post_details_author", "1", "yes");
INSERT INTO `bd_options` VALUES("2335", "jetpack_content_post_details_comment", "1", "yes");
INSERT INTO `bd_options` VALUES("2336", "verification_services_codes", "0", "yes");
INSERT INTO `bd_options` VALUES("2346", "_transient_dirsize_cache", "a:5:{s:45:\"/home/jrmaour/test/wp-content/uploads/2023/04\";i:0;s:45:\"/home/jrmaour/test/wp-content/uploads/2023/02\";i:1054353;s:45:\"/home/jrmaour/test/wp-content/uploads/2023/01\";i:11558717;s:42:\"/home/jrmaour/test/wp-content/uploads/2023\";i:12613070;s:37:\"/home/jrmaour/test/wp-content/uploads\";i:12613070;}", "yes");
INSERT INTO `bd_options` VALUES("2353", "_transient_timeout_brute_use_math", "1682364839", "no");
INSERT INTO `bd_options` VALUES("2354", "_transient_brute_use_math", "1", "no");
INSERT INTO `bd_options` VALUES("2355", "jetpack_protect_error", "API Key Required", "no");
INSERT INTO `bd_options` VALUES("2356", "_transient_timeout_jpp_headers_updated_recently", "1682450639", "no");
INSERT INTO `bd_options` VALUES("2357", "_transient_jpp_headers_updated_recently", "1", "no");
INSERT INTO `bd_options` VALUES("2358", "trusted_ip_header", "", "no");
INSERT INTO `bd_options` VALUES("2361", "post_by_email_address1", "NULL", "yes");
INSERT INTO `bd_options` VALUES("2364", "_transient_timeout_jetpack_scan_state", "1682366211", "no");
INSERT INTO `bd_options` VALUES("2365", "_transient_jetpack_scan_state", "O:8:\"stdClass\":4:{s:5:\"state\";s:11:\"unavailable\";s:7:\"threats\";N;s:9:\"has_cloud\";b:0;s:6:\"reason\";s:23:\"missing_scan_capability\";}", "no");
INSERT INTO `bd_options` VALUES("2366", "_transient_timeout_jetpack_rewind_state", "1682366211", "no");
INSERT INTO `bd_options` VALUES("2367", "_transient_jetpack_rewind_state", "O:8:\"stdClass\":4:{s:6:\"reason\";s:8:\"site_new\";s:5:\"state\";s:11:\"unavailable\";s:12:\"last_updated\";s:29:\"2023-04-24T19:26:51.694+00:00\";s:9:\"has_cloud\";b:0;}", "no");
INSERT INTO `bd_options` VALUES("2368", "_transient_timeout_jetpack_restapi_stats_cache_23fb55b5a488716d8389b145a6cc67d4", "1682364540", "no");
INSERT INTO `bd_options` VALUES("2369", "_transient_jetpack_restapi_stats_cache_23fb55b5a488716d8389b145a6cc67d4", "a:1:{i:1682364240;s:409:\"{\"stats\":{\"visitors_today\":0,\"visitors_yesterday\":0,\"visitors\":0,\"views_today\":0,\"views_yesterday\":0,\"views_best_day\":\"\",\"views_best_day_total\":0,\"views\":0,\"comments\":0,\"posts\":0,\"followers_blog\":0,\"followers_comments\":0,\"comments_per_month\":0,\"comments_most_active_recent_day\":\"\",\"comments_most_active_time\":\"N\\/A\",\"comments_spam\":0,\"categories\":1,\"tags\":0,\"shares\":0,\"shares_twitter\":0,\"shares_facebook\":0}}\";}", "no");
INSERT INTO `bd_options` VALUES("2381", "_transient_timeout_jetpack_jitm_710398c236e8277cc28f200dd5aa964", "1682364551", "no");
INSERT INTO `bd_options` VALUES("2382", "_transient_jetpack_jitm_710398c236e8277cc28f200dd5aa964", "a:1:{s:18:\"last_response_time\";i:1682364251;}", "no");
INSERT INTO `bd_options` VALUES("2413", "_transient_timeout_jetpack_restapi_stats_cache_b8bb30fe262a9672b8e7b92be485fc71", "1682364585", "no");
INSERT INTO `bd_options` VALUES("2414", "_transient_jetpack_restapi_stats_cache_b8bb30fe262a9672b8e7b92be485fc71", "a:1:{i:1682364285;s:1101:\"{\"date\":\"2023-04-24\",\"stats\":{\"visitors_today\":0,\"visitors_yesterday\":0,\"visitors\":0,\"views_today\":0,\"views_yesterday\":0,\"views_best_day\":\"2023-04-24\",\"views_best_day_total\":0,\"views\":0,\"comments\":0,\"posts\":0,\"followers_blog\":0,\"followers_comments\":0,\"comments_per_month\":0,\"comments_most_active_recent_day\":\"\",\"comments_most_active_time\":\"N\\/A\",\"comments_spam\":0,\"categories\":1,\"tags\":0,\"shares\":0,\"shares_twitter\":0,\"shares_facebook\":0},\"visits\":{\"date\":\"2023-04-24\",\"unit\":\"day\",\"fields\":[\"period\",\"views\",\"visitors\"],\"data\":[[\"2023-03-26\",0,0],[\"2023-03-27\",0,0],[\"2023-03-28\",0,0],[\"2023-03-29\",0,0],[\"2023-03-30\",0,0],[\"2023-03-31\",0,0],[\"2023-04-01\",0,0],[\"2023-04-02\",0,0],[\"2023-04-03\",0,0],[\"2023-04-04\",0,0],[\"2023-04-05\",0,0],[\"2023-04-06\",0,0],[\"2023-04-07\",0,0],[\"2023-04-08\",0,0],[\"2023-04-09\",0,0],[\"2023-04-10\",0,0],[\"2023-04-11\",0,0],[\"2023-04-12\",0,0],[\"2023-04-13\",0,0],[\"2023-04-14\",0,0],[\"2023-04-15\",0,0],[\"2023-04-16\",0,0],[\"2023-04-17\",0,0],[\"2023-04-18\",0,0],[\"2023-04-19\",0,0],[\"2023-04-20\",0,0],[\"2023-04-21\",0,0],[\"2023-04-22\",0,0],[\"2023-04-23\",0,0],[\"2023-04-24\",0,0]]}}\";}", "no");
INSERT INTO `bd_options` VALUES("2415", "_transient_timeout_jetpack_jitm_13281ba4e3d7d340cc4226edc2f9ac4", "1682364712", "no");
INSERT INTO `bd_options` VALUES("2417", "_transient_jetpack_jitm_13281ba4e3d7d340cc4226edc2f9ac4", "a:2:{i:0;O:8:\"stdClass\":12:{s:7:\"content\";O:8:\"stdClass\":8:{s:7:\"message\";s:84:\"Optimisez les performances et le référencement de votre site avec Jetpack Boost !\";s:4:\"icon\";s:7:\"jetpack\";s:8:\"iconPath\";N;s:4:\"list\";a:0:{}s:11:\"description\";s:196:\"Jetpack Boost est l’une des principales extensions de performances. Optimisez vos images, améliorez le score de vitesse de vos pages et augmentez votre classement dans les moteurs de recherche.\";s:7:\"classes\";s:0:\"\";s:5:\"title\";s:0:\"\";s:10:\"disclaimer\";a:0:{}}s:3:\"CTA\";O:8:\"stdClass\":5:{s:7:\"message\";s:30:\"Installer maintenant (gratuit)\";s:4:\"hook\";s:21:\"jetpack_boost_install\";s:9:\"newWindow\";b:0;s:7:\"primary\";b:1;s:4:\"link\";s:0:\"\";}s:8:\"template\";s:7:\"default\";s:3:\"ttl\";i:300;s:2:\"id\";s:24:\"jetpack_boost_ad_install\";s:13:\"feature_class\";s:26:\"jetpack_standalone_plugins\";s:7:\"expires\";i:3628800;s:13:\"max_dismissal\";i:2;s:15:\"activate_module\";N;s:14:\"is_dismissible\";b:1;s:26:\"is_user_created_by_partner\";N;s:18:\"message_expiration\";N;}s:18:\"last_response_time\";i:1682364412;}", "no");
INSERT INTO `bd_options` VALUES("2419", "_transient_timeout_jetpack_jitm_f6e938e89443e08fb2d394f5f9ba30b", "1682364612", "no");
INSERT INTO `bd_options` VALUES("2420", "_transient_jetpack_jitm_f6e938e89443e08fb2d394f5f9ba30b", "a:1:{s:18:\"last_response_time\";i:1682364312;}", "no");
INSERT INTO `bd_options` VALUES("2445", "_transient_timeout_jetpack_blaze_site_supports_blaze_218243250", "1682450756", "no");
INSERT INTO `bd_options` VALUES("2446", "_transient_jetpack_blaze_site_supports_blaze_218243250", "1", "no");
INSERT INTO `bd_options` VALUES("2448", "monitor_receive_notifications", "1", "yes");
INSERT INTO `bd_options` VALUES("2459", "feedback_unread_count", "0", "yes");
INSERT INTO `bd_options` VALUES("2460", "_transient_timeout_jetpack_jitm_ed4be1df88d5337f66b3a126ad16acb", "1682364691", "no");
INSERT INTO `bd_options` VALUES("2461", "_transient_jetpack_jitm_ed4be1df88d5337f66b3a126ad16acb", "a:1:{s:18:\"last_response_time\";i:1682364391;}", "no");
INSERT INTO `bd_options` VALUES("2462", "_transient_timeout_jetpack_jitm_9619ae275f01d903ab0cf51a93e3c3d", "1682364778", "no");
INSERT INTO `bd_options` VALUES("2463", "_transient_jetpack_jitm_9619ae275f01d903ab0cf51a93e3c3d", "a:2:{i:0;O:8:\"stdClass\":12:{s:7:\"content\";O:8:\"stdClass\":8:{s:7:\"message\";s:71:\"Un nombre d’extensions accru implique une plus grande responsabilité\";s:4:\"icon\";s:7:\"jetpack\";s:8:\"iconPath\";N;s:4:\"list\";a:0:{}s:11:\"description\";s:166:\"Jetpack Protect est une solution de sécurité gratuite pour WordPress qui effectue des analyses automatisées de vos extensions et vous avertit des vulnérabilités.\";s:7:\"classes\";s:0:\"\";s:5:\"title\";s:0:\"\";s:10:\"disclaimer\";a:0:{}}s:3:\"CTA\";O:8:\"stdClass\":5:{s:7:\"message\";s:28:\"Obtenir Protect gratuitement\";s:4:\"hook\";s:0:\"\";s:9:\"newWindow\";b:1;s:7:\"primary\";b:1;s:4:\"link\";s:0:\"\";}s:8:\"template\";s:7:\"default\";s:3:\"ttl\";i:300;s:2:\"id\";s:28:\"jetpack_protect_plugin_promo\";s:13:\"feature_class\";s:18:\"protect_standalone\";s:7:\"expires\";i:3628800;s:13:\"max_dismissal\";i:2;s:15:\"activate_module\";N;s:14:\"is_dismissible\";b:1;s:26:\"is_user_created_by_partner\";N;s:18:\"message_expiration\";N;}s:18:\"last_response_time\";i:1682364478;}", "no");
INSERT INTO `bd_options` VALUES("2466", "_transient_timeout_jetpack_sync_last_checked_queue_state_sync", "1682364516", "no");
INSERT INTO `bd_options` VALUES("2467", "_transient_jetpack_sync_last_checked_queue_state_sync", "a:2:{i:0;i:0;i:1;i:0;}", "no");
INSERT INTO `bd_options` VALUES("2471", "_transient_timeout_jetpack_sync_constants_await", "1682368086", "no");
INSERT INTO `bd_options` VALUES("2472", "_transient_jetpack_sync_constants_await", "1682364486.4727", "no");
INSERT INTO `bd_options` VALUES("2473", "jetpack_constants_sync_checksum", "a:21:{s:7:\"ABSPATH\";i:2271936653;s:17:\"ALTERNATE_WP_CRON\";i:634125391;s:16:\"ATOMIC_CLIENT_ID\";i:634125391;s:26:\"AUTOMATIC_UPDATER_DISABLED\";i:634125391;s:15:\"DISABLE_WP_CRON\";i:634125391;s:18:\"DISALLOW_FILE_EDIT\";i:634125391;s:18:\"DISALLOW_FILE_MODS\";i:634125391;s:16:\"EMPTY_TRASH_DAYS\";i:2473281379;s:9:\"FS_METHOD\";i:634125391;s:12:\"IS_PRESSABLE\";i:634125391;s:16:\"JETPACK__VERSION\";i:87079039;s:11:\"PHP_VERSION\";i:2642017422;s:19:\"WP_ACCESSIBLE_HOSTS\";i:634125391;s:19:\"WP_AUTO_UPDATE_CORE\";i:634125391;s:14:\"WP_CONTENT_DIR\";i:1911274528;s:20:\"WP_CRON_LOCK_TIMEOUT\";i:3994858278;s:8:\"WP_DEBUG\";i:734881840;s:22:\"WP_HTTP_BLOCK_EXTERNAL\";i:634125391;s:19:\"WP_MAX_MEMORY_LIMIT\";i:1839787262;s:15:\"WP_MEMORY_LIMIT\";i:3065409971;s:17:\"WP_POST_REVISIONS\";i:4261170317;}", "yes");
INSERT INTO `bd_options` VALUES("2474", "jetpack_sync_https_history_home_url", "a:1:{i:0;s:5:\"https\";}", "yes");
INSERT INTO `bd_options` VALUES("2475", "jetpack_sync_https_history_main_network_site_url", "a:1:{i:0;s:5:\"https\";}", "yes");
INSERT INTO `bd_options` VALUES("2476", "jetpack_sync_https_history_site_url", "a:1:{i:0;s:5:\"https\";}", "yes");
INSERT INTO `bd_options` VALUES("2477", "_transient_timeout_jetpack_sync_callables_await", "1682364546", "no");
INSERT INTO `bd_options` VALUES("2478", "_transient_jetpack_sync_callables_await", "1682364486.4972", "no");
INSERT INTO `bd_options` VALUES("2479", "jetpack_callables_sync_checksum", "a:38:{s:11:\"get_plugins\";i:3557453439;s:10:\"get_themes\";i:4197674148;s:24:\"get_plugins_action_links\";i:361291096;s:28:\"has_file_system_write_access\";i:4261170317;s:8:\"home_url\";i:158354517;s:16:\"hosting_provider\";i:769900095;s:12:\"is_fse_theme\";i:734881840;s:15:\"is_main_network\";i:734881840;s:13:\"is_multi_site\";i:734881840;s:21:\"is_version_controlled\";i:734881840;s:6:\"locale\";i:577058967;s:17:\"main_network_site\";i:158354517;s:26:\"main_network_site_wpcom_id\";i:1756325991;s:14:\"paused_plugins\";i:223132457;s:13:\"paused_themes\";i:223132457;s:18:\"post_type_features\";i:1592006760;s:10:\"post_types\";i:815300153;s:27:\"rest_api_allowed_post_types\";i:2544842423;s:32:\"rest_api_allowed_public_metadata\";i:3610467939;s:5:\"roles\";i:12998271;s:10:\"shortcodes\";i:3671679970;s:13:\"site_icon_url\";i:1039741986;s:8:\"site_url\";i:1617724406;s:10:\"taxonomies\";i:165479307;s:13:\"theme_support\";i:2792076139;s:8:\"timezone\";i:3126062234;s:23:\"wp_get_environment_type\";i:1138987844;s:18:\"wp_max_upload_size\";i:3564436882;s:10:\"wp_version\";i:2728415867;s:14:\"active_modules\";i:2300127681;s:16:\"single_user_site\";i:4261170317;s:7:\"updates\";i:2903718415;s:24:\"available_jetpack_blocks\";i:4184509854;s:24:\"sso_is_two_step_required\";i:734881840;s:26:\"sso_should_hide_login_form\";i:734881840;s:18:\"sso_match_by_email\";i:734881840;s:21:\"sso_new_user_override\";i:734881840;s:29:\"sso_bypass_default_login_form\";i:734881840;}", "no");
INSERT INTO `bd_options` VALUES("2505", "_transient_timeout_rsssl_testpage", "1682450978", "no");
INSERT INTO `bd_options` VALUES("2506", "_transient_rsssl_testpage", "<html>\n<head>\n    <meta charset=\"UTF-8\">\n    <META NAME=\"ROBOTS\" CONTENT=\"NOINDEX, NOFOLLOW\">\n</head>\n<body>\n<h1>#SSL TEST PAGE#</h1>\n<p>This page is used purely to test for SSL availability.</p>\n#SERVER-HTTPS-ON# (on)<br>#SERVERPORT443#<br>#ENVHTTPS#<br>#LOADBALANCER#<br><br>#SUCCESSFULLY DETECTED SSL#\n</body>\n</html>\n", "no");
INSERT INTO `bd_options` VALUES("2508", "_transient_timeout_rsssl_htaccess_test_success", "1682365179", "no");
INSERT INTO `bd_options` VALUES("2509", "_transient_rsssl_htaccess_test_success", "success", "no");
INSERT INTO `bd_options` VALUES("2510", "_transient_timeout_rsssl_admin_users", "1682368179", "no");
INSERT INTO `bd_options` VALUES("2511", "_transient_rsssl_admin_users", "a:1:{i:0;O:7:\"WP_User\":8:{s:4:\"data\";O:8:\"stdClass\":10:{s:2:\"ID\";s:1:\"1\";s:10:\"user_login\";s:13:\"us88766765323\";s:9:\"user_pass\";s:34:\"$P$BuicIF6dHJwe9UoElVVPVtV3XyUQaw/\";s:13:\"user_nicename\";s:13:\"us88766765323\";s:10:\"user_email\";s:32:\"webclient.locationluxe@gmail.com\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2023-01-20 18:50:55\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:27:\"Location de voiture de luxe\";}s:2:\"ID\";i:1;s:4:\"caps\";a:1:{s:13:\"administrator\";b:1;}s:7:\"cap_key\";s:15:\"bd_capabilities\";s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:7:\"allcaps\";a:66:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:15:\"manage_security\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:13:\"administrator\";b:1;}s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;}}", "no");
INSERT INTO `bd_options` VALUES("2512", "_transient_timeout_rsssl_mixed_content_fixer_detected", "1682365179", "no");
INSERT INTO `bd_options` VALUES("2513", "_transient_rsssl_mixed_content_fixer_detected", "found", "no");
INSERT INTO `bd_options` VALUES("2519", "duplicator_ui_view_state", "a:1:{s:28:\"dup-settings-diag-opts-panel\";s:1:\"1\";}", "yes");
INSERT INTO `bd_options` VALUES("2524", "_transient_timeout_rsssl_code_execution_allowed_status", "1682451161", "no");
INSERT INTO `bd_options` VALUES("2525", "_transient_rsssl_code_execution_allowed_status", "not-allowed", "no");
INSERT INTO `bd_options` VALUES("2526", "rsssl_wp_version_detected", "not-found", "no");
INSERT INTO `bd_options` VALUES("2527", "_transient_timeout_rsssl_directory_indexing_status", "1682451162", "no");
INSERT INTO `bd_options` VALUES("2528", "_transient_rsssl_directory_indexing_status", "forbidden", "no");
INSERT INTO `bd_options` VALUES("2529", "_transient_timeout_rsssl_admin_user_count", "1682368424", "no");
INSERT INTO `bd_options` VALUES("2530", "_transient_rsssl_admin_user_count", "0", "no");
INSERT INTO `bd_options` VALUES("2531", "rsssl_le_installation_progress", "a:3:{i:0;s:16:\"dns-verification\";i:1;s:13:\"system-status\";i:2;s:6:\"domain\";}", "no");
INSERT INTO `bd_options` VALUES("2534", "_transient_timeout_rsssl_certinfo", "1682451224", "no");
INSERT INTO `bd_options` VALUES("2535", "_transient_rsssl_certinfo", "no-response", "no");
INSERT INTO `bd_options` VALUES("2536", "_transient_timeout_rsssl_alias_domain_available", "1682366610", "no");
INSERT INTO `bd_options` VALUES("2537", "_transient_rsssl_alias_domain_available", "available", "no");
INSERT INTO `bd_options` VALUES("2539", "rsssl_initial_alias_domain_value_set", "1", "no");
INSERT INTO `bd_options` VALUES("2540", "rsssl_plusone_count", "3", "yes");
INSERT INTO `bd_options` VALUES("2541", "rsssl_admin_notices", "empty", "yes");
INSERT INTO `bd_options` VALUES("2552", "_site_transient_timeout_theme_roots", "1682407690", "no");
INSERT INTO `bd_options` VALUES("2553", "_site_transient_theme_roots", "a:1:{s:47:\"theme location luxe/location-de-voiture-de-luxe\";s:7:\"/themes\";}", "no");
INSERT INTO `bd_options` VALUES("2564", "_site_transient_timeout_available_translations", "1682454433", "no");
INSERT INTO `bd_options` VALUES("2565", "_site_transient_available_translations", "a:130:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-02 03:21:35\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.2/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.21/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-11 22:28:09\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.2/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-12 20:34:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2019-10-29 07:54:22\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.22/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-24 17:24:25\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-10-31 08:48:37\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.12/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-30 16:46:59\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.2/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-09 07:39:36\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-29 09:00:46\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.2/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-25 08:06:58\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-02 19:47:35\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-29 21:14:35\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-28 07:33:50\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.2/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-10 00:05:59\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.2/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-28 07:37:41\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.2/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-18 09:00:29\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.2/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-07 21:00:17\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-19 10:51:23\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2021-12-24 12:36:39\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-04-01 22:35:34\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-18 07:25:08\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-20 04:54:08\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.2/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-04 07:22:04\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-06 14:12:40\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-15 19:52:49\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-14 22:16:37\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-10-04 20:53:18\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.6/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.6/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-06-14 16:02:22\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.12/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.17\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.17/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-11 17:42:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-08-12 08:38:59\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-21 17:46:00\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.2/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-05 06:53:02\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-13 11:28:33\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-29 07:54:36\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.2/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-19 20:54:32\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-21 13:20:47\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-22 13:54:46\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2018-01-29 17:32:35\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.21/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2022-12-25 12:53:23\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.2/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-18 12:45:47\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2018-09-14 12:33:48\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.22/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:31:\"ચાલુ રાખવું\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.29\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.29/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-14 21:14:16\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-11-06 12:34:38\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.12/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-17 11:08:02\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.2/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.2/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-24 19:47:36\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-08 23:10:42\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.22/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-24 17:34:58\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-30 13:21:15\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.2/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.22/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-24 08:01:09\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-01-21 21:13:06\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.2/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2018-07-10 11:35:44\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.22/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.17\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.17/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-10-20 17:15:28\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-30 09:50:37\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-24 16:15:49\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.2/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-24 03:51:58\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-02 00:14:51\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.2/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:43:32\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-09 01:41:47\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.2/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2019-11-22 15:32:08\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.22/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.11\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.11/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.34\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.34/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-28 17:21:06\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-03 04:46:20\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-13 12:17:01\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-30 10:02:03\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-02-22 21:20:14\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.2/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.21/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-31 08:04:21\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.30\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.30/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2022-10-01 12:16:29\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-29 21:22:43\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-30 23:24:56\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/6.2/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-21 10:51:56\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-22 15:57:02\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-20 06:23:24\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.12/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-09 10:02:55\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-03 08:30:58\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.2/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2022-11-11 12:48:55\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-19 12:09:33\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.2/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-08-01 21:21:06\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.6/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-16 21:07:17\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:6:\"5.3.14\";s:7:\"updated\";s:19:\"2019-10-13 15:35:35\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.3.14/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.34\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.34/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.8.6/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.21/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-28 20:25:07\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2021-07-03 18:41:33\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.22/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-04 10:46:30\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.12/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-10 01:15:33\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.2/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-04-23 22:48:55\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:3:\"6.2\";s:7:\"updated\";s:19:\"2023-03-28 17:14:41\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "no");
INSERT INTO `bd_options` VALUES("2566", "_site_transient_timeout_community-events-b10ca22d976654a55d6dcc7cd8324bb9", "1682486851", "no");
INSERT INTO `bd_options` VALUES("2567", "_site_transient_community-events-b10ca22d976654a55d6dcc7cd8324bb9", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:11:\"90.59.117.0\";}s:6:\"events\";a:1:{i:0;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:76:\"Simplifier, structurer, automatiser votre CSS dans vos projets WP avec SASS.\";s:3:\"url\";s:57:\"https://www.meetup.com/wordpress-in-nice/events/292748162\";s:6:\"meetup\";s:17:\"WordPress In Nice\";s:10:\"meetup_url\";s:41:\"https://www.meetup.com/wordpress-in-nice/\";s:4:\"date\";s:19:\"2023-04-27 18:30:00\";s:8:\"end_date\";s:19:\"2023-04-27 20:30:00\";s:20:\"start_unix_timestamp\";i:1682613000;s:18:\"end_unix_timestamp\";i:1682620200;s:8:\"location\";a:4:{s:8:\"location\";s:12:\"Nice, France\";s:7:\"country\";s:2:\"fr\";s:8:\"latitude\";d:43.70609;s:9:\"longitude\";d:7.270567;}}}}", "no");
INSERT INTO `bd_options` VALUES("2568", "_transient_timeout_feed_0d2db5fea5a8633b56992c916819b198", "1682486852", "no");
INSERT INTO `bd_options` VALUES("2569", "_transient_feed_0d2db5fea5a8633b56992c916819b198", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Blog | WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Mar 2023 12:54:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.3-alpha-55684\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Blog | WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"WordPress 6.2 « Dolphy »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://fr.wordpress.org/2023/03/30/wordpress-6-2-dolphy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://fr.wordpress.org/2023/03/30/wordpress-6-2-dolphy/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Mar 2023 08:32:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2659\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:401:\"Surnommée «&#160;Dolphy&#160;» en l&#8217;honneur du jazzman américain Eric Allan Dolphy Jr, WordPress&#160;6.2 est la première version majeure de 2023, et contient plus de 900 améliorations et corrections de bugs. Cette version marque une transition dans la feuille de route générale du projet open-source WordPress, car la focalisation va désormais passer de l’éditeur et de la [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:64876:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2023/03/dolphy.png\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"683\" src=\"https://fr.wordpress.org/files/2023/03/dolphy-1024x683.png\" alt=\"\" class=\"wp-image-2721\" srcset=\"https://fr.wordpress.org/files/2023/03/dolphy-1024x683.png 1024w, https://fr.wordpress.org/files/2023/03/dolphy-300x200.png 300w, https://fr.wordpress.org/files/2023/03/dolphy-768x512.png 768w, https://fr.wordpress.org/files/2023/03/dolphy.png 1200w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Surnommée «&nbsp;Dolphy&nbsp;» en l&rsquo;honneur du jazzman américain Eric Allan Dolphy Jr,  WordPress&nbsp;6.2 est la première version majeure de 2023, et contient plus de 900 améliorations et corrections de bugs. Cette version marque une transition dans la feuille de route générale du projet open-source WordPress, car la focalisation va désormais passer de l’éditeur et de la personnalisation de sites à l&rsquo;exploration des flux de travail et de la collaboration.</p>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile is-image-fill\" style=\"grid-template-columns:30% auto\"><figure class=\"wp-block-media-text__media\" style=\"background-image:url(https://fr.wordpress.org/files/2023/03/about-site-editor.png);background-position:25% 48%\"><img decoding=\"async\" loading=\"lazy\" width=\"872\" height=\"872\" src=\"https://fr.wordpress.org/files/2023/03/about-site-editor.png\" alt=\"\" class=\"wp-image-2662 size-full\" srcset=\"https://fr.wordpress.org/files/2023/03/about-site-editor.png 872w, https://fr.wordpress.org/files/2023/03/about-site-editor-300x300.png 300w, https://fr.wordpress.org/files/2023/03/about-site-editor-150x150.png 150w, https://fr.wordpress.org/files/2023/03/about-site-editor-768x768.png 768w\" sizes=\"(max-width: 872px) 100vw, 872px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\" style=\"font-size:20px\">Explorez et modifiez tout votre site à partir de l’éditeur</h3>\n\n\n\n<p>L’interface de l&rsquo;édition de site a été revue afin de vous donner plus de contrôle sur l’expérience d’édition de votre site. Vous trouverez une prévisualisation complète de vos modèles et éléments de modèles, et pourrez passer à l’éditeur de site depuis n’importe quel écran.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile is-image-fill\" style=\"grid-template-columns:30% auto\"><figure class=\"wp-block-media-text__media\" style=\"background-image:url(https://fr.wordpress.org/files/2023/03/about-navigation.png);background-position:25% 47%\"><img decoding=\"async\" loading=\"lazy\" width=\"872\" height=\"872\" src=\"https://fr.wordpress.org/files/2023/03/about-navigation.png\" alt=\"\" class=\"wp-image-2663 size-full\" srcset=\"https://fr.wordpress.org/files/2023/03/about-navigation.png 872w, https://fr.wordpress.org/files/2023/03/about-navigation-300x300.png 300w, https://fr.wordpress.org/files/2023/03/about-navigation-150x150.png 150w, https://fr.wordpress.org/files/2023/03/about-navigation-768x768.png 768w\" sizes=\"(max-width: 872px) 100vw, 872px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\" style=\"font-size:20px\">Améliorations du bloc de navigation</h3>\n\n\n\n<p>La nouvelle colonne latérale de réglages facilite la modification de la navigation de votre site. Ajoutez, supprimez et réordonnez vos éléments de menus plus rapidement, peu importe la complexité de vos menus.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile is-image-fill\" style=\"grid-template-columns:30% auto\"><figure class=\"wp-block-media-text__media\" style=\"background-image:url(https://fr.wordpress.org/files/2023/03/about-block-inserter.png);background-position:33% 52%\"><img decoding=\"async\" loading=\"lazy\" width=\"872\" height=\"872\" src=\"https://fr.wordpress.org/files/2023/03/about-block-inserter.png\" alt=\"\" class=\"wp-image-2664 size-full\" srcset=\"https://fr.wordpress.org/files/2023/03/about-block-inserter.png 872w, https://fr.wordpress.org/files/2023/03/about-block-inserter-300x300.png 300w, https://fr.wordpress.org/files/2023/03/about-block-inserter-150x150.png 150w, https://fr.wordpress.org/files/2023/03/about-block-inserter-768x768.png 768w\" sizes=\"(max-width: 872px) 100vw, 872px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\" style=\"font-size:20px\">Une expérience plus fluide pour l’outil d’insertion de blocs</h3>\n\n\n\n<p>L’onglet «&nbsp;média&nbsp;» permet de glisser et déposer du contenu depuis votre médiathèque rapidement. La vue partagée facilite la navigation parmi les catégories et la prévisualisation des compositions.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile is-image-fill\" style=\"grid-template-columns:30% auto\"><figure class=\"wp-block-media-text__media\" style=\"background-image:url(https://fr.wordpress.org/files/2023/03/about-split-controls-fixed.png);background-position:24% 50%\"><img decoding=\"async\" loading=\"lazy\" width=\"872\" height=\"872\" src=\"https://fr.wordpress.org/files/2023/03/about-split-controls-fixed.png\" alt=\"\" class=\"wp-image-2665 size-full\" srcset=\"https://fr.wordpress.org/files/2023/03/about-split-controls-fixed.png 872w, https://fr.wordpress.org/files/2023/03/about-split-controls-fixed-300x300.png 300w, https://fr.wordpress.org/files/2023/03/about-split-controls-fixed-150x150.png 150w, https://fr.wordpress.org/files/2023/03/about-split-controls-fixed-768x768.png 768w\" sizes=\"(max-width: 872px) 100vw, 872px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\" style=\"font-size:20px\">Une meilleure interface pour les réglages des blocs</h3>\n\n\n\n<p>La colonne latérale de réglages de vos blocs est mieux organisée, avec des onglets pour les réglages et pour les styles. Les outils dont vous avez besoin sont identifiables et facile d’accès.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile is-image-fill\" style=\"grid-template-columns:30% auto\"><figure class=\"wp-block-media-text__media\" style=\"background-image:url(https://fr.wordpress.org/files/2023/03/about-headers.png);background-position:20% 46%\"><img decoding=\"async\" loading=\"lazy\" width=\"872\" height=\"872\" src=\"https://fr.wordpress.org/files/2023/03/about-headers.png\" alt=\"\" class=\"wp-image-2666 size-full\" srcset=\"https://fr.wordpress.org/files/2023/03/about-headers.png 872w, https://fr.wordpress.org/files/2023/03/about-headers-300x300.png 300w, https://fr.wordpress.org/files/2023/03/about-headers-150x150.png 150w, https://fr.wordpress.org/files/2023/03/about-headers-768x768.png 768w\" sizes=\"(max-width: 872px) 100vw, 872px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\" style=\"font-size:20px\">Des en-têtes et des pieds de page prêts à l&#8217;emploi</h3>\n\n\n\n<p>Découvrez une nouvelle collection de compositions d’en-têtes et de pieds de page. Utilisez-les avec n’importe quel thème basé sur des blocs pour en faire un point de départ rapide et de qualité pour les modèles de pages de votre site.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile is-image-fill\" style=\"grid-template-columns:30% auto\"><figure class=\"wp-block-media-text__media\" style=\"background-image:url(https://fr.wordpress.org/files/2023/03/about-openverse.png);background-position:27% 48%\"><img decoding=\"async\" loading=\"lazy\" width=\"872\" height=\"872\" src=\"https://fr.wordpress.org/files/2023/03/about-openverse.png\" alt=\"\" class=\"wp-image-2667 size-full\" srcset=\"https://fr.wordpress.org/files/2023/03/about-openverse.png 872w, https://fr.wordpress.org/files/2023/03/about-openverse-300x300.png 300w, https://fr.wordpress.org/files/2023/03/about-openverse-150x150.png 150w, https://fr.wordpress.org/files/2023/03/about-openverse-768x768.png 768w\" sizes=\"(max-width: 872px) 100vw, 872px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\" style=\"font-size:20px\">Explorez les médias Openverse directement depuis l’éditeur</h3>\n\n\n\n<p>La bibliothèque d’Openverse répertorie plus de 600 millions d’images et de fichiers audio gratuits sous licence ouverte, et elle est désormais directement intégrée à l’éditeur.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile is-image-fill\" style=\"grid-template-columns:30% auto\"><figure class=\"wp-block-media-text__media\" style=\"background-image:url(https://fr.wordpress.org/files/2023/03/about-distraction-free.png);background-position:50% 50%\"><img decoding=\"async\" loading=\"lazy\" width=\"872\" height=\"872\" src=\"https://fr.wordpress.org/files/2023/03/about-distraction-free.png\" alt=\"\" class=\"wp-image-2668 size-full\" srcset=\"https://fr.wordpress.org/files/2023/03/about-distraction-free.png 872w, https://fr.wordpress.org/files/2023/03/about-distraction-free-300x300.png 300w, https://fr.wordpress.org/files/2023/03/about-distraction-free-150x150.png 150w, https://fr.wordpress.org/files/2023/03/about-distraction-free-768x768.png 768w\" sizes=\"(max-width: 872px) 100vw, 872px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\" style=\"font-size:20px\">Un nouveau mode sans distraction</h3>\n\n\n\n<p>De temps en temps, il est bon de pouvoir se concentrer sur son travail. Vous pouvez maintenant masquer tous les panneaux et réglages pour vous concentrer sur l’écriture de votre contenu.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile is-image-fill\" style=\"grid-template-columns:30% auto\"><figure class=\"wp-block-media-text__media\" style=\"background-image:url(https://fr.wordpress.org/files/2023/03/about-out-of-beta.png);background-position:44% 50%\"><img decoding=\"async\" loading=\"lazy\" width=\"872\" height=\"872\" src=\"https://fr.wordpress.org/files/2023/03/about-out-of-beta.png\" alt=\"\" class=\"wp-image-2670 size-full\" srcset=\"https://fr.wordpress.org/files/2023/03/about-out-of-beta.png 872w, https://fr.wordpress.org/files/2023/03/about-out-of-beta-300x300.png 300w, https://fr.wordpress.org/files/2023/03/about-out-of-beta-150x150.png 150w, https://fr.wordpress.org/files/2023/03/about-out-of-beta-768x768.png 768w\" sizes=\"(max-width: 872px) 100vw, 872px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\" style=\"font-size:20px\">L’éditeur de site n’est officiellement plus en version bêta&nbsp;!</h3>\n\n\n\n<p>La version 6.2 est une invitation à découvrir le potentiel de la prochaine génération de thèmes WordPress.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile\" style=\"grid-template-columns:auto 23%\"><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\" style=\"font-size:20px\">Un nouveau guide de styles à votre disposition</h3>\n\n\n\n<p>Utilisez le guide de style pour obtenir une vue d’ensemble de l’apparence de chaque bloc de votre site. Tout vos blocs sont affichés en un seul endroit, accessible en un clin d’œil.</p>\n</div><figure class=\"wp-block-media-text__media\"><img decoding=\"async\" loading=\"lazy\" width=\"560\" height=\"560\" src=\"https://fr.wordpress.org/files/2023/03/about-style-book.png\" alt=\"\" class=\"wp-image-2671 size-full\" srcset=\"https://fr.wordpress.org/files/2023/03/about-style-book.png 560w, https://fr.wordpress.org/files/2023/03/about-style-book-300x300.png 300w, https://fr.wordpress.org/files/2023/03/about-style-book-150x150.png 150w\" sizes=\"(max-width: 560px) 100vw, 560px\" /></figure></div>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile\" style=\"grid-template-columns:auto 23%\"><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\" style=\"font-size:20px\">Copier / coller les styles en un clin d’œil</h3>\n\n\n\n<p>Travaillez votre design sur un type de bloc, puis copiez et collez ces styles sur d’autres blocs pour obtenir exactement l’aspect que vous souhaitez.</p>\n</div><figure class=\"wp-block-media-text__media\"><img decoding=\"async\" loading=\"lazy\" width=\"560\" height=\"560\" src=\"https://fr.wordpress.org/files/2023/03/about-copy-paste.png\" alt=\"\" class=\"wp-image-2672 size-full\" srcset=\"https://fr.wordpress.org/files/2023/03/about-copy-paste.png 560w, https://fr.wordpress.org/files/2023/03/about-copy-paste-300x300.png 300w, https://fr.wordpress.org/files/2023/03/about-copy-paste-150x150.png 150w\" sizes=\"(max-width: 560px) 100vw, 560px\" /></figure></div>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile\" style=\"grid-template-columns:auto 23%\"><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\" style=\"font-size:20px\">CSS personnalisé</h3>\n\n\n\n<p>Améliorez votre site à votre guise en ajoutant votre propre CSS sur votre site ou sur vos blocs, pour un niveau de contrôle encore plus important sur l’apparence de votre site.</p>\n</div><figure class=\"wp-block-media-text__media\"><img decoding=\"async\" loading=\"lazy\" width=\"560\" height=\"560\" src=\"https://fr.wordpress.org/files/2023/03/about-custom-css.png\" alt=\"\" class=\"wp-image-2673 size-full\" srcset=\"https://fr.wordpress.org/files/2023/03/about-custom-css.png 560w, https://fr.wordpress.org/files/2023/03/about-custom-css-300x300.png 300w, https://fr.wordpress.org/files/2023/03/about-custom-css-150x150.png 150w\" sizes=\"(max-width: 560px) 100vw, 560px\" /></figure></div>\n\n\n\n<h3 class=\"wp-block-heading\" style=\"font-size:20px\">Positionnement épinglé</h3>\n\n\n\n<p>Maintenez certains blocs important en haut de page lorsque les internautes la font défiler.</p>\n\n\n\n<h3 class=\"wp-block-heading\" style=\"font-size:20px\">Importation des widgets</h3>\n\n\n\n<p>Options pour importer vos widgets préférés depuis les thèmes classiques vers les thèmes basés sur des blocs.</p>\n\n\n\n<h3 class=\"wp-block-heading\" style=\"font-size:20px\">Polices embarquées depuis les thèmes</h3>\n\n\n\n<p>Les thèmes par défaut proposés par WordPress offrent un meilleur respect des données personnelles en embarquant les polices Google en local.</p>\n\n\n\n<h3 class=\"wp-block-heading\">En savoir plus sur WordPress 6.2</h3>\n\n\n\n<p>Visitez&nbsp;<a href=\"https://learn.wordpress.org/\">learn.wordpress.org</a>&nbsp;pour des tutoriels vidéos, des ateliers en ligne, des cours et des plans de cours pour les personnes organisant des évènements, et pour des contenus présentant les nouvelles fonctionnalités de WordPress.</p>\n\n\n\n<p>Consultez notre&nbsp;<a href=\"https://fr.wordpress.org/2023/03/10/guide-des-changements-techniques-de-wordpress-6-2/\">guide des changements techniques introduits par WordPress 6.2</a>. Il contient toutes les notes techniques que vous devez connaître si vous développez sur WordPress.</p>\n\n\n\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-6-2/\">Lire les notes de développement de WordPress 6.2 (en anglais)</a>&nbsp;pour obtenir plus d’informations sur les améliorations proposées et les anomalies corrigées, les informations d’installation, les notes et ressources à destination des développeuses et des développeurs, connaître les personnes ayant contribué à cette version et pour obtenir la liste des fichiers modifiés.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WP 6.2</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul>\n<li>Direction générale&nbsp;: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination de la version&nbsp;: <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a></li>\n\n\n\n<li>Direction technique du cœur WP&nbsp;: <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a></li>\n\n\n\n<li>Direction technique Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a></li>\n\n\n\n<li>Gestion de projet côté cœur WP : <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Gestion de projet côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a>, <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a></li>\n\n\n\n<li>Responsable du design&nbsp;: <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Coordination de la documentation&nbsp;: <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>, <a href=\"https://profiles.wordpress.org/femkreations/\">Femy Praseet</a>, <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a>, <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a></li>\n\n\n\n<li>Coordination de la communication&nbsp;: <a href=\"https://profiles.wordpress.org/jpantani/\">Jonathan Pantani</a>, <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a>, <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Coordination des tests&nbsp;: <a href=\"https://profiles.wordpress.org/robinwpdeveloper/\">Robin</a>, <a href=\"https://profiles.wordpress.org/adeltahri/\">Adel Tahri</a></li>\n\n\n\n<li>Responsable de l&rsquo;optimisation des performances&nbsp;: <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.2 n&rsquo;aurait pas pu sortir sans la contribution passionnée de plus de 600 personnes provenant d&rsquo;au moins 50 pays différents. Un remerciement tout spécial pour les 178 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.2 <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> </p>\n\n\n\n<p>Les personnes listées ci-dessous démontrent la vitalité et le dynamisme de notre belle communauté open-source, merci à elles&nbsp;!</p>\n\n\n\n<p style=\"font-size:12px\"><a href=\"https://profiles.wordpress.org/10upsimon/\">10upsimon</a> · <a href=\"https://profiles.wordpress.org/254volkan/\">254volkan</a> · <a href=\"https://profiles.wordpress.org/mercime/\">@mercime</a> · <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a> · <a href=\"https://profiles.wordpress.org/aeg0125/\">Aaron Graham</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abidhasan112/\">Abid Hasan</a> · <a href=\"https://profiles.wordpress.org/abitofmind/\">abitofmind</a> · <a href=\"https://profiles.wordpress.org/abtop/\">ABTOP</a> · <a href=\"https://profiles.wordpress.org/ace100/\">ace100</a> · <a href=\"https://profiles.wordpress.org/bosconiandynamics/\">Adam Bosco</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/admwgn/\">Adam Wiltgen</a> · <a href=\"https://profiles.wordpress.org/adeltahri/\">Adel Tahri</a> · <a href=\"https://profiles.wordpress.org/adhun/\">Adhun Anand</a> · <a href=\"https://profiles.wordpress.org/adityaarora010196/\">adityaarora010196</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/afshanadiya/\">Afshana Diya</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/ajmaurya/\">Ajay Maurya</a> · <a href=\"https://profiles.wordpress.org/ajayver/\">ajayver</a> · <a href=\"https://profiles.wordpress.org/seakashdiu/\">Akash Mia</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanjacobmathew/\">Alan Jacob Mathew</a> · <a href=\"https://profiles.wordpress.org/albarin/\">albarin</a> · <a href=\"https://profiles.wordpress.org/alberuni-azad/\">Alberuni Azad.</a> · <a href=\"https://profiles.wordpress.org/alecgeatches/\">alecgeatches</a> · <a href=\"https://profiles.wordpress.org/aleksganev/\">Aleks Ganev</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alvastar/\">alvastar</a> · <a href=\"https://profiles.wordpress.org/alvitazwar052/\">Alvi Tazwar</a> · <a href=\"https://profiles.wordpress.org/amin7/\">amin</a> · <a href=\"https://profiles.wordpress.org/amirrezatm/\">amirrezatm</a> · <a href=\"https://profiles.wordpress.org/amitbarai013/\">Amit Barai Alit</a> · <a href=\"https://profiles.wordpress.org/paulamit/\">Amit Paul</a> · <a href=\"https://profiles.wordpress.org/anantajitjg/\">Anantajit JG</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andreaboe/\">andreaboe</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/apmatthe/\">Andrew Matthews</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey “Rarst” Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a> · <a href=\"https://profiles.wordpress.org/aniketpatel/\">Aniket Patel</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antonyagrios/\">Antony Agrios</a> · <a href=\"https://profiles.wordpress.org/aparnajl/\">Aparna Adhun</a> · <a href=\"https://profiles.wordpress.org/arrasel403/\">AR Rasel</a> · <a href=\"https://profiles.wordpress.org/arafatjamil01/\">Arafat Jamil</a> · <a href=\"https://profiles.wordpress.org/aravindajith/\">Aravind Ajith</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/arnolp/\">arnolp</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/artz91/\">ArtZ91</a> · <a href=\"https://profiles.wordpress.org/aryamaaru/\">Arun</a> · <a href=\"https://profiles.wordpress.org/mrasharirfan/\">Ashar Irfan</a> · <a href=\"https://profiles.wordpress.org/ashrafulsarkar/\">Ashraful Sarkar Naiem</a> · <a href=\"https://profiles.wordpress.org/nmutua/\">Autumn</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/azurseisme/\">azurseisme</a> · <a href=\"https://profiles.wordpress.org/barryceelen/\">Barry Ceelen</a> · <a href=\"https://profiles.wordpress.org/bart/\">Bart</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/benish74/\">benish74</a> · <a href=\"https://profiles.wordpress.org/benjgrolleau/\">Benjamin Grolleau</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">Bernie Reiter</a> · <a href=\"https://profiles.wordpress.org/mxbclang/\">Bethany Chobanian Lang</a> · <a href=\"https://profiles.wordpress.org/bgin/\">bgin</a> · <a href=\"https://profiles.wordpress.org/albatross10/\">Bhavik Kalpesh</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>&nbsp;· <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> ·&nbsp;<a href=\"https://profiles.wordpress.org/bjorn2404/\">bjorn2404</a> · <a href=\"https://profiles.wordpress.org/bogdanungureanu/\">BogdanUngureanu</a> · <a href=\"https://profiles.wordpress.org/bonjour52/\">bonjour52</a> · <a href=\"https://profiles.wordpress.org/bookwyrm/\">bookwyrm</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradyvercher/\">Brady Vercher</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/bgoewert/\">Brennan Goewert</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/bronsonquick/\">bronsonquick</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke Kaminski</a> · <a href=\"https://profiles.wordpress.org/brookedot/\">Brooke.</a> · <a href=\"https://profiles.wordpress.org/buutqn/\">buutqn</a> · <a href=\"https://profiles.wordpress.org/cameronjonesweb/\">Cameron Jones</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos Garcia Prim</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/critterverse/\">Channing Ritter</a> · <a href=\"https://profiles.wordpress.org/mcaskill/\">Chauncey McAskill</a> · <a href=\"https://profiles.wordpress.org/chintan1896/\">Chintan hingrajiya</a> · <a href=\"https://profiles.wordpress.org/chiragrathod103/\">Chirag Rathod</a> · <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloe Bringmann</a> · <a href=\"https://profiles.wordpress.org/chocofc1/\">chocofc1</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisbaltazar/\">chrisbaltazar</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/chrystl/\">Chrystl</a> · <a href=\"https://profiles.wordpress.org/ckanderson22/\">ckanderson22</a> · <a href=\"https://profiles.wordpress.org/claytoncollie/\">Clayton Collie</a> · <a href=\"https://profiles.wordpress.org/cnspecialcolor/\">cnspecialcolor</a> · <a href=\"https://profiles.wordpress.org/codesdnc/\">codesdnc</a> · <a href=\"https://profiles.wordpress.org/codingchicken/\">Coding Chicken</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/conner_bw/\">conner_bw</a> · <a href=\"https://profiles.wordpress.org/copons/\">Copons</a> · <a href=\"https://profiles.wordpress.org/corentingautier/\">corentingautier</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">Cory Birdsong</a> · <a href=\"https://profiles.wordpress.org/craigfrancis/\">Craig Francis</a> · <a href=\"https://profiles.wordpress.org/craiglpeters/\">craiglpeters</a> · <a href=\"https://profiles.wordpress.org/geisthanen/\">Creative Andrew</a> · <a href=\"https://profiles.wordpress.org/mitogh/\">Crisoforo Gaspar</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/dperonne/\">D.PERONNE</a> · <a href=\"https://profiles.wordpress.org/daisyo/\">Daisy Olsen</a> · <a href=\"https://profiles.wordpress.org/dalirajab/\">dali-rajab</a> · <a href=\"https://profiles.wordpress.org/dalleyne/\">Damien Alleyne</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/wirecat/\">Daniel Johnson</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/datagutten/\">datagutten</a> · <a href=\"https://profiles.wordpress.org/davilera/\">David Aguilera</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dgwyer/\">David Gwyer</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/davefx/\">David Marín Carreño</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/davidvongries/\">David Vongries</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/dennisatyoast/\">Dennis Claassen</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">derekblank</a> · <a href=\"https://profiles.wordpress.org/devanshijoshi/\">devanshijoshi</a> · <a href=\"https://profiles.wordpress.org/dhusakovic/\">dhusakovic</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/doctorlai/\">doctorlai</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/donncha/\">Donncha</a> · <a href=\"https://profiles.wordpress.org/drzraf/\">drzraf</a> · <a href=\"https://profiles.wordpress.org/d-signed/\">DSIGNED</a> · <a href=\"https://profiles.wordpress.org/dustinrue/\">dustinrue</a> · <a href=\"https://profiles.wordpress.org/chopinbach/\">Edwin Cromley</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/emanuelx/\">emanuelx</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/enej/\">Enej Bajgorić</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/edanzer/\">Erick Danzer</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik Betshammar</a> · <a href=\"https://profiles.wordpress.org/esratpopy/\">Esrat Sultana Popy</a> · <a href=\"https://profiles.wordpress.org/manuilov/\">Eugene M</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/fosuahmed/\">Faisal Ahmed</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fasuto/\">fasuto</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/felipelavinz/\">Felipe Lavín</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/femkreations/\">Femy Praseeth</a> · <a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a> · <a href=\"https://profiles.wordpress.org/fpodhorsky/\">fpodhorsky</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/bueltge/\">Frank Bueltge</a> · <a href=\"https://profiles.wordpress.org/franz00/\">franzaurus</a> · <a href=\"https://profiles.wordpress.org/fuadragib/\">Fuad Ragib</a> · <a href=\"https://profiles.wordpress.org/galbaras/\">Gal Baras</a> · <a href=\"https://profiles.wordpress.org/gamecreature/\">gamecreature</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/revgeorge/\">George Hotelling</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/gisgeo/\">gisgeo</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/grl570810/\">grl570810</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">gvgvgvijayan</a> · <a href=\"https://profiles.wordpress.org/hvar/\">H-var</a> · <a href=\"https://profiles.wordpress.org/hakre/\">hakre</a> · <a href=\"https://profiles.wordpress.org/hanshenrik/\">hanshenrik</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/haritpanchal/\">Harit Panchal</a> · <a href=\"https://profiles.wordpress.org/hasanmisbah/\">Hasan Misbah</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/ehtmlu/\">Helmut Wandl</a> · <a href=\"https://profiles.wordpress.org/luehrsen/\">Hendrik Luehrsen</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/hiren1094/\">hiren sanja</a> · <a href=\"https://profiles.wordpress.org/patelhitesh/\">Hitesh Patel</a> · <a href=\"https://profiles.wordpress.org/hughiemolloy/\">hughie.molloy</a> · <a href=\"https://profiles.wordpress.org/hugodevos/\">hugodevos</a> · <a href=\"https://profiles.wordpress.org/hztyfoon/\">hztyfoon</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/polevaultweb/\">Iain Poulson</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/iazel/\">Iazel</a> · <a href=\"https://profiles.wordpress.org/ignatggeorgiev/\">Ignat Georgiev</a> · <a href=\"https://profiles.wordpress.org/imanish003/\">imanish003</a> · <a href=\"https://profiles.wordpress.org/ingeniumed/\">ingeniumed</a> · <a href=\"https://profiles.wordpress.org/innovext/\">Innovext</a> · <a href=\"https://profiles.wordpress.org/inwerpsel/\">inwerpsel</a> · <a href=\"https://profiles.wordpress.org/iqbalrony/\">iqbalrony</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">ironprogrammer</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/ivanjeronimo/\">ivanjeronimo</a> · <a href=\"https://profiles.wordpress.org/jhoffmann/\">j.hoffmann</a> · <a href=\"https://profiles.wordpress.org/jackreichert/\">Jack Reichert</a> · <a href=\"https://profiles.wordpress.org/jaedm97/\">Jaed Mosharraf</a> · <a href=\"https://profiles.wordpress.org/jakariaistauk/\">Jakaria Istauk</a> · <a href=\"https://profiles.wordpress.org/outrankjames/\">James</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/james-roberts/\">James Roberts</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">Jan Thiel</a> · <a href=\"https://profiles.wordpress.org/janusdev/\">janusdev</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/ipajen/\">Jarko Piironen</a> · <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a> · <a href=\"https://profiles.wordpress.org/carazo/\">Javier Carazo</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jchambo/\">jchambo</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jeanphilippegreen/\">Jean-Philippe Green</a> · <a href=\"https://profiles.wordpress.org/jeawhanlee/\">jeawhanlee</a> · <a href=\"https://profiles.wordpress.org/jeffmatson/\">Jeff Matson</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jmdodd/\">Jennifer M. Dodd</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/lobeless14/\">Jeremy Lind</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jhned/\">jhned</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">jigar bhanushali</a> · <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelmadigan/\">joelmadigan</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnwatkins0/\">John Watkins</a> · <a href=\"https://profiles.wordpress.org/jokerrs/\">Jokerrs</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/jpantani/\">Jonathan Pantani</a> · <a href=\"https://profiles.wordpress.org/jongycastillo/\">Jong</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/jornp/\">jornp</a> · <a href=\"https://profiles.wordpress.org/dunhakdis/\">Joseph G.</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden</a> · <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jsh4/\">jsh4</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/juliobox/\">Julio Potier</a> · <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/welenofsky/\">Justin Welenofsky</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">justlevine</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kacper3355/\">kacper3355</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a> · <a href=\"https://profiles.wordpress.org/kaneva/\">kaneva</a> · <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a> · <a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn P.</a> · <a href=\"https://profiles.wordpress.org/kkoppenhaver/\">Keanan Koppenhaver</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kellychoffman/\">Kelly Hoffman</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">Kevin Batdorf</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/konyoldeath/\">konyoldeath</a> · <a href=\"https://profiles.wordpress.org/kowsar89/\">Kowsar Hossain</a> · <a href=\"https://profiles.wordpress.org/krunal265/\">Krunal Bhimajiyani</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kmadhak/\">Kunal Madhak</a> · <a href=\"https://profiles.wordpress.org/lanacodes/\">Lana Codes</a> · <a href=\"https://profiles.wordpress.org/larsmqller/\">larsmqller</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lenasterg/\">Lena Stergatou</a> · <a href=\"https://profiles.wordpress.org/leonidasmilossis/\">Leo Milo</a> · <a href=\"https://profiles.wordpress.org/lifeboat/\">lifeboat</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/webaxones/\">Loïc Antignac</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/dreadlox/\">Lox</a> · <a href=\"https://profiles.wordpress.org/lozula/\">lozula</a> · <a href=\"https://profiles.wordpress.org/lucius0101/\">lucius0101</a> · <a href=\"https://profiles.wordpress.org/lucymtc/\">Lucy Tomas</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/pyrobd/\">Lukman Nakib</a> · <a href=\"https://profiles.wordpress.org/pagelab/\">Márcio Duarte</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mahbubshovan/\">Mahbub Shovan</a> · <a href=\"https://profiles.wordpress.org/mahekkalola/\">Mahek Kalola</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manojkpatil/\">Manoj Patil</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/marekdedic/\">Marek Dědič</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/marissamakes/\">Marissa Matthews</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markoserb/\">Marko Ivanovic</a> · <a href=\"https://profiles.wordpress.org/marksabbath/\">marksabbath</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/mkox/\">Markus Kosmal</a> · <a href=\"https://profiles.wordpress.org/mhkuu/\">Martijn van der Klis</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/matclayton/\">matclayton</a> · <a href=\"https://profiles.wordpress.org/wetah/\">Mateus Machado Luna</a> · <a href=\"https://profiles.wordpress.org/paapst/\">Mathieu Paapst</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">matiasbenedetto</a> · <a href=\"https://profiles.wordpress.org/mattkeys/\">Matt Keys</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/matthiasreinholz/\">Matthias Reinholz</a> · <a href=\"https://profiles.wordpress.org/h4l9k/\">Mauricio</a> · <a href=\"https://profiles.wordpress.org/wppunk/\">Max</a> · <a href=\"https://profiles.wordpress.org/cadic/\">Max Lyuchin</a> · <a href=\"https://profiles.wordpress.org/maximej/\">Maxime J.</a> · <a href=\"https://profiles.wordpress.org/jamilbd07/\">MD Jamil Uddin</a> · <a href=\"https://profiles.wordpress.org/kawserz/\">Md Kawser Ahmed Khan Jami</a> · <a href=\"https://profiles.wordpress.org/rakibwordpress/\">Md Rakib Hossain</a> · <a href=\"https://profiles.wordpress.org/abirhasandipu/\">Md. Abir Hasan Dipu</a> · <a href=\"https://profiles.wordpress.org/reduanmasud/\">Md. Reduan Masud</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/mehulkaklotar/\">Mehul Kaklotar</a> · <a href=\"https://profiles.wordpress.org/mensmaximus/\">mensmaximus</a> · <a href=\"https://profiles.wordpress.org/meyegui/\">meyerdev.ch</a> · <a href=\"https://profiles.wordpress.org/mgol/\">mgol</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/michael-kelly/\">Michael Kelly</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michelmany/\">Michel Many</a> · <a href=\"https://profiles.wordpress.org/miguelaxcar/\">Miguel Axcar</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/mmtr86/\">Miguel Torres</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikestraw/\">Mike Straw</a> · <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/multidots1896/\">Minal Diwan</a> · <a href=\"https://profiles.wordpress.org/mitchellaustin/\">mitchellaustin</a> · <a href=\"https://profiles.wordpress.org/presents111/\">miya</a> · <a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/mtias/\">mtias</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/tanjimtc71/\">Musarrat Anjum Chowdhury</a> · <a href=\"https://profiles.wordpress.org/amustaque97/\">Mustaque Ahmed</a> · <a href=\"https://profiles.wordpress.org/mw108/\">mw108</a> · <a href=\"https://profiles.wordpress.org/naeemhaque/\">Naeem Haque</a> · <a href=\"https://profiles.wordpress.org/namithjawahar/\">Namith Jawahar</a> · <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a> · <a href=\"https://profiles.wordpress.org/nazmulhasan103/\">Nazmul Hasan</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/neychok/\">Neycho Kalaydzhiev</a> · <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a> · <a href=\"https://profiles.wordpress.org/nicholaswilson/\">nicholaswilson</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/nick_thegeek/\">Nick the Geek</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/itsnikhilpatel/\">NikhilPatel</a> · <a href=\"https://profiles.wordpress.org/dhrupo/\">Niluthpal Purkayastha</a> · <a href=\"https://profiles.wordpress.org/dasnitesh780/\">Nitesh Das</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/rnitinb/\">Nitin Rathod</a> · <a href=\"https://profiles.wordpress.org/nitman43/\">nitman43</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/nuvopoint/\">nuvoPoint</a> · <a href=\"https://profiles.wordpress.org/oakesjosh/\">oakesjosh</a> · <a href=\"https://profiles.wordpress.org/obayedmamur/\">Obayed Mamur</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/oh_hello/\">oh_hello</a> · <a href=\"https://profiles.wordpress.org/hideokamoto/\">Okamoto Hidetaka</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/olliejones/\">OllieJones</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pablohoney/\">PabloHoney</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paulschreiber/\">Paul Schreiber</a> · <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a> · <a href=\"https://profiles.wordpress.org/pbking/\">pbking</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a> · <a href=\"https://profiles.wordpress.org/pputzer/\">pepe</a> · <a href=\"https://profiles.wordpress.org/petaryoast/\">Petar Ratković</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/walbo/\">Petter Walbø Johnsgård</a> · <a href=\"https://profiles.wordpress.org/phil-webster/\">Phil Webster</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/iapial/\">Pial</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> · <a href=\"https://profiles.wordpress.org/knowingart_com/\">PJ Brunet</a> · <a href=\"https://profiles.wordpress.org/pkolenbr/\">pkolenbr</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pravinparmar2404/\">Pravin Parmar</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/ptahdunbar/\">Ptah Dunbar</a> · <a href=\"https://profiles.wordpress.org/pypwalters/\">pypwalters</a> · <a href=\"https://profiles.wordpress.org/raduiason/\">raduiason</a> · <a href=\"https://profiles.wordpress.org/initsogar/\">Rafael Agostini</a> · <a href=\"https://profiles.wordpress.org/rafinkhan/\">Rafin</a> · <a href=\"https://profiles.wordpress.org/rajanpanchal2028/\">Rajan Panchal</a> · <a href=\"https://profiles.wordpress.org/rajeshraval786/\">Rajesh Raval</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/ramon-fincken/\">ramon fincken</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/razthee007/\">Razthee Md. Yakini</a> · <a href=\"https://profiles.wordpress.org/renatoagds/\">Renato Augusto Gama dos Santos</a> · <a href=\"https://profiles.wordpress.org/rezakhan995/\">Reza Khan</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/riccardodicurti/\">Riccardo Di Curti</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rinkychowdhury9/\">Rinky Chowdhury</a> · <a href=\"https://profiles.wordpress.org/ritteshpatel/\">Ritesh Patel</a> · <a href=\"https://profiles.wordpress.org/rjasdfiii/\">rjasdfiii</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/robinwpdeveloper/\">Robin</a> · <a href=\"https://profiles.wordpress.org/robin-labadie/\">Robin Labadie</a> · <a href=\"https://profiles.wordpress.org/rodage/\">rodage</a> · <a href=\"https://profiles.wordpress.org/rodricus/\">rodricus</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/digical/\">Ross Gile</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/re_enter_rupok/\">Rupok</a> · <a href=\"https://profiles.wordpress.org/rryyaanndd/\">Ryan</a> · <a href=\"https://profiles.wordpress.org/ryankienstra/\">Ryan Kienstra</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sereedmedia/\">Sé Reed</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">Sérgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wrede</a> · <a href=\"https://profiles.wordpress.org/andy786/\">Sahil B.</a> · <a href=\"https://profiles.wordpress.org/stalukder03/\">Sajib Talukder</a> · <a href=\"https://profiles.wordpress.org/sakibmd/\">Sakib Mohammed</a> · <a href=\"https://profiles.wordpress.org/samful/\">Sam Fullalove</a> · <a href=\"https://profiles.wordpress.org/sam1el/\">sam1el</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/samruddhikhandale/\">samruddhikhandale</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sanjucta/\">sanjucta</a> · <a href=\"https://profiles.wordpress.org/sanketchodavadiya/\">Sanket Chodavadiya</a> · <a href=\"https://profiles.wordpress.org/sannevndrmeulen/\">Sanne van der Meulen</a> · <a href=\"https://profiles.wordpress.org/sapayth/\">sapayth</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/saumil1611/\">Saumil Nerpagar</a> · <a href=\"https://profiles.wordpress.org/ira2910/\">Sazia Faizunnessa Ira</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/countrymusicchicago/\">Scott Winterroth</a> · <a href=\"https://profiles.wordpress.org/hiyascout/\">Scout James</a> · <a href=\"https://profiles.wordpress.org/seanchayes/\">Sean Hayes</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/seriouslysenpai/\">seriouslysenpai</a> · <a href=\"https://profiles.wordpress.org/wandering-aramean/\">Seth Miller</a> · <a href=\"https://profiles.wordpress.org/shahidul95/\">Shahidul Islam</a> · <a href=\"https://profiles.wordpress.org/shamayel007/\">Shamayel</a> · <a href=\"https://profiles.wordpress.org/shamimmiashuhagh/\">Shamim Mia</a> · <a href=\"https://profiles.wordpress.org/smeunus/\">Sharif Mohammad Eunus</a> · <a href=\"https://profiles.wordpress.org/shraboni/\">Shraboni</a> · <a href=\"https://profiles.wordpress.org/shubham1gupta/\">shubham1gupta</a> · <a href=\"https://profiles.wordpress.org/silicium23/\">Silicium</a> · <a href=\"https://profiles.wordpress.org/simongomes02/\">Simon Gomes</a> · <a href=\"https://profiles.wordpress.org/slieschke/\">Simon Lieschke</a> · <a href=\"https://profiles.wordpress.org/siobhan/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/calvinalkan/\">snicco.io</a> · <a href=\"https://profiles.wordpress.org/sruthi90/\">sruthi90</a> · <a href=\"https://profiles.wordpress.org/steelwagstaff/\">SteelWagstaff</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stentibbing/\">stentibbing</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephym/\">Stephy Miehle</a> · <a href=\"https://profiles.wordpress.org/stephymiehle/\">stephymiehle</a> · <a href=\"https://profiles.wordpress.org/stevenkword/\">Steven Word</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sun/\">sun</a> · <a href=\"https://profiles.wordpress.org/sunyatasattva/\">sunyatasattva (a11n)</a> · <a href=\"https://profiles.wordpress.org/codemonksuvro/\">Suvro</a> · <a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/afrin29/\">Syeda Sanjida Afrin</a> · <a href=\"https://profiles.wordpress.org/syhc/\">syhc</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/syntaxart/\">syntaxart</a> · <a href=\"https://profiles.wordpress.org/szaqal21/\">szaqal21</a> · <a href=\"https://profiles.wordpress.org/tahmidulkarim/\">Tahmid ul Karim</a> · <a href=\"https://profiles.wordpress.org/tahminar27/\">tahminar27</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/tanazmasaba/\">Tanaz Masaba</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/tanner-m/\">Tanner Moushey</a> · <a href=\"https://profiles.wordpress.org/rahmantasnia/\">Tasnia Rahman Raima</a> · <a href=\"https://profiles.wordpress.org/teebee/\">teebee</a> · <a href=\"https://profiles.wordpress.org/tekapo/\">tekapo</a> · <a href=\"https://profiles.wordpress.org/thedaysse/\">thedaysse</a> · <a href=\"https://profiles.wordpress.org/iamjaydip/\">thejaydip</a> · <a href=\"https://profiles.wordpress.org/theode/\">theode</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/thomasplevy/\">Thomas Patrick Levy</a> · <a href=\"https://profiles.wordpress.org/thomask/\">thomask</a> · <a href=\"https://profiles.wordpress.org/timbroddin/\">timbroddin</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/dziudek/\">Tomasz Dziuda</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a> · <a href=\"https://profiles.wordpress.org/starbuck/\">Tony G</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a> · <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul I Chowdhury</a> · <a href=\"https://profiles.wordpress.org/travisaxton/\">travisaxton</a> · <a href=\"https://profiles.wordpress.org/triumvirate/\">triumvirate</a> · <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a> · <a href=\"https://profiles.wordpress.org/umesh84/\">Umesh Gupta</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a> · <a href=\"https://profiles.wordpress.org/virgar/\">Virginie Garnier</a> · <a href=\"https://profiles.wordpress.org/elifvish/\">Vishal Kumar</a> · <a href=\"https://profiles.wordpress.org/vladytimy/\">Vlad T</a> · <a href=\"https://profiles.wordpress.org/vtad/\">vtad</a> · <a href=\"https://profiles.wordpress.org/vykesmac/\">vykesmac</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/webrocker/\">Webrocker</a> · <a href=\"https://profiles.wordpress.org/websitegenii/\">websitegenii</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whaze/\">whaze</a> · <a href=\"https://profiles.wordpress.org/winterpsv/\">winterpsv</a> · <a href=\"https://profiles.wordpress.org/wojsmol/\">wojsmol</a> · <a href=\"https://profiles.wordpress.org/wojtekn/\">Wojtek Naruniec</a> · <a href=\"https://profiles.wordpress.org/wojtekszkutnik/\">Wojtek Szkutnik</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/zebaafiashama/\">Zeba Afia Shama</a> · <a href=\"https://profiles.wordpress.org/zenaulislam/\">Zenaul Islam</a> · <a href=\"https://profiles.wordpress.org/zevilz/\">zevilz</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></p>\n\n\n\n<h3 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.2 en français</h3>\n\n\n\n<p>WordPress est un projet international et la version 6.2 est déjà complètement disponible dans plus de 70 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress 6.2 en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/btpub\">Bruno Tritsch</a>,&nbsp;<a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>,&nbsp;<a href=\"https://profiles.wordpress.org/fxbenard\">FX Bénard</a>, <a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>,&nbsp;<a href=\"https://profiles.wordpress.org/gaellebesson\">gaellebesson</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/webaxones\">Loïc Antignac</a>,&nbsp;<a href=\"https://profiles.wordpress.org/lulucmy\">lulucmy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/oellin\">Magali</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nuryko\">Marianna</a>,&nbsp;<a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>,&nbsp;<a href=\"https://profiles.wordpress.org/maxpertici\">Maxime Pertici</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nandow\">nandow</a>,&nbsp;<a href=\"https://profiles.wordpress.org/petitphp\">petitphp</a>,&nbsp;<a href=\"https://profiles.wordpress.org/larrach\">Rachel Peter</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>,&nbsp;<a href=\"https://profiles.wordpress.org/stephanepoisson\">Stéphane POISSON</a>,&nbsp;<a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>,&nbsp;<a href=\"https://profiles.wordpress.org/virgar\">Virginie Garnier</a>,&nbsp;<a href=\"https://profiles.wordpress.org/whaze\">whaze</a>,&nbsp;<a href=\"https://profiles.wordpress.org/alexisgrolot\">WordPress Express</a>, et&nbsp;<a href=\"https://profiles.wordpress.org/wplmillet\">wplmillet</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://fr.wordpress.org/2023/03/30/wordpress-6-2-dolphy/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:76:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2023/03/10/guide-des-changements-techniques-de-wordpress-6-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://fr.wordpress.org/2023/03/10/guide-des-changements-techniques-de-wordpress-6-2/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Mar 2023 12:09:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2612\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:475:\"Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&#160;6.2, dont la sortie est prévue le 28 mars 2023. WordPress 6.2 corrige quelque 300 tickets Trac&#160;:&#160;110 sont des améliorations et nouvelles fonctionnalités,&#160;166 sont des corrections de bogues et&#160;20 sont d’autres tâches courantes. On retrouvera 28 améliorations de performances,&#160;15 améliorations d’accessibilité et&#160;18 améliorations de [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:40678:\"\n<p>Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&nbsp;6.2, dont la sortie est prévue le 28 mars 2023.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2023/03/wp62-field-guide-1.png\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"591\" src=\"https://fr.wordpress.org/files/2023/03/wp62-field-guide-1-1024x591.png\" alt=\"\" class=\"wp-image-2614\" srcset=\"https://fr.wordpress.org/files/2023/03/wp62-field-guide-1-1024x591.png 1024w, https://fr.wordpress.org/files/2023/03/wp62-field-guide-1-300x173.png 300w, https://fr.wordpress.org/files/2023/03/wp62-field-guide-1-768x443.png 768w, https://fr.wordpress.org/files/2023/03/wp62-field-guide-1.png 1486w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>WordPress 6.2 corrige <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.2&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">quelque 300 tickets Trac</a>&nbsp;:&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.2&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">110 sont des améliorations et nouvelles fonctionnalités</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.2&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">166 sont des corrections de bogues</a> et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.2&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">20 sont d’autres tâches courantes</a>.</p>\n\n\n\n<p>On retrouvera <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.2&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">28 améliorations de performances</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.2&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">15 améliorations d’accessibilité</a> et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.2&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">18 améliorations de code</a> notamment dédiées à la prise en charge des versions les plus récentes de PHP.</p>\n\n\n\n<p>Du côté du projet Gutenberg, <a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.2\">1645 pull requests</a> ont été fusionnées au cœur de WordPress&nbsp;: 292 améliorations, 354&nbsp;corrections de bogues et 30 améliorations concernant l’accessibilité de l’éditeur.</p>\n\n\n\n<p>Les modifications apportées par WP&nbsp;6.2 concernent 44&nbsp;composants du cœur WordPress. Vous trouverez dans cet article des précisions concernant les modifications les plus impactantes.</p>\n\n\n\n<p class=\"has-text-color\" style=\"color:#14825a\">En route pour un petit tour d’horizon des<br>nouveautés techniques de WordPress&nbsp;6.2&nbsp;<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f680.png\" alt=\"🚀\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais.</p>\n\n\n\n<p>L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p class=\"has-background\" style=\"background-color:#fee7af\">À noter&nbsp;: certaines modifications listées ici vont nécessiter des actions de la part des auteurs et autrices de thèmes et d’extensions, qui devront adapter ou modifier leur code. Si vous êtes concerné·e, veuillez lire les notes de développement listées dans cet article consciencieusement afin de vous assurer que votre code fonctionnera avec WordPress&nbsp;6.2 lorsque cette version sortira le 28&nbsp;mars 2023.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"Themes\">Les polices Google Font sont maintenant incluses localement dans les thèmes natifs</h2>\n\n\n\n<p>Suite aux incertitudes juridiques liées à l’utilisation des polices <em>Google Fonts</em> directement chargées depuis les serveurs de Google, les thèmes natifs qui embarquaient auparavant directement des polices provenant des serveurs de Google ne le feront plus à partir de WordPress 6.2.</p>\n\n\n\n<p>Cela concerne les thèmes suivants&nbsp;:</p>\n\n\n\n<ul>\n<li><em>Twenty Twelve</em> à partir de sa version 3.9</li>\n\n\n\n<li><em>Twenty Thirteen</em> à partir de sa version 3.8</li>\n\n\n\n<li><em>Twenty Fourteen</em> à partir de sa version 3.6</li>\n\n\n\n<li><em>Twenty Fifteen</em> à partir de sa version 3.4</li>\n\n\n\n<li><em>Twenty Sixteen</em> à partir de sa version 2.9</li>\n\n\n\n<li><em>Twenty Seventeen</em> à partir de sa version 3.2</li>\n</ul>\n\n\n\n<p>Les autres thèmes natifs n&rsquo;utilisent pas directement de polices Google et ne sont donc pas concernés par cette modification.</p>\n\n\n\n<p>À partir de maintenant, chaque thème concerné va servir une nouvelle feuille de styles depuis son propre répertoire, au sein du domaine de votre site. Si le thème embarque plusieurs polices différentes, votre thème les embarquera en les plaçant dans une seule feuille de styles pour de meilleures performances.</p>\n\n\n\n<p>Voici par exemple la déclaration de feuille de styles de Twenty Thirteen&nbsp;:</p>\n\n\n<div class=\"wp-block-syntaxhighlighter-code \"><pre class=\"brush: css; title: ; notranslate\">\n&lt;link\n	rel=&quot;stylesheet&quot;\n	id=&quot;twentythirteen-fonts-css&quot;\n	href=&quot;https://example.com/wp-content/themes/twentythirteen/fonts/source-sans-pro-plus-bitter.css?ver=20230328&quot;\n	media=&quot;all&quot;\n/&gt;\n</pre></div>\n\n\n<p>Comme vous pouvez le voir, les polices sont maintenant directement embarquées depuis les thèmes natifs, afin d’éviter toute dépendance tierce.</p>\n\n\n\n<p class=\"has-background\" style=\"background-color:#fee7af\"><strong>Attention&nbsp;: si vous avez déjà modifié ou retiré l’appel <em>Google Fonts</em> via un thème enfant ou via une extension, il est recommandé de vérifier que ce changement n’affecte pas votre site.</strong></p>\n\n\n\n<p>Pour en savoir plus, consultez la note de développement suivante&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"Y9fix8byS8\"><a href=\"https://make.wordpress.org/core/2023/03/06/google-fonts-are-included-locally-in-bundled-themes/\">Google Fonts are included locally in bundled themes</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Google Fonts are included locally in bundled themes&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/03/06/google-fonts-are-included-locally-in-bundled-themes/embed/#?secret=LQGDbnYuSO#?secret=Y9fix8byS8\" data-secret=\"Y9fix8byS8\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"blockeditor\">L’éditeur de blocs</h2>\n\n\n\n<p>WordPress 6.2 comprend 10 versions du projet Gutenberg –&nbsp;<a href=\"https://make.wordpress.org/core/2022/09/30/whats-new-in-gutenberg-14-2-28-september/\">14.2</a>, <a href=\"https://make.wordpress.org/core/2022/10/13/whats-new-in-gutenberg-14-3-12-october/\">14.3</a>, <a href=\"https://make.wordpress.org/core/2022/10/27/whats-new-in-gutenberg-14-4-26-october/\">14.4</a>, <a href=\"https://make.wordpress.org/core/2022/11/09/whats-new-in-gutenberg-14-5-9-november/\">14.5</a>, <a href=\"https://make.wordpress.org/core/2022/11/23/whats-new-in-gutenberg-14-6-23-november/\">14.6</a>, <a href=\"https://make.wordpress.org/core/2022/12/09/whats-new-in-gutenberg-14-7-7-december/\">14.7</a>, <a href=\"https://make.wordpress.org/core/2022/12/22/whats-new-in-gutenberg-14-8-21-december/\">14.8</a>, <a href=\"https://make.wordpress.org/core/2023/01/04/whats-new-in-gutenberg-14-9-4-january/\">14.9</a>, <a href=\"https://make.wordpress.org/core/2023/01/20/whats-new-in-gutenberg-15-0-18-january/\">15.0</a> et <a href=\"https://make.wordpress.org/core/2023/02/10/whats-new-in-gutenberg-15-1-8-february/\">15.1</a>. Vous y trouverez de nouvelles API, des mises à niveau de bibliothèques, des améliorations très utiles des Styles globaux, encore plus de fonctionnalités prises en charge nativement par les blocs, de nouveaux crochets d’action et filtres, ainsi que <a href=\"https://core.trac.wordpress.org/ticket/57471\">bien d&rsquo;autres modifications ayant été développées sur ces 10 versions de l’extension Gutenberg</a>.</p>\n\n\n\n<p>Pour en savoir plus, consultez les notes de développement suivantes&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"n2WFGSL2CC\"><a href=\"https://make.wordpress.org/core/2023/03/07/introducing-the-html-api-in-wordpress-6-2/\">Introducing the HTML API in WordPress 6.2</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Introducing the HTML API in WordPress 6.2&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/03/07/introducing-the-html-api-in-wordpress-6-2/embed/#?secret=qWbjG7rDS3#?secret=n2WFGSL2CC\" data-secret=\"n2WFGSL2CC\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"M82WlzFxsu\"><a href=\"https://make.wordpress.org/core/2023/03/07/upgrading-to-react-18-and-common-pitfalls-of-concurrent-mode/\">Upgrading to React 18 and common pitfalls of concurrent mode</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Upgrading to React 18 and common pitfalls of concurrent mode&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/03/07/upgrading-to-react-18-and-common-pitfalls-of-concurrent-mode/embed/#?secret=RpUH01kp4I#?secret=M82WlzFxsu\" data-secret=\"M82WlzFxsu\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"twZm3MCaTb\"><a href=\"https://make.wordpress.org/core/2023/03/06/custom-css-for-global-styles-and-per-block/\">Custom CSS for global styles and per block</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Custom CSS for global styles and per block&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/03/06/custom-css-for-global-styles-and-per-block/embed/#?secret=Gw8tU7aWEg#?secret=twZm3MCaTb\" data-secret=\"twZm3MCaTb\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"ZNOpTU85lt\"><a href=\"https://make.wordpress.org/core/2023/02/19/style-book-preview-of-blocks-in-global-styles/\">Style Book preview of blocks in global styles</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Style Book preview of blocks in global styles&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/02/19/style-book-preview-of-blocks-in-global-styles/embed/#?secret=R3sVocacKE#?secret=ZNOpTU85lt\" data-secret=\"ZNOpTU85lt\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"qZ291B2NN6\"><a href=\"https://make.wordpress.org/core/2023/03/07/shadows-in-global-styles-with-wordpress-6-2/\">Shadows in Global Styles with WordPress 6.2</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Shadows in Global Styles with WordPress 6.2&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/03/07/shadows-in-global-styles-with-wordpress-6-2/embed/#?secret=jkJeKyBLSo#?secret=qZ291B2NN6\" data-secret=\"qZ291B2NN6\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"PWtKtg9YUw\"><a href=\"https://make.wordpress.org/core/2023/03/07/sticky-position-block-support/\">Sticky position block support</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Sticky position block support&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/03/07/sticky-position-block-support/embed/#?secret=AtzJ8mk5KI#?secret=PWtKtg9YUw\" data-secret=\"PWtKtg9YUw\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"U2DStPkdCp\"><a href=\"https://make.wordpress.org/core/2023/03/06/minimum-height-dimensions-block-support/\">Minimum height dimensions block support</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Minimum height dimensions block support&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/03/06/minimum-height-dimensions-block-support/embed/#?secret=uWwtmaDTGe#?secret=U2DStPkdCp\" data-secret=\"U2DStPkdCp\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"BUfnEQcoGS\"><a href=\"https://make.wordpress.org/core/2023/02/28/custom-settings-wordpress-6-2/\">Customize settings for any block in WordPress 6.2</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Customize settings for any block in WordPress 6.2&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/02/28/custom-settings-wordpress-6-2/embed/#?secret=i3GL0VbSTi#?secret=BUfnEQcoGS\" data-secret=\"BUfnEQcoGS\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"pwoOs2XiSD\"><a href=\"https://make.wordpress.org/core/2023/03/07/introduction-of-block-inspector-tabs/\">Introduction of Block Inspector Tabs</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Introduction of Block Inspector Tabs&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/03/07/introduction-of-block-inspector-tabs/embed/#?secret=Kwhyyzdi8U#?secret=pwoOs2XiSD\" data-secret=\"pwoOs2XiSD\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"xxeDIgaDji\"><a href=\"https://make.wordpress.org/core/2022/12/09/update-to-content-only-editing-filter-namespace/\">Update to content only editing filter namespace</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Update to content only editing filter namespace&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/12/09/update-to-content-only-editing-filter-namespace/embed/#?secret=Od8kWWwqTv#?secret=xxeDIgaDji\" data-secret=\"xxeDIgaDji\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"8kFEsRew5m\"><a href=\"https://make.wordpress.org/core/2023/03/06/add-new-prop-to-serversiderender-component/\">Add new prop to ServerSideRender component</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Add new prop to ServerSideRender component&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/03/06/add-new-prop-to-serversiderender-component/embed/#?secret=SCVQjiLIpb#?secret=8kFEsRew5m\" data-secret=\"8kFEsRew5m\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"09NBil83hn\"><a href=\"https://make.wordpress.org/core/2023/03/03/editor-components-updates-in-wordpress-6-2/\">Editor Components updates in WordPress 6.2</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Editor Components updates in WordPress 6.2&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/03/03/editor-components-updates-in-wordpress-6-2/embed/#?secret=oQ4gEUSTac#?secret=09NBil83hn\" data-secret=\"09NBil83hn\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"JCZNnjDtnD\"><a href=\"https://make.wordpress.org/core/2023/03/07/patterns-api-expanded-to-include-template_types-property/\">Patterns API expanded to include template_types property</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Patterns API expanded to include template_types property&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/03/07/patterns-api-expanded-to-include-template_types-property/embed/#?secret=FcP78xalny#?secret=JCZNnjDtnD\" data-secret=\"JCZNnjDtnD\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"4QJSGLeOEy\"><a href=\"https://make.wordpress.org/core/2023/03/07/miscellaneous-editor-changes-in-wordpress-6-2/\">Miscellaneous Editor changes in WordPress 6.2</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Miscellaneous Editor changes in WordPress 6.2&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/03/07/miscellaneous-editor-changes-in-wordpress-6-2/embed/#?secret=wSzZ6hh85H#?secret=4QJSGLeOEy\" data-secret=\"4QJSGLeOEy\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Internationalisation</h2>\n\n\n\n<p>Dans WordPress 6.2, le composant internationalisation (abrégé «&nbsp;i18n&nbsp;») propose une nouvelle fonction conteneur et propose de faciliter le changement des traductions de l’administration du site pour chaque compte. Voici la note de développement dédiée aux modifications ayant eu lieu sur ce composant&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"PmeBBCqf9M\"><a href=\"https://make.wordpress.org/core/2023/03/03/i18n-improvements-in-6-2/\">I18N Improvements in 6.2</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;I18N Improvements in 6.2&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/03/03/i18n-improvements-in-6-2/embed/#?secret=oN9FSuxaex#?secret=PmeBBCqf9M\" data-secret=\"PmeBBCqf9M\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">API de gestion des fichiers système</h2>\n\n\n\n<p>Si vous utilisiez la fonction <code>copy_dir()</code> pour déplacer des répertoires, vous serez probablement heureux de découvrir la nouvelle fonction <code>move_dir()</code>, qui arrive avec WordPress 6.2.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"iD9AZGTuz0\"><a href=\"https://make.wordpress.org/core/2023/03/07/introducing-move_dir-in-wordpress-6-2/\">Introducing move_dir() in WordPress 6.2</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Introducing move_dir() in WordPress 6.2&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/03/07/introducing-move_dir-in-wordpress-6-2/embed/#?secret=2lu0bdfgVX#?secret=iD9AZGTuz0\" data-secret=\"iD9AZGTuz0\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p>Notons également l&rsquo;apparition de la fonction <code>wp_opcache_invalidate()</code>&nbsp;qui sert à vider OPcache pour des fichiers PHP individuels après les avoir surchargés. La fonction &nbsp;<code>wp_opcache_invalidate_directory()</code>&nbsp;a été ajoutée dans le cadre du ticket <a href=\"https://core.trac.wordpress.org/ticket/57375\">#57375</a> afin de vider le cache OPcache de façon récursive pour les fichiers PHP après les avoir surchargés. Cette fonction accepte un paramètre unique <code>$dir</code>, pointant vers le répertoire contenant les fichiers PHP pour lesquels OPcache doit être vidé.</p>\n\n\n\n<p>Dans le ticket <a href=\"https://core.trac.wordpress.org/ticket/57375\">#57375</a>, la méthode&nbsp;<code>WP_Filesystem_Direct::move()</code>&nbsp;a reçu la possibilité de gérer des répertoires afin de la rendre cohérente par rapport aux méthodes <code>::move()</code> présentes dans <code>WP_Filesystem_FTPext</code>,&nbsp;<code>WP_Filesystem_ftpsockets</code>&nbsp;et&nbsp;<code>WP_Filesystem_SSH2</code>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Base de données</h2>\n\n\n\n<p>La possibilité de nettoyer les noms de tables et de champs a été ajoutée dans la méthode <code>wpdb::prepare()</code>. Plus d&rsquo;infos dans la note de développement dédiée&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"8Mu29VU4GA\"><a href=\"https://make.wordpress.org/core/2022/10/08/escaping-table-and-field-names-with-wpdbprepare-in-wordpress-6-1/\">Escaping Table and Field names with wpdb::prepare() in WordPress</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Escaping Table and Field names with wpdb::prepare() in WordPress&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/08/escaping-table-and-field-names-with-wpdbprepare-in-wordpress-6-1/embed/#?secret=du2jY7znoa#?secret=8Mu29VU4GA\" data-secret=\"8Mu29VU4GA\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Gestion des publications</h2>\n\n\n\n<p>La fonction <code>get_page_by_title()</code> est maintenant dépréciée en faveur de l&rsquo;utilisation de <code>WP_Query</code>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"iFjyMSq3Ii\"><a href=\"https://make.wordpress.org/core/2023/03/06/get_page_by_title-deprecated/\">get_page_by_title() deprecated</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;get_page_by_title() deprecated&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/03/06/get_page_by_title-deprecated/embed/#?secret=LWF768ee3z#?secret=iFjyMSq3Ii\" data-secret=\"iFjyMSq3Ii\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"perfs\">Performances</h2>\n\n\n\n<p>WordPress 6.2 apporte plusieurs gains de temps de chargement importants au cœur du CMS. Cela est clairement visualisable dans les tests que nous avons conduits avec des mesures de <a href=\"https://docs.google.com/spreadsheets/d/1LroIJoYz-O9CpfJzaiKYYMWJ7GbE5RZoW1rf1R4FqyA/edit#gid=996638482\">signaux web essentiels (<em>Web Vitals</em> en anglais)</a> et de <a href=\"https://docs.google.com/spreadsheets/d/1LroIJoYz-O9CpfJzaiKYYMWJ7GbE5RZoW1rf1R4FqyA/edit#gid=0\">chargement côté serveur (<em>Server Timing</em> en anglais)</a>.</p>\n\n\n\n<p>Les performances des thèmes basés sur des blocs ont également été améliorées, avec un <a href=\"https://web.dev/ttfb/\">TTFB (en anglais <em>Time to First Byte</em>, ou temps de chargement du premier octet</a>) qui est environ 20&nbsp;% plus rapide, et aussi 14&nbsp;% d&rsquo;amélioration sur le <a href=\"https://web.dev/lcp/\">LCP (<em>Largest Contenful Paint</em>, représentant le temps avant que la page complète soit lisible)</a>. Sur des pages où vous utilisez de grandes bannières d’images, vous devriez même observer une amélioration du critère LCP d&rsquo;environ 19&nbsp;%.</p>\n\n\n\n<p>Autres améliorations de performances&nbsp;:</p>\n\n\n\n<ul>\n<li>Le nouveau filtre <code>pre_wp_load_alloptions</code> permet de court-circuiter le chargement des options auto-chargées de WordPress avec des conditions personnalisées. Voir le <a href=\"https://core.trac.wordpress.org/ticket/56045\">ticket #56045</a> pour plus d&rsquo;informations.</li>\n\n\n\n<li>Les résultats de la fonction <code>get_adjacent_post()</code> sont maintenant mis en cache. Voir le <a href=\"https://core.trac.wordpress.org/ticket/41131\">ticket #41131</a>.</li>\n\n\n\n<li>Les clés de mise en cache de <code>WP_Term_Query</code> sont dorénavant basées sur du SQL sans variables, afin de pouvoir être mises en cache. Voir le <a href=\"https://core.trac.wordpress.org/ticket/57298\">ticket #57298</a>.</li>\n\n\n\n<li><code>WP_Query</code> ne parcourt désormais plus les publications deux fois avant de les retourner. Ça peut paraître une évidence, mais le <a href=\"https://core.trac.wordpress.org/ticket/57373\">ticket #57373</a> a nécessité beaucoup de travail sur ce point.</li>\n\n\n\n<li>Le chargement différé des métadonnées des termes de taxonomies est à présent plus rapide, grâce à l’utilisation de la fonction <code>wp_cache_get_multiple()</code>. Voir le <a href=\"https://core.trac.wordpress.org/ticket/57150\">ticket #57150</a>.</li>\n\n\n\n<li>Les résultats de <code>wp_get_global_settings()</code> sont maintenant placés en cache au sein d’une seule et unique requête, ce qui améliore de 8&nbsp;% les temps de réponse du cœur WordPress. Pour en savoir plus, voir le <a href=\"https://core.trac.wordpress.org/ticket/57502\">ticket #57502</a>.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thèmes</h2>\n\n\n\n<p>Les développeuses et développeurs de thèmes WordPress pourront apprécier l&rsquo;arrivée de nouvelles fonctionnalités, et devront aussi prendre en compte la suppression de certains fonctionnalités obsolètes&nbsp;:</p>\n\n\n\n<ul>\n<li>La fonctionnalité «&nbsp;Variations de styles&nbsp;» a été ajoutée dans la liste des filtres sur les thèmes sur WordPress.org. Voir le <a href=\"https://core.trac.wordpress.org/ticket/56869\">ticket #56869</a>.</li>\n\n\n\n<li>Le fichier <code>theme.json</code> prend maintenant en charge davantage de pseudo-classes CSS liées aux liens hypertextes, comme <code>:link</code>&nbsp;ou&nbsp;<code>:any-link</code>. Voir le <a href=\"https://core.trac.wordpress.org/ticket/57053\">ticket #57053</a>.</li>\n\n\n\n<li>Les thèmes possédant un nom composé de chiffres sont désormais pris en charge par le CMS via un changement dans&nbsp;<code>WP_Theme::__construct()</code>. Voir le <a href=\"https://core.trac.wordpress.org/ticket/54645\">ticket #54645</a>.</li>\n\n\n\n<li>Amélioration des performances des fonctions <code>_add_block_template_part_area_info</code> et <code>_add_block_template_info</code> en diminuant les appels à la fonction  <code>get_option</code>. Voir le <a href=\"https://core.trac.wordpress.org/ticket/57077\">ticket #57077</a>.</li>\n\n\n\n<li>Une mise en cache a été ajoutée sur <code>WP_Theme::is_block_theme()</code>. Voir le <a href=\"https://core.trac.wordpress.org/ticket/57114\">ticket #57114</a>.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Bibliothèques externes</h2>\n\n\n\n<p>La bibliothèque jQuery a été mise à jour, elle est passée de la version 3.6.3 à 3.6.4.</p>\n\n\n\n<p>En outre, la bibliothèque <code>Requests</code> a aussi été mise à jour. Une note de développement détaille d&rsquo;ailleurs les changements apportés&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"bkYeQfRrWr\"><a href=\"https://make.wordpress.org/core/2023/03/08/requests-library-upgraded-to-2-0-5-in-wordpress-6-2/\">Requests library upgraded to 2.0.5 in WordPress 6.2</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Requests library upgraded to 2.0.5 in WordPress 6.2&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/03/08/requests-library-upgraded-to-2-0-5-in-wordpress-6-2/embed/#?secret=KYn2V4QANu#?secret=bkYeQfRrWr\" data-secret=\"bkYeQfRrWr\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Autres mises à jour</h2>\n\n\n\n<p>Plusieurs crochets d’action et filtres ont été mis à jour, vous les trouverez dans la note de développement suivante&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"NbmRoqD5xC\"><a href=\"https://make.wordpress.org/core/2023/03/07/miscellaneous-developer-changes-in-wordpress-6-2/\">Miscellaneous developer changes in WordPress 6.2</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Miscellaneous developer changes in WordPress 6.2&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/03/07/miscellaneous-developer-changes-in-wordpress-6-2/embed/#?secret=mwuiUZgXSy#?secret=NbmRoqD5xC\" data-secret=\"NbmRoqD5xC\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"wait\">Mais ce n’est pas tout&nbsp;!</h2>\n\n\n\n<p>Voici d’autres composants qui ont reçu des mises à jour notables.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Processus de chargement de WP</h3>\n\n\n\n<p>Ajout d&rsquo;une vérification que les fonctions&nbsp;<code>mysqli_connect()</code>&nbsp;ou&nbsp;<code>mysql_connect()</code>&nbsp;sont bien disponibles. Cela résout une erreur fatale potentiellement provoquée par l&rsquo;absence de l’extension PHP <code>mysqli</code> sur le serveur, et affiche un message d&rsquo;erreur clair le cas échéant. Voir le ticket <a href=\"https://core.trac.wordpress.org/ticket/51988\">#51988</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Commentaires</h3>\n\n\n\n<p>Ajout de la possibilité de passer le paramètre&nbsp;<code>$comment_ID</code>&nbsp;aux fonctions <code>get_comment_time()</code> et <code>comment_time()</code>. Cela apporte une meilleure cohérence vis-à-vis des fonctions similaires <code>get_comment_date()</code> et <code>comment_date()</code>. Voir le <a href=\"https://core.trac.wordpress.org/ticket/52322\">ticket #52322</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Mots de passe d’applications</h3>\n\n\n\n<p>Les URL en <code>HTTP</code> sont désormais autorisées pour la création de mots de passe d’applications dans le cadre d’un environnement local. Voir le <a href=\"https://core.trac.wordpress.org/ticket/52617\">ticket #52617</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Bibliothèques externes</h3>\n\n\n\n<p>Les bibliothèques suivantes ont été mises à jour&nbsp;:</p>\n\n\n\n<ul>\n<li>jQuery (voir le <a href=\"https://core.trac.wordpress.org/ticket/57324\">ticket #57324</a>)</li>\n\n\n\n<li>jQuery Migrate (voir le <a href=\"https://core.trac.wordpress.org/ticket/56743\">ticket #56743</a>)</li>\n\n\n\n<li>PHPMailer (voir le <a href=\"https://core.trac.wordpress.org/ticket/57281\">ticket #57281</a>)</li>\n\n\n\n<li>element-closest (voir le <a href=\"https://core.trac.wordpress.org/ticket/52851\">ticket#52851</a>)</li>\n\n\n\n<li>regenerator runtime (voir le <a href=\"https://core.trac.wordpress.org/ticket/57646\">ticket #57646</a>)</li>\n\n\n\n<li>polyfill-library (voir le <a href=\"https://core.trac.wordpress.org/ticket/57646\">ticket #57646</a>)</li>\n\n\n\n<li>Requests 2.0 (voir le <a href=\"https://core.trac.wordpress.org/ticket/54504\">ticket #54504</a>). Pour en savoir plus sur cette mise à jour,&nbsp;<a href=\"https://github.com/WordPress/Requests/blob/stable/docs/upgrading.md\">voir la documentation de la bibliothèque Requests 2.0</a>.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Formattage</h3>\n\n\n\n<p>Optimisation de la fonction de bas niveau&nbsp;<code>wp_kses_bad_protocol()</code>&nbsp;afin d&rsquo;améliorer les performances de la fonction d&rsquo;échappement&nbsp;<code>esc_url()</code>. Voir le <a href=\"https://core.trac.wordpress.org/ticket/52617\">ticket #22951</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Modernisation du code</h3>\n\n\n\n<p>Un énorme travail a été fait pour améliorer encore la conformité de la structure du code de WordPress vis-à-vis des versions de PHP supérieures à 8.0. Voir le <a href=\"https://core.trac.wordpress.org/ticket/56788\">ticket #56788</a>.  </p>\n\n\n\n<h3 class=\"wp-block-heading\">E-mails</h3>\n\n\n\n<p>L&rsquo;ajout de pièce jointes avec noms de fichiers personnalisés dans la fonction <code>wp_mail()</code> est maintenant possible en passant un tableau associatif <code>$attachments</code>, où les chaînes utilisées en tant que clés seront employées pour déterminer les noms de fichiers. Voir le <a href=\"https://core.trac.wordpress.org/ticket/28407\">ticket #28407</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Médias</h3>\n\n\n\n<p>Il est maintenant possible de fournir explicitement une valeur booléenne <code>false</code> au paramètre&nbsp;<code>$attr</code>&nbsp;de la fonction <code>wp_get_attachment_image()</code> afin de s&rsquo;assurer que l&rsquo;attribut <code>decoding</code> n&rsquo;est pas ajouté au média. Voir le <a href=\"https://core.trac.wordpress.org/ticket/57086\">ticket #57086</a>.</p>\n\n\n\n<p>La logique permettant de déterminer les images participant au <a href=\"https://web.dev/lcp/\">LCP (<em>Largest Contenful Paint</em>, représentant le temps avant que la page complète soit lisible)</a> au sein des thèmes basés sur des blocs a été grandement améliorée, afin de s&rsquo;assurer que ces images ne soient pas chargées en différé. Cela permet d&rsquo;améliorer la conformité LCP des thèmes basés sur des blocs. Cette modification tire par ailleurs profit du principe des éléments de modèles de l&rsquo;éditeur de site pour éviter de charger en différé les médias situés dans l&rsquo;entête du site. Un <a href=\"https://core.trac.wordpress.org/ticket/56930#comment:53\">test conduit sur une page créée via un thème basé sur des blocs</a> a permis de souligner une amélioration de <strong>19&nbsp;% du critère LCP sur WordPress 6.2</strong>. Voir les tickets <a href=\"https://core.trac.wordpress.org/ticket/56930\">#56930</a> et <a href=\"https://core.trac.wordpress.org/ticket/57490\">#57490</a> pour plus de détails.</p>\n\n\n\n<h3 class=\"wp-block-heading\">API REST</h3>\n\n\n\n<p>Ajout de la prise en charge de caractères non latins dans la Regex utilisée pour le point de terminaison <code>template</code>. Ces caractères sont encodés afin de pouvoir être utilisés dans une URL (exemple&nbsp;:&nbsp;<code>%cf%84%ce%b5%cf%83%cf%84</code>). Voir le <a href=\"https://core.trac.wordpress.org/ticket/57329\">ticket #57329</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Gestion des comptes</h3>\n\n\n\n<p>Ajout du nouveau crochet d&rsquo;action&nbsp;<code>wp_set_password</code>, déclenché après la création d&rsquo;un mot de passe pour un compte déterminé. Cela aidera les auteur·ices d&rsquo;extensions à intercepter toutes les utilisations de <code>wp_set_password()</code>, qu&rsquo;elles proviennent du cœur de WordPress ou d&rsquo;autres extensions. Voir le <a href=\"https://core.trac.wordpress.org/ticket/57490\">ticket #57436</a>.</p>\n\n\n\n<p class=\"has-background\" style=\"background-color:#fee7af\">Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements. Vous pouvez utiliser&nbsp;<a rel=\"noreferrer noopener\" href=\"https://wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\">l’extension Beta Tester</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec <a href=\"https://wordpress.org/news/2023/03/wordpress-6-2-release-candidate-1/\">WordPress 6.2&nbsp;Release Candidate&nbsp;1</a>.&nbsp;Nous comptons sur vous pour vous assurer que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p>Ce guide a été traduit de l&rsquo;anglais puis adapté à partir du <a href=\"https://make.wordpress.org/core/2023/03/09/wordpress-6-2-field-guide/\"><em>Field Guide</em> de WP 6.2</a> par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Bénard</a> et <a href=\"https://profiles.wordpress.org/btpub/\">Bruno Tritsch</a> pour leur relecture attentive.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://fr.wordpress.org/2023/03/10/guide-des-changements-techniques-de-wordpress-6-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Questionnaire annuel sur votre expérience d’utilisation de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://fr.wordpress.org/2022/12/05/questionnaire-annuel-sur-votre-experience-dutilisation-de-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"https://fr.wordpress.org/2022/12/05/questionnaire-annuel-sur-votre-experience-dutilisation-de-wordpress/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Dec 2022 10:33:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Questionnaires/sondages\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2577\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:378:\"Chaque année, les membres de la communauté WordPress sont invités à donner leurs retours sur WordPress. Chaque personne gravitant autour de notre CMS est concernée, qu’elle en soit simple utilisatrice, ou qu’elle participe à la conception ou à la production de sites, d’extensions, de thèmes, ou même au développement de WordPress ou de sa communauté. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4827:\"\n<p>Chaque année, les membres de la communauté WordPress sont invités à donner leurs retours sur WordPress. Chaque personne gravitant autour de notre CMS est concernée, qu’elle en soit simple utilisatrice, ou qu’elle participe à la conception ou à la production de sites, d’extensions, de thèmes, ou même au développement de WordPress ou de sa communauté.</p>\n\n\n\n<p>Les retours obtenus par ce questionnaire sont utilisés pour la conférence annuelle du co-fondateur de WordPress, le <a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\"><em lang=\"en\">State of the Word</em></a> et auront une influence sur la direction stratégique du projet dans les années à venir.</p>\n\n\n\n<p>Pour le dire plus simplement, ce questionnaire aide les personnes qui construisent WordPress à en savoir plus sur la façon dont ce logiciel est utilisé.</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-1 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordpressdotorg.survey.fm/fr-2022\">Je participe au questionnaire annuel&nbsp;!</a></div>\n</div>\n\n\n\n<span id=\"more-2577\"></span>\n\n\n\n<p>Cette année encore, le questionnaire est disponible en plusieurs langues – dont le français – grâce à l’aide des différentes équipes de traduction du CMS, merci à elles !</p>\n\n\n\n<p>Ce questionnaire sera accessible jusqu’à la fin de l’année 2022, et la publication des résultats est prévue courant 2023. Cette année, les questions ont été revues afin de faciliter le déroulement, la réalisation et l’analyse de l&rsquo;enquête. Certaines questions ont été supprimées, tandis que quelques nouvelles sont désormais présentes, reflétant le présent et l’avenir de WordPress. Si vous cherchez l’analyse des résultats de l’enquête de 2021, elle sera également partagée début 2023.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Faites passer le message</h2>\n\n\n\n<p>Aidez à faire connaître le questionnaire en le partageant avec votre réseau, via Slack, ou sur vos comptes de réseaux sociaux. Plus il y aura de personnes qui répondront au questionnaire et partageront leur expérience avec WordPress, plus l’ensemble du projet en bénéficiera.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Sécurité et confidentialité</h2>\n\n\n\n<p>La sécurité et la confidentialité des données sont primordiales pour le projet et la communauté WordPress. Dans cet esprit, toutes les données personnelles sont rendues anonymes&nbsp;: aucune adresse e-mail ou adresse IP ne sera associée aux résultats publiés. Pour en savoir plus sur les pratiques de WordPress.org en matière de confidentialité, consultez la <a href=\"https://fr.wordpress.org/about/privacy/\">politique de confidentialité</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Merci</h2>\n\n\n\n<p>Nous remercions les contributeurs et contributrices WordPress suivants pour leur aide à la mise en œuvre de ce questionnaire annuel, comprenant la création des questions, la réflexion stratégique, l’élaboration de l’enquête et sa traduction&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/dansoschin/\">dansoschin</a>, <a href=\"https://profiles.wordpress.org/_dorsvenabili/\">_dorsvenabili</a>, <a href=\"https://profiles.wordpress.org/angelasjin/\">angelasjin</a>, <a href=\"https://profiles.wordpress.org/arkangel/\">arkangel</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">audrasjb</a>, <a href=\"https://profiles.wordpress.org/atachibana/\">atachibana</a>, <a href=\"https://profiles.wordpress.org/bjmcsherry/\">bjmcsherry</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">chanthaboune</a>, <a href=\"https://profiles.wordpress.org/eidolonnight/\">eidolonnight</a>, <a href=\"https://profiles.wordpress.org/fernandot/\">fernandot</a>, <a href=\"https://profiles.wordpress.org/fierevere/\">fierevere</a>, <a href=\"https://profiles.wordpress.org/fxbenard/\">fxbenard</a>, <a href=\"https://profiles.wordpress.org/jdy68/\">jdy68</a>, <a href=\"https://profiles.wordpress.org/jpantani/\">jpantani</a>, <a href=\"https://profiles.wordpress.org/laurlittle/\">laurlittle</a>, <a href=\"https://profiles.wordpress.org/nao/\">nao</a>, <a href=\"https://profiles.wordpress.org/nielslange/\">nielslange</a>, <a href=\"https://profiles.wordpress.org/peiraisotta/\">peiraisotta</a>, <a href=\"https://profiles.wordpress.org/piermario/\">piermario</a>, <a href=\"https://profiles.wordpress.org/rmartinezduque/\">rmartinezduque</a>, <a href=\"https://profiles.wordpress.org/santanainniss/\">santanainniss</a>.</p>\n\n\n\n<p class=\"has-text-align-right\"><small><em>Traduction du communiqué par <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> et <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.</em></small></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"https://fr.wordpress.org/2022/12/05/questionnaire-annuel-sur-votre-experience-dutilisation-de-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"WordPress 6.1 « Misha »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://fr.wordpress.org/2022/11/02/wordpress-6-1-misha/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://fr.wordpress.org/2022/11/02/wordpress-6-1-misha/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 02 Nov 2022 03:12:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2551\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:418:\"La troisième version majeure de WordPress pour l&#8217;année 2022 est disponible. Elle a été baptisée «&#160;Misha&#160;» en l&#8217;honneur du pianiste de jazz Michail Jefimowitsch Alperin. Nous vous invitons à effectuer cette mise à jour afin de bénéficier des améliorations de stabilité, de performances, et d&#8217;utilisabilité que propose cette nouvelle version majeure. Quoi de neuf dans [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:80292:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2022/11/misha.png\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"679\" src=\"https://fr.wordpress.org/files/2022/11/misha-1024x679.png\" alt=\"\" class=\"wp-image-2554\" srcset=\"https://fr.wordpress.org/files/2022/11/misha-1024x679.png 1024w, https://fr.wordpress.org/files/2022/11/misha-300x199.png 300w, https://fr.wordpress.org/files/2022/11/misha-768x509.png 768w, https://fr.wordpress.org/files/2022/11/misha-1536x1019.png 1536w, https://fr.wordpress.org/files/2022/11/misha.png 1996w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p><span style=\"font-weight: 400\">La troisième version majeure de WordPress pour l&rsquo;année 2022 est disponible.</span> Elle a été baptisée «&nbsp;Misha&nbsp;» en l&rsquo;honneur du pianiste de jazz Michail Jefimowitsch Alperin.</p>\n\n\n\n<p>Nous vous invitons à effectuer cette mise à jour afin de bénéficier des améliorations de stabilité, de performances, et d&rsquo;utilisabilité que propose cette nouvelle version majeure.</p>\n\n\n\n<span id=\"more-2551\"></span>\n\n\n\n<h2 class=\"wp-block-heading\">Quoi de neuf dans WordPress&nbsp;6.1&nbsp;?</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Twenty Twenty-Three&nbsp;: un nouveau thème natif proposant 10 variations de styles distinctes</h3>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2022/11/Style-Variation-News-1024x601.png\" alt=\"\" class=\"wp-image-13816\" /></figure>\n\n\n\n<p>S’appuyant sur les principes fondamentaux des versions 5.9 et 6.0 pour les thèmes de blocs et les variations de style, le nouveau thème par défaut, nommé <em>Twenty Twenty-Three</em>, comprend&nbsp;<a href=\"https://make.wordpress.org/design/2022/09/07/tt3-default-theme-announcing-style-variation-selections/\">10 variations de styles différentes</a>&nbsp;et est&nbsp;<a href=\"https://make.wordpress.org/themes/handbook/review/accessibility/\">accessible</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Une meilleure expérience de création avec de nouveaux modèles entièrement revus</h3>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2022/11/Templates-News-1024x601.png\" alt=\"\" class=\"wp-image-13818\" /></figure>\n\n\n\n<p>Les&nbsp;<a href=\"https://make.wordpress.org/core/2022/07/21/core-editor-improvement-deeper-customization-with-more-template-options/\">nouveaux modèles (note de développement, en anglais)</a>&nbsp;comprennent un modèle personnalisé pour les publications dans l’éditeur de site. Les outils de recherche/remplacement accélèrent la conception des&nbsp;<a href=\"https://make.wordpress.org/core/2022/08/25/core-editor-improvement-refining-the-template-creation-experience/\">éléments de modèles (en anglais)</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Plus de cohérence et de contrôle sur les outils de conception</h3>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped wp-block-gallery-2 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" data-id=\"13819\" src=\"https://wordpress.org/news/files/2022/11/Design-Tools-News-1024x601.png\" alt=\"\" class=\"wp-image-13819\" /></figure>\n</figure>\n\n\n\n<p>L’amélioration des&nbsp;commandes pour les éléments de conception et les blocs&nbsp;rendent le processus de mise en page et de création de site plus cohérent, complet et intuitif.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Les menus peuvent être créés et modifiés plus facilement</h3>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2022/11/Navigation-1024x601.png\" alt=\"\" class=\"wp-image-13821\" /></figure>\n\n\n\n<p>Les&nbsp;<a href=\"https://make.wordpress.org/core/2022/09/27/navigation-block-fallback-behavior-in-wp-6-1-dev-note/\">nouvelles options de récupération du bloc Navigation (en anglais)</a>&nbsp;vous permettent de modifier le menu que vous avez ouvert sans avoir besoin d’effectuer de recherche. De plus, les commandes pour choisir et travailler sur les menus sont dorénavant placées dans les réglages du bloc. Le système de menu mobile bénéficie également d’une mise à jour avec de nouvelles fonctionnalités comprenant plusieurs options d’icônes pour personnaliser le menu.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Amélioration de la mise en page et de la visualisation des réglages des publications</h3>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2022/11/Document-settings-News-1024x601.png\" alt=\"\" class=\"wp-image-13825\" /></figure>\n\n\n\n<p>Un affichage plus propre et mieux organisé vous permet de visualiser et de gérer facilement les réglages importants des publications, en particulier au niveau du sélecteur de modèles et de l’outil de planification.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Réglage de verrouillage en un clic pour tous les blocs internes</h3>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped wp-block-gallery-4 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" data-id=\"13824\" src=\"https://wordpress.org/news/files/2022/11/Lock-News-1024x601.png\" alt=\"\" class=\"wp-image-13824\" /></figure>\n</figure>\n\n\n\n<p>Lorsque vous verrouillez des blocs, une nouvelle option vous permet d’appliquer vos réglages de verrouillage à tous les blocs d’un bloc conteneur tel que le bloc Groupe, Couverture ou encore Colonnes.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Amélioration des textes indicatifs des blocs</h3>\n\n\n\n<p>Les textes indicatifs de plusieurs blocs ont été améliorés, afin de mieux refléter les options de personnalisation qui vous permettent de concevoir votre site et son contenu. Par exemple, le texte d’aide du bloc Image affiche les réglages personnalisés des bordures et des filtres duotones avant même de sélectionner l’image à afficher.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Composez des listes et des citations enrichies en y plaçant des blocs internes</h3>\n\n\n\n<p>Les blocs Liste et Citation prennent désormais en charge les blocs internes, ce qui permet des compositions plus flexibles et plus riches, par exemple en vous permettant d’ajouter des titres à l’intérieur de vos blocs de citations.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Du texte plus <em>responsive</em> avec une typographie fluide</h3>\n\n\n\n<p>La <a href=\"https://make.wordpress.org/core/2022/08/04/whats-new-in-gutenberg-13-8-3-august/#fluid-typography-support\"></a><a href=\"https://make.wordpress.org/core/2022/10/03/fluid-font-sizes-in-wordpress-6-1/\">typographie fluide (en anglais)</a>&nbsp;vous permet de définir des tailles de police qui s’adaptent pour faciliter la lecture sur n’importe quelle taille d’écran.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Ajoutez des suggestions de compositions pour vos types de publications</h3>\n\n\n\n<p>Dans WordPress 6.0, lorsque vous ajoutiez une nouvelle page, vous pouviez voir des suggestions de compositions afin d’éviter de partir d’une page vide. Avec WordPress 6.1 vous verrez cette fenêtre modale lors de la création de n’importe quel type de publication.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Facilitation de la recherche de thèmes basés sur des blocs</h3>\n\n\n\n<p>Le répertoire des thèmes contient&nbsp;<a href=\"https://fr.wordpress.org/themes/tags/full-site-editing/\">un filtre pour les thèmes basés sur des blocs</a>, et l’aperçu des compositions donne une meilleure idée de ce à quoi le thème pourrait ressembler lorsque vous explorez les thèmes et les compositions.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Conservez les réglages de l’éditeur de site pour plus tard</h3>\n\n\n\n<p>Les réglages de l’éditeur de site sont désormais&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/10/changes-to-block-editor-preferences-in-wordpress-6-1/\">persistants pour chaque compte</a>. Cela signifie que vos réglages seront désormais cohérents sur tous les navigateurs et appareils.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Un système de gestion des styles simplifié</h3>\n\n\n\n<p>Les règles CSS pour les marges internes et externes, la typographie, les couleurs et les bordures du&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/10/block-styles-generation-style-engine/\">moteur de styles</a>&nbsp;sont désormais regroupées au même endroit, ce qui diminue le temps consacré aux tâches de mise en page et aide à générer des noms de classes sémantiques.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Amélioration de l’accessibilité de l’administration et de l’éditeur</h3>\n\n\n\n<p>Plus de 40 améliorations de l’accessibilité ont été réalisées, comprenant la résolution des problèmes de perte de focus dans l’éditeur, l’amélioration des libellés de formulaires et de la restitution vocale des messages, l’amélioration de l’interface de modifications des textes alternatifs, la correction du débordement du menu d’administration sur les petits écrans ou en zoom navigateur. En savoir plus sur les&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/11/wordpress-6-1-accessibility-improvements/\">améliorations d’accessibilité apportées par WP 6.1</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Autres changements importants</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Éléments de modèles de blocs dans les thèmes classiques</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/10/04/block-based-template-parts-in-traditional-themes/\"></a>Les éléments de modèles de blocs peuvent désormais être <a href=\"https://make.wordpress.org/core/2022/10/04/block-based-template-parts-in-traditional-themes/\">définis dans les thèmes classiques (en anglais)</a>&nbsp;en ajoutant les fichiers HTML appropriés au répertoire&nbsp;<code>parts</code>&nbsp;à la racine du thème.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Évolution des blocs de boucle de requête</h3>\n\n\n\n<p>Les&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/10/extending-the-query-loop-block/\">nouveaux filtres</a>&nbsp;permettent aux variantes du bloc de requête de prendre en charge des requêtes personnalisées afin de créer des variantes plus spécifiques et des options avancées de filtrage des types de publication hiérarchiques.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Des filtres pour tous vos styles</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/10/10/filters-for-theme-json-data/\"><a href=\"https://make.wordpress.org/core/2022/10/10/filters-for-theme-json-data/\">Exploitez les filtres</a> dans la barre latérale « Styles » pour contrôler les réglages sur quatre niveaux de votre site, du moins spécifique au plus spécifique : principal, thème, compte, bloc.</a></p>\n\n\n\n<h3 class=\"wp-block-heading\">Préréglages d’espacement pour une conception plus rapide et cohérente</h3>\n\n\n\n<p>Gagnez du temps et évitez de coder en dur des déclarations dans un thème grâce aux&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/07/introduction-of-presets-across-padding-margin-and-block-gap/\">valeurs de marge internes et externes prédéfinies pour de multiples blocs</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Modification limitée au contenu sur les blocs conteneurs</h3>\n\n\n\n<p>Grâce au&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/11/content-locking-features-and-updates/\">réglage de modification limitée au contenu</a>, les mises en page peuvent être verrouillées au sein des blocs conteneurs. Dans un bloc de contenu seul, ses blocs enfants sont invisibles dans la vue en liste et ne sont pas modifiables. Vous contrôlez donc la mise en page tandis que vos rédactrices et rédacteurs peuvent se concentrer sur le contenu.</p>\n\n\n\n<p>Combinez-la avec les options de verrouillage des blocs pour un contrôle encore plus poussé de vos blocs.</p>\n\n\n\n<h3 class=\"wp-block-heading\">De meilleures performances</h3>\n\n\n\n<p>WordPress 6.1 résout 25 tickets dédiés à l’amélioration des performances. De&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/10/performance-improvements-to-the-rest-api/\">l’API REST</a>&nbsp;au&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/10/multisite-improvements-in-wordpress-6-1/\">multisite</a>, en passant par&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/07/improvements-to-wp_query-performance-in-6-1/\"><code>WP_Query</code></a>&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/07/improved-php-performance-for-core-blocks-registration/\">l’enregistrement des blocs du cœur WordPress</a>&nbsp;et par de&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/06/new-cache-site-health-checks-in-wordpress-6-1/\">nouvelles vérifications sur l’outil Santé du site</a>, ou par l’ajout des attributs&nbsp;<code>async</code>&nbsp;aux images, il y a des améliorations bénéfiques pour tous les types de sites. Un récapitulatif complet est disponible dans le&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/11/performance-field-guide-for-wordpress-6-1/\">guide dédié aux performance de WP&nbsp;6.1</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Guide des changements techniques de WordPress 6.1</h2>\n\n\n\n<p>WordPress 6.1 comprend encore bien plus de nouvelles fonctionnalités et d’améliorations. Pour en savoir plus, et notamment si vous développez des sites WordPress, <a href=\"https://fr.wordpress.org/2022/10/12/guide-des-changements-techniques-de-wordpress-6-1/\" data-type=\"post\" data-id=\"2509\">consultez le guide des changements techniques de cette version</a>.</p>\n\n\n\n<h1 class=\"wp-block-heading\">Plus d’informations sur WordPress 6.1</h1>\n\n\n\n<p>Découvrez WordPress 6.1 en fonctionnement&nbsp;! Notre&nbsp;<a href=\"https://youtu.be/1w9oywSa6Hw\">vidéo de présentation</a>&nbsp;propose une vue d’ensemble des principales fonctionnalités qui sont sorties avec WordPress 6.1.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" class=\"youtube-player\" width=\"612\" height=\"345\" src=\"https://www.youtube.com/embed/1w9oywSa6Hw?version=3&#038;rel=1&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;fs=1&#038;hl=fr-FR&#038;autohide=2&#038;wmode=transparent\" allowfullscreen=\"true\" style=\"border:0;\" sandbox=\"allow-scripts allow-same-origin allow-popups allow-presentation\"></iframe>\n</div></figure>\n\n\n\n<p><br></p>\n\n\n\n<p>Visitez&nbsp;<a href=\"https://learn.wordpress.org/\">learn.wordpress.org</a>&nbsp;pour des tutoriels vidéos, des ateliers en ligne, des cours et des plans de cours pour les personnes organisant des évènements, et pour des contenus présentant les nouvelles fonctionnalités de WordPress.</p>\n\n\n\n<p>Consultez notre&nbsp;<a href=\"https://fr.wordpress.org/2022/10/12/guide-des-changements-techniques-de-wordpress-6-1/\">guide des changements techniques introduits par WordPress 6.0</a>. Il contient toutes les notes techniques que vous devez connaître si vous développez sur WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.1</h2>\n\n\n\n<p><span style=\"font-weight: 400\">Les personnes mentionnées ci-dessous ont participé à la direction de cette version majeure du CMS&nbsp;:</span></p>\n\n\n\n<ul>\n<li><span style=\"font-weight: 400\">Direction générale&nbsp;: </span><a href=\"https://profiles.wordpress.org/matt/\"><span style=\"font-weight: 400\">Matt Mullenweg</span></a><span style=\"font-weight: 400\">&nbsp;</span></li>\n\n\n\n<li><span style=\"font-weight: 400\">Coordinateurs de cette version&nbsp;: </span><a href=\"https://profiles.wordpress.org/priethor/\"><span style=\"font-weight: 400\">Héctor Prieto</span></a><span style=\"font-weight: 400\"> et </span><a href=\"https://profiles.wordpress.org/desrosj/\"><span style=\"font-weight: 400\">Jonathan Desrosiers</span></a><span style=\"font-weight: 400\">&nbsp;</span></li>\n\n\n\n<li><span style=\"font-weight: 400\">Direction technique côté Core&nbsp;: </span><a href=\"https://profiles.wordpress.org/mikeschroder/\"><span style=\"font-weight: 400\">Mike Schroder</span></a><span style=\"font-weight: 400\">, </span><a href=\"https://profiles.wordpress.org/davidbaumwald/\"><span style=\"font-weight: 400\">David Baumwald</span></a><span style=\"font-weight: 400\">, et </span><a href=\"https://profiles.wordpress.org/jeffpaul/\"><span style=\"font-weight: 400\">Jeff Paul</span></a></li>\n\n\n\n<li><span style=\"font-weight: 400\"><span style=\"font-weight: 400\">Direction</span> technique côté Gutenberg&nbsp;: </span><a href=\"https://profiles.wordpress.org/czapla/\"><span style=\"font-weight: 400\">Michal Czaplinski</span></a><span style=\"font-weight: 400\">, </span><a href=\"https://profiles.wordpress.org/bernhard-reiter/\"><span style=\"font-weight: 400\">Bernie Reiter</span></a><span style=\"font-weight: 400\">, et </span><a href=\"https://profiles.wordpress.org/cbravobernal/\"><span style=\"font-weight: 400\">Carlos Bravo</span></a></li>\n\n\n\n<li><span style=\"font-weight: 400\">Gestion de projet côté cœur&nbsp;: </span><a href=\"https://profiles.wordpress.org/audrasjb/\"><span style=\"font-weight: 400\">JB Audras</span></a><span style=\"font-weight: 400\"> et </span><a href=\"https://profiles.wordpress.org/chaion07/\"><span style=\"font-weight: 400\">Ahmed Chaion</span></a></li>\n\n\n\n<li><span style=\"font-weight: 400\"><span style=\"font-weight: 400\">Gestion de projet côté</span></span> Gutenberg&nbsp;<span style=\"font-weight: 400\">: </span><a href=\"https://profiles.wordpress.org/ndiego/\"><span style=\"font-weight: 400\">Nick Diego</span></a> <span style=\"font-weight: 400\">et </span><a href=\"https://profiles.wordpress.org/annezazu/\"><span style=\"font-weight: 400\">Anne McCarthy</span></a></li>\n\n\n\n<li><span style=\"font-weight: 400\">Documentation&nbsp;: </span><a href=\"https://profiles.wordpress.org/bph/\"><span style=\"font-weight: 400\">Birgit Pauli-Haack</span></a><span style=\"font-weight: 400\">, </span><a href=\"https://profiles.wordpress.org/milana_cap/\"><span style=\"font-weight: 400\">Milana Cap</span></a><span style=\"font-weight: 400\">, et </span><a href=\"https://profiles.wordpress.org/femkreations/\"><span style=\"font-weight: 400\">Femy Praseeth</span></a></li>\n\n\n\n<li><span style=\"font-weight: 400\">Communication&nbsp;:</span> <a href=\"https://profiles.wordpress.org/jpantani/\"><span style=\"font-weight: 400\">Jonathan Pantani</span></a> <span style=\"font-weight: 400\">et </span><a href=\"https://profiles.wordpress.org/dansoschin/\"><span style=\"font-weight: 400\">Dan Soschin</span></a></li>\n\n\n\n<li><span style=\"font-weight: 400\">Tests&nbsp;: </span><a href=\"https://profiles.wordpress.org/ironprogrammer/\"><span style=\"font-weight: 400\">Brian Alexander</span></a></li>\n\n\n\n<li><span style=\"font-weight: 400\">Design : </span><a href=\"https://profiles.wordpress.org/richtabor/\"><span style=\"font-weight: 400\">Rich Tabor</span></a></li>\n\n\n\n<li><span style=\"font-weight: 400\">Design et développement du nouveau thème natif&nbsp;: </span><a href=\"https://profiles.wordpress.org/beafialho/\"><span style=\"font-weight: 400\">Beatriz Fialho</span></a><span style=\"font-weight: 400\"> et </span><a href=\"https://profiles.wordpress.org/mikachan/\"><span style=\"font-weight: 400\">Sarah Norris</span></a></li>\n</ul>\n\n\n\n<p>Il n&rsquo;aurait pas été possible de sortir WordPress 6.1 sans le travail acharné de plus de 800 personnes situées dans au moins 60 pays différents. Merci à toutes celles et ceux qui ont travaillé sur cette nouvelle version de WordPress&nbsp;!</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/1naveengiri/\">1naveengiri</a> · <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/hurayraiit/\">Abu Hurayra</a> · <a href=\"https://profiles.wordpress.org/bosconiandynamics/\">Adam Bosco</a> · <a href=\"https://profiles.wordpress.org/adampickering/\">Adam Pickering</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/admwgn/\">Adam Wiltgen</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zielinski</a> · <a href=\"https://profiles.wordpress.org/addiestavlo/\">Addie</a> · <a href=\"https://profiles.wordpress.org/oztaser/\">Adil Öztaşer</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/aezazshekh/\">Aezaz Shekh</a> · <a href=\"https://profiles.wordpress.org/afrid1719/\">afrid1719</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/kamig478/\">Akram Ul Haq</a> · <a href=\"https://profiles.wordpress.org/akshitsethi/\">Akshit Sethi</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alamgircsebd/\">alamgircsebd</a> · <a href=\"https://profiles.wordpress.org/alanp57/\">AlanP57</a> · <a href=\"https://profiles.wordpress.org/alansyue/\">alansyue</a> · <a href=\"https://profiles.wordpress.org/albatross10/\">albatross10</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/alberuni-azad/\">Alberuni Azad.</a> · <a href=\"https://profiles.wordpress.org/elpanda13gmailcom/\">Alejandro J. Sanchez P.</a> · <a href=\"https://profiles.wordpress.org/zutigrm/\">Aleksej</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/acoulombe/\">Alexis Coulombe</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">alexstine</a> · <a href=\"https://profiles.wordpress.org/allancole/\">allancole</a> · <a href=\"https://profiles.wordpress.org/allisonplus/\">allisonplus</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a> · <a href=\"https://profiles.wordpress.org/amirkamizi/\">amirkamizi</a> · <a href=\"https://profiles.wordpress.org/amjadr360/\">Amjad Ali</a> · <a href=\"https://profiles.wordpress.org/anantajitjg/\">Anantajit JG</a> · <a href=\"https://profiles.wordpress.org/anariel-design/\">Anariel Design</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/deksar/\">Andreas</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/_smartik_/\">Andrei Surdu</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/eatingrules/\">Andrew Wilder</a> · <a href=\"https://profiles.wordpress.org/andrewnz/\">AndrewNZ</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey « Rarst » Savchenko</a> · <a href=\"https://profiles.wordpress.org/andrija/\">Andrija Naglic</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/andykeith/\">Andy Keith</a> · <a href=\"https://profiles.wordpress.org/aniketpatel/\">Aniket Patel</a> · <a href=\"https://profiles.wordpress.org/anitanenova/\">anitanenova</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/annabansaghi/\">Anna Bansaghi</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/alaca/\">Ante Laca</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/apedog/\">apedog</a> · <a href=\"https://profiles.wordpress.org/apokalyptik/\">apokalyptik</a> · <a href=\"https://profiles.wordpress.org/arrasel403/\">AR Rasel</a> · <a href=\"https://profiles.wordpress.org/arcangelini/\">arcangelini</a> · <a href=\"https://profiles.wordpress.org/archon810/\">archon810</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/yellyc/\">Ariel Chinn</a> · <a href=\"https://profiles.wordpress.org/xylocone/\">Arjun Singh</a> · <a href=\"https://profiles.wordpress.org/armondal/\">Arnab Mondal</a> · <a href=\"https://profiles.wordpress.org/passoniate/\">Arslan Kalwar</a> · <a href=\"https://profiles.wordpress.org/arturgrabo/\">Artur Grabowski</a> · <a href=\"https://profiles.wordpress.org/ideag/\">Arunas Liuiza</a> · <a href=\"https://profiles.wordpress.org/aspexi/\">Aspexi</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/filosofo/\">Austin Matzko</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/baned/\">BaneD</a> · <a href=\"https://profiles.wordpress.org/barneydavey/\">barneydavey</a> · <a href=\"https://profiles.wordpress.org/bbobnis/\">Bartosz Bobnis</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/bengreeley/\">Ben Greeley</a> · <a href=\"https://profiles.wordpress.org/utz119/\">Benachi</a> · <a href=\"https://profiles.wordpress.org/benjgrolleau/\">Benjamin Grolleau</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">Bernie Reiter</a> · <a href=\"https://profiles.wordpress.org/bhrugesh12/\">Bhrugesh Bavishi</a> · <a href=\"https://profiles.wordpress.org/elten/\">Bing</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/blockify/\">Blockify</a> · <a href=\"https://profiles.wordpress.org/boblindner/\">Bob</a> · <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a> · <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/cantuaria/\">Bruno Cantuaria</a> · <a href=\"https://profiles.wordpress.org/ribaricplusplus/\">Bruno Ribaric</a> · <a href=\"https://profiles.wordpress.org/burgiuk/\">burgiuk</a> · <a href=\"https://profiles.wordpress.org/burhandodhy/\">Burhan Nasir</a> · <a href=\"https://profiles.wordpress.org/bwbama/\">bwbama</a> · <a href=\"https://profiles.wordpress.org/cadlec/\">cadlec</a> · <a href=\"https://profiles.wordpress.org/cagsmith/\">cagsmith</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos Garcia Prim</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cavalierlife/\">cavalierlife</a> · <a href=\"https://profiles.wordpress.org/cdbessig/\">cdbessig</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/nhuja/\">Chandra M</a> · <a href=\"https://profiles.wordpress.org/critterverse/\">Channing Ritter</a> · <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a> · <a href=\"https://profiles.wordpress.org/chintan1896/\">Chintan hingrajiya</a> · <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloe Bringmann</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisbudd1/\">Chris Budd</a> · <a href=\"https://profiles.wordpress.org/chrishardie/\">Chris Hardie</a> · <a href=\"https://profiles.wordpress.org/czarate/\">Chris Zarate</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/chrisguitarguy/\">chrisguitarguy</a> · <a href=\"https://profiles.wordpress.org/cwbudde/\">Christian-W. Budde</a> · <a href=\"https://profiles.wordpress.org/christinavoudouris/\">Christina Voudouris</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/cfinke/\">Christopher Finke</a> · <a href=\"https://profiles.wordpress.org/ryno267/\">Chuck Reynolds</a> · <a href=\"https://profiles.wordpress.org/chynnabenton/\">chynnabenton</a> · <a href=\"https://profiles.wordpress.org/ckanderson22/\">ckanderson22</a> · <a href=\"https://profiles.wordpress.org/design_dolphin/\">CodePoet</a> · <a href=\"https://profiles.wordpress.org/codewhy/\">codewhy</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/collieit/\">Collie-IT, Anne K. Frey</a> · <a href=\"https://profiles.wordpress.org/colonelphantom/\">colonelphantom</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">Cory Birdsong</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/craigfrancis/\">craigfrancis</a> · <a href=\"https://profiles.wordpress.org/crazycoders/\">crazycoders</a> · <a href=\"https://profiles.wordpress.org/mitogh/\">Crisoforo Gaspar</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/curdin/\">Curdin Krummenacher</a> · <a href=\"https://profiles.wordpress.org/cyrillbolliger/\">cyrillbolliger</a> · <a href=\"https://profiles.wordpress.org/dxd5001/\">Daijiro Miyazawa</a> · <a href=\"https://profiles.wordpress.org/dainemawer/\">dainemawer</a> · <a href=\"https://profiles.wordpress.org/daisyo/\">Daisy Olsen</a> · <a href=\"https://profiles.wordpress.org/daledupreez/\">Dale du Preez</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/damonganto/\">damonganto</a> · <a href=\"https://profiles.wordpress.org/danfarrow/\">Dan Farrow</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/danieliser/\">Daniel Iser</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/schutzsmith/\">Daniel Schutzsmith</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/dariak/\">Daria</a> · <a href=\"https://profiles.wordpress.org/dkotter/\">Darin Kotter</a> · <a href=\"https://profiles.wordpress.org/darkog/\">Darko G.</a> · <a href=\"https://profiles.wordpress.org/darkskipper/\">darkskipper</a> · <a href=\"https://profiles.wordpress.org/uofaberdeendarren/\">Darren Coutts</a> · <a href=\"https://profiles.wordpress.org/htdat/\">Dat Hoang</a> · <a href=\"https://profiles.wordpress.org/datainterlock/\">datainterlock</a> · <a href=\"https://profiles.wordpress.org/dhilditch/\">Dave Hilditch</a> · <a href=\"https://profiles.wordpress.org/dave1010/\">dave1010</a> · <a href=\"https://profiles.wordpress.org/davidanderson/\">David Anderson</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dcowgill/\">David C</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/desmith/\">David E. Smith</a> · <a href=\"https://profiles.wordpress.org/dg12345/\">David Goring</a> · <a href=\"https://profiles.wordpress.org/dgwyer/\">David Gwyer</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/daxelrod/\">daxelrod</a> · <a href=\"https://profiles.wordpress.org/daymobrew/\">daymobrew</a> · <a href=\"https://profiles.wordpress.org/deepakvijayan/\">Deepak Vijayan</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/denishua/\">denishua</a> · <a href=\"https://profiles.wordpress.org/dennisatyoast/\">Dennis Claassen</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">derekblank</a> · <a href=\"https://profiles.wordpress.org/pcfreak30/\">Derrick Hammer</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhl/\">dhl</a> · <a href=\"https://profiles.wordpress.org/dianeco/\">Diane Co</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dingdang/\">dingdang</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/dipakparmar443/\">Dipak Parmar</a> · <a href=\"https://profiles.wordpress.org/divyeshgodhani/\">divyeshgodhani</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/donmhico/\">donmhico</a> · <a href=\"https://profiles.wordpress.org/dougwollison/\">Doug Wollison</a> · <a href=\"https://profiles.wordpress.org/dougal/\">Dougal Campbell</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/drzraf/\">drzraf</a> · <a href=\"https://profiles.wordpress.org/dsas/\">dsas</a> · <a href=\"https://profiles.wordpress.org/dwainm/\">Dwain Maralack</a> · <a href=\"https://profiles.wordpress.org/kucrut/\">Dzikri Aziz</a> · <a href=\"https://profiles.wordpress.org/dovyp/\">Dōvy Paukstys</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/chopinbach/\">Edwin Cromley</a> · <a href=\"https://profiles.wordpress.org/eedee/\">eedee</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham S.</a> · <a href=\"https://profiles.wordpress.org/eliezerspp/\">Eliezer Peña</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/clarkeemily/\">Emily Clarke</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/codekraft/\">Erik</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik Betshammar</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">estelaris</a> · <a href=\"https://profiles.wordpress.org/madpixels/\">eugene.manuilov</a> · <a href=\"https://profiles.wordpress.org/eugenemanuilov/\">Eugene.Manuilov</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/aaemnnosttv/\">Evan Mattson</a> · <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/faison/\">Faison</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/fellyph/\">Fellyph Cintra</a> · <a href=\"https://profiles.wordpress.org/femkreations/\">Femy Praseeth</a> · <a href=\"https://profiles.wordpress.org/florianbrinkmann/\">Florian Brinkmann</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/fuadragib/\">Fuad Ragib</a> · <a href=\"https://profiles.wordpress.org/furi3r/\">furi3r</a> · <a href=\"https://profiles.wordpress.org/gabri3lmarques/\">gabri3lmarques</a> · <a href=\"https://profiles.wordpress.org/gdetassigny/\">Gabriel de Tassigny</a> · <a href=\"https://profiles.wordpress.org/gabertronic/\">Gabriel Rose</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/voldemortensen/\">Garth Mortensen</a> · <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/garymatthews919/\">garymatthews919</a> · <a href=\"https://profiles.wordpress.org/revgeorge/\">George Hotelling</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">gigitux</a> · <a href=\"https://profiles.wordpress.org/giox069/\">giox069</a> · <a href=\"https://profiles.wordpress.org/giuseppemazzapica/\">giuseppemazzapica</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/goldenapples/\">goldenapples</a> · <a href=\"https://profiles.wordpress.org/greglone/\">Grégory Viguier</a> · <a href=\"https://profiles.wordpress.org/graham73may/\">graham73may</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/greg24/\">greg24</a> · <a href=\"https://profiles.wordpress.org/gregorlove/\">gRegor Morrill</a> · <a href=\"https://profiles.wordpress.org/gunterer/\">gunterer</a> · <a href=\"https://profiles.wordpress.org/bordoni/\">Gustavo Bordoni</a> · <a href=\"https://profiles.wordpress.org/h2ham/\">h2ham (Hiromu Hasegawa)</a> · <a href=\"https://profiles.wordpress.org/hakanca/\">hakanca</a> · <a href=\"https://profiles.wordpress.org/hakre/\">hakre</a> · <a href=\"https://profiles.wordpress.org/hansjovisyoast/\">Hans-Christiaan Braun</a> · <a href=\"https://profiles.wordpress.org/thakkarhardik/\">Hardik Thakkar</a> · <a href=\"https://profiles.wordpress.org/haritpanchal/\">Harit Panchal</a> · <a href=\"https://profiles.wordpress.org/harshvaishnav/\">harshvaishnav</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman</a> · <a href=\"https://profiles.wordpress.org/azhiyadev/\">Hauwa Abashiya</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/henrywright/\">Henry Wright</a> · <a href=\"https://profiles.wordpress.org/here/\">here</a> · <a href=\"https://profiles.wordpress.org/herregroen/\">Herre Groen</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/hiren1094/\">hiren sanja</a> · <a href=\"https://profiles.wordpress.org/hiyascout/\">hiyascout</a> · <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">Howdy_McGee</a> · <a href=\"https://profiles.wordpress.org/hugodevos/\">hugodevos</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/hztyfoon/\">hztyfoon</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/iansvo/\">iansvo</a> · <a href=\"https://profiles.wordpress.org/icaspar/\">iCaspar</a> · <a href=\"https://profiles.wordpress.org/igmoweb/\">Ignacio Cruz Moreno</a> · <a href=\"https://profiles.wordpress.org/igorsch/\">Igor</a> · <a href=\"https://profiles.wordpress.org/igrigorik/\">igrigorik</a> · <a href=\"https://profiles.wordpress.org/ilovecats7/\">ilovecats7</a> · <a href=\"https://profiles.wordpress.org/ilunabar/\">ilunabar</a> · <a href=\"https://profiles.wordpress.org/imadarshakshat/\">imadarshakshat</a> · <a href=\"https://profiles.wordpress.org/ipajen/\">ipajen</a> · <a href=\"https://profiles.wordpress.org/ipstenu/\">Ipstenu (Mika Epstein)</a> · <a href=\"https://profiles.wordpress.org/irecinius/\">irecinius</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iulia-cazan/\">Iulia Cazan</a> · <a href=\"https://profiles.wordpress.org/ivanjeronimo/\">ivanjeronimo</a> · <a href=\"https://profiles.wordpress.org/iviweb/\">iviweb</a> · <a href=\"https://profiles.wordpress.org/jdgrimes/\">J.D. Grimes</a> · <a href=\"https://profiles.wordpress.org/primetimejas/\">Jacob Schweitzer</a> · <a href=\"https://profiles.wordpress.org/jakariaistauk/\">Jakaria Istauk</a> · <a href=\"https://profiles.wordpress.org/jamesckemp/\">James Kemp</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jamieburchell/\">jamieburchell</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">Jan Thiel</a> · <a href=\"https://profiles.wordpress.org/jarretc/\">Jarret</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/trapsta/\">Jasper Kinoti</a> · <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/grandeljay/\">Jay Trees</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jeawhanlee/\">jeawhanlee</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> · <a href=\"https://profiles.wordpress.org/juberstine/\">Jeff Uberstine</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeroenreumkens/\">JeroenReumkens</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jhart35/\">jhart35</a> · <a href=\"https://profiles.wordpress.org/jhnstn/\">jhnstn</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">jigar bhanushali</a> · <a href=\"https://profiles.wordpress.org/jnz31/\">jnz31</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelhardi/\">joelhardi</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/johnmark8080/\">johnmark8080</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/jpantani/\">Jonathan Pantani</a> · <a href=\"https://profiles.wordpress.org/jonmackintosh/\">jonmackintosh</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonny-s/\">jonny-s</a> · <a href=\"https://profiles.wordpress.org/jonoaldersonwp/\">Jono Alderson</a> · <a href=\"https://profiles.wordpress.org/joostdevalk/\">Joost de Valk</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josvelasco/\">Jos Velasco</a> · <a href=\"https://profiles.wordpress.org/joegrainger/\">Joseph Grainger</a> · <a href=\"https://profiles.wordpress.org/jostnes/\">Josepha Dambul</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden</a> · <a href=\"https://profiles.wordpress.org/jhabdas/\">Josh Habdas</a> · <a href=\"https://profiles.wordpress.org/joshuaabenazer/\">Joshua Abenazer</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrbeilke/\">jrbeilke</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">jsnajdr</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/juliobox/\">Julio Potier</a> · <a href=\"https://profiles.wordpress.org/just0nequestion/\">just0nequestion</a> · <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a> · <a href=\"https://profiles.wordpress.org/justinsainton/\">Justin Sainton</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/welenofsky/\">Justin Welenofsky</a> · <a href=\"https://profiles.wordpress.org/jyolsna/\">jyolsna</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a> · <a href=\"https://profiles.wordpress.org/akabarikalpesh/\">Kalpesh Akabari</a> · <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a> · <a href=\"https://profiles.wordpress.org/karinclimber/\">Kari Anderson</a> · <a href=\"https://profiles.wordpress.org/karlgroves/\">karlgroves</a> · <a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a> · <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a> · <a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn Presner</a> · <a href=\"https://profiles.wordpress.org/kbrownkd/\">kbrownkd</a> · <a href=\"https://profiles.wordpress.org/kkoppenhaver/\">Keanan Koppenhaver</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kellychoffman/\">Kelly Hoffman</a> · <a href=\"https://profiles.wordpress.org/kevinb/\">Kevin Behrens</a> · <a href=\"https://profiles.wordpress.org/khag7/\">Kevin Hagerty</a> · <a href=\"https://profiles.wordpress.org/khoipro/\">Khoi Pro</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/killua99/\">killua99</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/blackawxs/\">klewis</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/vdwijngaert/\">Koen Van den Wijngaert</a> · <a href=\"https://profiles.wordpress.org/konradyoast/\">Konrad.K</a> · <a href=\"https://profiles.wordpress.org/kovshenin/\">Konstantin Kovshenin</a> · <a href=\"https://profiles.wordpress.org/kanlukasz/\">Kris Kelvin</a> · <a href=\"https://profiles.wordpress.org/krishaweb/\">KrishaWeb</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kmadhak/\">Kunal Madhak</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kwillmorth/\">kwillmorth</a> · <a href=\"https://profiles.wordpress.org/kbjohnson90/\">Kyle B. Johnson</a> · <a href=\"https://profiles.wordpress.org/devnel/\">Kyle Nel</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/laurent22777/\">laurent22777</a> · <a href=\"https://profiles.wordpress.org/lazam786/\">lazam786</a> · <a href=\"https://profiles.wordpress.org/leewillis77/\">Lee Willis</a> · <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/leogermani/\">leogermani</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/linsoftware/\">Linnea Huxford</a> · <a href=\"https://profiles.wordpress.org/lonnylot/\">lonnylot</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/lovor/\">Lovro Hrust</a> · <a href=\"https://profiles.wordpress.org/lucasbustamante/\">Lucas Bustamante</a> · <a href=\"https://profiles.wordpress.org/lucilastancato/\">lucilastancato</a> · <a href=\"https://profiles.wordpress.org/luigipulcini/\">luigipulcini</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/infolu/\">Luiz Araújo</a> · <a href=\"https://profiles.wordpress.org/mitweka/\">Lukas Niebler</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/msnewas/\">M S Newaz</a> · <a href=\"https://profiles.wordpress.org/maartenj/\">Maarten</a> · <a href=\"https://profiles.wordpress.org/mashikag/\">Maciej</a> · <a href=\"https://profiles.wordpress.org/maciejmackowiak/\">maciejmackowiak</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/patopaiar/\">magicoders</a> · <a href=\"https://profiles.wordpress.org/maahrokh/\">Mahrokh</a> · <a href=\"https://profiles.wordpress.org/maksimkuzmin/\">maksimkuzmin</a> · <a href=\"https://profiles.wordpress.org/malthert/\">malthert</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manishsongirkar36/\">Manish Songirkar</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani</a> · <a href=\"https://profiles.wordpress.org/manzurahammed/\">Manzur Ahammed</a> · <a href=\"https://profiles.wordpress.org/marcyoast/\">Marc</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/mkaz/\">Marcus Kazmierczak</a> · <a href=\"https://profiles.wordpress.org/marekdedic/\">Marek Dědič</a> · <a href=\"https://profiles.wordpress.org/nuryko/\">Marianna</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markbiek/\">Mark Biek</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markparnell/\">Mark Parnell</a> · <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/mkox/\">Markus Kosmal</a> · <a href=\"https://profiles.wordpress.org/mhkuu/\">Martijn van der Klis</a> · <a href=\"https://profiles.wordpress.org/hinjiriyo/\">Martin Stehle</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mashukushibiki/\">Mashu</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">masteradhoc</a> · <a href=\"https://profiles.wordpress.org/msurdi/\">Matías Emanuel Surdi</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">matiasbenedetto</a> · <a href=\"https://profiles.wordpress.org/mattchowning/\">Matt Chowning</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattwondra/\">Matt Wondra</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/mattheweppelsheimer/\">Matthew Eppelsheimer</a> · <a href=\"https://profiles.wordpress.org/matthiaspabst/\">Matthias Pabst</a> · <a href=\"https://profiles.wordpress.org/matthiasreinholz/\">Matthias Reinholz</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">mattyrob</a> · <a href=\"https://profiles.wordpress.org/azouamauriac/\">Mauriac AZOUA</a> · <a href=\"https://profiles.wordpress.org/maximej/\">Maxime J.</a> · <a href=\"https://profiles.wordpress.org/maximemeganck/\">Maxime Meganck</a> · <a href=\"https://profiles.wordpress.org/mayankmajeji/\">Mayank Majeji</a> · <a href=\"https://profiles.wordpress.org/maythamalsudany/\">maythamalsudany</a> · <a href=\"https://profiles.wordpress.org/mayuge/\">Mayuge</a> · <a href=\"https://profiles.wordpress.org/mcliwanow/\">mcliwanow</a> · <a href=\"https://profiles.wordpress.org/rakibwordpress/\">Md Rakib Hossain</a> · <a href=\"https://profiles.wordpress.org/russel07/\">Md. Russel Hussain</a> · <a href=\"https://profiles.wordpress.org/mdrago/\">mdrago</a> · <a href=\"https://profiles.wordpress.org/mehedi890/\">Mehedi Foysal</a> · <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a> · <a href=\"https://profiles.wordpress.org/mehulkaklotar/\">Mehul Kaklotar</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/meloniq/\">meloniq</a> · <a href=\"https://profiles.wordpress.org/merkys/\">Merkys Maliukevičius</a> · <a href=\"https://profiles.wordpress.org/meysamnorouzi/\">meysam norouzi</a> · <a href=\"https://profiles.wordpress.org/mfgmicha/\">Micha Krapp</a> · <a href=\"https://profiles.wordpress.org/michaelbourne/\">Michael Bourne</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/mihaidumitrascu/\">Mihai Dumitrascu</a> · <a href=\"https://profiles.wordpress.org/mihai2u/\">Mike Crantea</a> · <a href=\"https://profiles.wordpress.org/mdgl/\">Mike Glendinning</a> · <a href=\"https://profiles.wordpress.org/mikehansenme/\">Mike Hansen</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley (a11n)</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikemanzo/\">mikemanzo</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/milindmore22/\">Milind More</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/multidots1896/\">Minal Diwan</a> · <a href=\"https://profiles.wordpress.org/presents111/\">miya</a> · <a href=\"https://profiles.wordpress.org/mlajo/\">Mladen</a> · <a href=\"https://profiles.wordpress.org/batmoo/\">Mohammad Jangda</a> · <a href=\"https://profiles.wordpress.org/mjkhajeh/\">MohammadJafar Khajeh</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/boemedia/\">Monique Dubbelman</a> · <a href=\"https://profiles.wordpress.org/mt8biz/\">moto hachi</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrobit/\">mrobit</a> · <a href=\"https://profiles.wordpress.org/msolution/\">msolution</a> · <a href=\"https://profiles.wordpress.org/mtias/\">mtias</a> · <a href=\"https://profiles.wordpress.org/wparslan/\">Muhammad Arslan</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/mmaumio/\">Muntasir Mahmud</a> · <a href=\"https://profiles.wordpress.org/amustaque97/\">Mustaque Ahmed</a> · <a href=\"https://profiles.wordpress.org/mvraghavan/\">mvraghavan</a> · <a href=\"https://profiles.wordpress.org/mweichert/\">mweichert</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">n8finch</a> · <a href=\"https://profiles.wordpress.org/nalininonstopnewsuk/\">Nalini Thakor</a> · <a href=\"https://profiles.wordpress.org/namithjawahar/\">Namith Jawahar</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nateallen/\">Nate Allen</a> · <a href=\"https://profiles.wordpress.org/nhadsall/\">Nathan</a> · <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a> · <a href=\"https://profiles.wordpress.org/navigatrum/\">navigatrum</a> · <a href=\"https://profiles.wordpress.org/neffff/\">neffff</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/neychok/\">Neycho Kalaydzhiev</a> · <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nikkigagency/\">nikkigagency</a> · <a href=\"https://profiles.wordpress.org/im_niloy/\">Niloy</a> · <a href=\"https://profiles.wordpress.org/ninos-ego/\">Ninos</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/nlpro/\">nlpro</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/noplanman/\">noplanman</a> · <a href=\"https://profiles.wordpress.org/nouarah/\">nouarah</a> · <a href=\"https://profiles.wordpress.org/numidwasnotavailable/\">NumidWasNotAvailable</a> · <a href=\"https://profiles.wordpress.org/nunomorgadinho/\">Nuno Morgadinho</a> · <a href=\"https://profiles.wordpress.org/zikubd/\">Nurul Umbhiya</a> · <a href=\"https://profiles.wordpress.org/nvartolomei/\">nvartolomei</a> · <a href=\"https://profiles.wordpress.org/obayedmamur/\">Obayed Mamur</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/oliverstapelfeldt/\">Oliver Stapelfeldt</a> · <a href=\"https://profiles.wordpress.org/olliejones/\">OllieJones</a> · <a href=\"https://profiles.wordpress.org/oneearth27/\">oneearth27</a> · <a href=\"https://profiles.wordpress.org/onnimonni/\">Onni Hakala</a> · <a href=\"https://profiles.wordpress.org/opr18/\">opr18</a> · <a href=\"https://profiles.wordpress.org/ovidiul/\">ovidiul</a> · <a href=\"https://profiles.wordpress.org/p_enrique/\">p_enrique</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/poliuk/\">Pablo Postigo</a> · <a href=\"https://profiles.wordpress.org/pablohoney/\">PabloHoney</a> · <a href=\"https://profiles.wordpress.org/palmiak/\">palmiak</a> · <a href=\"https://profiles.wordpress.org/pls78/\">Paolo L. Scala</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/xparham/\">Parham Ghaffarian</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/patrickgroot/\">Patrick Groot</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/figureone/\">Paul Ryan</a> · <a href=\"https://profiles.wordpress.org/paulohcruz/\">Paulo Cruz</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/pavelschoffer/\">pavelschoffer</a> · <a href=\"https://profiles.wordpress.org/pbking/\">pbking</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/walbo/\">Petter Walbø Johnsgård</a> · <a href=\"https://profiles.wordpress.org/johnstonphilip/\">Phil Johnston</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/strategio/\">Pierre Sylvestre</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> · <a href=\"https://profiles.wordpress.org/mordauk/\">Pippin Williamson</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/pratiweb/\">Pratiksha</a> · <a href=\"https://profiles.wordpress.org/nikeo/\">presscustomizr</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a> · <a href=\"https://profiles.wordpress.org/priyomukul/\">Priyo Mukul</a> · <a href=\"https://profiles.wordpress.org/prokium/\">prokium</a> · <a href=\"https://profiles.wordpress.org/itsjonq/\">Q</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/larrach/\">Rachel Peter</a> · <a href=\"https://profiles.wordpress.org/raduiason/\">raduiason</a> · <a href=\"https://profiles.wordpress.org/rafiahmedd/\">Rafi Ahmed</a> · <a href=\"https://profiles.wordpress.org/tan007/\">Rahi Prajapati</a> · <a href=\"https://profiles.wordpress.org/rajanpanchal2028/\">Rajan Panchal</a> · <a href=\"https://profiles.wordpress.org/rajeshraval786/\">Rajesh Raval</a> · <a href=\"https://profiles.wordpress.org/ralucastn/\">ralucastn</a> · <a href=\"https://profiles.wordpress.org/superpoincare/\">Ramanan</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramon-fincken/\">ramon fincken</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/randhirexpresstech/\">randhirexpresstech</a> · <a href=\"https://profiles.wordpress.org/ravipatel/\">Ravikumar Patel</a> · <a href=\"https://profiles.wordpress.org/rcanepa/\">rcanepa</a> · <a href=\"https://profiles.wordpress.org/rebasaurus/\">rebasaurus</a> · <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/renegeuze/\">renegeuze</a> · <a href=\"https://profiles.wordpress.org/laboiteare/\">Reuhno</a> · <a href=\"https://profiles.wordpress.org/rflw/\">rflw</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rinatkhaziev/\">Rinat</a> · <a href=\"https://profiles.wordpress.org/rinkychowdhury9/\">Rinky Chowdhury</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rkaiser0324/\">rkaiser0324</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/miqrogroove/\">Robert Chapin</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">robertght</a> · <a href=\"https://profiles.wordpress.org/robinwpdeveloper/\">Robin</a> · <a href=\"https://profiles.wordpress.org/robmiller/\">robmiller</a> · <a href=\"https://profiles.wordpress.org/rodrigosevero/\">rodrigosevero</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/rolfsiebers/\">Rolf Siebers</a> · <a href=\"https://profiles.wordpress.org/rollybueno/\">rollybueno</a> · <a href=\"https://profiles.wordpress.org/rherault/\">Romain Herault</a> · <a href=\"https://profiles.wordpress.org/romulodl/\">romulodl</a> · <a href=\"https://profiles.wordpress.org/ross_ritchey/\">ross_ritchey</a> · <a href=\"https://profiles.wordpress.org/lev0/\">Roy</a> · <a href=\"https://profiles.wordpress.org/geekstreetwp/\">Russell Aaron</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/ryanmurphy/\">Ryan Murphy</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">Sérgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wrede</a> · <a href=\"https://profiles.wordpress.org/sabbirmc/\">Sabbir Ahmed</a> · <a href=\"https://profiles.wordpress.org/sajjad67/\">Sajjad Hossain Sagor</a> · <a href=\"https://profiles.wordpress.org/saggre/\">Sakri Koskimies</a> · <a href=\"https://profiles.wordpress.org/samikeijonen/\">Sami Keijonen</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sandipmondal/\">Sandip Mondal &#8211; a11n</a> · <a href=\"https://profiles.wordpress.org/sandrasanzdev/\">Sandra Sanz</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">santosguillamot</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarahricker/\">sarahricker</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiyamoorthy V</a> · <a href=\"https://profiles.wordpress.org/isaumya/\">Saumya Majumder</a> · <a href=\"https://profiles.wordpress.org/xconsau/\">Saurabh Sharma</a> · <a href=\"https://profiles.wordpress.org/scofennellgmailcom/\">Scott Fennell</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/gmagicscott/\">Scott Lesovic</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/seakashdiu/\">seakashdiu</a> · <a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a> · <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a> · <a href=\"https://profiles.wordpress.org/monolithon/\">seieric</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/seedsca/\">Sergio Scabuzzo</a> · <a href=\"https://profiles.wordpress.org/seriouslysenpai/\">seriouslysenpai</a> · <a href=\"https://profiles.wordpress.org/sethta/\">Seth Alling</a> · <a href=\"https://profiles.wordpress.org/shanjidah/\">shangidah afroz</a> · <a href=\"https://profiles.wordpress.org/enchiridion/\">Shannon Little</a> · <a href=\"https://profiles.wordpress.org/sharjeelkhanvmi/\">Sharjeel Khan</a> · <a href=\"https://profiles.wordpress.org/shetheliving/\">shetheliving</a> · <a href=\"https://profiles.wordpress.org/shoaibkarimali/\">Shoaib Ali</a> · <a href=\"https://profiles.wordpress.org/shraboni/\">Shraboni</a> · <a href=\"https://profiles.wordpress.org/shreyasikhar26/\">Shreyas Ikhar</a> · <a href=\"https://profiles.wordpress.org/shuvo586/\">shuvo586</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth ravikumar</a> · <a href=\"https://profiles.wordpress.org/nomnom99/\">Siddharth Thevaril</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/sirzooro/\">sirzooro</a> · <a href=\"https://profiles.wordpress.org/slaffik/\">Slava Abakumov</a> · <a href=\"https://profiles.wordpress.org/slobodanmanic/\">Slobodan Manic</a> · <a href=\"https://profiles.wordpress.org/smit08/\">Smit Rathod</a> · <a href=\"https://profiles.wordpress.org/sobatkras/\">sobatkras</a> · <a href=\"https://profiles.wordpress.org/khromov/\">Stanislav Khromov</a> · <a href=\"https://profiles.wordpress.org/steelwagstaff/\">SteelWagstaff</a> · <a href=\"https://profiles.wordpress.org/ste_95/\">Stefano</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/hypest/\">Stefanos Togoulidis</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/camwynsp/\">Stephen Page</a> · <a href=\"https://profiles.wordpress.org/sterlo/\">Sterling Hamilton</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/steveo2000/\">steveo2000</a> · <a href=\"https://profiles.wordpress.org/studiolxv/\">studiolxv</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/5um17/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh (WP Lovers)</a> · <a href=\"https://profiles.wordpress.org/csesumonpro/\">Sumon Sarker</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/sunyatasattva/\">sunyatasattva</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/system909/\">system909</a> · <a href=\"https://profiles.wordpress.org/tahmidulkarim/\">Tahmid ul Karim</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/tanvirul/\">Tanvirul Haque</a> · <a href=\"https://profiles.wordpress.org/taskotr/\">Taras Dashkevych</a> · <a href=\"https://profiles.wordpress.org/targz/\">targz</a> · <a href=\"https://profiles.wordpress.org/tlovett1/\">Taylor Lovett</a> · <a href=\"https://profiles.wordpress.org/tazotodua/\">tazotodua</a> · <a href=\"https://profiles.wordpress.org/tbember/\">tbember</a> · <a href=\"https://profiles.wordpress.org/tykoted/\">Teddy Patriarca</a> · <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a> · <a href=\"https://profiles.wordpress.org/edent/\">Terence Eden</a> · <a href=\"https://profiles.wordpress.org/tharsheblows/\">tharsheblows</a> · <a href=\"https://profiles.wordpress.org/iamjaydip/\">thejaydip</a> · <a href=\"https://profiles.wordpress.org/tweetythierry/\">Thierry Muller</a> · <a href=\"https://profiles.wordpress.org/thijso/\">Thijs</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/hyperbrand/\">Thorsten Schraut</a> · <a href=\"https://profiles.wordpress.org/threadi/\">threadi</a> · <a href=\"https://profiles.wordpress.org/baxbridge/\">Tiffany Bridge</a> · <a href=\"https://profiles.wordpress.org/tillkruess/\">Till Krüss</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tmooredev/\">Titus Moore</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomjdv/\">Tom de Visser</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tj692/\">Tom Janssen</a> · <a href=\"https://profiles.wordpress.org/tommusrhodus/\">Tom Rhodes</a> · <a href=\"https://profiles.wordpress.org/tomasztunik/\">Tomasz Tunik</a> · <a href=\"https://profiles.wordpress.org/tomepajk/\">tomepajk</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a> · <a href=\"https://profiles.wordpress.org/tonylocalword/\">tony.localword</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/transl8or/\">transl8or</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/tremidkhar/\">Tremi Dkhar</a> · <a href=\"https://profiles.wordpress.org/trevorpfromsandee/\">TrevorPolischuk</a> · <a href=\"https://profiles.wordpress.org/nathannoom/\">Trinadin</a> · <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a> · <a href=\"https://profiles.wordpress.org/turtlepod/\">turtlepod</a> · <a href=\"https://profiles.wordpress.org/tushar284/\">Tushar</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/grapplerulrich/\">Ulrich</a> · <a href=\"https://profiles.wordpress.org/umesh84/\">Umesh Gupta</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utsavmadaan823/\">utsavmadaan823</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/evildon/\">varma</a> · <a href=\"https://profiles.wordpress.org/vasartam/\">vasartam</a> · <a href=\"https://profiles.wordpress.org/vdankbaar/\">vdankbaar</a> · <a href=\"https://profiles.wordpress.org/velochicdunord/\">Velochicdunord</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vikasprogrammer/\">vikasprogrammer</a> · <a href=\"https://profiles.wordpress.org/virgar/\">Virginie Garnier</a> · <a href=\"https://profiles.wordpress.org/vishalkakadiya/\">Vishal Kakadiya</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/webbeetle/\">webbeetle</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whaze/\">whaze</a> · <a href=\"https://profiles.wordpress.org/whissi/\">Whissi</a> · <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/withinboredom/\">withinboredom</a> · <a href=\"https://profiles.wordpress.org/woji29911/\">woji29911</a> · <a href=\"https://profiles.wordpress.org/yahil/\">Yahil Madakiya</a> · <a href=\"https://profiles.wordpress.org/yannielsen/\">Yan Knudtskov</a> · <a href=\"https://profiles.wordpress.org/collet/\">Yann</a> · <a href=\"https://profiles.wordpress.org/yoavf/\">Yoav Farhi</a> · <a href=\"https://profiles.wordpress.org/byohann6/\">Yohann Billard</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/omaeyusuke/\">yuu</a> · <a href=\"https://profiles.wordpress.org/zaerl/\">zaerl</a> · <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a> · <a href=\"https://profiles.wordpress.org/zenaulislam/\">Zenaul Islam</a> · <a href=\"https://profiles.wordpress.org/ziposc/\">ziposc</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a> · <a href=\"https://profiles.wordpress.org/shenyanzhi/\">沈唁</a></p>\n\n\n\n<p>Merci également à toutes celles et ceux qui ont traduit cette version en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/bonaldi\">Bonaldi</a>,&nbsp;<a href=\"https://profiles.wordpress.org/btpub\">Bruno Tritsch</a>,&nbsp;<a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>,&nbsp;<a href=\"https://profiles.wordpress.org/wolforg\">Didier Demory</a>, <a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">FX&nbsp;Bénard</a>,&nbsp;<a href=\"https://profiles.wordpress.org/florianv\">florianv</a>,&nbsp;<a href=\"https://profiles.wordpress.org/fred5550\">Frederic Nuyts</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ggwptranslate\">Gilbert GAYRAUD</a>,&nbsp;<a href=\"https://profiles.wordpress.org/guillaumeturpin\">Guillaume TURPIN</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ioanamuresan\">Ioana M.</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jaz_on\">Jason Rouet</a>, <a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/loulou51\">Loulou51</a>, <a href=\"https://profiles.wordpress.org/lulucmy\">lulucmy</a>, <a href=\"https://profiles.wordpress.org/maecatnou\">maecatnou</a>,&nbsp;<a href=\"https://profiles.wordpress.org/oellin\">Magali</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nuryko\">Marianna</a>, <a href=\"https://profiles.wordpress.org/chaton666\">Marie Comet</a>, <a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>,&nbsp;<a href=\"https://profiles.wordpress.org/maxpertici\">Maxime Pertici</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nandow\">nandow</a>,&nbsp;<a href=\"https://profiles.wordpress.org/pasglop\">pasglop</a>,&nbsp;<a href=\"https://profiles.wordpress.org/larrach\">Rachel Peter</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>,&nbsp;<a href=\"https://profiles.wordpress.org/solaack\">solaack</a>,&nbsp;<a href=\"https://profiles.wordpress.org/stephanepoisson\">Stéphane POISSON</a>,&nbsp;<a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>,&nbsp;<a href=\"https://profiles.wordpress.org/translationsbyautomattic\">Translations by Automattic</a>,&nbsp;<a href=\"https://profiles.wordpress.org/virgar\">Virginie Garnier</a>,&nbsp;<a href=\"https://profiles.wordpress.org/virginienacci\">virginienacci</a>, <a href=\"https://profiles.wordpress.org/whaze\">whaze</a>,&nbsp;<a href=\"https://profiles.wordpress.org/whodunitagency\">Whodunit</a>,&nbsp;<a href=\"https://profiles.wordpress.org/wptranslationsorg\">WP-Translations</a>, et&nbsp;<a href=\"https://profiles.wordpress.org/wplmillet\">wplmillet</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://fr.wordpress.org/2022/11/02/wordpress-6-1-misha/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:77:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2022/10/12/guide-des-changements-techniques-de-wordpress-6-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://fr.wordpress.org/2022/10/12/guide-des-changements-techniques-de-wordpress-6-1/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Oct 2022 16:20:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:13:\"Documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2509\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"Tour d\'horizon des changements techniques apportés par WordPress 6.1, la prochaine version majeure du CMS.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:66:\"https://make.wordpress.org/design/files/2022/09/tt3_variations.mp4\";s:6:\"length\";s:6:\"996018\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:45796:\"\n<p>La version&nbsp;<em>Release Candidate</em>&nbsp;de&nbsp;<strong>WordPress&nbsp;6.1</strong>&nbsp;est sortie mardi 11 octobre. Il est donc temps de parcourir les différents changements techniques qu’apportera cette prochaine version majeure de notre CMS.</p>\n\n\n\n<p><strong>La sortie finale de cette nouvelle version est planifiée pour le 1<sup>er</sup>&nbsp;novembre 2022.</strong></p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" loading=\"lazy\" width=\"2328\" height=\"1158\" src=\"https://fr.wordpress.org/files/2022/10/wp61-guide.png\" alt=\"WordPress 6.1 : Guide des changements techniques\" class=\"wp-image-2472\" srcset=\"https://fr.wordpress.org/files/2022/10/wp61-guide.png 2328w, https://fr.wordpress.org/files/2022/10/wp61-guide-300x149.png 300w, https://fr.wordpress.org/files/2022/10/wp61-guide-1024x509.png 1024w, https://fr.wordpress.org/files/2022/10/wp61-guide-768x382.png 768w, https://fr.wordpress.org/files/2022/10/wp61-guide-1536x764.png 1536w, https://fr.wordpress.org/files/2022/10/wp61-guide-2048x1019.png 2048w\" sizes=\"(max-width: 2328px) 100vw, 2328px\" /></figure>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/6-1/\">L’équipe de direction de WP 6.1</a>&nbsp;et plusieurs centaines de contributeurs et contributrices ont travaillé sur plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.1&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">120 améliorations et nouvelles fonctionnalités</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.1&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">241 correctifs</a>&nbsp;et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.1&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">42 autres tâches variées</a>, ce qui représente plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.1&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">400 tickets sur Trac</a>.</p>\n\n\n\n<p>À cela, il faut ajouter plus de&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56467\">50 pull requests</a>&nbsp;ayant permis de fusionner les différentes versions de Gutenberg dans le cœur du CMS. Du côté du projet Gutenberg il y a eu en tout 1684 pull requests apportant 425 nouvelles fonctionnalités et améliorations et 428&nbsp;correctifs de bugs, le reste concernant des tâches courantes de revue de qualité du code, de documentation ou d&rsquo;amélioration des outils de déploiement.</p>\n\n\n\n<p class=\"is-style-serif has-text-color\" style=\"color:#d95e43;font-size:18px\">En route pour un petit tour d’horizon des<br>nouveautés techniques de WordPress&nbsp;6.1&nbsp;<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f680.png\" alt=\"🚀\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<span id=\"more-2509\"></span>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais.</p>\n\n\n\n<p>L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p class=\"has-text-color has-background\" style=\"color:#ac270c;background-color:#f4e3da\">À noter&nbsp;: certaines modifications listées ici vont nécessiter des actions de la part des auteurs et autrices de thèmes et d’extensions, qui devront adapter ou modifier leur code. Si vous êtes concerné·e, veuillez lire les notes de développement listées dans cet article consciencieusement afin de vous assurer que votre code fonctionnera avec WordPress&nbsp;6.1 lorsque cette version sortira le 1<sup>er</sup>&nbsp;novembre 2022.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Performances</h2>\n\n\n\n<p>Avec&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.1&amp;group=component&amp;col=id&amp;col=summary&amp;col=version&amp;col=focuses&amp;col=keywords&amp;order=priority\">45 tickets sur Trac</a>&nbsp;pour WP&nbsp;6.1, l’amélioration des performances et des temps de chargement de WordPress a été l’un des enjeux principaux de cette version. Les changements les plus significatifs portent sur les requêtes&nbsp;<code>WP_Query</code>&nbsp;et sur l’API REST, deux points qui impactent grandement les temps de chargement de votre site. L’un des changements les plus attendus concernait notamment la mise en cache des requêtes&nbsp;<code>WP_Query</code>, et c’est maintenant une réalité avec WP&nbsp;6.1.</p>\n\n\n\n<p>De nouveaux points de contrôle ont aussi été ajoutés dans l’écran de&nbsp;<em>Santé du site</em>, qui vous indiquera maintenant si la mise en cache des pages et le cache persistant fonctionnent correctement sur votre site.</p>\n\n\n\n<p>Plusieurs améliorations conséquentes sur l’API de mise en cache de WordPress ont également été mises en œuvre, et l’ordre d’exécution général des crochets d’action a été optimisé pour retarder le moins possible l’affichage des pages.</p>\n\n\n\n<p>L’enregistrement de blocs personnalisés pour l’éditeur à l’aide de fichiers&nbsp;<code>block.json</code>&nbsp;a aussi été rendu bien plus performant.</p>\n\n\n\n<p>Et ce n’est qu’une petite partie des améliorations de performances de WP 6.1. Pour en découvrir plus, voici un guide spécifique sur les performances dans cette nouvelle version de WP&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"qnD9kaPwLM\"><a href=\"https://make.wordpress.org/core/2022/10/11/performance-field-guide-for-wordpress-6-1/\">Performance Field Guide for WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Performance Field Guide for WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/11/performance-field-guide-for-wordpress-6-1/embed/#?secret=S9AxfZHdKy#?secret=qnD9kaPwLM\" data-secret=\"qnD9kaPwLM\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Accessibilité</h2>\n\n\n\n<p>Il s’agit du second focus principal de WordPress 6.1, avec&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.1&amp;group=component&amp;col=id&amp;col=summary&amp;col=focuses&amp;col=version&amp;col=keywords&amp;order=priority\">28 tickets sur Trac</a>, concernant 13 des principaux composants du CMS. De nombreuses améliorations ont été faites sur l’éditeur de blocs et sur la fonctionnalité d’édition complète du site, quelques éléments encore non conformes sur les différents écrans d’administration ont été corrigés, et beaucoup d’autres améliorations ont été faites pour faciliter l’utilisation de WordPress par toutes et tous.</p>\n\n\n\n<p>Une attention particulière a également été portée sur la gestion des champs requis sur les différents formulaires de l’interface d’administration&nbsp;: pour faciliter leur maintenance, une petite API a été créée afin de gérer de façon centralisée leur affichage. Celle-ci est publique et peut donc être utilisée par les personnes réalisant des développements sur mesure.</p>\n\n\n\n<p>Notons également qu’avec WordPress 6.1, les deux thèmes natifs&nbsp;<a href=\"https://core.trac.wordpress.org/changeset/54467\">Twenty Twenty-Three</a>&nbsp;(nous reparlerons de celui-là dans un article dédié&nbsp;!) et&nbsp;<a href=\"https://github.com/WordPress/wordpress-develop/pull/2324/files\">Twenty Twenty-Two</a>&nbsp;font leur entrée parmi les premiers&nbsp;<em>Block Themes</em>&nbsp;(ces thèmes entièrement modifiables avec l’éditeur de blocs) ayant obtenu le libellé&nbsp;<code>accessibility-ready</code>&nbsp;sur le répertoire de thèmes WordPress.org.</p>\n\n\n\n<p>Pour en savoir plus sur toutes ces améliorations concernant l’accessibilité de WordPress, consultez le guide spécifique proposé par l’équipe&nbsp;<em>Accessibility</em>&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"gOxSBctZIG\"><a href=\"https://make.wordpress.org/core/2022/10/11/wordpress-6-1-accessibility-improvements/\">WordPress 6.1 Accessibility Improvements</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;WordPress 6.1 Accessibility Improvements&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/11/wordpress-6-1-accessibility-improvements/embed/#?secret=Rp2Ep8E3XI#?secret=gOxSBctZIG\" data-secret=\"gOxSBctZIG\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">L’éditeur de blocs</h2>\n\n\n\n<p>C’est évidemment encore et toujours un des axes concentrant le plus d’évolutions d’une version à une autre&nbsp;<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f60a.png\" alt=\"😊\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p>WordPress 6.1 embarque les versions&nbsp;<a href=\"https://make.wordpress.org/core/2022/04/28/whats-new-in-gutenberg-13-1-27-april/\">13.1</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/05/12/whats-new-in-gutenberg-13-2-may-11/\">13.2</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/05/26/whats-new-in-gutenberg-13-3-0-may-25/\">13.3</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/06/10/whats-new-in-gutenberg-13-4-8-june/\">13.4</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/06/22/whats-new-in-gutenberg-13-5-22-june/\">13.5</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/07/07/whats-new-in-gutenberg-13-6-6-july/\">13.6</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/07/20/whats-new-in-gutenberg-13-7-20-july/\">13.7</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/08/04/whats-new-in-gutenberg-13-8-3-august/\">13.8</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/08/17/whats-new-in-gutenberg-13-9-17-august/\">13.9</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/09/01/whats-new-in-gutenberg-14-0-31-august/\">14.0</a>, et&nbsp;<a href=\"https://make.wordpress.org/core/2022/09/16/whats-new-in-gutenberg-14-1-15-september/\">14.1</a>&nbsp;du projet Gutenberg.</p>\n\n\n\n<p>Parmi les nombreux changements de ces 10 versions de l’extension Gutenberg, un gros effort a été fait pour rendre les blocs et autres fonctionnalités de l’éditeur de plus en plus disponibles pour les thèmes «&nbsp;classiques&nbsp;», c’est à dire les thèmes qui ne prennent pas encore en charge l’édition complète du site à l’aide de blocs, une fonctionnalité introduite dans le CMS en 2022 avec WordPress&nbsp;5.9.</p>\n\n\n\n<p>L’objectif est de faciliter le travail des développeuses et des développeurs pour effectuer une transition de leurs thèmes «&nbsp;classiques&nbsp;» vers le principe du thème basé sur des blocs, que celui-ci soit entièrement ou partiellement modifiable dans l’éditeur. Nous espérons que cela poussera encore plus les personnes développant des thèmes WordPress à exploiter au maximum les fonctionnalités de l’éditeur.</p>\n\n\n\n<p>Par ailleurs, de nombreuses fonctionnalités utiles au quotidien ont été ajoutées dans cette version&nbsp;: filtrage des données du&nbsp;<code>theme.json</code>, nouveau système de gestion des préférences dans l’éditeur, possibilité de modifier et étendre le bloc «&nbsp;Boucle de requête&nbsp;», et bien plus encore.</p>\n\n\n\n<p>Vous trouverez ci-dessous les différentes notes de développement concernant l’éditeur de WordPress&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"dBrmxcR9rG\"><a href=\"https://make.wordpress.org/core/2022/10/12/block-api-changes-in-wordpress-6-1/\">Block API changes in WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Block API changes in WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/12/block-api-changes-in-wordpress-6-1/embed/#?secret=yffoVF22CZ#?secret=dBrmxcR9rG\" data-secret=\"dBrmxcR9rG\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"Fjn1oGyqWW\"><a href=\"https://make.wordpress.org/core/2022/10/07/create-block-scaffolding-tool-updates/\">Create-block scaffolding tool updates</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Create-block scaffolding tool updates&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/07/create-block-scaffolding-tool-updates/embed/#?secret=VtlSw1eM1t#?secret=Fjn1oGyqWW\" data-secret=\"Fjn1oGyqWW\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zyyLlU97ov\"><a href=\"https://make.wordpress.org/core/2022/10/10/extending-the-query-loop-block/\">Extending the Query Loop block</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Extending the Query Loop block&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/10/extending-the-query-loop-block/embed/#?secret=LIiTYZPDuG#?secret=zyyLlU97ov\" data-secret=\"zyyLlU97ov\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zexxXNky1n\"><a href=\"https://make.wordpress.org/core/2022/10/04/block-based-template-parts-in-traditional-themes/\">Block-based &#8220;template parts&#8221; in traditional themes</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Block-based &#8220;template parts&#8221; in traditional themes&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/04/block-based-template-parts-in-traditional-themes/embed/#?secret=jGN0kLdfpO#?secret=zexxXNky1n\" data-secret=\"zexxXNky1n\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"TQjPI7jtgJ\"><a href=\"https://make.wordpress.org/core/2022/10/10/block-styles-generation-style-engine/\">Block styles generation (Style Engine)</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Block styles generation (Style Engine)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/10/block-styles-generation-style-engine/embed/#?secret=hpcPvjxOC0#?secret=TQjPI7jtgJ\" data-secret=\"TQjPI7jtgJ\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"3JmOVCNc5n\"><a href=\"https://make.wordpress.org/core/2022/10/10/changes-to-block-editor-preferences-in-wordpress-6-1/\">Changes to block editor preferences in WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Changes to block editor preferences in WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/10/changes-to-block-editor-preferences-in-wordpress-6-1/embed/#?secret=71OVXmY0eo#?secret=3JmOVCNc5n\" data-secret=\"3JmOVCNc5n\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"vifHRi3Twr\"><a href=\"https://make.wordpress.org/core/2022/10/10/editor-components-updates-for-wordpress-6-1/\">Editor Components updates in WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Editor Components updates in WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/10/editor-components-updates-for-wordpress-6-1/embed/#?secret=qPmCZKf0U8#?secret=vifHRi3Twr\" data-secret=\"vifHRi3Twr\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"h3aDnp2W04\"><a href=\"https://make.wordpress.org/core/2022/10/11/simplified-data-access-with-new-react-hooks-in-wordpress-6-1/\">Simplified data access with new React hooks in WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Simplified data access with new React hooks in WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/11/simplified-data-access-with-new-react-hooks-in-wordpress-6-1/embed/#?secret=0IPHFMNGSf#?secret=h3aDnp2W04\" data-secret=\"h3aDnp2W04\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"bRnyzICqAu\"><a href=\"https://make.wordpress.org/core/2022/10/10/miscellaneous-editor-changes-for-wordpress-6-1/\">Miscellaneous editor changes for WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Miscellaneous editor changes for WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/10/miscellaneous-editor-changes-for-wordpress-6-1/embed/#?secret=5zY0ol61lV#?secret=bRnyzICqAu\" data-secret=\"bRnyzICqAu\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p>Par ailleurs, la note de développement suivante fournit un état des lieux très pratique des blocs natifs et de leurs différentes possibilités de formatage&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"wq78upcC0e\"><a href=\"https://make.wordpress.org/core/2022/10/11/roster-of-design-tools-per-block/\">Roster of design tools per block</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Roster of design tools per block&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/11/roster-of-design-tools-per-block/embed/#?secret=0coW6ckdnA#?secret=wq78upcC0e\" data-secret=\"wq78upcC0e\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Développement de thèmes WordPress</h2>\n\n\n\n<p>Les notes de développement suivantes présentent des changements qui concernent tout particulièrement les développeuses et développeurs de thèmes.</p>\n\n\n\n<p>Tout d’abord, l’entête&nbsp;<code>Update URI</code>&nbsp;qui doit être utilisé si vous développez des thèmes sur mesure n’ayant pas vocation à être déployés sur le répertoire WordPress.org. Cela évitera que votre site propose une mise à jour et écrase votre thème dans le cas où un thème du répertoire officiel porterait le même identifiant (slug) que le vôtre&nbsp;!</p>\n\n\n\n<p>Ensuite nous avons plusieurs notes de développement concernant les interactions entre les thèmes et l’éditeur de site. Et notamment la possibilité de créer des éléments de modèles basés sur des blocs au sein d’un thème classique, c’est à dire d’un thème ne proposant au départ pas de compatibilité avec l’édition complète de site (<em>full site editing</em>).</p>\n\n\n\n<p>Enfin, on notera l&rsquo;arrivée de la gestion fluide des polices typographiques, qui permettent de définir la taille de typo de façon à ce qu&rsquo;elle s&rsquo;adapte dynamiquement à la largeur de l&rsquo;écran.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"kTK0wJfy87\"><a href=\"https://make.wordpress.org/core/2022/10/06/introducing-update-uri-theme-header-in-wordpress-6-1/\">Introducing “Update URI” theme header in WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Introducing “Update URI” theme header in WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/06/introducing-update-uri-theme-header-in-wordpress-6-1/embed/#?secret=qitshxDkLe#?secret=kTK0wJfy87\" data-secret=\"kTK0wJfy87\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zexxXNky1n\"><a href=\"https://make.wordpress.org/core/2022/10/04/block-based-template-parts-in-traditional-themes/\">Block-based &#8220;template parts&#8221; in traditional themes</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Block-based &#8220;template parts&#8221; in traditional themes&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/04/block-based-template-parts-in-traditional-themes/embed/#?secret=jGN0kLdfpO#?secret=zexxXNky1n\" data-secret=\"zexxXNky1n\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"WzczIz4yg6\"><a href=\"https://make.wordpress.org/core/2022/10/03/fluid-font-sizes-in-wordpress-6-1/\">Fluid font sizes in WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Fluid font sizes in WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/03/fluid-font-sizes-in-wordpress-6-1/embed/#?secret=SLMWQp7RNK#?secret=WzczIz4yg6\" data-secret=\"WzczIz4yg6\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"z0vYQmLM5z\"><a href=\"https://make.wordpress.org/core/2022/09/27/navigation-block-fallback-behavior-in-wp-6-1-dev-note/\">Navigation Block Fallback Behavior in WP 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Navigation Block Fallback Behavior in WP 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/09/27/navigation-block-fallback-behavior-in-wp-6-1-dev-note/embed/#?secret=tx4090NC9A#?secret=z0vYQmLM5z\" data-secret=\"z0vYQmLM5z\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"GWWtPp4NS7\"><a href=\"https://make.wordpress.org/core/2022/10/10/styling-elements-in-block-themes/\">Styling elements in block themes</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Styling elements in block themes&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/10/styling-elements-in-block-themes/embed/#?secret=DNb1wiOY5K#?secret=GWWtPp4NS7\" data-secret=\"GWWtPp4NS7\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"iGV1yvHNkk\"><a href=\"https://make.wordpress.org/core/2022/10/10/updated-editor-layout-support-in-6-1-after-refactor/\">Updated editor layout support in 6.1 after refactor</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Updated editor layout support in 6.1 after refactor&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/10/updated-editor-layout-support-in-6-1-after-refactor/embed/#?secret=ldKH3CQjOT#?secret=iGV1yvHNkk\" data-secret=\"iGV1yvHNkk\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"90Yib2AXch\"><a href=\"https://make.wordpress.org/core/2022/10/10/filters-for-theme-json-data/\">Filters for theme.json data</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Filters for theme.json data&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/10/filters-for-theme-json-data/embed/#?secret=5Qfg0Q38Dk#?secret=90Yib2AXch\" data-secret=\"90Yib2AXch\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"PrZ6RePCEE\"><a href=\"https://make.wordpress.org/core/2022/10/07/introduction-of-presets-across-padding-margin-and-block-gap/\">Introduction of presets across padding, margin and block gap</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Introduction of presets across padding, margin and block gap&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/07/introduction-of-presets-across-padding-margin-and-block-gap/embed/#?secret=9fmr75XcT7#?secret=PrZ6RePCEE\" data-secret=\"PrZ6RePCEE\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Twenty Twenty-Three, le nouveau thème natif</h2>\n\n\n\n<p><em>Twenty Twenty-Three</em>&nbsp;est le nouveau thème par défaut de WordPress.</p>\n\n\n\n<p>Comme son prédécesseur, il exploite à 100&nbsp;% les fonctionnalités de l’éditeur de site. Il va même beaucoup plus loin en intégrant nativement 10 variations de styles permettant de modifier complètement l’interface depuis l’administration.</p>\n\n\n\n<p>Ces 10 variations de styles ont été sélectionnées à l’aide d’un appel à contribution. L’objectif est de montrer par l’exemple comment se comportent les nouvelles fonctionnalités de l’éditeur de site, et notamment comment exploiter le fichier&nbsp;<code>theme.json</code>.</p>\n\n\n\n<p>Vous trouverez ci-dessous une vidéo balayant les 10 variations de styles de ce thème.</p>\n\n\n\n<figure class=\"wp-block-video\"><video controls src=\"https://make.wordpress.org/design/files/2022/09/tt3_variations.mp4\"></video></figure>\n\n\n\n<p>Comme d’habitude, ce thème natif a été développé sur GitHub (où vous retrouverez l’historique du projet) puis intégré au cœur de WordPress pendant la phase de développement de la version 6.1.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Autres améliorations</h2>\n\n\n\n<h3 class=\"wp-block-heading\">API REST</h3>\n\n\n\n<p>L’API REST a vu l’arrivée d’améliorations concernant le point de terminaison&nbsp;<code>/search</code>&nbsp;ainsi que de l’affichage des réponses JSON pouvant être controlées via le filtre&nbsp;<code>rest_json_encode_options</code>. Toutes les améliorations de l’API sont décrites dans la note de développement suivante&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"wqhN6S07e4\"><a href=\"https://make.wordpress.org/core/2022/10/11/miscellaneous-rest-api-improvements-in-wordpress-6-1/\">Miscellaneous REST API improvements in WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Miscellaneous REST API improvements in WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/11/miscellaneous-rest-api-improvements-in-wordpress-6-1/embed/#?secret=99O3BHkhq9#?secret=wqhN6S07e4\" data-secret=\"wqhN6S07e4\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Page de connexion</h3>\n\n\n\n<p>Une nouvelle fonction attendue depuis plus de 10 ans a fait son entrée dans la boîte à outils des développeuses et développeurs&nbsp;:&nbsp;<code>is_login()</code>&nbsp;permet de déterminer si l’on se trouve sur la page de connexion ou non.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"T8g55XKRps\"><a href=\"https://make.wordpress.org/core/2022/09/11/new-is_login-function-for-determining-if-a-page-is-the-login-screen/\">New is_login() function for determining if a page is the login screen</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;New is_login() function for determining if a page is the login screen&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/09/11/new-is_login-function-for-determining-if-a-page-is-the-login-screen/embed/#?secret=JQ3aBVlXl1#?secret=T8g55XKRps\" data-secret=\"T8g55XKRps\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Tableaux de listes de l’admin</h3>\n\n\n\n<p>Une nouvelle méthode fait son apparition, afin de pouvoir interagir et filtrer plus facilement les liens de visualisation présents dans ces tableaux.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"at2b0OL7mT\"><a href=\"https://make.wordpress.org/core/2022/10/09/introducing-wp_list_tableget_views_links-in-wordpress-6-1/\">Introducing WP_List_Table::get_views_links() in WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Introducing WP_List_Table::get_views_links() in WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/09/introducing-wp_list_tableget_views_links-in-wordpress-6-1/embed/#?secret=iitc3BtHzA#?secret=at2b0OL7mT\" data-secret=\"at2b0OL7mT\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Médias</h3>\n\n\n\n<p>Avec la version 5.8, nous avons accueilli&nbsp;<a href=\"https://make.wordpress.org/core/2021/06/07/wordpress-5-8-adds-webp-support/\">la prise en charge du format WebP</a>&nbsp;et nous prévoyions initialement d’intégrer la génération automatique et par défaut d’images dans ce format dans WordPress 6.1, mais le&nbsp;<em>commit</em>&nbsp;associé a finalement été&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/54226\">annulé</a>&nbsp;avec la&nbsp;<a href=\"https://make.wordpress.org/core/2022/09/11/webp-in-core-for-6-1/\">recommandation</a>&nbsp;de plutôt intégrer cette fonctionnalité dans une&nbsp;<a href=\"https://make.wordpress.org/core/2022/09/11/canonical-plugins-revisited/\">extension canonique</a>.</p>\n\n\n\n<p>En revanche, la propriété&nbsp;<code>muted</code>&nbsp;est maintenant disponible pour les vidéos insérées dans l’éditeur, ce qui permet de rendre silencieuse les vidéos ayant vocation à être lancées automatiquement (propriété&nbsp;<code>autoplay</code>). Ceci est obligatoire pour les vidéos automatiques.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Autres changements techniques</h3>\n\n\n\n<p>WordPress 6.1 introduit de nombreuses nouvelles fonctions et crochets d’action ou filtres. Ces changements sont détaillés dans la note de développement suivante&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"eKrGcN1LRi\"><a href=\"https://make.wordpress.org/core/2022/10/11/miscellaneous-core-changes-for-wordpress-6-1/\">Miscellaneous Core changes for WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Miscellaneous Core changes for WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/11/miscellaneous-core-changes-for-wordpress-6-1/embed/#?secret=wygMCG7gVe#?secret=eKrGcN1LRi\" data-secret=\"eKrGcN1LRi\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p>En plus de tous ces changements, on notera les évolutions suivantes, triées par composant du cœur WP&nbsp;:</p>\n\n\n\n<ul>\n<li><strong>Mots de passe d’applications :</strong>&nbsp;les super&nbsp;admins peuvent mettre en place un mot de passe d’application sur un site auquel ils n’ont pas été rattachés (<a href=\"https://core.trac.wordpress.org/ticket/53224\">#53224</a>)</li>\n\n\n\n<li><strong>Sauvegardes automatiques :</strong>&nbsp;les utilisateur·ices ayant un blocage via la fonctionnalité&nbsp;<code>post lock</code>&nbsp;pouvaient auparavant tricher en surchargeant les modifications via les sauvegardes automatiques&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/55659\">#55659</a>)</li>\n\n\n\n<li><strong>API de gestion du cache&nbsp;:&nbsp;</strong>ajout des fonctions&nbsp;<code>wp_cache_flush_group</code>&nbsp;et&nbsp;<code>wp_cache_supports</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/4476\">#4476</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56605\">#56605</a>)</li>\n\n\n\n<li><strong>Charset&nbsp;:</strong>&nbsp;ajout de l’échappement des caractères unicode NFD dans&nbsp;<code>remove_accents()</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/35951\">#35951</a>)</li>\n\n\n\n<li><strong>API Cron :</strong>&nbsp;ajout de la journalisation des erreurs et de crochets associés dans&nbsp;<code>wp-cron.php</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/56048\">#56048</a>)</li>\n\n\n\n<li><strong>Éditeur&nbsp;:</strong>&nbsp;clarification du fait que&nbsp;<code>get_page_template()</code>&nbsp;ne fonctionne pas sur les thèmes basés sur des blocs&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/56394\">#56394</a>)</li>\n\n\n\n<li><strong>Compositions de blocs :</strong>&nbsp;ajout d’une catégorie «&nbsp;Pieds de page&nbsp;»&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/56416\">#56416</a>)</li>\n\n\n\n<li><strong>Bibliothèque tierces :</strong>\n<ul>\n<li>Correction sur Thickbox pour la prise en charge des images WebP&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/55786\">#55786</a></li>\n\n\n\n<li>Mise à jour de PHPMailer à la version 6.6.4&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/55976\">#55976</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56016\">#56016</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56413\">#56413</a></li>\n\n\n\n<li>Mise à jour de Underscore à la version 6.1&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56030\">#56030</a></li>\n\n\n\n<li>Mise à jour de Moment à la version 6.1&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56031\">#56031</a></li>\n\n\n\n<li>Mise à jour de jQuery&nbsp;UI à la version 6.1&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56239\">#56239</a></li>\n\n\n\n<li>Mise à jour de mediaelement.js à la version 4.2.17&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56319\">#56319</a></li>\n\n\n\n<li>Mise à jour de jQuery à la version 3.6.1&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56451\">#56451</a></li>\n\n\n\n<li>Mise à jour de Sodium Compat à la version 1.19.0&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56564\">#56564</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56653\">#56653</a></li>\n\n\n\n<li>Mise à jour de GetID3 à la version 1.9.22&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56692\">#56692</a></li>\n</ul>\n</li>\n\n\n\n<li><strong>Formatage :</strong>\n<ul>\n<li>Suppression des accents combinés dans&nbsp;<code>remove_accents()</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/24661\">#24661</a></li>\n\n\n\n<li>Inversement de l’encapsulation de&nbsp;<code>sanitize_url()</code>&nbsp;et&nbsp;<code>esc_url_raw()</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/55852\">#55852</a></li>\n\n\n\n<li>Correction de la valeur retournée par&nbsp;<code>safecss_filter_attr()</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/55966\">#55966</a></li>\n\n\n\n<li>Autorisation de l’utilisation de propriétés CSS spécifiques à la mise en page dans le filtre&nbsp;<code>safe_style_css</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56122\">#56122</a></li>\n\n\n\n<li>Autorisation de l’utilisation de variables CSS dans&nbsp;<code>safecss_filter_attr</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56353\">#56353</a></li>\n</ul>\n</li>\n\n\n\n<li><strong>Général :</strong>\n<ul>\n<li>Mise à jour de&nbsp;<code>is_serialized</code>&nbsp;pour accepter les Enums&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/53299\">#53299</a></li>\n\n\n\n<li>Remplacement des appels à&nbsp;<code>phpversion()</code>&nbsp;par la constante PHP_VERSION&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/55680\">#55680</a></li>\n\n\n\n<li>Suppression des doublons d’utilisation de&nbsp;<code>realpath()</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56636\">#56636</a></li>\n\n\n\n<li>Suppression des doublons d’utilisation de&nbsp;<code>file_get_contents</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56637\">#56637</a></li>\n\n\n\n<li>Suppression des appels à&nbsp;<code>file_exists()</code>&nbsp;sur les variables utilisant&nbsp;<code>realpath()</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56654\">#56654</a></li>\n\n\n\n<li>Suppression des doublons d’utilisation de&nbsp;<code>get_theme_file_path</code>&nbsp;dans&nbsp;<code>register_block_style_handle</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56666\">#56666</a></li>\n\n\n\n<li>Correction du retour obtenu en utilisant&nbsp;<code>wp_rand( 0, 0)</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/55194\">#55194</a></li>\n</ul>\n</li>\n\n\n\n<li><strong>Internationalisation :</strong>&nbsp;correction d’un bug conduisant&nbsp;<code>switch_to_locale()</code>&nbsp;à annuler le chargement des traductions des thèmes et des extensions&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/39210\">#39210</a></li>\n\n\n\n<li><strong>Page de connexion/inscription :</strong>\n<ul>\n<li>Les champs obligatoires de la page d’inscription sur les multisites n’avaient pas d’attribut&nbsp;<code>required</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/54344\">#54344</a></li>\n\n\n\n<li>Ajout de description ARIA sur les champs d’erreur de connexion&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/54483\">#54483</a></li>\n</ul>\n</li>\n\n\n\n<li><strong>Médias :</strong>&nbsp;correction d’un bug sur l’interprétation de l’orientation des images via leurs données EXIF&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/54937\">#54937</a></li>\n\n\n\n<li><strong>Multisite :</strong>\n<ul>\n<li>Suppression complète des termes globaux <a href=\"https://core.trac.wordpress.org/ticket/21734\">#21734</a></li>\n\n\n\n<li>Utilisation de l’API&nbsp;des métadonnées pour les options du réseau <a href=\"https://core.trac.wordpress.org/ticket/37181\">#37181</a></li>\n\n\n\n<li>Stockage de l&rsquo;ID du site principal dans les options du réseau multisite <a href=\"https://core.trac.wordpress.org/ticket/55802\">#55802</a></li>\n</ul>\n</li>\n\n\n\n<li><strong>Chargement des scripts :</strong> mise en place des scripts en front-end via&nbsp;<code>viewScript</code> pour les blocs dynamiques <a href=\"https://core.trac.wordpress.org/ticket/56470\">#56470</a></li>\n\n\n\n<li><strong>Publications :</strong> correction de la vérification des publications non existantes dans&nbsp;<code>get_post_permalink()</code> <a href=\"https://core.trac.wordpress.org/ticket/45329\">#45329</a></li>\n\n\n\n<li><strong>Taxonomies :</strong>\n<ul>\n<li>Dans <code>wp_insert_term</code>, passage de <code>$args</code> en tant que paramètre additionnel pour les actions d’après-insertion (<code>create_term</code>, <code>created_term</code>, etc.)&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/55441\">#55441</a></li>\n\n\n\n<li>Les liens d&rsquo;archives de catégories n&rsquo;incluent plus par défaut la description dans l&rsquo;attribut  <code>title</code> du lien&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/55530\">#55530</a></li>\n\n\n\n<li>Les champs des termes sont maintenant associés avec leurs description dans l&rsquo;admin&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/55651\">#55651</a></li>\n</ul>\n</li>\n\n\n\n<li><strong>Mises à jour :</strong>\n<ul>\n<li>Ajout d&rsquo;un suivi de l&rsquo;usage des modules PHP installés sur les sites WP&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/48116\">#48116</a></li>\n</ul>\n</li>\n\n\n\n<li><strong>Widgets :</strong>\n<ul>\n<li>Suppression de requêtes inutiles vers la base de données&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/54677\">#54677</a></li>\n</ul>\n</li>\n</ul>\n\n\n\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p>Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements. Vous pouvez utiliser&nbsp;<a rel=\"noreferrer noopener\" href=\"https://wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\">l’extension Beta Tester</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec WordPress 6.1&nbsp;RC&nbsp;1.&nbsp;Nous comptons sur vous pour vous assurer que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p style=\"font-size:13px\">Ce guide en français a été rédigé par <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a> avec l’aide de <a href=\"https://profiles.wordpress.org/fxbenard\">FX Bénard</a> et <a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://fr.wordpress.org/2022/10/12/guide-des-changements-techniques-de-wordpress-6-1/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"Arrêt définitif des mises à jour de sécurité pour les versions de WordPress 3.7 à 4.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:122:\"https://fr.wordpress.org/2022/09/07/arret-definitif-des-mises-a-jour-de-securite-pour-les-versions-de-wordpress-3-7-a-4-0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"https://fr.wordpress.org/2022/09/07/arret-definitif-des-mises-a-jour-de-securite-pour-les-versions-de-wordpress-3-7-a-4-0/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Sep 2022 13:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"WordPress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2445\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:147:\"À partir du 1er décembre 2022, l\'équipe de sécurité de WordPress ne fournira plus de mises à jour de sécurité pour les versions 3.7 à 4.0.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4398:\"\n<p>Jusqu&rsquo;à présent, l&rsquo;équipe de sécurité de WordPress proposait des correctifs de sécurité pour toutes les versions de WordPress reposant sur les versions 3.7 à la version actuelle (6.0, sachant que WordPress&nbsp;6.1 sortira cet automne). Cela faisait donc un grand nombre de versions à maintenir, alors qu&rsquo;elles ne représentent qu&rsquo;un nombre très minoritaire de sites (les statistiques sont disponibles publiquement <a href=\"https://fr.wordpress.org/about/stats/\">sur cette page</a>).</p>\n\n\n\n<p>À partir du 1<sup>er</sup> décembre 2022, l&rsquo;équipe dédiée à la sécurité de WordPress ne fournira plus de mises à jour de sécurité pour les versions 3.7 à 4.0.</p>\n\n\n\n<span id=\"more-2445\"></span>\n\n\n\n<p>Ces versions datant maintenant de 8 ans ou plus, il y a peu de chances que votre site soit concerné, mais vous pouvez vous en assurer en vous connectant à votre tableau de bord et en vérifiant la version de WordPress indiquée dans l’encart «&nbsp;D&rsquo;un coup d&rsquo;œil&nbsp;» (sur les versions les plus anciennes, cet encart est intitulé «&nbsp;Aujourd’hui&nbsp;»).</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2022/09/widget-wordpress-duncoupdoeil.png\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"300\" src=\"https://fr.wordpress.org/files/2022/09/widget-wordpress-duncoupdoeil-1024x300.png\" alt=\"\" class=\"wp-image-2448\" srcset=\"https://fr.wordpress.org/files/2022/09/widget-wordpress-duncoupdoeil-1024x300.png 1024w, https://fr.wordpress.org/files/2022/09/widget-wordpress-duncoupdoeil-300x88.png 300w, https://fr.wordpress.org/files/2022/09/widget-wordpress-duncoupdoeil-768x225.png 768w, https://fr.wordpress.org/files/2022/09/widget-wordpress-duncoupdoeil.png 1132w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Dans le cas où vous disposeriez d&rsquo;une installation tournant sur WordPress 4.0 ou inférieur, vous devrez faire une mise à jour vers une version plus récente (nous recommandons la dernière version disponible) afin de garder votre site sécurisé. Consultez notre <a href=\"https://fr.wordpress.org/support/article/updating-wordpress/\">documentation sur la mise à niveau de votre site WordPress</a> pour plus d&rsquo;informations.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2022/09/maj-wordpress-tableau-de-bord.png\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"564\" src=\"https://fr.wordpress.org/files/2022/09/maj-wordpress-tableau-de-bord-1024x564.png\" alt=\"\" class=\"wp-image-2452\" srcset=\"https://fr.wordpress.org/files/2022/09/maj-wordpress-tableau-de-bord-1024x564.png 1024w, https://fr.wordpress.org/files/2022/09/maj-wordpress-tableau-de-bord-300x165.png 300w, https://fr.wordpress.org/files/2022/09/maj-wordpress-tableau-de-bord-768x423.png 768w, https://fr.wordpress.org/files/2022/09/maj-wordpress-tableau-de-bord-1536x846.png 1536w, https://fr.wordpress.org/files/2022/09/maj-wordpress-tableau-de-bord-2048x1128.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Dans tous les cas, il est important de noter que <strong>la seule version de WordPress activement maintenue est la version courante</strong> (à ce jour, la version 6.0). Les versions plus anciennes ne font que bénéficier de correctifs de sécurité et ne reçoivent généralement aucun correctif de bug.</p>\n\n\n\n<p>Dans les prochains mois, l&rsquo;arrêt du support d&rsquo;un nouveau groupe d’anciennes versions de WordPress sera annoncé, selon un calendrier qui est en cours d&rsquo;élaboration au sein de l&rsquo;équipe de sécurité de WP.</p>\n\n\n\n<p>Pour plus d&rsquo;informations sur le processus d&rsquo;arrêt du support des anciennes versions de WordPress, vous pouvez consulter <a href=\"https://make.wordpress.org/security/?p=73\">cet article de l&rsquo;équipe de sécurité de WordPress (en anglais)</a>.</p>\n\n\n\n<p class=\"has-small-font-size\"><em>Article publié par <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a> de l&rsquo;équipe de sécurité de WP. Merci aux co-responsables du site fr.wordpress.org <a href=\"https://profiles.wordpress.org/wolforg/\">Didier Demory</a>, <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> et <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Bénard</a> pour la relecture.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"https://fr.wordpress.org/2022/09/07/arret-definitif-des-mises-a-jour-de-securite-pour-les-versions-de-wordpress-3-7-a-4-0/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"WordPress 6.0 « Arturo »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://fr.wordpress.org/2022/05/25/wordpress-6-0-arturo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://fr.wordpress.org/2022/05/25/wordpress-6-0-arturo/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 May 2022 06:16:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2400\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:376:\"Bienvenue sur WordPress 6.0 «&#160;Arturo&#160;» Nous vous souhaitons la bienvenue sur WordPress 6.0, version inspirée par le musicien de jazz Arturo O’Farrill. Célèbre pour son influence sur le jazz latino contemporain, Arturo a publié plus de 15 albums sur 50 ans de carrière. Prenez le temps d’explorer WordPress 6.0. Cette version a été conçue afin [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:54838:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2022/05/Main-image-News-post.png\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"694\" src=\"https://fr.wordpress.org/files/2022/05/Main-image-News-post-1024x694.png\" alt=\"\" class=\"wp-image-2401\" srcset=\"https://fr.wordpress.org/files/2022/05/Main-image-News-post-1024x694.png 1024w, https://fr.wordpress.org/files/2022/05/Main-image-News-post-300x203.png 300w, https://fr.wordpress.org/files/2022/05/Main-image-News-post-768x521.png 768w, https://fr.wordpress.org/files/2022/05/Main-image-News-post-1536x1042.png 1536w, https://fr.wordpress.org/files/2022/05/Main-image-News-post-2048x1389.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue sur WordPress 6.0 «&nbsp;Arturo&nbsp;»</h2>\n\n\n\n<p>Nous vous souhaitons la bienvenue sur WordPress 6.0, version inspirée par le musicien de jazz <a href=\"https://en.wikipedia.org/wiki/Arturo_O\'Farrill\">Arturo O’Farrill</a>. Célèbre pour son influence sur le jazz latino contemporain, Arturo a publié plus de 15 albums sur 50 ans de carrière.</p>\n\n\n\n<p>Prenez le temps d’explorer WordPress 6.0. Cette version a été conçue afin de vous aider à développer votre inspiration créative et pour rendre l’expérience éditoriale encore plus intuitive. Pendant que vous découvrez les nouveautés de cette version, n’hésitez pas à lancer une liste de lecture comprenant les meilleures chansons d’Arturo&nbsp;!</p>\n\n\n\n<p>Avec presque 1 000 améliorations et corrections, la deuxième version majeure de l’année 2022 est là. <a href=\"https://fr.wordpress.org/latest-fr_FR.zip\">Cliquez ici pour télécharger WordPress 6.0 !</a></p>\n\n\n\n<span id=\"more-2400\"></span>\n\n\n\n<p>Les propriétaires de sites devraient mettre à jour leurs installations WordPress afin de profiter des avantages de sa stabilité, de ses améliorations de performances, et de ses améliorations en terme d&rsquo;ergonomie. Les personnes créant du contenu avec WordPress apprécieront toutes les nouvelles fonctionnalités améliorant l&rsquo;expérience éditoriale et de mise en page.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/latest-fr_FR.zip\">Télécharger WordPress 6.0 en français – ZIP 22,5 Mo </a></div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Le contenu de WordPress 6.0</h3>\n\n\n\n<p>Pour en savoir plus sur le contenu technique de la version, lisez <a href=\"https://fr.wordpress.org/2022/05/04/guide-des-changements-techniques-de-wordpress-6-0/\" data-type=\"post\" data-id=\"2369\">le guide que nous avons publié il y a quelques semaines</a>.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/05/Writing-Improvements-1.png?fit=1204%2C700&amp;ssl=1\" alt=\"Selecting multiple lines of text from two blocks\" class=\"wp-image-12887\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading\">Une expérience d’édition améliorée</h4>\n\n\n\n<p>Les améliorations éditoriales ne manquent pas, que vous écriviez un tout nouvel article ou que vous ajoutiez des éléments à une page existante. Explorez les façons d’améliorer votre processus de création de contenu avec&nbsp;:</p>\n\n\n\n<ul>\n<li>Sélectionnez du texte à cheval sur plusieurs blocs pour le modifier en une seule fois.</li>\n\n\n\n<li>Saisissez deux crochets ouvrants&nbsp;<code>[[</code>&nbsp;pour accéder rapidement au gestionnaire de liens.</li>\n\n\n\n<li>Conservez les styles existants lorsque vous transformez des blocs d’un certain type en un autre type de bloc, par exemple lorsque vous transformez un bloc paragraphe en un bloc code.</li>\n\n\n\n<li>Créez des boutons personnalisés et tous les nouveaux boutons que vous créerez par la suite conserveront automatiquement ces styles personnalisés.</li>\n\n\n\n<li>Rendez les nuages d’étiquettes et les icônes de réseaux sociaux encore plus attrayants avec leurs nouveaux réglages. Un nouveau style de contour est aussi disponible pour le nuage d’étiquettes.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/05/Style-switcher-big.gif?fit=1204%2C700&amp;ssl=1\" alt=\"Style variations of Twenty Twenty Two theme\" class=\"wp-image-12893\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading\">Changements de styles</h4>\n\n\n\n<p>Les thèmes basés sur des blocs permettent désormais de multiples variations de style. Cela étend le nouveau système de gestion des styles et ajoute des raccourcis permettant de changer l’affichage de votre site avec un seul et même thème. Vous pouvez modifier les réglages disponibles, tels que la graisse de la police et autres options de mise en forme comme la palette de couleurs disponible par défaut. Vous pouvez modifier le rendu de votre site en quelques clics seulement.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/05/Expanded-templates.png?fit=1204%2C700&amp;ssl=1\" alt=\"Popover listing available templates\" class=\"wp-image-12889\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading\">Plus de choix de modèles</h4>\n\n\n\n<p>WordPress 6.0 inclut cinq nouveaux modèles pour les thèmes basés sur des blocs&nbsp;: auteur/autrice, date, catégorie, étiquette et taxonomie. Ces modèles additionnels offrent encore plus de flexibilité pour créer du contenu. Adaptez-les avec les outils que vous connaissez déjà ou bien en utilisant les nouvelles fonctionnalités de cette version&nbsp;:</p>\n\n\n\n<ul>\n<li>Les images mises en avant peuvent être utilisées dans le bloc bannière.</li>\n\n\n\n<li>Les nouveaux contrôles de la taille des images mises en avant vous permettent d’obtenir exactement ce que vous souhaitez.</li>\n\n\n\n<li>Lorsque vous modifiez un modèle, l’outil d’insertion rapide vous affiche les compositions et les éléments de modèles qui vous aideront à travailler plus rapidement et à découvrir de nouvelles options de mise en page.</li>\n\n\n\n<li>Le bloc Boucle de requête prend en charge le filtrage en fonction de multiples auteurs ou autrices, en fonction de taxonomies personnalisées, ainsi que la personnalisation de ce qui est affiché lorsqu’aucune publication n’est trouvée.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i1.wp.com/wordpress.org/news/files/2022/05/Integrated-Patterns.png?fit=1204%2C700&amp;ssl=1\" alt=\"Browsing footer patterns in the quick inserter\" class=\"wp-image-12890\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading\">Compositions intégrées</h4>\n\n\n\n<p>Les compositions s’affichent désormais là où vous en avez besoin, comme dans l’outil d’insertion rapide ou lors de la création d’un nouvel en-tête ou pied de page. Si vous créez des thèmes basés sur des blocs, vous pouvez même&nbsp;<a href=\"https://make.wordpress.org/core/2022/05/02/new-features-for-working-with-patterns-and-themes-in-wordpress-6-0/\">déclarer des compositions provenant du répertoire de compositions via le fichier&nbsp;<code>theme.json</code></a>, ce qui vous permet de prioriser les compositions qui vous semblent les plus utiles pour les personnes utilisant votre thème.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Une vue en liste améliorée</h4>\n\n\n\n<p>De nouveaux raccourcis clavier vous permettent de sélectionner plusieurs blocs dans la vue en liste, de les modifier en une fois et de les glisser-déposer dans la liste. La vue en liste peut maintenant être ouverte et fermée plus facilement. Au départ, elle est en affichage réduit puis elle s’étend automatiquement à la sélection actuelle lorsque que vous sélectionnez un bloc.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Verrouillage des blocs</h4>\n\n\n\n<p>Vous pouvez dorénavant verrouiller vos blocs, ce qui permet de désactiver la possibilité de les déplacer ou de les retirer. Cela facilite la gestion de projet pour les pros, en permettant à leurs clientèle d’exprimer leur créativité au sein d’un cadre limitant les risques de casser leur site.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i1.wp.com/wordpress.org/news/files/2022/05/Block-Locking-Controls.png?fit=1204%2C700&amp;ssl=1\" alt=\"Unlocking the block in the block toolbar\" class=\"wp-image-12892\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">De nouveaux outils de design</h3>\n\n\n\n<p>Les outils de design deviennent plus puissants et intuitifs à chaque nouvelle version.<br>Parmi les principaux changements de la version 6.0, on trouvera&nbsp;:</p>\n\n\n\n<ul>\n<li>Un nouveau panneau de gestion des couleurs qui économise de la place sur l’éditeur, tout en montrant toutes les options en un coup d’œil.</li>\n\n\n\n<li>Les nouveaux contrôles des bordures offrent une façon plus simple de définir les bordures de vos conteneurs.</li>\n\n\n\n<li>Les niveaux de transparence vous permettent des choix colorimétriques encore plus créatifs.</li>\n\n\n\n<li>Contrôlez les espacements, les marges ou la typographie de vos blocs en une fois via le bloc groupe.</li>\n\n\n\n<li>Basculez entre les variations «&nbsp;empilé&nbsp;», «&nbsp;en ligne&nbsp;» ou «&nbsp;groupé&nbsp;» pour positionner des groupes de blocs avec une plus grande flexibilité de mise en page.</li>\n\n\n\n<li>Utilisez la fonctionnalité de gestion des espacements du bloc galerie pour créer toute une variété de mises en page en faisant varier l’espacement entre les images, ou tout simplement en le supprimant.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/05/List-view.png?fit=1204%2C700&amp;ssl=1\" alt=\"Selecting multiple blocks in the list view\" class=\"wp-image-12891\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">De meilleures performances</h3>\n\n\n\n<p>Cette version comprend plusieurs améliorations des performances de WordPress. Elles portent sur le chargement des publications, la réduction du temps d’exécution des requêtes, la mise en cache, le chargement des menus de navigation et bien plus encore. Notre équipe dédiée aux performances travaille au quotidien pour améliorer l&rsquo;expérience d&rsquo;utilisation de votre site WordPress.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Une meilleure accessibilité</h3>\n\n\n\n<p>Rendre le web plus accessible fait partie des missions du CMS WordPress. Cette nouvelle version comprend plus de 50 améliorations de l’accessibilité de WP.</p>\n\n\n\n<h2 class=\"wp-block-heading\">En savoir plus sur WordPress 6.0</h2>\n\n\n\n<p>Découvrez WordPress 6.0 en action&nbsp;! Notre&nbsp;<a href=\"https://www.youtube.com/watch?v=oe452WcY7fA\">vidéo de présentation</a>&nbsp;propose une vue d’ensemble des principales fonctionnalités qui sont arrivées avec WordPress 6.0.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" class=\"youtube-player\" width=\"612\" height=\"345\" src=\"https://www.youtube.com/embed/oe452WcY7fA?version=3&#038;rel=1&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;fs=1&#038;hl=fr-FR&#038;autohide=2&#038;wmode=transparent\" allowfullscreen=\"true\" style=\"border:0;\" sandbox=\"allow-scripts allow-same-origin allow-popups allow-presentation\"></iframe>\n</div></figure>\n\n\n\n<p>Nous invitons les développeurs et développeuses à explorer <a href=\"https://make.wordpress.org/core/2022/05/03/wordpress-6-0-field-guide/\">le guide de changements techniques de WordPress&nbsp;6.0</a>.</p>\n\n\n\n<p>N’hésitez aussi pas à lire le <a href=\"https://wordpress.org/support/wordpress-version/version-6-0/\">journal de version de WordPress 6.0</a> pour plus d&rsquo;informations sur les fichiers créés, modifiés et supprimés dans cette version.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WP 6.0</h2>\n\n\n\n<ul>\n<li>Directeur de la version&nbsp;: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a>&nbsp;</li>\n\n\n\n<li>Coordinateur·ice·s de la version&nbsp;: <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> et <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a></li>\n\n\n\n<li>Directeur technique Cœur&nbsp;: <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a></li>\n\n\n\n<li>Directeurs techniques Éditeur&nbsp;: <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> et <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a></li>\n\n\n\n<li>Responsables de projet Cœur&nbsp;: <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> et <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a></li>\n\n\n\n<li>Responsable de projet Éditeur&nbsp;: <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a></li>\n\n\n\n<li>Directeur·ice·s de la documentation&nbsp;: <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>, <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> et <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a></li>\n\n\n\n<li>Responsable de la communication&nbsp;: <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a></li>\n\n\n\n<li>Responsable des tests&nbsp;: <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> et <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a></li>\n\n\n\n<li>Responsable du design&nbsp;: <a href=\"https://profiles.wordpress.org/critterverse/\">Channing Ritter</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux plus de 500 contributeurs et contributrices&nbsp;!</h2>\n\n\n\n<p>La livraison de WordPress 6.0 n’aurait jamais été possible sans la participation de ces personnes provenant de plus de 58 pays différents&nbsp;!</p>\n\n\n\n<p><small><a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/abdullahramzan/\">Abdullah Ramzan</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zielinski</a> · <a href=\"https://profiles.wordpress.org/adi64bit/\">adi64bit</a> · <a href=\"https://profiles.wordpress.org/aadilali/\">Adil Ali</a> · <a href=\"https://profiles.wordpress.org/agepcom/\">agepcom</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanjacobmathew/\">Alan Jacob Mathew</a> · <a href=\"https://profiles.wordpress.org/alansyue/\">alansyue</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/albertomake/\">albertomake</a> · <a href=\"https://profiles.wordpress.org/alefesouza/\">Alefe Souza</a> · <a href=\"https://profiles.wordpress.org/alex897/\">Aleksandar Kostov</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/aliakseyenkaihar/\">aliakseyenkaihar</a> · <a href=\"https://profiles.wordpress.org/alkesh7/\">Alkesh Miyani</a> · <a href=\"https://profiles.wordpress.org/alokstha1/\">Alok Shrestha</a> · <a href=\"https://profiles.wordpress.org/shedonist/\">Amanda Giles</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/_smartik_/\">Andrei Surdu</a> · <a href=\"https://profiles.wordpress.org/aandrewdixon/\">Andrew Dixon</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey “Rarst” Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/la-geek/\">Angelika Reisiger</a> · <a href=\"https://profiles.wordpress.org/rilwis/\">Anh Tran</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/anoopranawat/\">Anoop Ranawat</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/paranoia1906/\">Anthony Ledesma</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antonrinas/\">antonrinas</a> · <a href=\"https://profiles.wordpress.org/arcangelini/\">arcangelini</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/arnee/\">Arne</a> · <a href=\"https://profiles.wordpress.org/arpitgshah/\">Arpit G Shah</a> · <a href=\"https://profiles.wordpress.org/artdecotech/\">artdecotech</a> · <a href=\"https://profiles.wordpress.org/madeinua/\">ArteMa</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/asaquzzaman/\">Asaquzzaman mishu</a> · <a href=\"https://profiles.wordpress.org/atomicjack/\">atomicjack</a> · <a href=\"https://profiles.wordpress.org/ajoah/\">Aurélien Joahny</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/barryhughes/\">Barry</a> · <a href=\"https://profiles.wordpress.org/barryceelen/\">Barry Ceelen</a> · <a href=\"https://profiles.wordpress.org/bartoszgadomski/\">Bartosz Gadomski</a> · <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/utz119/\">Benachi</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bettyjj/\">BettyJJ</a> · <a href=\"https://profiles.wordpress.org/bhrugesh12/\">Bhrugesh Bavishi</a> · <a href=\"https://profiles.wordpress.org/binarymoon/\">binarymoon</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/supercleanse/\">Blair Williams</a> · <a href=\"https://profiles.wordpress.org/blogaid/\">BlogAid</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/wpe_bdurette/\">Brandon DuRette</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bronsonquick/\">bronsonquick</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a> · <a href=\"https://profiles.wordpress.org/brookedot/\">Brooke.</a> · <a href=\"https://profiles.wordpress.org/ribaricplusplus/\">Bruno Ribaric</a> · <a href=\"https://profiles.wordpress.org/caraya/\">caraya</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos Garcia</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cbigler/\">cbigler</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/critterverse/\">Channing Ritter</a> · <a href=\"https://profiles.wordpress.org/charleyparkerdesign/\">charleyparkerdesign</a> · <a href=\"https://profiles.wordpress.org/charlyox/\">charlyox</a> · <a href=\"https://profiles.wordpress.org/chintan1896/\">Chintan hingrajiya</a> · <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloe Bringmann</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/clubkert/\">Chris Lubkert</a> · <a href=\"https://profiles.wordpress.org/chrisvanpatten/\">Chris Van Patten</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/clonemykey/\">clonemykey</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/conner_bw/\">conner_bw</a> · <a href=\"https://profiles.wordpress.org/cr0ybot/\">Cory Hughart</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/mitogh/\">Crisoforo Gaspar</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/htdat/\">Dat Hoang</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">Dave Smith</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dgwyer/\">David Gwyer</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/devutpol/\">Deb Nath Utpol</a> · <a href=\"https://profiles.wordpress.org/delowardev/\">Delowar Hossain</a> · <a href=\"https://profiles.wordpress.org/denishua/\">denishua</a> · <a href=\"https://profiles.wordpress.org/dennisatyoast/\">Dennis Claassen</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dhanendran/\">Dhanendran</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhusakovic/\">dhusakovic</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/donmhico/\">donmhico</a> · <a href=\"https://profiles.wordpress.org/drago239/\">drago239</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/dromero20/\">dromero20</a> · <a href=\"https://profiles.wordpress.org/eddystile/\">Eddy</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">ehtis</a> · <a href=\"https://profiles.wordpress.org/eliezerspp/\">Eliezer Peña</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/eric3d/\">eric3d</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik Betshammar</a> · <a href=\"https://profiles.wordpress.org/espiat/\">espiat</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/etaproducto/\">etaproducto</a> · <a href=\"https://profiles.wordpress.org/everpress/\">EverPress</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/iogui/\">Fabio Blanco</a> · <a href=\"https://profiles.wordpress.org/faison/\">Faison</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/femkreations/\">Femy Praseeth</a> · <a href=\"https://profiles.wordpress.org/florianbrinkmann/\">Florian Brinkmann</a> · <a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a> · <a href=\"https://profiles.wordpress.org/foliovision/\">FolioVision</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco Vera</a> · <a href=\"https://profiles.wordpress.org/frankei/\">frankei</a> · <a href=\"https://profiles.wordpress.org/furi3r/\">furi3r</a> · <a href=\"https://profiles.wordpress.org/gadhiyaravi/\">gadhiyaravi</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/voldemortensen/\">Garth Mortensen</a> · <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/genosseeinhorn/\">genosseeinhorn</a> · <a href=\"https://profiles.wordpress.org/revgeorge/\">George Hotelling</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/geriux/\">geriux</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/greglone/\">Grégory Viguier</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregoiresailland/\">gregoiresailland</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gumacahin/\">gumacahin</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">gvgvgvijayan</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman</a> · <a href=\"https://profiles.wordpress.org/hasnainashfaq/\">Hasnain Ashfaq</a> · <a href=\"https://profiles.wordpress.org/azhiyadev/\">Hauwa Abashiya</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/henrywright/\">Henry Wright</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/hitendra-chopda/\">Hitendra Chopda</a> · <a href=\"https://profiles.wordpress.org/hristok/\">HristoK</a> · <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/ianatkins/\">ianatkins</a> · <a href=\"https://profiles.wordpress.org/ianmjones/\">ianmjones</a> · <a href=\"https://profiles.wordpress.org/credo61/\">ImanGM</a> · <a href=\"https://profiles.wordpress.org/imokol/\">imokol</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/ishitaka/\">ishitaka</a> · <a href=\"https://profiles.wordpress.org/itsamoreh/\">itsamoreh</a> · <a href=\"https://profiles.wordpress.org/iulia-cazan/\">Iulia Cazan</a> · <a href=\"https://profiles.wordpress.org/ivanlutrov/\">Ivan Lutrov</a> · <a href=\"https://profiles.wordpress.org/jadpm/\">jadpm</a> · <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a> · <a href=\"https://profiles.wordpress.org/jakeparis/\">jakeparis</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/codente/\">Jamie</a> · <a href=\"https://profiles.wordpress.org/rumpel2116/\">Jan Weiss</a> · <a href=\"https://profiles.wordpress.org/janh2/\">janh2</a> · <a href=\"https://profiles.wordpress.org/jarretc/\">Jarret</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a> · <a href=\"https://profiles.wordpress.org/jprieton/\">Javier Prieto</a> · <a href=\"https://profiles.wordpress.org/grandeljay/\">Jay Trees</a> · <a href=\"https://profiles.wordpress.org/jazbek/\">jazbek</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jblz/\">Jeff Bowen</a> · <a href=\"https://profiles.wordpress.org/jeffmatson/\">Jeff Matson</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/miss_jwo/\">Jenny Wong</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeremyyip/\">Jeremy Yip</a> · <a href=\"https://profiles.wordpress.org/sausajez/\">Jez Emery</a> · <a href=\"https://profiles.wordpress.org/jhned/\">jhned</a> · <a href=\"https://profiles.wordpress.org/jhnstn/\">jhnstn</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">jigar bhanushali</a> · <a href=\"https://profiles.wordpress.org/jiteshdhamaniya/\">jiteshdhamaniya</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/goaroundagain/\">Johannes Kinast</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/johnwatkins0/\">John Watkins</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/jrchamp/\">Jonathan Champ</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonoaldersonwp/\">Jono Alderson</a> · <a href=\"https://profiles.wordpress.org/jorgecontreras/\">Jorge</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josearcos/\">José Arcos</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/jostnes/\">Josepha Dambul</a> · <a href=\"https://profiles.wordpress.org/joshf/\">Joshua Fredrickson</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrivett/\">jrivett</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">jsnajdr</a> · <a href=\"https://profiles.wordpress.org/juanlopez4691/\">juanlopez4691</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/junaidkbr/\">Junaid Ahmed</a> · <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a> · <a href=\"https://profiles.wordpress.org/justinbusa/\">Justin Busa</a> · <a href=\"https://profiles.wordpress.org/certainstrings/\">Justin Tucker</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a> · <a href=\"https://profiles.wordpress.org/kapacity/\">kapacity</a> · <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a> · <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">kbatdorf</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/w33zy/\">Kemory Grubb</a> · <a href=\"https://profiles.wordpress.org/gwwar/\">Kerry Liu</a> · <a href=\"https://profiles.wordpress.org/kprovance/\">Kev Provance</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/kirtan95/\">Kirtan Gajjar</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kmix39/\">KMix</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/konradyoast/\">Konrad.K</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/kpegoraro/\">kpegoraro</a> · <a href=\"https://profiles.wordpress.org/kubiq/\">kubiq</a> · <a href=\"https://profiles.wordpress.org/sainthkh/\">Kukhyeon Heo</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lenasterg/\">lenasterg</a> · <a href=\"https://profiles.wordpress.org/uzumymw/\">leskam</a> · <a href=\"https://profiles.wordpress.org/layotte/\">Lew Ayotte</a> · <a href=\"https://profiles.wordpress.org/linux4me2/\">linux4me2</a> · <a href=\"https://profiles.wordpress.org/lschuyler/\">Lisa Schuyler</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/louislaugesen/\">Louis</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/karpstrucking/\">Lucas Karpiuk</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/pyrobd/\">Lukman Nakib</a> · <a href=\"https://profiles.wordpress.org/michelangelovandam/\">M. van Dam</a> · <a href=\"https://profiles.wordpress.org/macbookandrew/\">macbookandrew</a> · <a href=\"https://profiles.wordpress.org/mashikag/\">Maciej</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/maguijo/\">maguijo</a> · <a href=\"https://profiles.wordpress.org/mhimon/\">Mahbub Hasan Imon</a> · <a href=\"https://profiles.wordpress.org/malthert/\">malthert</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/mkaz/\">Marcus Kazmierczak</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/mkox/\">Markus Kosmal</a> · <a href=\"https://profiles.wordpress.org/marv2/\">marv2</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mat-lipe/\">Mat Lipe</a> · <a href=\"https://profiles.wordpress.org/paapst/\">Mathieu</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">matiasbenedetto</a> · <a href=\"https://profiles.wordpress.org/mattchowning/\">Matt Chowning</a> · <a href=\"https://profiles.wordpress.org/sivel/\">Matt Martz</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/themattroyal/\">Matt Royal</a> · <a href=\"https://profiles.wordpress.org/mjstoney/\">Matt Stoney</a> · <a href=\"https://profiles.wordpress.org/mattwiebe/\">Matt Wiebe</a> · <a href=\"https://profiles.wordpress.org/mauriac/\">maur</a> · <a href=\"https://profiles.wordpress.org/azouamauriac/\">Mauriac AZOUA</a> · <a href=\"https://profiles.wordpress.org/maxkellermann/\">Max Kellermann</a> · <a href=\"https://profiles.wordpress.org/mehedi890/\">Mehedi Foysal</a> · <a href=\"https://profiles.wordpress.org/mgol/\">mgol</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/mauteri/\">Mike Auteri</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/miken32/\">miken32</a> · <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/multidots1896/\">Minal Diwan</a> · <a href=\"https://profiles.wordpress.org/mirkolofio/\">Mirco Babini</a> · <a href=\"https://profiles.wordpress.org/mmdeveloper/\">MMDeveloper</a> · <a href=\"https://profiles.wordpress.org/mohadeseghasemi/\">Mohadese Ghasemi</a> · <a href=\"https://profiles.wordpress.org/ahsan03/\">Mohammad Ahsan Habib</a> · <a href=\"https://profiles.wordpress.org/opurockey/\">Mohammad Rockeybul Alam</a> · <a href=\"https://profiles.wordpress.org/mjkhajeh/\">MohammadJafar Khajeh</a> · <a href=\"https://profiles.wordpress.org/mor10/\">Morten Rand-Hendriksen</a> · <a href=\"https://profiles.wordpress.org/moushik/\">moushik</a> · <a href=\"https://profiles.wordpress.org/computerguru/\">mqudsi</a> · <a href=\"https://profiles.wordpress.org/muhammadfaizanhaidar/\">Muhammad Faizan Haidar</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/amustaque97/\">Mustaque Ahmed</a> · <a href=\"https://profiles.wordpress.org/nabil_kadimi/\">Nabil</a> · <a href=\"https://profiles.wordpress.org/nagpai/\">Nagesh Pai – a11n</a> · <a href=\"https://profiles.wordpress.org/nalininonstopnewsuk/\">Nalini Thakor</a> · <a href=\"https://profiles.wordpress.org/nhadsall/\">Nathan</a> · <a href=\"https://profiles.wordpress.org/nayana123/\">Nayana Maradia</a> · <a href=\"https://profiles.wordpress.org/nextend_ramona/\">Nextend Support – Ramona</a> · <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a> · <a href=\"https://profiles.wordpress.org/nickciske/\">Nick Ciske</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/rahe/\">Nicolas Juen</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/knilkantha/\">Nil</a> · <a href=\"https://profiles.wordpress.org/nmschaller/\">nmschaller</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/oakesjosh/\">oakesjosh</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/opr18/\">opr18</a> · <a href=\"https://profiles.wordpress.org/otshelnik-fm/\">Otshelnik-Fm</a> · <a href=\"https://profiles.wordpress.org/overclokk/\">overclokk</a> · <a href=\"https://profiles.wordpress.org/ovidiul/\">ovidiul</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pls78/\">Paolo L. Scala</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/figureone/\">Paul Ryan</a> · <a href=\"https://profiles.wordpress.org/pschrottky/\">Paul Von Schrottky</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">paulkevan</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/malinevskiy/\">Pavlo</a> · <a href=\"https://profiles.wordpress.org/pbking/\">pbking</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a> · <a href=\"https://profiles.wordpress.org/petaryoast/\">Petar Ratković</a> · <a href=\"https://profiles.wordpress.org/psmits1567/\">Peter Smits</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petrosparaskevopoulos/\">petrosparaskevopoulos</a> · <a href=\"https://profiles.wordpress.org/walbo/\">Petter Walbø Johnsgård</a> · <a href=\"https://profiles.wordpress.org/pgpagely/\">pgpagely</a> · <a href=\"https://profiles.wordpress.org/johnstonphilip/\">Phil Johnston</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/pikamander2/\">pikamander2</a> · <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pravinparmar2404/\">Pravin Parmar</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a> · <a href=\"https://profiles.wordpress.org/priyank9033/\">Priyank</a> · <a href=\"https://profiles.wordpress.org/pypwalters/\">pypwalters</a> · <a href=\"https://profiles.wordpress.org/r-a-y/\">r-a-y</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/rafiahmedd/\">Rafi Ahmed</a> · <a href=\"https://profiles.wordpress.org/superpoincare/\">Ramanan</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/jontyravi/\">Ravi Vaghela</a> · <a href=\"https://profiles.wordpress.org/ravipatel/\">ravipatel</a> · <a href=\"https://profiles.wordpress.org/razvanonofrei/\">Razvan Onofrei</a> · <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/rianrietveld/\">Rian Rietveld</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/richybkreckel/\">Richard B. Kreckel</a> · <a href=\"https://profiles.wordpress.org/ricomoorman/\">ricomoorman</a> · <a href=\"https://profiles.wordpress.org/r0bsc0tt/\">Rob Scott</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/rolfsiebers/\">Rolf Siebers</a> · <a href=\"https://profiles.wordpress.org/costasovo/\">Rostislav Wolný</a> · <a href=\"https://profiles.wordpress.org/rufus87/\">Rufus87</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/bookdude13/\">Ryan Fredlund</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wrede</a> · <a href=\"https://profiles.wordpress.org/sabbir1991/\">Sabbir Ahmed</a> · <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a> · <a href=\"https://profiles.wordpress.org/samiff/\">Sami Falah</a> · <a href=\"https://profiles.wordpress.org/sanzeeb3/\">Sanjeev Aryal</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">santosguillamot</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/arasae/\">Sarah Snow</a> · <a href=\"https://profiles.wordpress.org/sarayourfriend/\">sarayourfriend</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiyamoorthy V</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/sbossarte/\">sbossarte</a> · <a href=\"https://profiles.wordpress.org/sclayf1/\">sclayf1</a> · <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/omaeyusuke/\">Segayuu</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sheepysheep60/\">sheepysheep60</a> · <a href=\"https://profiles.wordpress.org/shital-patel/\">Shital Marakana</a> · <a href=\"https://profiles.wordpress.org/shreyasikhar26/\">Shreyas Ikhar</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth</a> · <a href=\"https://profiles.wordpress.org/nomnom99/\">Siddharth Thevaril</a> · <a href=\"https://profiles.wordpress.org/silb3r/\">silb3r</a> · <a href=\"https://profiles.wordpress.org/lumpysimon/\">Simon Blackbourn</a> · <a href=\"https://profiles.wordpress.org/pross/\">Simon Prosser</a> · <a href=\"https://profiles.wordpress.org/simonhammes/\">simonhammes</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/smit08/\">Smit Rathod</a> · <a href=\"https://profiles.wordpress.org/snapfractalpop/\">snapfractalpop</a> · <a href=\"https://profiles.wordpress.org/socalchristina/\">socalchristina</a> · <a href=\"https://profiles.wordpress.org/spencercameron/\">Spencer Cameron-Morin</a> · <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a> · <a href=\"https://profiles.wordpress.org/stefanfisk/\">stefanfisk</a> · <a href=\"https://profiles.wordpress.org/satollo/\">Stefano Lissa</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/hypest/\">Stefanos Togoulidis</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephenharris/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/stevegrunwell/\">Steve Grunwell</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/5um17/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/csesumonpro/\">Sumon Sarker</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/sunyatasattva/\">sunyatasattva</a> · <a href=\"https://profiles.wordpress.org/mahype/\">Sven Wagener</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/tharsheblows/\">tharsheblows</a> · <a href=\"https://profiles.wordpress.org/legendusmaximus/\">Theo H</a> · <a href=\"https://profiles.wordpress.org/thimalw/\">Thimal Wickremage</a> · <a href=\"https://profiles.wordpress.org/twistermc/\">Thomas McMahon</a> · <a href=\"https://profiles.wordpress.org/thomasplevy/\">Thomas Patrick Levy</a> · <a href=\"https://profiles.wordpress.org/xiven/\">Thomas Pike</a> · <a href=\"https://profiles.wordpress.org/tillkruess/\">Till Krüss</a> · <a href=\"https://profiles.wordpress.org/waterfire/\">Tim Blankenship</a> · <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomjdevisser/\">Tom</a> · <a href=\"https://profiles.wordpress.org/tomasztunik/\">tomasztunik</a> · <a href=\"https://profiles.wordpress.org/tomalec/\">Tomek</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/ttahmouch/\">Tony Tahmouch</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/sierratr/\">Tracy</a> · <a href=\"https://profiles.wordpress.org/trex005/\">trex005</a> · <a href=\"https://profiles.wordpress.org/tszming/\">tszming</a> · <a href=\"https://profiles.wordpress.org/tumas2/\">tumas2</a> · <a href=\"https://profiles.wordpress.org/twstokes/\">twstokes</a> · <a href=\"https://profiles.wordpress.org/junsuijin/\">Tynan Beatty</a> · <a href=\"https://profiles.wordpress.org/tzipporahwitty/\">tzipporahwitty</a> · <a href=\"https://profiles.wordpress.org/uday17035/\">Uday Kokitkar</a> · <a href=\"https://profiles.wordpress.org/ugljanin/\">ugljanin</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/grapplerulrich/\">Ulrich</a> · <a href=\"https://profiles.wordpress.org/utkarshpatel/\">Utkarsh</a> · <a href=\"https://profiles.wordpress.org/valer1e/\">valer1e</a> · <a href=\"https://profiles.wordpress.org/versusbassz/\">versusbassz</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/elifvish/\">Vishal Kumar</a> · <a href=\"https://profiles.wordpress.org/vladolaru/\">vlad.olaru</a> · <a href=\"https://profiles.wordpress.org/volodymyrkolesnykov/\">Volodymyr Kolesnykov</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/wendyjchen/\">Wendy Chen</a> · <a href=\"https://profiles.wordpress.org/west7/\">Wes Theron</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whoisnegrello/\">whoisnegrello</a> · <a href=\"https://profiles.wordpress.org/antonynz/\">wpcharged</a> · <a href=\"https://profiles.wordpress.org/wpmakenorg/\">wpmakenorg</a> · <a href=\"https://profiles.wordpress.org/wpsoul/\">wpsoul</a> · <a href=\"https://profiles.wordpress.org/wraithkenny/\">WraithKenny</a> · <a href=\"https://profiles.wordpress.org/wslyhbb/\">wslyhbb</a> · <a href=\"https://profiles.wordpress.org/upsuper/\">Xidorn Quan</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/dolphingg/\">Yunus Ertuğrul</a> · <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a> · <a href=\"https://profiles.wordpress.org/znuff/\">znuff</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></small></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>Merci également aux personnes qui ont traduit WordPress 6.0 en français&nbsp;: <a href=\"https://profiles.wordpress.org/fxbenard\">FX Bénard</a>, <a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a style=\"font-size: revert;, sans-serif\" href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/wolforg\">Didier Demory</a>, <a href=\"https://profiles.wordpress.org/ajoah\">Aurélien Joahny</a>,&nbsp;<a href=\"https://profiles.wordpress.org/bonaldi\">Bonaldi</a>,&nbsp;<a href=\"https://profiles.wordpress.org/btpub\">Bruno Tritsch</a>,&nbsp;<a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>,&nbsp;<a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>,&nbsp;<a href=\"https://profiles.wordpress.org/fred5550\">Frederic Nuyts</a>,&nbsp;<a href=\"https://profiles.wordpress.org/guillaumeturpin\">Guillaume TURPIN</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ioanamuresan\">Ioana M</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jaz_on\">Jason Rouet</a>,&nbsp;<a href=\"https://profiles.wordpress.org/lulucmy\">lulucmy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/oellin\">Magali</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nuryko\">Marianna</a>,&nbsp;<a href=\"https://profiles.wordpress.org/chaton666\">Marie Comet</a>,&nbsp;<a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>,&nbsp;<a href=\"https://profiles.wordpress.org/maxpertici\">Maxime Pertici</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nandow\">Nandor Wiener</a>,&nbsp;<a href=\"https://profiles.wordpress.org/pasglop\">pasglop</a>,&nbsp;<a href=\"https://profiles.wordpress.org/larrach\">Rachel Peter</a>,&nbsp;<a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>,&nbsp;<a href=\"https://profiles.wordpress.org/virgar\">Virginie Garnier</a>,&nbsp;<a href=\"https://profiles.wordpress.org/virginienacci\">Virginie Nacci</a>,&nbsp;<a href=\"https://profiles.wordpress.org/whodunitagency\">Whodunit</a>,&nbsp;<a href=\"https://profiles.wordpress.org/wptranslationsorg\">WP-Translations</a> et&nbsp;<a href=\"https://profiles.wordpress.org/wplmillet\">wplmillet</a>.</p>\n\n\n\n<p class=\"has-text-align-right\"><small>Merci à <a href=\'https://profiles.wordpress.org/fxbenard/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>fxbenard</a> <a href=\'https://profiles.wordpress.org/wolforg/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>wolforg</a> et <a href=\'https://profiles.wordpress.org/em-m/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>em-m</a> pour la relecture de communiqué</small></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://fr.wordpress.org/2022/05/25/wordpress-6-0-arturo/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2022/05/04/guide-des-changements-techniques-de-wordpress-6-0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://fr.wordpress.org/2022/05/04/guide-des-changements-techniques-de-wordpress-6-0/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 May 2022 12:16:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2369\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:349:\"Maintenant que la première version Release Candidate de WordPress 6.0 est sortie, il est grand temps d&#8217;explorer les modifications apportées par cette future version, dont la sortie est prévue pour le 24 mai 2022. WordPress 6.0 est une version majeure de même niveau que WP 5.8 ou WP 5.9. Elle apportera le principe des variations [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:38078:\"\n<p>Maintenant que la première version <em>Release Candidate</em> de WordPress 6.0 est sortie, il est grand temps d&rsquo;explorer les modifications apportées par cette future version, dont la sortie est prévue pour le 24 mai 2022. WordPress 6.0 est une version majeure de même niveau que WP 5.8 ou WP 5.9. Elle apportera le principe des variations de styles, l’interface de verrouillage des blocs, plusieurs améliorations de l&rsquo;éditeur, encore plus d’outils de design, de nouveaux crochets et filtres, des mises à jour des différentes bibliothèques utilisées par WP, et bien plus encore&nbsp;!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2022/05/wordpress-60-provisoire.png\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"702\" src=\"https://fr.wordpress.org/files/2022/05/wordpress-60-provisoire-1024x702.png\" alt=\"\" class=\"wp-image-2376\" srcset=\"https://fr.wordpress.org/files/2022/05/wordpress-60-provisoire-1024x702.png 1024w, https://fr.wordpress.org/files/2022/05/wordpress-60-provisoire-300x206.png 300w, https://fr.wordpress.org/files/2022/05/wordpress-60-provisoire-768x527.png 768w, https://fr.wordpress.org/files/2022/05/wordpress-60-provisoire.png 1446w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<span id=\"more-2369\"></span>\n\n\n\n<p>Au bas mot, ce seront au moins <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.0&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">97 améliorations et nouvelles fonctionnalités</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.0&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">131 corrections de bogues</a>, <a href=\"https://core.trac.wordpress.org/ticket/55567\">13 correctifs sur l’éditeur de bloc</a>, ainsi que <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.0&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">23 autres changements divers</a>, ce qui représente au total <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.0&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">231 tickets Trac</a>.</p>\n\n\n\n<p>La nouvelle équipe chargée des performances de WordPress a aussi travaillé dur pour améliorer diverses parties du CMS. De nombreuses requêtes ont été optimisées et certaines d&rsquo;entre elles ont été retirées, la gestion du cache a été perfectionnée, et de nombreux doublons de traductions ont été enlevés afin d&rsquo;améliorer la vitesse de chargement de WP sur les installations non anglophones.</p>\n\n\n\n<p class=\"is-style-plain has-medium-font-size\">C&rsquo;est parti pour un petit tour d’horizon des nouveautés de WordPress 6.0&nbsp;!</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L&rsquo;objectif est de fournir un panorama général des changements techniques apportés par cette version, en français.</p>\n\n\n\n<p class=\"has-text-color has-background\" style=\"color:#03517f;background-color:#cceaff\">À noter&nbsp;: certaines modifications listées ici vont nécessiter des actions des auteurs et autrices de thèmes et d’extensions, qui devront adapter ou modifier leur code. Si vous êtes concerné·e, veuillez lire les notes de développement listées dans cet article consciencieusement afin de vous assurer que votre code fonctionnera avec WordPress 6.0 lorsque cette version sortira le 24 mai 2022.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Accessibilité</h2>\n\n\n\n<p>De même que pour les performances, l’accessibilité de WordPress a été grandement améliorée. La note de développement suivante détaille les différentes améliorations effectuées.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"aylbLUKVvp\"><a href=\"https://make.wordpress.org/core/2022/04/20/wordpress-6-0-accessibility-improvements/\">WordPress 6.0 Accessibility Improvements</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;WordPress 6.0 Accessibility Improvements&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/04/20/wordpress-6-0-accessibility-improvements/embed/#?secret=1ZIEsiLvDE#?secret=aylbLUKVvp\" data-secret=\"aylbLUKVvp\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">L’éditeur de blocs</h2>\n\n\n\n<p>L’éditeur a bien entendu reçu de nombreuses améliorations&nbsp;:</p>\n\n\n\n<ul>\n<li>Possibilité de construire de multiples variations de styles pour les thèmes basés sur des blocs&nbsp;;</li>\n\n\n\n<li>Possibilité de créer des compositions de contenu de pages que les rédacteurs et rédactrices pourront utiliser ou non pour construire leurs pages de contenu&nbsp;;</li>\n\n\n\n<li>Nouvelle propriété <code>ancestor</code> dans le fichier <code>block.json</code> afin de permettre la restriction des endroits où les rédacteurs et rédactrices peuvent placer leurs blocs&nbsp;;</li>\n\n\n\n<li>Une nouvelle interface de verrouillage des blocs à l&rsquo;aide de l&rsquo;attribut <code>lock</code>&nbsp;;</li>\n\n\n\n<li>Déclaration et enregistrement de blocs au sein des thèmes&nbsp;;</li>\n\n\n\n<li>Amélioration de la préservation des contenus non reconnus comme des blocs dans l’éditeur&nbsp;;</li>\n\n\n\n<li>Une fonctionnalité d&rsquo;exportation des blocs des thèmes plus robuste au sein de l’éditeur&nbsp;;</li>\n\n\n\n<li>Des mises à jour du balisage des blocs image, citation, liste et groupe&nbsp;;</li>\n\n\n\n<li>De nouveaux blocs tels que le bloc de commentaires de la publication, le bloc «&nbsp;Aucun résultat&nbsp;», et bien plus encore…</li>\n</ul>\n\n\n\n<p>À noter que si vous utilisez la version <em>extension</em> de Gutenberg (ce qui ne devrait être le cas que sur un site destiné à des expérimentations), vous devrez impérativement la mettre à jour vers sa toute dernière version <em>avant</em> de mettre à jour votre site avec la version 6.0 de WordPress.</p>\n\n\n\n<p>Sans plus attendre, voici les notes de développement liées à l’éditeur&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"O4MaN7Al9W\"><a href=\"https://make.wordpress.org/core/2022/05/03/page-creation-patterns-in-wordpress-6-0/\">Page creation patterns in WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Page creation patterns in WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/03/page-creation-patterns-in-wordpress-6-0/embed/#?secret=Vva1kiTUdO#?secret=O4MaN7Al9W\" data-secret=\"O4MaN7Al9W\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"yNgdvwFZyq\"><a href=\"https://make.wordpress.org/core/2022/05/03/global-styles-variations-in-wordpress-6-0/\">Global Styles variations in WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Global Styles variations in WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/03/global-styles-variations-in-wordpress-6-0/embed/#?secret=LouvK1NNRH#?secret=yNgdvwFZyq\" data-secret=\"yNgdvwFZyq\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"gEKvxlYKbw\"><a href=\"https://make.wordpress.org/core/2022/05/03/support-for-handling-resolution-errors-for-editor-data-module/\">Support for handling resolution errors for Editor data module</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Support for handling resolution errors for Editor data module&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/03/support-for-handling-resolution-errors-for-editor-data-module/embed/#?secret=ok7NQ4NnkH#?secret=gEKvxlYKbw\" data-secret=\"gEKvxlYKbw\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"yzhtIAVRNf\"><a href=\"https://make.wordpress.org/core/2022/05/03/block-markup-updates-for-image-quote-list-and-group-blocks/\">Block markup updates for image, quote, list and group blocks</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Block markup updates for image, quote, list and group blocks&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/03/block-markup-updates-for-image-quote-list-and-group-blocks/embed/#?secret=udFFQ8yHBA#?secret=yzhtIAVRNf\" data-secret=\"yzhtIAVRNf\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"kC6j5E5zKf\"><a href=\"https://make.wordpress.org/core/2022/05/03/separator-block-updated-to-use-block-supports-color-settings/\">Separator block: Updated to use block supports color settings</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Separator block: Updated to use block supports color settings&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/03/separator-block-updated-to-use-block-supports-color-settings/embed/#?secret=EVWwVqSsK8#?secret=kC6j5E5zKf\" data-secret=\"kC6j5E5zKf\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"e8Tty8IzRp\"><a href=\"https://make.wordpress.org/core/2022/05/03/block-editor-miscellaneous-dev-notes-for-wordpress-6-0/\">Block Editor miscellaneous Dev Notes for WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Block Editor miscellaneous Dev Notes for WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/03/block-editor-miscellaneous-dev-notes-for-wordpress-6-0/embed/#?secret=5wJqoOGfuk#?secret=e8Tty8IzRp\" data-secret=\"e8Tty8IzRp\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Processus de chargement de WordPress</h2>\n\n\n\n<p>Entre autres améliorations concernant les performances du logiciel, le processus de chargement de WordPress (le «&nbsp;bootstrap&nbsp;») a été amélioré afin de permettre aux développeurs et développeuses d’ignorer les requêtes non nécessaires avec le filtre <code>do_parse_request</code>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"QGN6nyDZZx\"><a href=\"https://make.wordpress.org/core/2022/04/27/changes-to-do_parse_request-filter-in-wordpress-6-0/\">Changes to do_parse_request filter in WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Changes to do_parse_request filter in WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/04/27/changes-to-do_parse_request-filter-in-wordpress-6-0/embed/#?secret=JGyFNpM8Vw#?secret=QGN6nyDZZx\" data-secret=\"QGN6nyDZZx\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">API de gestion du cache</h2>\n\n\n\n<p>Avec WordPress 6.0, l’API <code>wp_cache_*_multiple</code> devient une API complètement CRUD (voir le <a href=\"https://fr.wikipedia.org/wiki/CRUD\">terme «&nbsp;CRUD&nbsp;» sur Wikipédia</a>). Par ailleurs, une option permettant de réinitialiser le temps d’exécution du cache sans réinitialiser l&rsquo;entièreté du cache persistant a été ajoutée.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"HixiB7GUbB\"><a href=\"https://make.wordpress.org/core/2022/04/29/caching-improvements-in-wordpress-6-0/\">Caching improvements in WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Caching improvements in WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/04/29/caching-improvements-in-wordpress-6-0/embed/#?secret=eSHwD0gV8N#?secret=HixiB7GUbB\" data-secret=\"HixiB7GUbB\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Médias</h2>\n\n\n\n<p>La gestion des médias a elle aussi reçu de nouveaux filtres et plusieurs améliorations d’interface&nbsp;:</p>\n\n\n\n<ul>\n<li>Activation de la modification des tailles d’images personnalisées à l’aide du filtre&nbsp;<code>edit_custom_thumbnail_sizes</code>&nbsp;qui permet aux développeuses et développeurs de modifier les tailles d’images personnalisées individuelles (<a href=\"https://core.trac.wordpress.org/ticket/28277\">Voir le ticket #28277</a>)&nbsp;;</li>\n\n\n\n<li>&nbsp;Ajout d’une fonction «&nbsp;copier l’URL dans le presse-papier&nbsp;» sur la vue en liste des médias (<a href=\"https://core.trac.wordpress.org/ticket/54426\">Voir le ticket #54426</a>).</li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"yxx2tJKflU\"><a href=\"https://make.wordpress.org/core/2022/04/27/new-filter-to-modify-content-images-in-wordpress-6-0/\">New filter to modify content images in WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;New filter to modify content images in WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/04/27/new-filter-to-modify-content-images-in-wordpress-6-0/embed/#?secret=8kaC2NHwuW#?secret=yxx2tJKflU\" data-secret=\"yxx2tJKflU\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p>Le composant Médias a par ailleurs lui aussi reçu des améliorations de performances&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"rzdrAmmrI6\"><a href=\"https://make.wordpress.org/core/2022/05/02/media-storing-file-size-as-part-of-metadata/\">Media: storing file size as part of metadata</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Media: storing file size as part of metadata&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/02/media-storing-file-size-as-part-of-metadata/embed/#?secret=7VfVtwQN76#?secret=rzdrAmmrI6\" data-secret=\"rzdrAmmrI6\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Types de publications</h2>\n\n\n\n<p>WordPress 6.0 introduit encore davantage de crochets et filtres dynamiques pour les types de publications et les taxonomies.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"WJDM87k4sz\"><a href=\"https://make.wordpress.org/core/2022/05/02/object-type-specific-registration-hooks-in-6-0/\">Object type specific registration hooks in 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Object type specific registration hooks in 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/02/object-type-specific-registration-hooks-in-6-0/embed/#?secret=wYXFAV3b98#?secret=WJDM87k4sz\" data-secret=\"WJDM87k4sz\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Taxonomies</h2>\n\n\n\n<p>Les taxonomies ont reçues des améliorations de performances, notamment à travers la mise en cache des requêtes sur les termes de taxonomies, et via l’ajout de limites aux requêtes concernant les taxonomies, mais aussi au niveau des éléments de menus de navigation.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"VtwOOxjJuQ\"><a href=\"https://make.wordpress.org/core/2022/04/28/taxonomy-performance-improvements-in-wordpress-6-0/\">Taxonomy performance improvements in WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Taxonomy performance improvements in WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/04/28/taxonomy-performance-improvements-in-wordpress-6-0/embed/#?secret=90lFxU7Wbk#?secret=VtwOOxjJuQ\" data-secret=\"VtwOOxjJuQ\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Thèmes</h2>\n\n\n\n<p>Cette nouvelle version offre aux auteurs et autrices de thèmes une façon encore plus efficace de travailler avec les compositions de blocs, la prise en charge de multiples fichiers <code>theme.json</code> avec l’éditeur de site, et bien plus encore.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"pTkwNLfniL\"><a href=\"https://make.wordpress.org/core/2022/05/02/new-features-for-working-with-patterns-and-themes-in-wordpress-6-0/\">New features for working with patterns and themes in WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;New features for working with patterns and themes in WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/02/new-features-for-working-with-patterns-and-themes-in-wordpress-6-0/embed/#?secret=z1ichmCsB3#?secret=pTkwNLfniL\" data-secret=\"pTkwNLfniL\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"ZTyMFeyCFv\"><a href=\"https://make.wordpress.org/core/2022/05/02/theme-export-in-wordpress-6-0/\">Theme export in WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Theme export in WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/02/theme-export-in-wordpress-6-0/embed/#?secret=AIOHcWsoD9#?secret=ZTyMFeyCFv\" data-secret=\"ZTyMFeyCFv\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Les thèmes basés sur des blocs peuvent maintenant se passer du fichier&nbsp;index.php</h3>\n\n\n\n<p>Avec cette modification, il n&rsquo;est maintenant plus nécessaire d&rsquo;avoir un fichier modèle&nbsp;<code>index.php</code>. Jusqu&rsquo;à présent, il était nécessaire d&rsquo;en avoir un même s&rsquo;il n&rsquo;était pas utilisé. Dorénavant, ce fichier est remplacé par le fichier&nbsp;<code>templates/index.html</code>. <a href=\"https://core.trac.wordpress.org/ticket/54272\">Voir le ticket #54272</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Correction de la logique d’affichage des avertissements&nbsp;_doing_it_wrong()&nbsp;pour&nbsp;add_theme_support( &lsquo;html5&rsquo; )</h3>\n\n\n\n<ul>\n<li>Le fait d’appeler&nbsp;<code>add_theme_support( \'html5\' )</code>&nbsp;sans passer un tableau de types pris en charges affiche maintenant un avertissement&nbsp;<code>_doing_it_wrong()</code>&nbsp;: «&nbsp;Vous devez passer un tableau de types&nbsp;» ;</li>\n\n\n\n<li>Si le second paramètre n’est pas spécifié, un tableau contenant&nbsp;<code>comment-list</code>,&nbsp;<code>comment-form</code>, et&nbsp;<code>search-form</code>&nbsp;sera automatiquement passé en tant que solution de repli, pour assurer la rétrocompatibilité de la fonction&nbsp;;</li>\n\n\n\n<li>Si le second paramètre n’est pas un tableau, la fonction retournera&nbsp;<code>false</code>.</li>\n</ul>\n\n\n\n<p>Pour plus d&rsquo;informations, <a href=\"https://core.trac.wordpress.org/ticket/51657\">voir le ticket #51657</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Comptes</h2>\n\n\n\n<p>Avec WP 6.0, les installations comprenant plus de 10&nbsp;000 comptes ont reçu des améliorations de performances sur les requêtes concernant les comptes.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"BHtC3yStBd\"><a href=\"https://make.wordpress.org/core/2022/04/29/wp_user_query-now-accepts-fields-options-in-wordpress-6-0/\">WP_User_Query now accepts fields options in WordPress 6.0 </a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;WP_User_Query now accepts fields options in WordPress 6.0 &#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/04/29/wp_user_query-now-accepts-fields-options-in-wordpress-6-0/embed/#?secret=YDNq2zqbDE#?secret=BHtC3yStBd\" data-secret=\"BHtC3yStBd\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"WrP1XxUcf7\"><a href=\"https://make.wordpress.org/core/2022/05/02/performance-increase-for-sites-with-large-user-counts-now-also-available-on-single-site/\">Performance increase for sites with large user counts (now also available on single site)</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Performance increase for sites with large user counts (now also available on single site)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/02/performance-increase-for-sites-with-large-user-counts-now-also-available-on-single-site/embed/#?secret=xdlkVPVFnI#?secret=WrP1XxUcf7\" data-secret=\"WrP1XxUcf7\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Autres changements techniques</h2>\n\n\n\n<p>WordPress 6.0 apporte également&nbsp;: </p>\n\n\n\n<ul>\n<li>Un filtre destiné aux auteurs et autrices d’extensions qui leur permet de modifier la description de leur extension telle qu’elle est affichée sur l&rsquo;écran <strong>Extensions &gt; Ajouter</strong> et/ou sur l&rsquo;écran&nbsp;<strong>Administration du réseau&nbsp;&gt; Extensions &gt; Ajouter</strong>&nbsp;;</li>\n\n\n\n<li>La possibilité de filtrer l’ensemble de la notification e-mail envoyée par <code>retrieve_password</code>&nbsp;;</li>\n\n\n\n<li>La possibilité de retirer les icônes de sites sur les réseaux multisites.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"ET2xV9XcVa\"><a href=\"https://make.wordpress.org/core/2022/05/03/miscellaneous-dev-notes-for-wordpress-6-0/\">Miscellaneous Dev Notes for WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Miscellaneous Dev Notes for WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/03/miscellaneous-dev-notes-for-wordpress-6-0/embed/#?secret=Z0RAvcrbpa#?secret=ET2xV9XcVa\" data-secret=\"ET2xV9XcVa\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Et bien plus encore…</h2>\n\n\n\n<p>Plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.0&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">131 corrections de bugs</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.0&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">97 améliorations et nouvelles fonctionnalité</a>, ainsi que&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.0&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">23 tâches diverses</a>&nbsp;ont été&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.0&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">ajoutés dans WordPress 6.0</a>.</p>\n\n\n\n<p>Voici quelques modifications qui méritent d’être soulignées&nbsp;:</p>\n\n\n\n<ul>\n<li><strong>Administration&nbsp;:</strong> ajout d’un filtre&nbsp;<code>media_date_column_time</code>&nbsp;à la colonne de date de l&rsquo;écran de liste des médias. De façon similaire au filtre existant <code>post_date_column_time</code>&nbsp;pour les publications, ce filtre permet de modifier l’affichage du contenu de la colonne «&nbsp;Date&nbsp;» (<a href=\"https://core.trac.wordpress.org/ticket/42942\">voir le ticket #42942</a>)&nbsp;;</li>\n\n\n\n<li><strong>Outils de <em>build</em> et de tests&nbsp;:</strong>\n<ul>\n<li>Mise à jour de webpack vers la version v5.x. Cela rapproche WordPress de la façon dont l’extension Gutenberg gère ses paquets&nbsp;;</li>\n\n\n\n<li>WordPress 6.0 active également la prise en charge de <em>«&nbsp;React Fast Refresh&nbsp;»</em> pour le développement de blocs avec <code>@wordpress/scripts</code>&nbsp;;</li>\n\n\n\n<li>Cette nouvelle version ajoute aussi la dernière version de&nbsp;<code>caniuse-lite</code>&nbsp;qui permet de s’assurer que les outils de <em>build</em> de WP ciblent la dernière version des navigateurs pris en charge par WordPress (voir les tickets <a href=\"https://core.trac.wordpress.org/ticket/51750\">#51750</a> et <a href=\"https://core.trac.wordpress.org/ticket/55505\">#55505</a>)&nbsp;;</li>\n\n\n\n<li>Un fichier <code>.git-blame-ignore-revs</code> a été ajouté au répertoire de développement de WP afin de rendre la fonctionnalité <code>git blame</code> plus efficace sur GitHub (<a href=\"https://core.trac.wordpress.org/ticket/55422\">voir le ticket #55422</a>)&nbsp;;</li>\n\n\n\n<li>La commande <code>npm install</code> a été corrigée pour les contributeurs et contributrices utilisant des appareils <em>«&nbsp;Apple M series silicone&nbsp;»</em> en mettant à jour la dépendance technique <code>grunt-contrib-qunit</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/52690\">voir le ticket #52690</a>)&nbsp;;</li>\n</ul>\n</li>\n\n\n\n<li><strong>Thèmes natifs&nbsp;:</strong> si vous rencontriez des soucis avec l’ordre des éléments dans le formulaire de commentaires du thème Twenty Nineteen, nous avons une bonne nouvelle&nbsp;: ceci a été corrigé dans le ticket <a href=\"https://core.trac.wordpress.org/ticket/46600\">#46600</a>&nbsp;; </li>\n\n\n\n<li><strong>URL canoniques&nbsp;:</strong> la fonction <code>redirect_guess_404_permalink()</code> inclue maintenant tous les états publics des publications, et pas uniquement l’état «&nbsp;publié&nbsp;» / <code>publish</code>, dans les redirections 404 de recherche (<a href=\"https://core.trac.wordpress.org/ticket/47911\">voir le ticket #47911</a>)&nbsp;;</li>\n\n\n\n<li><strong>Commentaires&nbsp;:</strong>&nbsp;accélération du chargement SQL du tableau de bord et de la modération des commentaires (<a href=\"https://core.trac.wordpress.org/ticket/19901\">voir le ticket #19901</a>)&nbsp;;</li>\n\n\n\n<li><strong>Emojis :</strong> mise à jour de la bibliothèque Twemoji vers la version 14.0.2. Cette version introduit la prise en charge des derniers Emojis ajoutés dans la version 14 (<a href=\"https://core.trac.wordpress.org/ticket/55395\">voir le ticket #55395</a>)&nbsp;;</li>\n\n\n\n<li><strong>Bibliothèques externes&nbsp;:</strong>\n<ul>\n<li>Mise à jour de Jcrop à la version 0.9.15 (<a href=\"https://core.trac.wordpress.org/ticket/54035\">ticket #54035</a>)&nbsp;;</li>\n\n\n\n<li>Mise à jour de jQuery Color à la version 2.2.0. Suppression de la version embarquée (qui existait toujours dans le cœur WP) en faveur de l&rsquo;amélioration du processus Grunt pour plutôt inclure le paquet depuis NPM (<a href=\"https://core.trac.wordpress.org/ticket/55016\">ticket #55016</a>)&nbsp;;</li>\n\n\n\n<li>Mise à jour de <code>random_compat</code> à la version 2.0.21. Cela améliore la compatibilité avec PHP 8.1 et corrige des bogues avec les plateformes Windows (<a href=\"https://core.trac.wordpress.org/ticket/55181\">ticket #55181</a>) ;</li>\n\n\n\n<li>Mise à niveau de PHPMailer à la version 6.5.4. Amélioration de compatibilité PHP et sécurisation contre les hébergeurs désactivant certaines fonctions de sécurité. <strong>Note aux hébergeurs&nbsp;: ne désactivez pas les fonctions&nbsp;<code>escapeshellarg()</code>&nbsp;et&nbsp;<code>escapeshellcmd()</code>, cela présente un risque de sécurité&nbsp;!</strong> (<a href=\"https://core.trac.wordpress.org/ticket/55187\">ticket #55187</a>)&nbsp;;</li>\n\n\n\n<li>Mise à niveau de PHPMailer à la version 6.6.0 (<a href=\"https://core.trac.wordpress.org/ticket/55277\">ticket #55277</a>)&nbsp;;</li>\n\n\n\n<li>Mise à jour de sodium_compat à la version 1.17.1. Amélioration de la compatibilité PHP 8.1 (<a href=\"https://core.trac.wordpress.org/ticket/55453\">ticket #55453</a>)</li>\n\n\n\n<li>Mise à jour de <code>backbone</code>&nbsp;de la version&nbsp;<code>1.4.0</code>&nbsp;à la version&nbsp;<code>1.4.1</code>&nbsp;;</li>\n\n\n\n<li>Mise à jour de <code>underscore</code>&nbsp;de la version&nbsp;<code>1.13.1</code>&nbsp;à la version&nbsp;<code>1.13.2</code>&nbsp;;</li>\n\n\n\n<li>Mise à jour de <code>clipboard</code>&nbsp;de la version&nbsp;<code>2.0.8</code>&nbsp;à la version&nbsp;<code>2.0.10</code> (<a href=\"https://core.trac.wordpress.org/ticket/55547\">ticket #55547</a>)&nbsp;;</li>\n</ul>\n</li>\n\n\n\n<li><strong>Formatage :</strong>\n<ul>\n<li>Ajout de la prise en charge des formatage de tailles PB, EB, ZB, and YB (<a href=\"https://core.trac.wordpress.org/ticket/40875\">ticket #40875</a>)</li>\n</ul>\n</li>\n\n\n\n<li><strong>KSES&nbsp;:</strong>\n<ul>\n<li>Prise en charge de l&rsquo;élément&nbsp;<code>&lt;ruby&gt;</code>&nbsp;et des autres éléments liés. Cela est particulièrement utile pour le contenu écrit en japonais ou chinois, via les éléments HTML&nbsp;<code>&lt;ruby&gt;</code>,&nbsp;<code>&lt;rt&gt;</code> et&nbsp;<code>&lt;rp&gt;</code>&nbsp;dans le&nbsp;<a href=\"https://html.spec.whatwg.org/multipage/text-level-semantics.html#the-ruby-element\">standard HTML</a>, ainsi que&nbsp;<code>&lt;rb&gt;</code>&nbsp;et&nbsp;<code>&lt;rtc&gt;</code>&nbsp;pour des options de formatage avancées (<a href=\"https://core.trac.wordpress.org/ticket/54698\">ticket #54698</a>)&nbsp;;</li>\n\n\n\n<li>Ajout global de la prise en charge des attributs&nbsp;<code>lang</code>,&nbsp;<code>xml:lang</code>,&nbsp;<code>dir</code>&nbsp;en tant qu’attributs utilisables sur n&rsquo;importe quel élément HTML, ce qui améliore considérablement les possibilités de produire du contenu accessible (<a href=\"https://core.trac.wordpress.org/ticket/54699\">ticket #54699</a>)&nbsp;;</li>\n\n\n\n<li>La fonction <code>get_the_author_link()</code> devient filtrable sur WordPress 6.0, via le filtre <code>get_the_author_link</code>, afin de permettre l&rsquo;altération de l’affichage du lien vers l’auteur/autrice de chaque publication (<a href=\"https://core.trac.wordpress.org/ticket/51859\">ticket #51859</a>)&nbsp;;</li>\n</ul>\n</li>\n\n\n\n<li><strong>Internationnalisation&nbsp;:</strong>\n<ul>\n<li>Le séparateur des éléments de liste est maintenant une propriété de <code>WP_Locale</code> (<a href=\"https://core.trac.wordpress.org/ticket/39733\">voir le ticket #39733</a>)&nbsp;;</li>\n\n\n\n<li>Les chemins de langues sont maintenant définissables dans la fonction  <code>register_block_type</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/54797\">ticket #54797</a>)&nbsp;;</li>\n</ul>\n</li>\n\n\n\n<li><strong>Médias&nbsp;:</strong> suppression du filtre&nbsp;<code>attachment_fields_to_save</code>&nbsp;filter et dépréciation de la fonction&nbsp;<code>image_attachment_fields_to_save()</code>. Cette fonction n’était plus utilisée par le cœur WP&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/39108\">ticket #39108</a>)&nbsp;;</li>\n\n\n\n<li><strong>Réseaux multisites&nbsp;:</strong> amélioration de la génération du cache des clés sur <code>WP_Site_Query</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/55462\">ticket #55462</a>)&nbsp;;</li>\n\n\n\n<li><strong>Extensions&nbsp;:</strong>\n<ul>\n<li>Ajout du filtre&nbsp;<code>plugin_install_description</code> (<a href=\"https://core.trac.wordpress.org/ticket/55480\">ticket #55480</a>)</li>\n\n\n\n<li>Conversion de&nbsp;<code>apply_filters()</code>&nbsp;en une vraie fonction variadique. Une fonction variadique est une fonction d&rsquo;arité indéfinie, c&rsquo;est-à-dire qu&rsquo;elle accepte un nombre variable de paramètres (<a href=\"https://core.trac.wordpress.org/ticket/53218\">voir le ticket #53218</a>)&nbsp;;</li>\n</ul>\n</li>\n\n\n\n<li><strong>Publications et types de publications&nbsp;:</strong> passage du paramètre <code>$update</code>&nbsp;aux filtres <code>wp_insert_post_data</code>&nbsp;et&nbsp;<code>wp_insert_attachment_data</code>. Cela facilite la détermination de l&rsquo;existence d&rsquo;une publication lors de sa mise à jour (<a href=\"https://core.trac.wordpress.org/ticket/46228\">ticket #46228</a>)&nbsp;;</li>\n\n\n\n<li><strong>Taxonomies :</strong> mutualisation de la traduction des libellés de taxonomies afin d&rsquo;améliorer les performances générales de l&rsquo;administration WordPress&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/26746\">ticket #26746</a>).</li>\n</ul>\n\n\n\n<p>Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements. Vous pouvez utiliser&nbsp;<a rel=\"noreferrer noopener\" href=\"https://wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\">l’extension Beta Tester</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec WordPress 6.0 RC1.&nbsp;Nous comptons sur vous pour vous assurer que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p class=\"has-small-font-size\"><em>Rédigé par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a> d&rsquo;après le <a href=\"https://make.wordpress.org/core/2022/05/03/wordpress-6-0-field-guide/\">Field Guide en anglais</a>. Merci à <a href=\"https://profiles.wordpress.org/valer1e/\">Valérie Galassi</a>, <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Bénard</a> et <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> pour la relecture.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://fr.wordpress.org/2022/05/04/guide-des-changements-techniques-de-wordpress-6-0/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 5.9 « Joséphine »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://fr.wordpress.org/2022/01/25/wordpress-5-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://fr.wordpress.org/2022/01/25/wordpress-5-9/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 25 Jan 2022 21:05:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2330\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:450:\"Bienvenue sur WordPress 5.9 «&#160;Joséphine&#160;»&#160;! Nous vous présentons WordPress 5.9, nommée «&#160;Joséphine&#160;» en l’honneur de la chanteuse internationale de jazz Joséphine Baker. Vous pouvez&#160;télécharger cette version ici&#160;ou effectuer la mise à jour directement depuis votre tableau de bord. En tant que militante des droits civiques depuis toujours, Joséphine Baker pensait que tout le monde pouvait [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:62335:\"\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"682\" src=\"https://fr.wordpress.org/files/2022/01/5-9-josephine-1024x682.png\" alt=\"\" class=\"wp-image-2341\" srcset=\"https://fr.wordpress.org/files/2022/01/5-9-josephine-1024x682.png 1024w, https://fr.wordpress.org/files/2022/01/5-9-josephine-300x200.png 300w, https://fr.wordpress.org/files/2022/01/5-9-josephine-768x512.png 768w, https://fr.wordpress.org/files/2022/01/5-9-josephine.png 1264w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"bienvenue-sur-wordpress-5-9-josephine\">Bienvenue sur WordPress 5.9 «&nbsp;Joséphine&nbsp;»&nbsp;!</h2>\n\n\n\n<p>Nous vous présentons WordPress 5.9, nommée «&nbsp;Joséphine&nbsp;» en l’honneur de la chanteuse internationale de jazz Joséphine Baker. Vous pouvez&nbsp;<a href=\"https://wordpress.org/download/\">télécharger cette version ici</a>&nbsp;ou effectuer la mise à jour directement depuis votre tableau de bord.</p>\n\n\n\n<p>En tant que militante des droits civiques depuis toujours, Joséphine Baker pensait que tout le monde pouvait vivre en harmonie ensemble, tout comme les différents instruments d&rsquo;un groupe de jazz se mélangent pour former un morceau complet. Mentionnons également que Joséphine Baker était naturalisée française et est d&rsquo;ailleurs entrée au Panthéon l’année dernière, en 2021.</p>\n\n\n\n<p>Activez donc une liste de lecture de votre service de musique préféré et profitez de ses célèbres interprétations de <em>« You are the greatest love »</em>, <em>« Sans Amour »</em> et <em>« Love is a dreamer »</em> tout en découvrant les fonctionnalités de cette toute nouvelle version de WordPress.</p>\n\n\n\n<span id=\"more-2330\"></span>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"l-edition-complete-de-votre-site-est-la\">L’édition complète de votre site est là.</h2>\n\n\n\n<p>Cela vous donne le contrôle sur l’ensemble de votre site, directement depuis votre administration WordPress.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2022/01/5-9-release-1.png\" alt=\"\" class=\"wp-image-12101\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"decouvrez-twenty-twenty-two\">Découvrez Twenty Twenty-Two</h3>\n\n\n\n<p>Et saluez l’arrivée du premier thème natif basé sur des blocs dans l’histoire de WordPress. Cela représente bien plus qu’un thème natif&nbsp;: c’est une toute nouvelle façon de travailler avec les thèmes WordPress.</p>\n\n\n\n<p>Les <a href=\"https://fr.wordpress.org/support/article/block-themes/\">thèmes basés sur des blocs</a> placent un large choix de conception dans vos mains, des jeux de couleurs aux combinaisons typographiques, en passant par les modèles de pages et les filtres d’images. Tout cela est compris sur <a href=\"https://fr.wordpress.org/support/article/site-editor/\">la nouvelle interface d’édition de site</a>. En un seul et même endroit, vous trouverez tout ce qu’il faut pour donner votre touche graphique à <em>Twenty Twenty‑Two</em>, et vous pourrez donner un nouveau départ à votre site.</p>\n\n\n\n<p>Le thème Twenty Twenty‑Two est déjà sans doute disponible sur votre site si vous l’avez mis à jour vers WP 5.9. Il a été installé en même temps que WordPress 5.9. Vous le trouverez avec&nbsp;les autres thèmes que vous avez installés.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2022/01/5-9-release-2.png\" alt=\"\" class=\"wp-image-12102\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"votre-palette-de-peinture-vous-attend\">Votre palette de peinture vous attend</h3>\n\n\n\n<p>D’autres thèmes basés sur des blocs et implémentant des fonctionnalités d’édition de site sont disponibles dans le répertoire officiel des thèmes, aux côtés de Twenty Twenty‑Two. Ils attendent simplement d’être essayés. Et bien d’autres viendront avec le temps&nbsp;!</p>\n\n\n\n<p>Lorsque vous utiliserez l’un de ces nouveaux thèmes, vous n’aurez plus besoin de l’outil de personnalisation. À la place, vous découvrirez la puissance de l’interface de gestion des styles globaux comprise dans l’éditeur de site. Tout comme avec Twenty Twenty‑Two, vous pourrez y bâtir l’apparence de votre site avec des outils prêts à l’emploi et une interface fluide et dynamique.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2022/01/5-9-release-3.png\" alt=\"\" class=\"wp-image-12103\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"le-bloc-navigation\">Le bloc navigation</h3>\n\n\n\n<p>Les blocs font leur entrée dans les menus de navigation, le cœur de l’expérience de visite de votre site.</p>\n\n\n\n<p>Le nouveau bloc Navigation vous donne la possibilité de choisir&nbsp;: un menu fluide ou plutôt un menu adapté à la taille d’écran de l’internaute. Qu’importe le menu que vous créez, vous pourrez le réutiliser partout où vous le souhaitez, que ce soit dans un nouveau modèle de page ou même après avoir changé de thème.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"encore-plus-d-ameliorations-et-de-mises-a-jour\">Encore plus d’améliorations et de mises à jour</h2>\n\n\n\n<p>Vous aimez bloguer ou produire de contenu&nbsp;? De nouveaux ajustements aideront votre expérience éditoriale et la rendront plus efficace.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2022/01/5-9-release-4.png\" alt=\"\" class=\"wp-image-12104\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"de-meilleurs-outils-de-controle-pour-les-blocs\">De meilleurs outils de contrôle pour les blocs</h3>\n\n\n\n<p>WordPress 5.9 contient de nouveaux outils typographiques et vous permet de contrôler votre mise en page, comme par exemple sur des détails tels que les espacements, les bordures, et bien plus encore. Cela vous aidera à apporter autant de soin à l’apparence générale de votre site qu’aux détails des contenus de vos pages.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2022/01/5-9-release-5.png\" alt=\"\" class=\"wp-image-12105\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"le-pouvoir-des-compositions\">Le pouvoir des compositions</h3>\n\n\n\n<p>Le répertoire de compositions de WordPress contient un grand nombre de compositions de blocs construites pour vous faire gagner du temps. Vous pouvez les utiliser et les modifier autant que vous le souhaitez. Vous voulez un en-tête ou un pied de page différent pour votre site&nbsp;? Vous pourrez en installer de nouveaux en quelques clics.</p>\n\n\n\n<p>Avec sa vue en grande largeur qui vous montre tous les détails de chaque élément, l’outil d’exploration de compositions vous permet de comparer les compositions entre elles et de choisir la plus adaptée pour votre site.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2022/01/5-9-release-6.png\" alt=\"\" class=\"wp-image-12106\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"une-refonte-de-la-vue-en-liste\">Une refonte de la vue en liste</h3>\n\n\n\n<p>Dans WP 5.9, la vue en liste vous permet de glisser-déposer votre contenu exactement où vous le souhaitez. Gérer des documents complexes est encore plus simple&nbsp;: des boutons vous permettent de déplier-replier les sections pendant que vous bâtissez votre site, et d’ajouter des ancres à vos blocs pour aider les internautes à naviguer dans la page.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2022/01/5-9-release-7.png\" alt=\"\" class=\"wp-image-12107\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"un-meilleur-bloc-galerie\">Un meilleur bloc galerie</h3>\n\n\n\n<p>Manipulez chaque image de vos blocs galeries de la même façon que vous manipuleriez un bloc image indépendant.</p>\n\n\n\n<p>Mettez en forme chaque image de votre galerie de façon indépendante des autres (par exemple avec un recadrage différent ou un filtre duotone), ou faites-les toutes se ressembler. Vous pourrez ensuite modifier la mise en page de la galerie avec un simple glisser-déposer.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"wordpress-5-9-pour-les-developpeurs-et-les-developpeuses\">WordPress 5.9 pour les développeurs et les développeuses</h2>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"le-fichier-theme-json-pour-les-themes-enfants\">Le fichier theme.json pour les thèmes enfants</h3>\n\n\n\n<p>Avec WP 5.9, le fichier <code>theme.json</code> prendra maintenant en charge les thèmes enfants. Cela signifie que vous pourrez construire un thème enfant directement depuis l’interface d’administration de WordPress, sans écrire la moindre ligne de code.&nbsp;</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/01/04/block-themes-a-new-way-to-build-themes-in-wordpress-5-9/\">Voir la note de développement sur la fonctionnalité theme.json pour les thèmes enfants (en anglais)</a></p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"verrouillage-des-blocs\">Verrouillage des blocs</h3>\n\n\n\n<p>Vous pouvez maintenant verrouiller tout ou partie des blocs au sein d’une composition, juste en ajoutant un attribut de verrouillage dans ses réglages au sein du fichier block.json. Laissez les rédacteur·ice·s libres de modifier le reste de la composition pour adapter son contenu.</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/01/04/block-themes-a-new-way-to-build-themes-in-wordpress-5-9/\">Voir la note de développement sur la fonctionnalité de verrouillage des blocs (en anglais)</a></p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"plusieurs-feuilles-de-styles-pour-chaque-bloc\">Plusieurs feuilles de styles pour chaque bloc</h3>\n\n\n\n<p>Vous pouvez maintenant déclarer plus qu’une seule feuille de style par bloc. Cela vous permet de partager des styles entre différents blocs que vous avez créés, ou pour charger des styles pour des blocs individuels, ce qui fait que vos styles ne sont chargés que lorsque le bloc est utilisé. Pour en savoir plus, apprenez à&nbsp;<a href=\"https://make.wordpress.org/core/2021/12/15/using-multiple-stylesheets-per-block/\">charger plusieurs feuilles de styles sur un bloc (en anglais)</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"un-bloc-galerie-remodele-de-a-a-z\">Un bloc galerie remodelé de A à Z</h3>\n\n\n\n<p>Les modifications du bloc galerie listées ci-dessus sont le résultat d’un remodelage complet. Si vous avez construit un thème ou une extension qui l’utilise, assurez-vous de lire la&nbsp;<a href=\"https://make.wordpress.org/core/2021/08/20/gallery-block-refactor-dev-note/\">note technique de compatibilité du bloc galerie (en anglais)</a>.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h3 class=\"wp-block-heading\" id=\"en-savoir-plus-sur-les-fonctionnalites-de-wp-5-9\">En savoir plus sur les fonctionnalités de WP&nbsp;5.9</h3>\n\n\n\n<p>Vous voulez plonger dans 5.9 mais ne savez pas par où commencer&nbsp;? Rendez-vous sur&nbsp;<a href=\"https://learn.wordpress.org/\">learn.wordpress.org</a>&nbsp;pour consulter des ressources sur les nouvelles fonctionnalités de WordPress 5.9.</p>\n\n\n\n<p>Si vous cherchez des ressources en français, nous vous conseillons aussi de <a href=\"https://fr.wordpress.org/2022/01/17/wordpress-5-9-documentation-en-francais-des-fonctionnalites-de-lediteur-de-site/\" data-type=\"post\" data-id=\"2304\">consulter la documentation produite par l&rsquo;équipe de traduction de WordPress en français tout spécialement pour WordPress&nbsp;5.9</a>.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h3 class=\"wp-block-heading\" id=\"consultez-le-guide-de-la-version-pour-en-savoir-plus\">Consultez le guide de la version pour en savoir plus&nbsp;!</h3>\n\n\n\n<p>Consultez le guide des changements techniques de WordPress&nbsp;5.9. Il met en avant les notes de développement pour chaque modification que vous souhaiteriez approfondir&nbsp;:&nbsp;<a href=\"https://fr.wordpress.org/2022/01/12/guide-des-changements-techniques-a-venir-sur-wordpress-5-9/\" data-type=\"post\" data-id=\"2264\">guide des changements techniques de WordPress 5.9 en français</a></p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"l-equipe-de-direction-de-wordpress-5-9\"><strong>L’équipe de direction de WordPress&nbsp;5.9</strong></h2>\n\n\n\n<p>La version 5.9 de WordPress 5.9 a été dirigée par <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a>, avec l’assistance de l’équipe de direction suivante&nbsp;:</p>\n\n\n\n<ul><li>Directeur de la version&nbsp;: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li><li>Directrice technique et coordinatrice de la version&nbsp;: <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a></li><li>Responsables projet&nbsp;: <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a> et <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a></li><li>Responsables techniques côté éditeur/Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> et <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a></li><li>Responsables du nouveau thème&nbsp;: <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> et <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a></li><li>Rédacteur technique&nbsp;: <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a></li><li>Responsables de la documentation&nbsp;: <a href=\"https://profiles.wordpress.org/mkaz/\">Marcus Kazmierczak</a> et <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a></li><li>Responsables marketing &amp; communications&nbsp;: <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> et <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a></li><li>Responsables des tests&nbsp;: <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> et <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a></li></ul>\n\n\n\n<p>WordPress 5.9 reflète l’impressionnant travail accompli par of 624 contributrices et contributeurs bénévoles. Cela a abouti à <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=5.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">370 tickets sur Trac</a> et plus de <a href=\"https://github.com/WordPress/gutenberg/compare/v10.8.0...v11.9.0\">1900 <em>pull requests</em> sur GitHub</a>. Merci à toutes et à tous&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/2linctools/\">2linctools</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a>, <a href=\"https://profiles.wordpress.org/abesell132/\">abesell132</a>, <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a>, <a href=\"https://profiles.wordpress.org/acosmin/\">acosmin</a>, <a href=\"https://profiles.wordpress.org/wpmudev-support8/\">Adam &#8211; WPMU DEV Support</a>, <a href=\"https://profiles.wordpress.org/bosconiandynamics/\">Adam Bosco</a>, <a href=\"https://profiles.wordpress.org/adam3128/\">Adam Morgan</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zielinski</a>, <a href=\"https://profiles.wordpress.org/addiestavlo/\">Addie</a>, <a href=\"https://profiles.wordpress.org/aadilali/\">Adil Ali</a>, <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a>, <a href=\"https://profiles.wordpress.org/aezazshekh/\">Aezaz Shekh</a>, <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a>, <a href=\"https://profiles.wordpress.org/ajotka/\">ajotka</a>, <a href=\"https://profiles.wordpress.org/soniakash/\">Akash Soni</a>, <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a>, <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a>, <a href=\"https://profiles.wordpress.org/alanjacobmathew/\">Alan Jacob Mathew</a>, <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a>, <a href=\"https://profiles.wordpress.org/alexvorn2/\">Alexandru Vornicescu</a>, <a href=\"https://profiles.wordpress.org/alexeydemidov/\">alexeydemidov</a>, <a href=\"https://profiles.wordpress.org/alexislloyd/\">Alexis Lloyd</a>, <a href=\"https://profiles.wordpress.org/alexstine/\">alexstine</a>, <a href=\"https://profiles.wordpress.org/algala/\">AlGala</a>, <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a>, <a href=\"https://profiles.wordpress.org/almendron/\">almendron</a>, <a href=\"https://profiles.wordpress.org/amandariu/\">Amanda Riu</a>, <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a>, <a href=\"https://profiles.wordpress.org/nosolosw/\">André</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a>, <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/anevins/\">Andrew Nevins</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a>, <a href=\"https://profiles.wordpress.org/oandregal/\">André</a>, <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a>, <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a>, <a href=\"https://profiles.wordpress.org/andy-schmidt/\">Andy Schmidt</a>, <a href=\"https://profiles.wordpress.org/andynick/\">andynick</a>, <a href=\"https://profiles.wordpress.org/la-geek/\">Angelika Reisiger</a>, <a href=\"https://profiles.wordpress.org/anjanavasan/\">Anjana Vasan</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a>, <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a>, <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a>, <a href=\"https://profiles.wordpress.org/anthonyeden/\">Anthony Eden</a>, <a href=\"https://profiles.wordpress.org/paranoia1906/\">Anthony Ledesma</a>, <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a>, <a href=\"https://profiles.wordpress.org/antonisme/\">Antonis Lilis</a>, <a href=\"https://profiles.wordpress.org/arena/\">arena</a>, <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a>, <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a>, <a href=\"https://profiles.wordpress.org/ashfame/\">Ashfame</a>, <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a>, <a href=\"https://profiles.wordpress.org/baelx/\">baelx</a>, <a href=\"https://profiles.wordpress.org/allerune/\">Bartlomiej</a>, <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a>, <a href=\"https://profiles.wordpress.org/beaulebens/\">Beau Lebens</a>, <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a>, <a href=\"https://profiles.wordpress.org/utz119/\">Benachi</a>, <a href=\"https://profiles.wordpress.org/benitolopez/\">benitolopez</a>, <a href=\"https://profiles.wordpress.org/rainbowgeek/\">Benjamin Denis</a>, <a href=\"https://profiles.wordpress.org/benjamingosset/\">Benjamin Gosset</a>, <a href=\"https://profiles.wordpress.org/benjaminanakena/\">benjamin.anakena</a>, <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">Bernhard Reiter</a>, <a href=\"https://profiles.wordpress.org/bgardner/\">bgardner</a>, <a href=\"https://profiles.wordpress.org/bijayyadav/\">bijayyadav</a>, <a href=\"https://profiles.wordpress.org/binarykitten/\">BinaryKitten</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a>, <a href=\"https://profiles.wordpress.org/bradparbs/\">Brad Parbs</a>, <a href=\"https://profiles.wordpress.org/bradleyt/\">Bradley Taylor</a>, <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/bravokeyl/\">bravokeyl</a>, <a href=\"https://profiles.wordpress.org/bgoewert/\">Brennan Goewert</a>, <a href=\"https://profiles.wordpress.org/rzen/\">Brian Richards</a>, <a href=\"https://profiles.wordpress.org/bronsonquick/\">bronsonquick</a>, <a href=\"https://profiles.wordpress.org/ribaricplusplus/\">Bruno Ribaric</a>, <a href=\"https://profiles.wordpress.org/brylie/\">Brylie Christopher Oxley</a>, <a href=\"https://profiles.wordpress.org/icaleb/\">Caleb Burks</a>, <a href=\"https://profiles.wordpress.org/calebwoodbridge/\">calebwoodbridge</a>, <a href=\"https://profiles.wordpress.org/carepsules/\">carepsules</a>, <a href=\"https://profiles.wordpress.org/carike/\">Carike</a>, <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a>, <a href=\"https://profiles.wordpress.org/vefusion/\">Carlos Garcia</a>, <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/cdyerkes/\">cdyerkes</a>, <a href=\"https://profiles.wordpress.org/ceyhun0/\">Ceyhun Ozugur</a>, <a href=\"https://profiles.wordpress.org/shireling/\">Chad</a>, <a href=\"https://profiles.wordpress.org/chiaki/\">Chiaki</a>, <a href=\"https://profiles.wordpress.org/chintan1896/\">Chintan hingrajiya</a>, <a href=\"https://profiles.wordpress.org/chipsnyder/\">Chip Snyder</a>, <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloe Bringmann</a>, <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a>, <a href=\"https://profiles.wordpress.org/cklosows/\">Chris Klosowski</a>, <a href=\"https://profiles.wordpress.org/chrisvanpatten/\">Chris Van Patten</a>, <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a>, <a href=\"https://profiles.wordpress.org/christianztamayo/\">Christian Tamayo</a>, <a href=\"https://profiles.wordpress.org/amethystanswers/\">Christina Workman</a>, <a href=\"https://profiles.wordpress.org/vimes1984/\">Christopher Churchill</a>, <a href=\"https://profiles.wordpress.org/clucasrowlands/\">clucasrowlands</a>, <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a>, <a href=\"https://profiles.wordpress.org/callye/\">Collieth Clarke</a>, <a href=\"https://profiles.wordpress.org/collizo4sky/\">Collins Agbonghama</a>, <a href=\"https://profiles.wordpress.org/copons/\">Copons</a>, <a href=\"https://profiles.wordpress.org/coreyw/\">Corey</a>, <a href=\"https://profiles.wordpress.org/cr0ybot/\">Cory Hughart</a>, <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a>, <a href=\"https://profiles.wordpress.org/craigfrancis/\">craigfrancis</a>, <a href=\"https://profiles.wordpress.org/mitogh/\">Crisoforo Gaspar</a>, <a href=\"https://profiles.wordpress.org/critterverse/\">critterverse</a>, <a href=\"https://profiles.wordpress.org/littlebigthing/\">Csaba (LittleBigThings)</a>, <a href=\"https://profiles.wordpress.org/davidszabo/\">Dávid Szabó</a>, <a href=\"https://profiles.wordpress.org/daisyo/\">Daisy Olsen</a>, <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a>, <a href=\"https://profiles.wordpress.org/danfarrow/\">Dan Farrow</a>, <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/danielpost/\">Daniel Post</a>, <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a>, <a href=\"https://profiles.wordpress.org/chthnc/\">Daniel Shaw</a>, <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a>, <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a>, <a href=\"https://profiles.wordpress.org/dariak/\">Daria</a>, <a href=\"https://profiles.wordpress.org/daschmi/\">Daschmi</a>, <a href=\"https://profiles.wordpress.org/datagutten/\">datagutten</a>, <a href=\"https://profiles.wordpress.org/datainterlock/\">datainterlock</a>, <a href=\"https://profiles.wordpress.org/davecpage/\">Dave Page</a>, <a href=\"https://profiles.wordpress.org/davidanderson/\">David Anderson</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a>, <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a>, <a href=\"https://profiles.wordpress.org/dgwyer/\">David Gwyer</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/davidkryzaniak/\">David Kryzaniak</a>, <a href=\"https://profiles.wordpress.org/davidmosterd/\">David Mosterd</a>, <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a>, <a href=\"https://profiles.wordpress.org/dryanpress/\">David Ryan</a>, <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>, <a href=\"https://profiles.wordpress.org/davidwebca/\">davidwebca</a>, <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a>, <a href=\"https://profiles.wordpress.org/deepaklalwani/\">Deepak Lalwani</a>, <a href=\"https://profiles.wordpress.org/denisco/\">Denis Yanchevskiy</a>, <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a>, <a href=\"https://profiles.wordpress.org/dhanendran/\">Dhanendran</a>, <a href=\"https://profiles.wordpress.org/dhusakovic/\">dhusakovic</a>, <a href=\"https://profiles.wordpress.org/diedeexterkate/\">DiedeExterkate</a>, <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a>, <a href=\"https://profiles.wordpress.org/dingo_d/\">dingo-d</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dlt101/\">dlt101</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/donmhico/\">donmhico</a>, <a href=\"https://profiles.wordpress.org/codezen8/\">Donna Botti</a>, <a href=\"https://profiles.wordpress.org/dontgo2sleep/\">dontgo2sleep</a>, <a href=\"https://profiles.wordpress.org/dougwollison/\">Doug Wollison</a>, <a href=\"https://profiles.wordpress.org/dpegasusm/\">dpegasusm</a>, <a href=\"https://profiles.wordpress.org/raubvogel/\">Dr. Ronny Harbich</a>, <a href=\"https://profiles.wordpress.org/dratwas/\">dratwas</a>, <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/drosmog/\">drosmog</a>, <a href=\"https://profiles.wordpress.org/dustinrue/\">dustinrue</a>, <a href=\"https://profiles.wordpress.org/seedsca/\">ecotechie</a>, <a href=\"https://profiles.wordpress.org/ehtis/\">ehtis</a>, <a href=\"https://profiles.wordpress.org/ekojr/\">EkoJR</a>, <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>, <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a>, <a href=\"https://profiles.wordpress.org/empatogen/\">empatogen</a>, <a href=\"https://profiles.wordpress.org/enchiridion/\">Enchiridion</a>, <a href=\"https://profiles.wordpress.org/enej/\">Enej Bajgorić</a>, <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique Sánchez</a>, <a href=\"https://profiles.wordpress.org/erayalakese/\">erayalakese</a>, <a href=\"https://profiles.wordpress.org/teachlynx/\">Eric Malalel</a>, <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a>, <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a>, <a href=\"https://profiles.wordpress.org/etoledo/\">etoledo</a>, <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>, <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a>, <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a>, <a href=\"https://profiles.wordpress.org/fedepia/\">fedepia</a>, <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a>, <a href=\"https://profiles.wordpress.org/felipeloureirosantos/\">Felipe Santos</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a>, <a href=\"https://profiles.wordpress.org/fpcsjames/\">FPCSJames</a>, <a href=\"https://profiles.wordpress.org/piewp/\">fperdaan</a>, <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a>, <a href=\"https://profiles.wordpress.org/fcolombo/\">Francesco</a>, <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">fullofcaffeine</a>, <a href=\"https://profiles.wordpress.org/galbaras/\">Gal Baras</a>, <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a>, <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/gazchap/\">gazchap</a>, <a href=\"https://profiles.wordpress.org/generosus/\">generosus</a>, <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a>, <a href=\"https://profiles.wordpress.org/revgeorge/\">George Hotelling</a>, <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a>, <a href=\"https://profiles.wordpress.org/gilbitron/\">Gilbert Pellegrom</a>, <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a>, <a href=\"https://profiles.wordpress.org/goldsounds/\">goldsounds</a>, <a href=\"https://profiles.wordpress.org/gkloveweb/\">Govind</a>, <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a>, <a href=\"https://profiles.wordpress.org/gregrickaby/\">Greg Rickaby</a>, <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/guillaumeturpin/\">Guillaume TURPIN</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a>, <a href=\"https://profiles.wordpress.org/hansjovisyoast/\">Hans-Christiaan Braun</a>, <a href=\"https://profiles.wordpress.org/haosun/\">haosun</a>, <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh</a>, <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman</a>, <a href=\"https://profiles.wordpress.org/azhiyadev/\">Hauwa Abashiya</a>, <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a>, <a href=\"https://profiles.wordpress.org/henrywright/\">Henry Wright</a>, <a href=\"https://profiles.wordpress.org/herbmiller/\">herbmiller</a>, <a href=\"https://profiles.wordpress.org/hermpheus/\">Herm Martini</a>, <a href=\"https://profiles.wordpress.org/herregroen/\">Herre Groen</a>, <a href=\"https://profiles.wordpress.org/hilayt24/\">hilayt24</a>, <a href=\"https://profiles.wordpress.org/hirofumi2012/\">hirofumi2012</a>, <a href=\"https://profiles.wordpress.org/hitendra-chopda/\">Hitendra Chopda</a>, <a href=\"https://profiles.wordpress.org/h71/\">Hossein Farahani</a>, <a href=\"https://profiles.wordpress.org/htmgarcia/\">htmgarcia</a>, <a href=\"https://profiles.wordpress.org/hudson-atwell/\">Hudson Atwell</a>, <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a>, <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianhayes94/\">ianhayes94</a>, <a href=\"https://profiles.wordpress.org/ianmjones/\">ianmjones</a>, <a href=\"https://profiles.wordpress.org/ignatggeorgiev/\">Ignat Georgiev</a>, <a href=\"https://profiles.wordpress.org/ibenic/\">Igor Benic</a>, <a href=\"https://profiles.wordpress.org/ilovecats7/\">ilovecats7</a>, <a href=\"https://profiles.wordpress.org/infected/\">infected</a>, <a href=\"https://profiles.wordpress.org/ipstenu/\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/iluy/\">Isaac</a>, <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a>, <a href=\"https://profiles.wordpress.org/ismaeld/\">ismaeld</a>, <a href=\"https://profiles.wordpress.org/jdgrimes/\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jackreichert/\">Jack Reichert</a>, <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a>, <a href=\"https://profiles.wordpress.org/jakubtyrcha/\">jakub.tyrcha</a>, <a href=\"https://profiles.wordpress.org/mcjambi/\">Jam Viet</a>, <a href=\"https://profiles.wordpress.org/macmanx/\">James Huff</a>, <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a>, <a href=\"https://profiles.wordpress.org/janthiel/\">Jan Thiel</a>, <a href=\"https://profiles.wordpress.org/janwoostendorp/\">janw.oostendorp</a>, <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a>, <a href=\"https://profiles.wordpress.org/evermail/\">Jason R. Johnston</a>, <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a>, <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a>, <a href=\"https://profiles.wordpress.org/jayupadhyay01/\">Jay Upadhyay</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a>, <a href=\"https://profiles.wordpress.org/teucrium/\">Jean-Philippe</a>, <a href=\"https://profiles.wordpress.org/jblz/\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a>, <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a>, <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a>, <a href=\"https://profiles.wordpress.org/jeremyescott/\">Jeremy Scott</a>, <a href=\"https://profiles.wordpress.org/jeremyyip/\">Jeremy Yip</a>, <a href=\"https://profiles.wordpress.org/amieiro/\">Jesús Amieiro</a>, <a href=\"https://profiles.wordpress.org/engelen/\">Jesper van Engelen</a>, <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a>, <a href=\"https://profiles.wordpress.org/jigneshnakrani/\">Jignesh Nakrani</a>, <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joegasper/\">joegasper</a>, <a href=\"https://profiles.wordpress.org/joelcj91/\">Joel James</a>, <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnillo/\">John Espiritu</a>, <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/zenithcity/\">john zenith</a>, <a href=\"https://profiles.wordpress.org/lwangaman/\">JohnRDOrazio (CLPTE)</a>, <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/jonoaldersonwp/\">Jono Alderson</a>, <a href=\"https://profiles.wordpress.org/joostdevalk/\">Joost de Valk</a>, <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a>, <a href=\"https://profiles.wordpress.org/josklever/\">Jos Klever</a>, <a href=\"https://profiles.wordpress.org/josephdickson/\">Joseph Dickson</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden</a>, <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a>, <a href=\"https://profiles.wordpress.org/jsnajdr/\">jsnajdr</a>, <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a>, <a href=\"https://profiles.wordpress.org/juanruitina/\">juanruitina</a>, <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a>, <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a>, <a href=\"https://profiles.wordpress.org/junaidbhura/\">Junaid Bhura</a>, <a href=\"https://profiles.wordpress.org/nukaga/\">Junko Nukaga</a>, <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a>, <a href=\"https://profiles.wordpress.org/justindocanto/\">Justin DoCanto</a>, <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a>, <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a>, <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a>, <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a>, <a href=\"https://profiles.wordpress.org/kallookoo/\">kallookoo</a>, <a href=\"https://profiles.wordpress.org/akabarikalpesh/\">Kalpesh Akabari</a>, <a href=\"https://profiles.wordpress.org/kaneva/\">kaneva</a>, <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a>, <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a>, <a href=\"https://profiles.wordpress.org/kellychoffman/\">Kelly Hoffman</a>, <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a>, <a href=\"https://profiles.wordpress.org/sourav926/\">Keramot UL Islam</a>, <a href=\"https://profiles.wordpress.org/kingkero/\">kero</a>, <a href=\"https://profiles.wordpress.org/gwwar/\">Kerry Liu</a>, <a href=\"https://profiles.wordpress.org/kevinfodness/\">Kevin Fodness</a>, <a href=\"https://profiles.wordpress.org/keyur5/\">keyur5</a>, <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a>, <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a>, <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a>, <a href=\"https://profiles.wordpress.org/vdwijngaert/\">Koen Van den Wijngaert</a>, <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a>, <a href=\"https://profiles.wordpress.org/kurudrive/\">kurudrive</a>, <a href=\"https://profiles.wordpress.org/kwisatz/\">kwisatz</a>, <a href=\"https://profiles.wordpress.org/devnel/\">Kyle Nel</a>, <a href=\"https://profiles.wordpress.org/kzeni/\">KZeni</a>, <a href=\"https://profiles.wordpress.org/lalitjalandhar/\">lalitjalandhar</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/laxman-prajapati/\">Laxman Prajapati</a>, <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a>, <a href=\"https://profiles.wordpress.org/leogermani/\">leogermani</a>, <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a>, <a href=\"https://profiles.wordpress.org/liammitchell/\">liammitchell</a>, <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a>, <a href=\"https://profiles.wordpress.org/linux4me2/\">linux4me2</a>, <a href=\"https://profiles.wordpress.org/webaxones/\">Loïc Antignac</a>, <a href=\"https://profiles.wordpress.org/loranrendel/\">Loran A. Rendel</a>, <a href=\"https://profiles.wordpress.org/karpstrucking/\">Lucas Karpiuk</a>, <a href=\"https://profiles.wordpress.org/lucasw89/\">lucasw89</a>, <a href=\"https://profiles.wordpress.org/lucatume/\">lucatume</a>, <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a>, <a href=\"https://profiles.wordpress.org/lukecarbis/\">Luke Carbis</a>, <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a>, <a href=\"https://profiles.wordpress.org/luovalabs/\">luovalabs</a>, <a href=\"https://profiles.wordpress.org/lynk/\">lynk</a>, <a href=\"https://profiles.wordpress.org/asif2bd/\">M Asif Rahman</a>, <a href=\"https://profiles.wordpress.org/gorby31/\">Madalin Gorbanescu</a>, <a href=\"https://profiles.wordpress.org/aetherunbound/\">Madison</a>, <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a>, <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a>, <a href=\"https://profiles.wordpress.org/malae/\">Malae</a>, <a href=\"https://profiles.wordpress.org/malthert/\">malthert</a>, <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a>, <a href=\"https://profiles.wordpress.org/manishamakhija/\">Manisha Makhija</a>, <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani</a>, <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a>, <a href=\"https://profiles.wordpress.org/mkaz/\">Marcus Kazmierczak</a>, <a href=\"https://profiles.wordpress.org/marekhrabe/\">Marek Hrabe</a>, <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a>, <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a>, <a href=\"https://profiles.wordpress.org/wetah/\">Mateus Machado Luna</a>, <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a>, <a href=\"https://profiles.wordpress.org/mhuntdesign/\">Matt</a>, <a href=\"https://profiles.wordpress.org/mattchowning/\">Matt Chowning</a>, <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/mattwiebe/\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mattoakley/\">mattoakley</a>, <a href=\"https://profiles.wordpress.org/wppunk/\">Max</a>, <a href=\"https://profiles.wordpress.org/max-dayala/\">MaxD</a>, <a href=\"https://profiles.wordpress.org/maximeculea/\">Maxime Culea</a>, <a href=\"https://profiles.wordpress.org/mclaurent/\">mclaurent</a>, <a href=\"https://profiles.wordpress.org/medusor/\">MEDUSOR</a>, <a href=\"https://profiles.wordpress.org/megphillips91/\">Meg Phillips</a>, <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a>, <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a>, <a href=\"https://profiles.wordpress.org/mgol/\">mgol</a>, <a href=\"https://profiles.wordpress.org/wpscholar/\">Micah Wood</a>, <a href=\"https://profiles.wordpress.org/mdawaffe/\">Michael Adams (mdawaffe)</a>, <a href=\"https://profiles.wordpress.org/tw2113/\">Michael Beckwith</a>, <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a>, <a href=\"https://profiles.wordpress.org/mnelson4/\">Michael Nelson</a>, <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a>, <a href=\"https://profiles.wordpress.org/michelwppi/\">Michel &#8211; xiligroup dev</a>, <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a>, <a href=\"https://profiles.wordpress.org/mikaelmayer/\">mikaelmayer</a>, <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley (a11n)</a>, <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a>, <a href=\"https://profiles.wordpress.org/multidots1896/\">Minal Diwan</a>, <a href=\"https://profiles.wordpress.org/0mirka00/\">mirka</a>, <a href=\"https://profiles.wordpress.org/mjaschen/\">mjaschen</a>, <a href=\"https://profiles.wordpress.org/mjulian7/\">mjulian7</a>, <a href=\"https://profiles.wordpress.org/mmxxi/\">mmxxi</a>, <a href=\"https://profiles.wordpress.org/moch11/\">moch11</a>, <a href=\"https://profiles.wordpress.org/opurockey/\">Mohammad Rockeybul Alam</a>, <a href=\"https://profiles.wordpress.org/mt8biz/\">moto hachi</a>, <a href=\"https://profiles.wordpress.org/computerguru/\">mqudsi</a>, <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a>, <a href=\"https://profiles.wordpress.org/mrjoeldean/\">mrjoeldean</a>, <a href=\"https://profiles.wordpress.org/mtoensing/\">mtoensing</a>, <a href=\"https://profiles.wordpress.org/wparslan/\">Muhammad Arslan</a>, <a href=\"https://profiles.wordpress.org/muhammadfaizanhaidar/\">Muhammad Faizan Haidar</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/musabshakeel/\">Musab Shakeel</a>, <a href=\"https://profiles.wordpress.org/amustaque97/\">Mustaque Ahmed</a>, <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir</a>, <a href=\"https://profiles.wordpress.org/nalininonstopnewsuk/\">Nalini Thakor</a>, <a href=\"https://profiles.wordpress.org/namithjawahar/\">Namith Jawahar</a>, <a href=\"https://profiles.wordpress.org/nao/\">Naoko Takano</a>, <a href=\"https://profiles.wordpress.org/natewr/\">NateWr</a>, <a href=\"https://profiles.wordpress.org/greatislander/\">Ned Zimmerman</a>, <a href=\"https://profiles.wordpress.org/nettsite/\">NettSite</a>, <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a>, <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a>, <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nickcernis/\">nickcernis</a>, <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a>, <a href=\"https://profiles.wordpress.org/jainnidhi/\">Nidhi Jain</a>, <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a>, <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a>, <a href=\"https://profiles.wordpress.org/nikschavan/\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nlpro/\">nlpro</a>, <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a>, <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a>, <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a>, <a href=\"https://profiles.wordpress.org/omarreiss/\">Omar Reiss</a>, <a href=\"https://profiles.wordpress.org/opr18/\">opr18</a>, <a href=\"https://profiles.wordpress.org/ellenbauer/\">Outzen Larkin</a>, <a href=\"https://profiles.wordpress.org/ov3rfly/\">Ov3rfly</a>, <a href=\"https://profiles.wordpress.org/ovann86/\">ovann86</a>, <a href=\"https://profiles.wordpress.org/ovidiul/\">ovidiul</a>, <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a>, <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a>, <a href=\"https://profiles.wordpress.org/iaaxpage/\">page-carbajal</a>, <a href=\"https://profiles.wordpress.org/palmiak/\">palmiak</a>, <a href=\"https://profiles.wordpress.org/pankajmohale/\">Pankaj Mohale</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/patrick-b/\">Patrick B</a>, <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/pabline/\">Paul Bunkham</a>, <a href=\"https://profiles.wordpress.org/rixeo/\">Paul Kevin</a>, <a href=\"https://profiles.wordpress.org/paulschreiber/\">Paul Schreiber</a>, <a href=\"https://profiles.wordpress.org/pschrottky/\">Paul Von Schrottky</a>, <a href=\"https://profiles.wordpress.org/psrpinto/\">Paulo Pinto</a>, <a href=\"https://profiles.wordpress.org/pbking/\">pbking</a>, <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a>, <a href=\"https://profiles.wordpress.org/pputzer/\">pepe</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/walbo/\">Petter Walbø Johnsgård</a>, <a href=\"https://profiles.wordpress.org/johnstonphilip/\">Phil Johnston</a>, <a href=\"https://profiles.wordpress.org/philipmjackson/\">Philip Jackson</a>, <a href=\"https://profiles.wordpress.org/pierlo/\">Pierre Gordon</a>, <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a>, <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a>, <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a>, <a href=\"https://profiles.wordpress.org/powerbuoy/\">powerbuoy</a>, <a href=\"https://profiles.wordpress.org/praem90/\">praem90</a>, <a href=\"https://profiles.wordpress.org/promz/\">Pramod Jodhani</a>, <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a>, <a href=\"https://profiles.wordpress.org/procodewp/\">procodewp</a>, <a href=\"https://profiles.wordpress.org/psealock/\">psealock</a>, <a href=\"https://profiles.wordpress.org/psufan/\">psufan</a>, <a href=\"https://profiles.wordpress.org/pwtyler/\">pwtyler</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/radixweb/\">Radixweb</a>, <a href=\"https://profiles.wordpress.org/rtm909/\">Rahul Mehta</a>, <a href=\"https://profiles.wordpress.org/ralucastn/\">ralucastn</a>, <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a>, <a href=\"https://profiles.wordpress.org/ramonopoly/\">ramonopoly</a>, <a href=\"https://profiles.wordpress.org/ravipatel/\">ravipatel</a>, <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a>, <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a>, <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rianrietveld/\">Rian Rietveld</a>, <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a>, <a href=\"https://profiles.wordpress.org/richardfoley/\">Richard Foley</a>, <a href=\"https://profiles.wordpress.org/richards1052/\">richards1052</a>, <a href=\"https://profiles.wordpress.org/rickcurran/\">Rick Curran</a>, <a href=\"https://profiles.wordpress.org/rbrishabh/\">Rishabh Budhiraja</a>, <a href=\"https://profiles.wordpress.org/saju4wordpress/\">Riyadh Ahmed</a>, <a href=\"https://profiles.wordpress.org/rmartinezduque/\">rmartinezduque</a>, <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a>, <a href=\"https://profiles.wordpress.org/robertghetau/\">robertght</a>, <a href=\"https://profiles.wordpress.org/robtarr/\">robtarr</a>, <a href=\"https://profiles.wordpress.org/kreppar/\">Rodrigo Arias</a>, <a href=\"https://profiles.wordpress.org/rohan013/\">Rohan Rawat</a>, <a href=\"https://profiles.wordpress.org/rhnsharma/\">Rohan Sharma</a>, <a href=\"https://profiles.wordpress.org/ronakganatra/\">Ronak Ganatra</a>, <a href=\"https://profiles.wordpress.org/rkohilakis/\">Roxy Kohilakis</a>, <a href=\"https://profiles.wordpress.org/russhylov/\">Ruslan</a>, <a href=\"https://profiles.wordpress.org/rviscomi/\">rviscomi</a>, <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/skierpage/\">S Page</a>, <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a>, <a href=\"https://profiles.wordpress.org/soean/\">Sören Wrede</a>, <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a>, <a href=\"https://profiles.wordpress.org/sabrib/\">Sabri Bouchaala</a>, <a href=\"https://profiles.wordpress.org/zeo/\">Safirul Alredha</a>, <a href=\"https://profiles.wordpress.org/solarissmoke/\">Samir Shah</a>, <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a>, <a href=\"https://profiles.wordpress.org/sandipmondal/\">Sandip Mondal &#8211; a11n</a>, <a href=\"https://profiles.wordpress.org/sanketchodavadiya/\">Sanket Chodavadiya</a>, <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a>, <a href=\"https://profiles.wordpress.org/sarayourfriend/\">sarayourfriend</a>, <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiyamoorthy V</a>, <a href=\"https://profiles.wordpress.org/savicmarko1985/\">savicmarko1985</a>, <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a>, <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a>, <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a>, <a href=\"https://profiles.wordpress.org/scruffian/\">scruffian</a>, <a href=\"https://profiles.wordpress.org/seanmcmillan/\">Sean McMillan</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/omaeyusuke/\">Segayuu</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/sergiocinos/\">Sergio Cinos</a>, <a href=\"https://profiles.wordpress.org/sergioestevao/\">SergioEstevao</a>, <a href=\"https://profiles.wordpress.org/shaharyar10/\">Shaharyar Afzal</a>, <a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a>, <a href=\"https://profiles.wordpress.org/shohag121/\">Shazahanul Islam Shohag</a>, <a href=\"https://profiles.wordpress.org/shimon246/\">shimon246</a>, <a href=\"https://profiles.wordpress.org/shital-patel/\">Shital Marakana</a>, <a href=\"https://profiles.wordpress.org/shivapoudel/\">Shiva Poudel</a>, <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth</a>, <a href=\"https://profiles.wordpress.org/nomnom99/\">Siddharth Thevaril</a>, <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a>, <a href=\"https://profiles.wordpress.org/simonhammes/\">simonhammes</a>, <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a>, <a href=\"https://profiles.wordpress.org/siobhan/\">Siobhan</a>, <a href=\"https://profiles.wordpress.org/sirreal/\">sirreal</a>, <a href=\"https://profiles.wordpress.org/sjlevy/\">sjlevy</a>, <a href=\"https://profiles.wordpress.org/skunkbad/\">skunkbad</a>, <a href=\"https://profiles.wordpress.org/smit08/\">Smit Rathod</a>, <a href=\"https://profiles.wordpress.org/snapfractalpop/\">snapfractalpop</a>, <a href=\"https://profiles.wordpress.org/sourovroy/\">Sourov Roy</a>, <a href=\"https://profiles.wordpress.org/spytzo/\">spytzo</a>, <a href=\"https://profiles.wordpress.org/ssergei/\">ssergei</a>, <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a>, <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a>, <a href=\"https://profiles.wordpress.org/hypest/\">Stefanos Togoulidis</a>, <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/strider72/\">Stephen Rider</a>, <a href=\"https://profiles.wordpress.org/dufresnesteven/\">Steve Dufresne</a>, <a href=\"https://profiles.wordpress.org/stevehenty/\">Steve Henty</a>, <a href=\"https://profiles.wordpress.org/stevegs/\">stevegs</a>, <a href=\"https://profiles.wordpress.org/stormrockwell/\">Storm Rockwell</a>, <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a>, <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a>, <a href=\"https://profiles.wordpress.org/szaqal21/\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/tacoverdo/\">Taco Verdonschot</a>, <a href=\"https://profiles.wordpress.org/takahashi_fumiki/\">Takahashi Fumiki</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/sparklingrobots/\">Tara King</a>, <a href=\"https://profiles.wordpress.org/tareiking/\">Tarei King</a>, <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a>, <a href=\"https://profiles.wordpress.org/terraling/\">terraling</a>, <a href=\"https://profiles.wordpress.org/terriann/\">Terri Ann</a>, <a href=\"https://profiles.wordpress.org/wildworks/\">Tetsuaki Hamano</a>, <a href=\"https://profiles.wordpress.org/themiked/\">theMikeD</a>, <a href=\"https://profiles.wordpress.org/tweetythierry/\">Thierry Muller</a>, <a href=\"https://profiles.wordpress.org/thulshof/\">Thijs Hulshof</a>, <a href=\"https://profiles.wordpress.org/thimalw/\">Thimal Wickremage</a>, <a href=\"https://profiles.wordpress.org/thisiswilliam/\">thisiswilliam</a>, <a href=\"https://profiles.wordpress.org/thomasplevy/\">Thomas Patrick Levy</a>, <a href=\"https://profiles.wordpress.org/timlappe/\">timlappe</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/titsmaker/\">titsmaker</a>, <a href=\"https://profiles.wordpress.org/tjcafferkey/\">tjcafferkey</a>, <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a>, <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a>, <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a>, <a href=\"https://profiles.wordpress.org/tomalec/\">Tomek</a>, <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a>, <a href=\"https://profiles.wordpress.org/starbuck/\">Tony G</a>, <a href=\"https://profiles.wordpress.org/ttahmouch/\">Tony Tahmouch</a>, <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a>, <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a>, <a href=\"https://profiles.wordpress.org/sierratr/\">Tracy</a>, <a href=\"https://profiles.wordpress.org/travisnorthcutt/\">Travis Northcutt</a>, <a href=\"https://profiles.wordpress.org/tubys/\">tubys</a>, <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a>, <a href=\"https://profiles.wordpress.org/twstokes/\">twstokes</a>, <a href=\"https://profiles.wordpress.org/desaiuditd/\">Udit Desai</a>, <a href=\"https://profiles.wordpress.org/umesh84/\">umesh84</a>, <a href=\"https://profiles.wordpress.org/devutpol/\">Utpol Deb Nath</a>, <a href=\"https://profiles.wordpress.org/webulous/\">Venkat Raj</a>, <a href=\"https://profiles.wordpress.org/versusbassz/\">versusbassz</a>, <a href=\"https://profiles.wordpress.org/bartoszgrzesik/\">verybg</a>, <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a>, <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a>, <a href=\"https://profiles.wordpress.org/vishitshah/\">Vishit Shah</a>, <a href=\"https://profiles.wordpress.org/vladytimy/\">Vlad T</a>, <a href=\"https://profiles.wordpress.org/vondelphia/\">Vondelphia.com</a>, <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a>, <a href=\"https://profiles.wordpress.org/wb1234/\">wb1234</a>, <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a>, <a href=\"https://profiles.wordpress.org/west7/\">Wes Theron</a>, <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/wfmattr/\">WFMattR</a>, <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a>, <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a>, <a href=\"https://profiles.wordpress.org/wojsmol/\">wojsmol</a>, <a href=\"https://profiles.wordpress.org/woodyhayday/\">woodyhayday</a>, <a href=\"https://profiles.wordpress.org/wp_kc/\">wp_kc</a>, <a href=\"https://profiles.wordpress.org/wpnomad/\">wpnomad a11n</a>, <a href=\"https://profiles.wordpress.org/wpweaver/\">wpweaver</a>, <a href=\"https://profiles.wordpress.org/yagniksangani/\">Yagnik Sangani</a>, <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a>, <a href=\"https://profiles.wordpress.org/yvettesonneveld/\">Yvette Sonneveld</a>, <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a>, and <a href=\"https://profiles.wordpress.org/zoiec/\">zoiec</a>.</p>\n\n\n\n<p>Lors de la publication de ce communiqué de presse officiel, WordPress 5.9 est déjà disponible dans 71 langues ayant traduit 90&nbsp;% ou plus de la version. Les traductrices et traducteurs de la communauté travaillent dur pour vous permettre d’utiliser WordPress dans votre langue natale.</p>\n\n\n\n<p>Merci en particulier à toutes les personnes qui ont aidé à traduire WordPress 5.9 en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">FX Bénard</a>, <a href=\"https://profiles.wordpress.org/wolforg\">Didier Demory</a>, <a href=\"https://profiles.wordpress.org/arpe5\">Arpe5</a>,&nbsp;<a href=\"https://profiles.wordpress.org/btpub\">Bruno Tritsch</a>,&nbsp;<a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>,&nbsp;<a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>,&nbsp;<a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>,&nbsp;<a href=\"https://profiles.wordpress.org/guerneves\">guerneves</a>,&nbsp;<a href=\"https://profiles.wordpress.org/juliobox\">Julio Potier</a>,&nbsp;<a href=\"https://profiles.wordpress.org/webaxones\">Loïc Antignac</a>,&nbsp;<a href=\"https://profiles.wordpress.org/oellin\">Magali</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nuryko\">Marianna</a>,&nbsp;<a href=\"https://profiles.wordpress.org/chaton666\">Marie Comet</a>,&nbsp;<a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nicolasricher\">Nicolas Richer</a>,&nbsp;<a href=\"https://profiles.wordpress.org/larrach\">Rachel Peter</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>,&nbsp;<a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>,&nbsp;<a href=\"https://profiles.wordpress.org/valer1e\">valer1e</a>,&nbsp;<a href=\"https://profiles.wordpress.org/weartdevelopment\">WeArt Development</a>, et&nbsp;<a href=\"https://profiles.wordpress.org/wplmillet\">wplmillet</a>.</p>\n\n\n\n<p>Merci également aux personnes qui contribuent bénévolement aux <a href=\"https://wordpress.org/support/\">forums de support officiels</a>. Elles répondent aux questions que se posent les gens qui utilisent WordPress partout dans le monde. Cela entretien le succès de WordPress depuis la toute première version sortie en 2003.</p>\n\n\n\n<p><em>Si vous souhaitez contribuer à WordPress, nous vous invitons à découvrir le fonctionnement de ce CMS open source sur le site <a href=\"https://make.wordpress.org/\">Make WordPress</a> et à en savoir plus sur le fonctionnement de l’équipe cœur de WP sur son <a href=\"https://make.wordpress.org/core/\">blog de développement</a>.</em></p>\n\n\n\n<p>Bonne mise à jour&nbsp;!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://fr.wordpress.org/2022/01/25/wordpress-5-9/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WordPress 5.9 : documentation en français des fonctionnalités de l’éditeur de site\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"https://fr.wordpress.org/2022/01/17/wordpress-5-9-documentation-en-francais-des-fonctionnalites-de-lediteur-de-site/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"https://fr.wordpress.org/2022/01/17/wordpress-5-9-documentation-en-francais-des-fonctionnalites-de-lediteur-de-site/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 17 Jan 2022 15:40:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2304\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:374:\"À quelques jours de la sortie de WordPress 5.9 (prévue mardi 25 janvier 2022), l’équipe de documentation de WordPress en français vient de publier de nouveaux contenus afin de documenter les nouveautés de cette version. Ces pages de documentation sont enrichies de nombreuses captures d’écran et de quelques vidéos, et sont en particulier destinées aux [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3539:\"\n<p>À quelques jours de la sortie de WordPress 5.9 (prévue mardi 25 janvier 2022), l’équipe de documentation de WordPress en français vient de publier de nouveaux contenus afin de documenter les nouveautés de cette version.</p>\n\n\n\n<span id=\"more-2304\"></span>\n\n\n\n<p>Ces pages de documentation sont enrichies de nombreuses captures d’écran et de quelques vidéos, et sont en particulier destinées aux profils de webmasters.</p>\n\n\n\n<p>Si vous avez un profil plus technique nous vous conseillons également la lecture de <a href=\"https://fr.wordpress.org/2022/01/12/guide-des-changements-techniques-a-venir-sur-wordpress-5-9/\" data-type=\"post\" data-id=\"2264\">cet article détaillant les changements techniques à venir sur WordPress 5.9</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"la-fonctionnalite-d-edition-complete-de-site-full-site-editing\">La fonctionnalité d’édition complète de site (<em>full site editing</em>)</h2>\n\n\n\n<p>Avec WordPress 5.9, de nouvelles fonctionnalités font leur apparition dans votre éditeur et vont vous permettre de modifier l’apparence et la mise en page de l’ensemble de votre site (vous retrouverez souvent ce concept sous son appellation anglophone <em>full site editing</em>), de l’en-tête au pied de page, en passant par la création de vos propres modèles de pages personnalisés.</p>\n\n\n\n<p>Avec ces nouvelles pages de documentation, vous pourrez avoir une connaissance plus précise de ce que propose l’<a href=\"https://fr.wordpress.org/support/article/site-editor/\">éditeur de site</a>, de ce que sont les <a href=\"https://fr.wordpress.org/support/article/theme-base-sur-des-blocs/\">thèmes basés sur des blocs</a>, mais aussi avoir une <a href=\"https://fr.wordpress.org/support/article/styles-overview/\">vue d’ensemble des styles globaux</a>, de comprendre comment utiliser <a href=\"https://fr.wordpress.org/support/article/template-editor/\">l’éditeur de modèles</a>, et de prendre en main les nouveaux blocs avancés&nbsp;: le <a href=\"https://fr.wordpress.org/support/article/navigation-block/\">bloc Navigation</a>, le <a href=\"https://fr.wordpress.org/support/article/template-part-block/\">bloc Élément de modèle</a>, ou encore le <a href=\"https://fr.wordpress.org/support/article/query-loop-block/\">bloc Boucle de requête</a>.</p>\n\n\n\n<p>Vous retrouverez toutes ces pages dans la nouvelle catégorie <a href=\"https://fr.wordpress.org/support/category/editeur-de-site/\">Éditeur de site</a> au sein de la documentation officielle de WordPress en français.</p>\n\n\n\n<p>Merci à toutes les personnes qui ont contribué à l’écriture ou à la relecture de ces nouvelles pages de documentation&nbsp;: <a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/pasglop\">Patrick Olivaud</a>, <a href=\"https://profiles.wordpress.org/chaton666\">Marie Comet</a>, <a href=\"https://profiles.wordpress.org/wolforg\">Didier Demory</a>, <a href=\"https://profiles.wordpress.org/webaxones\">Loïc Antignac</a> et <a href=\"https://profiles.wordpress.org/valer1e/\">Valérie Galassi</a>.</p>\n\n\n\n<p>Si vous avez des suggestions d’améliorations et de corrections, vous pouvez rejoindre l’équipe de documentation de WordPress en français sur le <a href=\"https://wpfr.net/slack\">Slack WordPress francophone</a>, canal <code>#documentation-fr</code>.</p>\n\n\n\n<p class=\"has-text-align-right has-small-font-size\">Communiqué co-rédigé par Jenny Dupuy et Jb Audras</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"https://fr.wordpress.org/2022/01/17/wordpress-5-9-documentation-en-francais-des-fonctionnalites-de-lediteur-de-site/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://fr.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 25 Apr 2023 17:27:31 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Thu, 30 Mar 2023 12:54:27 GMT\";s:4:\"link\";s:61:\"<https://fr.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20230424172636\";}", "no");
INSERT INTO `bd_options` VALUES("2570", "_transient_timeout_feed_mod_0d2db5fea5a8633b56992c916819b198", "1682486852", "no");
INSERT INTO `bd_options` VALUES("2571", "_transient_feed_mod_0d2db5fea5a8633b56992c916819b198", "1682443652", "no");
INSERT INTO `bd_options` VALUES("2572", "_transient_timeout_feed_48c2a7450ae14f12ef8a9b58ca9f0748", "1682486852", "no");
INSERT INTO `bd_options` VALUES("2573", "_transient_feed_48c2a7450ae14f12ef8a9b58ca9f0748", "a:4:{s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"feed\";a:1:{i:0;a:6:{s:4:\"data\";s:126:\"\n    \n    \n    \n    \n    \n    \n\n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"subtitle\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:36:\"https://rss.wpfr.net/feed/wp-planet/\";s:3:\"rel\";s:4:\"self\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"https://rss.wpfr.net/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2023-04-25T17:28:39+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"\n        WP RSS Aggregator\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"uri\";s:27:\"https://wprssaggregator.com\";s:7:\"version\";s:6:\"4.23.1\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"entry\";a:10:{i:0;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"https://wpmarmite.com/changer-identifiant-wordpress/?utm_source=rss&#038;utm_medium=rss&%23038;utm_campaign=changer-identifiant-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"Comment changer votre identifiant WordPress ?\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:137:\"https://wpmarmite.com/changer-identifiant-wordpress/?utm_source=rss&#038;utm_medium=rss&%23038;utm_campaign=changer-identifiant-wordpress\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2023-04-25T08:00:00.000+02:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2023-04-25T08:00:00.000+02:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:382:\"Un champ grisé. L’impossibilité de cliquer dans ce fameux champ pour tenter d’écrire quelque chose. Et ce message qui s’affiche, comme une fin de non-recevoir : « Les identifiants ne peuvent pas être modifiés. »  Si vous avez un jour...\nComment changer votre identifiant WordPress ? est un article de WPMarmite, le blog qui vous aide à tirer le meilleur de WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:765:\"\n        <p><img width=\"1500\" height=\"830\" src=\"https://wpmarmite.com/wp-content/uploads/2023/04/cover-wordpress-username-update.jpg\" class=\"attachment-full size-full wp-post-image\" alt=\"Changer identifiant WordPress\" //></p>\n<p>Un champ grisé. L’impossibilité de cliquer dans ce fameux champ pour tenter d’écrire quelque chose. Et ce message qui s’affiche, comme une fin de non-recevoir : « Les identifiants ne peuvent pas être modifiés. »&nbsp; Si vous avez un jour...</p>\n<p><a rel=\"nofollow\" href=\"https://wpmarmite.com/changer-identifiant-wordpress/\">Comment changer votre identifiant WordPress ?</a> est un article de <a rel=\"nofollow\" href=\"https://wpmarmite.com\">WPMarmite</a>, le blog qui vous aide à tirer le meilleur de WordPress.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Thibaut &amp;#124; WPMarmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"http://feedpress.me/WPMarmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"WP Marmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:1;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://www.seomix.fr/optimiser-arborescence-site-web/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"Arborescence d’un site web : comment bien l’optimiser ?\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:54:\"https://www.seomix.fr/optimiser-arborescence-site-web/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2023-04-19T07:30:00.000+02:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2023-04-19T07:30:00.000+02:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:862:\"Il existe plusieurs optimisations SEO à effectuer sur un site web pour avoir de la visibilité dans les moteurs de recherche : optimisations techniques, optimisations sémantiques, netlinking, maillage interne, mais l’arborescence est un élément central ! En effet, c’est par là que Google et les internautes vont découvrir la plupart des pages et URL d’un site internet. Mettre en place une arborescence optimisée vous donnera plus de chances d’être bien positionné en référencement naturel. Dans cet article, vous trouverez donc les meilleurs conseils pour optimiser au mieux votre arborescence web et avoir un référencement Google optimal. Qu’est-ce qu’une arborescence d’un site web ? Tout d’abord, pour introduire le sujet de cet article, nous […]Lire la suite : Arborescence d’un site web : comment bien l’optimiser ?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:1219:\"\n        <div><img width=\"180\" height=\"101\" src=\"https://www.seomix.fr/wp-content/uploads/2023/04/arborescence-site-web-180x101.png\" class=\"attachment-thumbnail size-thumbnail wp-post-image\" alt=\"arborescence site web\"/></div>Il existe plusieurs optimisations SEO à effectuer sur un site web pour avoir de la visibilité dans les moteurs de recherche&#160;: optimisations techniques, optimisations sémantiques, netlinking, maillage interne, mais l’arborescence est un élément central&#160;! En effet, c&#8217;est par là que Google et les internautes vont découvrir la plupart des pages et URL d&#8217;un site internet. Mettre en place une arborescence optimisée vous donnera plus de chances d’être bien positionné en référencement naturel. Dans cet article, vous trouverez donc les meilleurs conseils pour optimiser au mieux votre arborescence web et avoir un référencement Google optimal. Qu’est-ce qu’une arborescence d’un site web&#160;? Tout d’abord, pour introduire le sujet de cet article, nous [&#8230;]<br><strong>Lire la suite : </strong><a href=\"https://www.seomix.fr/optimiser-arborescence-site-web/\">Arborescence d’un site web&#160;: comment bien l&#8217;optimiser&#160;?</a>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Morgane Voisin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://www.seomix.fr/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"SeoMix\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:2;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"https://wpchannel.com/woocommerce/plugins-woocommerce/configurer-prix-remises-dynamiques-woocommerce-dynamic-pricing-discounts/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"Comment configurer des prix et des remises dynamiques avec WooCommerce Dynamic Pricing &amp; Discounts\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:127:\"https://wpchannel.com/woocommerce/plugins-woocommerce/configurer-prix-remises-dynamiques-woocommerce-dynamic-pricing-discounts/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2023-04-16T11:20:14.000+02:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2023-04-16T11:20:14.000+02:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:152:\"Si vous gérez une boutique en ligne, vous savez que proposer des réductions et des promotions peut être un excellent moyen d’attirer de nouveaux...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:379:\"\n        <div class=\"post-thumbnail\"><img width=\"1024\" height=\"724\" src=\"https://wpchannel.com/images/2023/04/shop-with-lot-of-products-1024x724.png\" class=\"attachment-medium size-medium wp-post-image\" alt=\"\" //></div>Si vous gérez une boutique en ligne, vous savez que proposer des réductions et des promotions peut être un excellent moyen d&#8217;attirer de nouveaux...\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Aurélien Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wpchannel.com/feed\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"WP channel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:3;a:6:{s:4:\"data\";s:57:\"\n    \n    \n    \n    \n    \n    \n    \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:8:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://api.follow.it/track-rss-story-click/v3/8GP0TN3yObhajuOOTD9wfwVLTsI7B9NX\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Autoremove Attachments\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:79:\"https://api.follow.it/track-rss-story-click/v3/8GP0TN3yObhajuOOTD9wfwVLTsI7B9NX\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2023-04-05T16:35:52.000+02:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2023-04-05T16:35:52.000+02:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Supprimer automatiquement les médias attachés à un contenu supprimé\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:271:\"\n        <img src=\"https://api.follow.it/track-rss-story-loaded/v1/9FyjRPcl0W-OYI1S_2uFIZs0ohxaO6Yr\" border=\"0\" width=\"1\" height=\"1\" alt=\"Autoremove Attachments\" title=\"Autoremove Attachments\"/> Supprimer automatiquement les médias attachés à un contenu supprimé\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://feeds.feedburner.com/LechodespluginsWp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"L’écho des plugins WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:4;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://jeanbaptisteaudras.com/2023/04/contribution-stats-for-wordpress-6-2-dolphy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Contribution Stats for WordPress 6.2 « Dolphy »\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:83:\"https://jeanbaptisteaudras.com/2023/04/contribution-stats-for-wordpress-6-2-dolphy/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2023-04-01T09:17:30.000+02:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2023-04-01T09:17:30.000+02:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:536:\"L’article Contribution Stats for WordPress 6.2 « Dolphy » provient de Jean-Baptiste Audras - CTO @ Whodunit & WordPress Core Developer\nWordPress 6.2 « Dolphy » was released on March 29, 2023. This version is named « Dolphy », after the American jazzer pianist Eric Allan Dolphy Jr. I was involved in this release as Tech Lead and as a core committer. It was a pleasure to […]\nL’article Contribution Stats for WordPress 6.2 « Dolphy » provient de Jean-Baptiste Audras - CTO @ Whodunit & WordPress Core Developer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:15867:\"\n        <p>L’article <a rel=\"nofollow\" href=\"https://jeanbaptisteaudras.com/2023/04/contribution-stats-for-wordpress-6-2-dolphy/\">Contribution Stats for WordPress 6.2 « Dolphy »</a> provient de <a rel=\"nofollow\" href=\"https://jeanbaptisteaudras.com\">Jean-Baptiste Audras - CTO @ Whodunit &amp; WordPress Core Developer</a></p>\n\n<p>WordPress 6.2 «&nbsp;Dolphy&nbsp;»&nbsp;was released on March 29, 2023. This version is named&nbsp;<em>«&nbsp;Dolphy&nbsp;»</em>, after the American jazzer pianist Eric Allan Dolphy <abbr title=\"Junior\">Jr</abbr>.</p>\n\n\n\n<p>I was involved in this release as <em>Tech Lead</em> and as a <a href=\"https://github.com/WordPress/wordpress-develop/commits?author=audrasjb\">core committer</a>. It was a pleasure to work with the release squad. A big <em>thank you</em> to all the talented people who worked hard to put together WP&nbsp;6.2 <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2764.png\" alt=\"❤\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //></p>\n\n\n\n<p>As for previous releases, let’s have a look on a few stats about this release.</p>\n\n\n\n<p>In the past, I already published some contributions stats for versions&nbsp;<a href=\"https://jeanbaptisteaudras.com/en/2019/11/distribution-of-wordpress-5-3-contributors-by-country-2/\">5.3</a>,&nbsp;<a href=\"https://jeanbaptisteaudras.com/en/2020/03/wordpress-5-4-core-contribution-statistics/\">5.4</a>,&nbsp;<a href=\"https://jeanbaptisteaudras.com/en/2020/08/wordpress-5-5-core-stats-contributions-by-country-company/\">5.5</a>,&nbsp;<a href=\"https://jeanbaptisteaudras.com/en/2020/12/wordpress-5-6-core-stats-contributions-by-country-company/\">5.6</a>,&nbsp;<a href=\"https://datastudio.google.com/u/0/reporting/a496c333-7e64-412c-9299-9ea2c84e5d2c/page/j595B\">5.7</a>, <a href=\"https://jeanbaptisteaudras.com/en/2022/01/wordpress-5-9-core-contribution-statistics/\">5.9</a>, <a href=\"https://jeanbaptisteaudras.com/en/2022/05/wp-6-0-arturo-contribution-stats/\">6.0</a> and <a href=\"https://jeanbaptisteaudras.com/en/2022/11/contribution-stats-for-wordpress-6-1-misha/\">6.1</a>. I did it again for WP 6.2, so we can have an eye on the relative « influence » of countries and companies on WordPress Core.</p>\n\n\n\n<p>Before diving into WordPress 6.2 Core contributions stats, I wanted to share a few disclaimers, for better context:</p>\n\n\n\n<ul>\n<li>These stats were generated after the last Release Candidate of WP 6.2. Thanks to <a href=\"https://profiles.wordpress.org/desrosj/\" target=\"_blank\" rel=\"noreferrer noopener\">Jon</a> who collected the props list for the release squad.</li>\n\n\n\n<li>These statistics only relate to Core contributions (= props gained for source code contributions) of WordPress. There is a lot of other types of contributions, not listed here: marketing, communication, translation, testing…</li>\n\n\n\n<li>To get these stats, I parsed the WordPress.org profile page of each contributor to get some public informations about them: country, employer, and wether they already contributed to WordPress Core or not.</li>\n\n\n\n<li>It includes both Core contributions on Trac and Gutenberg pull requests on GitHub.</li>\n\n\n\n<li>Those stats are based on what’s declared in each contributors’s wp.org profile.&nbsp;<strong>Users with empty profile informations are not taken into account.</strong></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading alignwide\">WordPress 6.2 overall stats</h2>\n\n\n\n<div class=\"wp-block-columns alignwide is-layout-flex wp-container-3\">\n<div class=\"wp-block-column is-layout-flow\" style=\"flex-basis:25%\">\n<p><strong>607</strong>&nbsp;<strong>people</strong>&nbsp;from at least&nbsp;<strong>50 countries</strong>&nbsp;and <strong>145 identified companies</strong> contributed to WordPress&nbsp;6.2.</p>\n\n\n\n<p>Worth noting that&nbsp;<strong>178 people contributed to WordPress Core for the very first time!</strong>&nbsp;That’s&nbsp;around&nbsp;<strong>30%</strong>&nbsp;of the total number of contributors!</p>\n\n\n\n<p>The ratio of new contributors represents quite a great onboarding figure for an open-source project!</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow\" style=\"flex-basis:75%\">\n<figure class=\"wp-block-image size-large is-resized\"><a href=\"https://jeanbaptisteaudras.com/2019/wp-content/uploads/2023/04/evolution-release-wp62.svg\"><img src=\"https://jeanbaptisteaudras.com/2019/wp-content/uploads/2023/04/evolution-release-wp62.svg\" alt=\"\" class=\"wp-image-145036\" width=\"783\" height=\"507\" //></a><figcaption class=\"wp-element-caption\">Overall contribution evolution across recent releases</figcaption></figure>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading alignwide\">Country ranking by number of contributions</h2>\n\n\n\n<div class=\"wp-block-columns alignwide is-layout-flex wp-container-6\">\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow\" style=\"flex-basis:33.33%\">\n<p>It’s interesting to see how much WordPress is a worldwide project. Contributions come from all over the planet <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //></p>\n\n\n\n<p><strong>USA</strong>&nbsp;is still number one by far with 803 contributions, and&nbsp;<strong>Russia</strong>&nbsp;comes 2nd with 449 contributions (still led by <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey</a>, the person who made the highest number of individual contributions on this version). <strong>France</strong>&nbsp;follows with 303 contributions, and&nbsp;<strong>Australia</strong>&nbsp;with 241 props.&nbsp;<strong>Bulgaria</strong>, <strong>India</strong>, and <strong>Greece</strong> are following.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow\" style=\"flex-basis:66.66%\">\n<figure class=\"wp-block-image size-large is-resized\"><a href=\"https://jeanbaptisteaudras.com/2019/wp-content/uploads/2023/04/WP62-country-contributions.svg\"><img loading=\"lazy\" src=\"https://jeanbaptisteaudras.com/2019/wp-content/uploads/2023/04/WP62-country-contributions.svg\" alt=\"\" class=\"wp-image-145037\" width=\"691\" height=\"691\" //></a></figure>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading alignwide\">Country ranking by number of contributors</h2>\n\n\n\n<div class=\"wp-block-columns alignwide is-layout-flex wp-container-9\">\n<div class=\"wp-block-column is-layout-flow\" style=\"flex-basis:66.66%\">\n<figure class=\"wp-block-image size-large is-resized\"><a href=\"https://jeanbaptisteaudras.com/2019/wp-content/uploads/2023/04/WP62-country-contributors.svg\"><img loading=\"lazy\" src=\"https://jeanbaptisteaudras.com/2019/wp-content/uploads/2023/04/WP62-country-contributors.svg\" alt=\"\" class=\"wp-image-145039\" width=\"633\" height=\"633\" //></a></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow\" style=\"flex-basis:33.33%\">\n<p>Still, contributions are not everything. <strong>Let&rsquo;s talk about contributors</strong>. Instead of counting contributions, we can count the individuals who worked on this release (=&nbsp;number of people credited in Trac tickets or GitHub PRs)… and we have the following results&nbsp;:</p>\n\n\n\n<p><strong>USA</strong>&nbsp;is still on the top of the game with 91 people. <strong>Bangladesh</strong> overtakes <strong>India</strong> for the first time with 65 contributors (and 49 for India).</p>\n\n\n\n<p>These countries are followed by <strong>Germany</strong> with 18, then <strong>France</strong> and <strong>United Kingdom</strong> with 14 contributors.</p>\n\n\n\n<p>USA still completely dominates the stats by number of independent contributors, and by number of contributions (props count). Contributors from Bangladesh and India also have a great number of people involved, but not so much props.</p>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Company ranking by contributions</h2>\n\n\n\n<p><strong>Automattic</strong> is still the most prolific company with employees credited in no less than 1793 contributions (by 82 contributors), and is followed by plugin editor <strong>Yoast</strong> with 712 contributions (by 11 contributors) and <strong>Whodunit</strong> French agency (280 contributions by 4 people). Next, we have the international WP agencies <strong>10up</strong> (244 contributions by 18 people), hosting companies like <strong>GoDaddy</strong> (156 contributions) or <strong>Bluehost</strong> (111), a freelancer <strong>Advies en zo</strong> (130), and <strong>Google</strong> with 110 contributions.</p>\n\n\n\n<p>Worth noting that major stakeholders can still be categorized in three sorts of companies: agencies, plugins/themes editors and hosting companies. And of course, well… Automattic <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f61c.png\" alt=\"😜\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //></p>\n\n\n\n<p>In the graphic below, you&rsquo;ll see all the company credited in WordPress 6.2 and the number of contributions of their employees.</p>\n\n\n\n<figure class=\"wp-block-image alignwide size-large\"><a href=\"https://jeanbaptisteaudras.com/2019/wp-content/uploads/2023/04/WP62-company-contributions.svg\"><img loading=\"lazy\" width=\"1200\" height=\"1200\" src=\"https://jeanbaptisteaudras.com/2019/wp-content/uploads/2023/04/WP62-company-contributions.svg\" alt=\"\" class=\"wp-image-145044\" //></a></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Company ranking by contributors</h2>\n\n\n\n<p>Of the 145 identified companies that contributed to WordPress 6.2, <strong>Automattic</strong> had by far the largest number of contributors, with 82 people involved. For the first time, <strong>WPDeveloper</strong> is the second biggest company in terms of contributors, with 35 people. <strong>10up</strong> comes third with 18 people. <strong>AuthLab</strong> and <strong>Yoast</strong> come fourth with 11 people. Then, we have <strong>Multidots</strong> and <strong>rtCamp</strong>, with more than 6 contributors.</p>\n\n\n\n<figure class=\"wp-block-image alignwide size-large\"><a href=\"https://jeanbaptisteaudras.com/2019/wp-content/uploads/2023/04/WP62-company-contributors.svg\"><img loading=\"lazy\" width=\"1200\" height=\"1200\" src=\"https://jeanbaptisteaudras.com/2019/wp-content/uploads/2023/04/WP62-company-contributors.svg\" alt=\"\" class=\"wp-image-145047\" //></a></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" //>\n\n\n\n<figure class=\"wp-block-pullquote is-style-default\"><blockquote><p>Thank you to everyone who helped <br>to release WordPress&nbsp;6.2. <br>Big or small, each of the above company contributes <br>to the <a href=\"https://wordpress.org/five-for-the-future/\"><em>Five for the future</em> initiative</a>&nbsp;<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f499.png\" alt=\"💙\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //></p></blockquote></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" //>\n\n\n\n<h2 class=\"wp-block-heading\">Individuals ranking – WordPress&nbsp;6.2</h2>\n\n\n\n<p>Here is the top 30 of WordPress 6.2 contributors. You can also checkout the full table <a href=\"https://docs.google.com/spreadsheets/d/1snF4iV3ejOKvifix5GYD08ydWHHQsIRCYEZPkLMDFCg/edit?usp=sharing\" target=\"_blank\" rel=\"noreferrer noopener nofollow\">on this spreadsheet</a>.</p>\n\n\n\n<figure class=\"wp-block-table alignwide is-style-stripes\"><table class=\"has-fixed-layout\"><thead><tr><th>Contributor</th><th>Contributions</th><th>Country</th><th>Company</th></tr></thead><tbody><tr><td>sergeybiryukov</td><td>448</td><td>Russia</td><td>Yoast</td></tr><tr><td>audrasjb</td><td>277</td><td>France</td><td>Whodunit</td></tr><tr><td>tyxla</td><td>227</td><td>Bulgaria</td><td>Automattic</td></tr><tr><td>costdev</td><td>149</td><td></td><td></td></tr><tr><td>mamaduka</td><td>147</td><td>Georgia</td><td>GoDaddy</td></tr><tr><td>hellofromtonya</td><td>134</td><td>United States</td><td>Automattic</td></tr><tr><td>poena</td><td>130</td><td>Sweden</td><td>Yoast</td></tr><tr><td>jrf</td><td>130</td><td>Netherlands</td><td>Advies en zo</td></tr><tr><td>scruffian</td><td>116</td><td></td><td>Automattic</td></tr><tr><td>desrosj</td><td>111</td><td>United States</td><td>Bluehost</td></tr><tr><td>aristath</td><td>108</td><td>Greece</td><td>Yoast</td></tr><tr><td>mukesh27</td><td>104</td><td>India</td><td>10up</td></tr><tr><td>ntsekouras</td><td>102</td><td>Greece</td><td>Automattic</td></tr><tr><td>peterwilsoncc</td><td>99</td><td>Australia</td><td>10up</td></tr><tr><td>wildworks</td><td>92</td><td>Japan</td><td></td></tr><tr><td>youknowriad</td><td>86</td><td>Algeria</td><td>Automattic</td></tr><tr><td>mciampini</td><td>75</td><td></td><td>Automattic</td></tr><tr><td>justinahinon</td><td>71</td><td>Benin</td><td>WebDevStudios</td></tr><tr><td>flixos90</td><td>69</td><td>United States</td><td>Google</td></tr><tr><td>getdave</td><td>68</td><td></td><td></td></tr><tr><td>spacedmonkey</td><td>66</td><td>United Kingdom</td><td>XWP</td></tr><tr><td>sabernhardt</td><td>61</td><td>United States</td><td></td></tr><tr><td>aaronrobertshaw</td><td>52</td><td></td><td>Automattic</td></tr><tr><td>azaozz</td><td>51</td><td>Canada</td><td>Automattic</td></tr><tr><td>ramonopoly</td><td>50</td><td></td><td></td></tr><tr><td>andraganescu</td><td>50</td><td>Romania</td><td>Automattic</td></tr><tr><td>jsnajdr</td><td>49</td><td></td><td></td></tr><tr><td>jorgefilipecosta</td><td>49</td><td>Portugal</td><td>Automattic</td></tr><tr><td>oandregal</td><td>48</td><td>Spain</td><td>Automattic</td></tr><tr><td>0mirka00</td><td>48</td><td>Japan</td><td>Automattic</td></tr></tbody></table></figure>\n\n\n\n<div class=\"wp-block-group alignfull is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<hr class=\"wp-block-separator has-css-opacity is-style-default\" //>\n\n\n<div class=\"wp-block-image is-style-rounded\">\n<figure class=\"aligncenter size-full is-resized\"><img loading=\"lazy\" src=\"https://jeanbaptisteaudras.com/2019/wp-content/uploads/2019/11/photo-avatar-jb-make-e1598437997298.jpg\" alt=\"Mon texte alternatif\" class=\"wp-image-99017\" width=\"127\" height=\"127\" //></figure></div>\n\n\n<blockquote class=\"wp-block-quote has-text-align-center is-style-large alignwide\">\n<p>I hope you liked that post! Comments &amp; shares are welcome&nbsp;<strong><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f60d.png\" alt=\"😍\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //></strong></p>\n\n\n\n<p><span style=\"color: inherit;font-family: inherit;letter-spacing: -0.0357143em\">You can also </span><a href=\"https://www.paypal.me/audrasjb\" target=\"_blank\" rel=\"noreferrer noopener\">buy me a beer or a coffee</a><span style=\"color: inherit;font-family: inherit;letter-spacing: -0.0357143em\"> if you want <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f37b.png\" alt=\"🍻\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2615.png\" alt=\"☕\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //></span></p>\n\n\n\n<p>Feel free to reuse any graphic or data used in this post, without any limitation. The raw data are available <a href=\"https://docs.google.com/spreadsheets/d/1snF4iV3ejOKvifix5GYD08ydWHHQsIRCYEZPkLMDFCg/edit?usp=sharing\">on this spreadsheet</a>.</p>\n\n\n\n<p>Contact me if you have any question.</p>\n</blockquote>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-default\" //>\n</div></div>\n\n\n\n<figure class=\"wp-block-image alignfull size-large\"><img loading=\"lazy\" width=\"1024\" height=\"401\" src=\"https://jeanbaptisteaudras.com/2019/wp-content/uploads/2023/04/banner-dolphy-wordpress-62-1024x401.png\" alt=\"\" class=\"wp-image-145033\" //></figure>\n<p>L’article <a rel=\"nofollow\" href=\"https://jeanbaptisteaudras.com/2023/04/contribution-stats-for-wordpress-6-2-dolphy/\">Contribution Stats for WordPress 6.2 « Dolphy »</a> provient de <a rel=\"nofollow\" href=\"https://jeanbaptisteaudras.com\">Jean-Baptiste Audras - CTO @ Whodunit &amp; WordPress Core Developer</a></p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"Jb\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://jeanbaptisteaudras.com/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:5;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://www.whodunit.fr/woa-21-les_intelligences-artidicielles-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"WOA ! #21 Les IAs et WordPress\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:73:\"https://www.whodunit.fr/woa-21-les_intelligences-artidicielles-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2023-02-14T09:06:45.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2023-02-14T09:06:45.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:332:\"Notre sujet du jour, c\'est l\'émergence des IAs. Comment peuvent-elles nous aider dans la création d\'un site web quelles sont leurs limites. Pour en discuter avec nous, Bastien développeur et passionné par les nouvelles technologies.\nL’article WOA ! #21 Les IAs et WordPress est apparu en premier sur Agence WordPress Whodunit.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:8986:\"\n        \n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile is-image-fill\" style=\"grid-template-columns:38% auto\" data-block-type=\"core\"><figure class=\"wp-block-media-text__media\" style=\"background-image:url(https://www.whodunit.fr/wp-content/uploads/2023/02/ap_19057452495410-1500x1000-1-1080x720.jpg);background-position:64% 68%\"><img width=\"1080\" height=\"720\" src=\"https://www.whodunit.fr/wp-content/uploads/2023/02/ap_19057452495410-1500x1000-1-1080x720.jpg\" alt=\"\" class=\"wp-image-75499 size-full\" //></figure><div class=\"wp-block-media-text__content\">\n<p style=\"font-style:italic;font-weight:300\">&#8220;Bienvenue à WOA (WordPress On. Air) numéro 21! <br>Je suis votre co-animateur temporaire, remplaçant Eddy qui est en train de se faire remplacer par une IA plus rapide et plus efficace&#8230; (plaisanterie). <br><br>Je co-anime ce podcast avec JB et Simon. <br>Dans ce podcast, nous allons discuter des dernières nouvelles concernant le monde de WordPress, du plugin du mois et nous allons explorer l&#8217;émergence de l&#8217;Intelligence Artificielle dans notre monde actuel et comment elle peut vous aider dans la création de votre site WordPress. <br><br>Nous allons découvrir comment l&#8217;IA peut faciliter tout, de la rédaction de textes à la gestion d&#8217;images en passant par le code. <br><br>Et pour en parler, nous avons le plaisir d&#8217;accueillir Bastien, développeur de chez Whodunit. <br><br>Alors, restez à l&#8217;écoute pour un épisode passionnant sur les IA et WordPress et comment elles sont en train de changer notre monde&#8230; <br><br>Mais ne vous inquiétez pas Eddy, je suis sûr que vous trouverez toujours un endroit pour vous dans ce monde en constante évolution.&#8221;</p>\n</div></div>\n\n\n\n\n\n\n\n<h2 id=\"h-ecoutez-le-podcast-sur\" data-block-type=\"core\">Ecoutez le podcast sur </h2>\n\n\n\n<div class=\"is-layout-flex wp-container-5 wp-block-columns\" data-block-type=\"core\">\n<div class=\"is-layout-flow wp-block-column\" data-block-type=\"core\">\n<figure class=\"wp-block-image size-large\" data-block-type=\"core\"><a href=\"https://podcasts.apple.com/fr/podcast/woa-wordpress-on-air/id1482779414\" target=\"_blank\" rel=\"noopener noreferrer\"><img src=\"https://www.whodunit.fr/wp-content/uploads/2019/10/apple-podcasts-e1571142591535.jpg\" alt=\"\" class=\"wp-image-66447\" //></a></figure>\n</div>\n\n\n\n<div class=\"is-layout-flow wp-block-column\" data-block-type=\"core\">\n<figure class=\"wp-block-image size-large\" data-block-type=\"core\"><a href=\"https://open.spotify.com/show/5rEMqG2cyoKYxpTTUAKSPp\" target=\"_blank\" rel=\"noopener noreferrer\"><img src=\"https://www.whodunit.fr/wp-content/uploads/2019/10/unknown.png\" alt=\"\" class=\"wp-image-66448\" //></a></figure>\n</div>\n\n\n\n<div class=\"is-layout-flow wp-block-column\" data-block-type=\"core\">\n<figure class=\"wp-block-image size-large\" data-block-type=\"core\"><a href=\"https://www.deezer.com/fr/show/586602\" target=\"_blank\" rel=\"noopener noreferrer\"><img src=\"https://www.whodunit.fr/wp-content/uploads/2019/10/deezer-1024x196.png\" alt=\"\" class=\"wp-image-66449\" //></a></figure>\n</div>\n\n\n\n<div class=\"is-layout-flow wp-block-column\" data-block-type=\"core\">\n<figure class=\"wp-block-image size-large\" data-block-type=\"core\"><a href=\"http://podplayer.net/?podId=2447675\" target=\"_blank\" rel=\"noopener noreferrer\"><img src=\"https://www.whodunit.fr/wp-content/uploads/2019/10/podcast-addict-for-windows-pc.jpg\" alt=\"\" class=\"wp-image-66450\" //></a></figure>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-stackable-image stk-block-image stk-block stk-89ce919\" data-block-id=\"89ce919\">.stk-89ce919{margin-bottom:0px !important}<figure class=\"stk-img-wrapper stk-image--shape-stretch\"><img loading=\"lazy\" class=\"stk-img wp-image-75456\" src=\"https://www.whodunit.fr/wp-content/uploads/2023/02/image-6.png\" width=\"1024\" height=\"1024\" //></figure></div>\n\n\n\n<p><em>Image générée sur <a href=\"https://midjourney.com/home/?callbackUrl=%2Fapp%2F\" target=\"_blank\" rel=\"noreferrer noopener\">midjourney</a></em></p>\n\n\n\n<h2 id=\"h-woa-wordpress-on-air-n-21\" data-block-type=\"core\">WOA : WordPress On Air N°21</h2>\n\n\n\n<p>Bonjour à toutes et à tous. <br>Heureux de vous retrouver après une pause un peu longue, on s&#8217;en excuse. <br>Mais on ne revient pas les mains vides, JB a plein d&#8217;infos WordPress à nous partager et Simon nous parle de son extension du mois pour générer des cartes interactives. <br><br>Notre sujet du jour, c&#8217;est l&#8217;émergence des IAs. Comment peuvent-elles nous aider dans la création d&#8217;un site web quelles sont leurs limites. Pour en discuter avec nous, Bastien développeur et passionné par les nouvelles technologies.<br><br>WOA Episode 21, c&#8217;est parti.</p>\n\n\n\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\" data-block-type=\"core\"></div>\n\n\n\n<h2 id=\"h-sommaire-de-l-emission\" data-block-type=\"core\">Sommaire de l&#8217;émission</h2>\n\n\n\n<ul data-block-type=\"core\">\n<li data-block-type=\"core\">Revue de presse, infos :</li>\n\n\n\n<li data-block-type=\"core\">Invité du mois\n<ul data-block-type=\"core\">\n<li data-block-type=\"core\">Bastien Martinent</li>\n</ul>\n</li>\n\n\n\n<li data-block-type=\"core\">Extension du mois\n<ul data-block-type=\"core\">\n<li data-block-type=\"core\">ACF et AmMap</li>\n</ul>\n</li>\n</ul>\n\n\n\n<div style=\"height:17px\" aria-hidden=\"true\" class=\"wp-block-spacer\" data-block-type=\"core\"></div>\n\n\n\n<h2 id=\"h-les-liens-de-l-emission\" data-block-type=\"core\">Les liens de l&#8217;émission</h2>\n\n\n\n<ul data-block-type=\"core\">\n<li data-block-type=\"core\">Revue de presse&nbsp;:\n<ul data-block-type=\"core\">\n<li data-block-type=\"core\"><a href=\"https://make.wordpress.org/core/2023/01/24/proposal-old-tickets-trac-triage-sessions/\">L&#8217;équipe Core de WP s&#8217;attaque au tri des vieux tickets</a></li>\n\n\n\n<li data-block-type=\"core\"><a href=\"https://twitter.com/nickmdiego/status/1616072992122978307\">Le positionnement &#8220;sticky&#8221; s&#8217;invite dans l&#8217;éditeur de WordPress</a></li>\n\n\n\n<li data-block-type=\"core\"><a href=\"https://fr.wordpress.org/plugins/blocks-everywhere/\">L&#8217;extension Blocks Everywhere</a> permet d&#8217;ajouter une version simplifiée de l&#8217;éditeur de blocs sur les commentaires de WP, sur les discussions BuddyPress et sur les forums BBPress</li>\n</ul>\n</li>\n\n\n\n<li data-block-type=\"core\">Extension du mois&nbsp;:\n<ul data-block-type=\"core\">\n<li data-block-type=\"core\"><a href=\"https://wordpress.org/plugins/acf-openstreetmap-field/\">ACF OpenStreetMap Field</a></li>\n\n\n\n<li data-block-type=\"core\"><a href=\"https://www.amcharts.com/docs/v4/chart-types/map/\" target=\"_blank\" rel=\"noreferrer noopener\">AmMap</a></li>\n</ul>\n</li>\n</ul>\n\n\n\n<h2 id=\"h-l-equipe\" data-block-type=\"core\">L&#8217;équipe</h2>\n\n\n\n<p><strong>Simon</strong> est un enfant de <s>la TV</s> Youtube, il s’intéresse à tous les sujets et dévore les podcasts et émissions, que ce soit sur les jeux de société, WordPress, la science ou encore la bière&nbsp;!</p>\n\n\n\n<p><strong>JB</strong> est une encyclopédie sur pattes de son CMS préféré. Devinez ce qu&#8217;il a gravé dans <a href=\"https://twitter.com/AudrasJb/status/1189955528782471169\" target=\"_blank\" rel=\"noreferrer noopener\">sa citrouille</a> pour Halloween&nbsp;?</p>\n\n\n\n<p><strong>Eddy</strong> a goûté au plaisir de la radio pendant plusieurs années, ça le démangeait de reprendre le micro.</p>\n\n\n\n<figure class=\"is-layout-flex wp-block-gallery-6 wp-block-gallery has-nested-images columns-4 is-cropped\" data-block-type=\"core\">\n<figure class=\"wp-block-image size-large\" data-block-type=\"core\"><img loading=\"lazy\" width=\"425\" height=\"425\" data-id=\"69730\" src=\"https://www.whodunit.fr/wp-content/uploads/2021/05/eddy.jpg\" alt=\"\" class=\"wp-image-69730\" //><figcaption class=\"wp-element-caption\">Eddy</figcaption></figure>\n\n\n\n<figure class=\"wp-block-image size-large\" data-block-type=\"core\"><img loading=\"lazy\" width=\"425\" height=\"425\" data-id=\"69748\" src=\"https://www.whodunit.fr/wp-content/uploads/2021/05/simon.jpg\" alt=\"\" class=\"wp-image-69748\" //><figcaption class=\"wp-element-caption\">Simon</figcaption></figure>\n\n\n\n<figure class=\"wp-block-image size-large\" data-block-type=\"core\"><img loading=\"lazy\" width=\"425\" height=\"425\" data-id=\"69738\" src=\"https://www.whodunit.fr/wp-content/uploads/2021/05/jean-baptiste.jpg\" alt=\"\" class=\"wp-image-69738\" //><figcaption class=\"wp-element-caption\">Jb</figcaption></figure>\n</figure>\n\n\n\n<h2 id=\"h-on-attend-vos-retours-avec-impatience\" data-block-type=\"core\">On attend vos retours avec impatience&nbsp;!</h2>\n\n\n\n<p>N&#8217;hésitez pas à laisser un commentaire, ça nous fera plaisir et surtout ça nous aidera à nous améliorer.</p>\n\n\n\n<p>Vous souhaitez intervenir ? Envoyez un mail à eddy@whodunit.fr pour en discuter.</p>\n<p>L’article <a rel=\"nofollow\" href=\"https://www.whodunit.fr/woa-21-les_intelligences-artidicielles-wordpress/\">WOA ! #21 Les IAs et WordPress</a> est apparu en premier sur <a rel=\"nofollow\" href=\"https://www.whodunit.fr\">Agence WordPress Whodunit</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Eddy Boels\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://www.whodunit.fr/podcasts/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Podcast WordPress on Air!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:6;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://www.whodunit.fr/wordpress-le-point-sur-ce-qui-vous-attend-en-2023/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WordPress : le point sur ce qui vous attend en 2023\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:74:\"https://www.whodunit.fr/wordpress-le-point-sur-ce-qui-vous-attend-en-2023/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2023-02-07T11:22:37.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2023-02-07T11:22:37.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:743:\"La sortie en novembre dernier de la version 6.1 de WordPress est l’occasion idéale de faire le point sur le CMS qui a vu le jour en 2003 et qui compte aujourd’hui plus de 60 millions de sites actifs à travers le monde. Il est important voire indispensable d’anticiper les prochaines évolutions de WordPress afin de se poser les bonnes questions, de faire les bons choix techniques, d’informer les clients… Voici pour vous un récapitulatif des nouveautés de WordPress en 2022, une présentation des prochaines fonctionnalités attendues en 2023, le tout agrémenté de quelques spoilers alerts sur le futur de…\nL’article WordPress : le point sur ce qui vous attend en 2023 est apparu en premier sur Agence WordPress Whodunit.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:19809:\"\n        \n<p>La sortie en novembre dernier de la version 6.1 de WordPress est l’occasion idéale de faire le point sur le CMS qui a vu le jour en 2003 et qui compte aujourd’hui plus de 60 millions de sites actifs à travers le monde.</p>\n\n\n\n<p>Il est important voire indispensable d’anticiper les prochaines évolutions de WordPress afin de se poser les bonnes questions, de faire les bons choix techniques, d’informer les clients…</p>\n\n\n\n<p>Voici pour vous un récapitulatif des nouveautés de WordPress en 2022, une présentation des prochaines fonctionnalités attendues en 2023, le tout agrémenté de quelques spoilers alerts sur le futur de WordPress et tout plein de conseils made in Whodunit </p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p><strong>Avec les intervenants : Jean-Baptiste Audras, CTO Whodunit et anciennement représentant Core WordPress et Eddy Boels, Customer Happiness Manager Whodunit </strong></p>\n\n\n\n<figure class=\"wp-block-image size-full\" data-block-type=\"core\"><img loading=\"lazy\" width=\"813\" height=\"472\" src=\"https://www.whodunit.fr/wp-content/uploads/2023/02/evolution-des-parts-de-marche-cms-en-10-ans-1.png\" alt=\"\" class=\"wp-image-75428\" //></figure>\n\n\n\n<h2 id=\"h-l-histoire-de-wordpress-et-son-evolution-au-fil-des-ans\" data-block-type=\"core\">L’histoire de WordPress et son évolution au fil des ans</h2>\n\n\n\n<h3 id=\"h-les-versions-majeures-en-2022\" data-block-type=\"core\">Les versions majeures en 2022</h3>\n\n\n\n<ul data-block-type=\"core\">\n<li data-block-type=\"core\">La version 5.9 a vu apparaître le full site editing (édition complète du site). Cela offre par exemple la possibilité d’éditer l’entête et le pied de page de son site et différents modèles de pages. Elle représente ainsi une grosse évolution pour le CMS.</li>\n\n\n\n<li data-block-type=\"core\">La version 6.0 : cette “petite” version majeure a servi à fignoler l’expérience d’édition de sites</li>\n\n\n\n<li data-block-type=\"core\">La version 6.0.3 : plus grosse version de sécurité de l’histoire du CMS, elle a contenu 15 correctifs de failles de sécurité remontées par des audits externes et des chercheurs en sécurité.</li>\n\n\n\n<li data-block-type=\"core\">La dernière version 6.1 : version très attendue car elle a implémenté le full site editing de façon encore plus profonde avec l’édition de style et variations de styles. Et un nouveau thème natif <a href=\"https://fr.wordpress.org/themes/twentytwentythree/\">T</a><a href=\"https://fr.wordpress.org/themes/twentytwentythree/\" target=\"_blank\" rel=\"noreferrer noopener\">wenty Twenty-Three</a>, un thème canevas vierge et qui contient tout ce qu’il faut pour réaliser un site accessible. Cette version représente un record en termes de contributeurs et contributrices (1399 personnes dont 656 qui n’avaient jamais contribué au développement de WP avant). Ceci peut s’expliquer en partie par la présence du Javascript moderne utilisé par l’éditeur Gutenberg qui attire de nouveaux développeurs et développeuses.</li>\n</ul>\n\n\n\n<p>La team performance de WordPress a été créée, permettant d’améliorer les performances de 20 à 30% notamment en back office.</p>\n\n\n\n<h3 id=\"h-comment-wordpress-s-est-adapte-aux-changements-technologiques-et-aux-nouvelles-tendances-du-web\" data-block-type=\"core\">Comment WordPress s’est adapté aux changements technologiques et aux nouvelles tendances du web</h3>\n\n\n\n<p>Aujourd&#8217;hui avec WordPress 6.1, il nous est possible de dire que WordPress supporte PHP 8 et 8.1. C’est à dire que vous n’aurez pas d&#8217;erreurs majeures si vous passez votre serveur en php 8.0, ou 8.1. En revanche, ce n’est pas encore forcément le cas de toutes les extensions et de tous les thèmes.</p>\n\n\n\n<p>En effet, il va falloir du temps pour s&#8217;assurer que tous les thèmes et toutes les extensions soient compatibles. D&#8217;ailleurs toutes ne le seront pas, il y a des extensions qui n’ont pas été mises à jour depuis trois ou quatre ans et dans ce cas là on risque d&#8217;avoir des problèmes d&#8217;incompatibilité.</p>\n\n\n\n<p>Il y a un travail en cours du côté de l&#8217;équipe Meta <a href=\"http://WordPress.org\" target=\"_blank\" rel=\"noreferrer noopener\">WordPress.org</a> pour pouvoir ajouter un tag sur les extensions du répertoire et pouvoir identifier facilement les extensions qui sont compatibles ou celles qui ne le sont pas. C’est un travail de test assez complet et assez complexe à mettre en oeuvre mais c&#8217;est quelque chose qui pourrait voir le jour pour 2023.</p>\n\n\n\n<p>On vous a préparé une liste non exhaustive des fonctionnalités qu’on aime sur WP 6.1 :</p>\n\n\n\n<ul data-block-type=\"core\">\n<li data-block-type=\"core\">Les variations de style, en un seul clic on peut changer l&#8217;apparence complète du site, la gestion des styles globaux, les palettes de couleurs, les typos,</li>\n\n\n\n<li data-block-type=\"core\">On trouve désormais dans l’éditeur des modèles de page et donc la possibilité de créer des modèles de page avec différents headers et footers</li>\n\n\n\n<li data-block-type=\"core\">La liste des blocs Gutenberg indispensables</li>\n\n\n\n<li data-block-type=\"core\">La gestion des espaces qui était très attendue (marges internes, externes, espacements…)</li>\n\n\n\n<li data-block-type=\"core\">Les blocs réutilisables ou patterns très importants : on trouve des modèles de composition de blocs tout faits, des bibliothèques très intéressantes qu’il suffit de copier-coller </li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\" data-block-type=\"core\"><img loading=\"lazy\" width=\"1080\" height=\"748\" src=\"https://www.whodunit.fr/wp-content/uploads/2023/02/capture-decran-2023-01-24-a-09-30-29-1080x748.png\" alt=\"\" class=\"wp-image-75444\" //></figure>\n\n\n\n<p>Il y a eu un gros travail sur la bibliothèque de patterns donc la composition de blocs, un développeur ou une développeuse peut créer ses propres compositions, utiliser celles qui sont natives, celles proposées directement par le thème qu’on aura installé mais on peut aussi aller chercher celles de <a href=\"http://wordpress.org\" target=\"_blank\" rel=\"noreferrer noopener\">wordpress</a><a href=\"http://wordpress.org\">.org</a>.</p>\n\n\n\n<p>L’étape suivante sera de créer ses propres compositions directement dans l&#8217;éditeur et c&#8217;est ainsi que nous en arrivons à ce qui est en cours de développement.</p>\n\n\n\n<h2 id=\"h-etat-des-lieux-de-wordpress\" data-block-type=\"core\">État des lieux de WordPress</h2>\n\n\n\n<h3 id=\"h-l-editeur-gutenberg-s-emancipe\" data-block-type=\"core\">L’éditeur Gutenberg s’émancipe</h3>\n\n\n\n<p>Nous voyons le projet Gutenberg sortir de l’écosystème WordPress lui-même, de sa zone de contenus.</p>\n\n\n\n<p>Il y a quelques semaines, un projet en Sass monté sur <a href=\"https://laravel.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Laravel</a> et qui utilise Gutenberg a été présenté au <a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\" target=\"_blank\" rel=\"noreferrer noopener\">State of the word</a>, la conférence annuelle du cofondateur WordPress.</p>\n\n\n\n<p>On a vu aussi apparaître l’extension <a href=\"https://wordpress.org/plugins/blocks-everywhere/\" target=\"_blank\" rel=\"noreferrer noopener\">blocks everywhere</a> disponible sur <a href=\"http://wordpress.org\" target=\"_blank\" rel=\"noreferrer noopener\">wordpress.org</a>. Comme son nom l&#8217;indique elle permet d&#8217;embarquer l&#8217;éditeur de bloc dans les commentaires par exemple. Elle permet aussi d&#8217;utiliser l&#8217;éditeur, pour ceux qui ont des sites vraiment collaboratifs, dans les extensions buddypress ou bbpress donc des extensions qui permettent de gérer des communautés ou de gérer des forums.</p>\n\n\n\n<p>On sait aussi que ça n’est qu’une question de semaine avant que l&#8217;éditeur puisse être utilisé pour directement éditer une catégorie, la description de catégorie étant quelque chose de très demandé notamment pour des sites de e-commerce.</p>\n\n\n\n<p>Gutenberg est également sorti de WordPress pour être directement implémenté dans Tumblr, une vieille plateforme de blogging et microblogging rachetée il y a maintenant quelques temps par <a href=\"https://automattic.com/\" target=\"_blank\" rel=\"noreferrer noopener\">automattic</a>, l&#8217;entreprise fondée par le co-fondateur de <a href=\"http://wordpress.org\" target=\"_blank\" rel=\"noreferrer noopener\">wordpress.org</a>, <a href=\"https://fr.wikipedia.org/wiki/Matthew_Mullenweg\" target=\"_blank\" rel=\"noreferrer noopener\">Matt Mullenweg</a>.</p>\n\n\n\n<p><mark class=\"has-inline-color has-palette-color-3-color\"><strong>On observe donc que le Projet Gutenberg a tendance à devenir plus gros que WordPress lui-même, l&#8217;objectif visé étant d’en faire un éditeur universel.</strong></mark></p>\n\n\n\n<h3 id=\"h-wp-playground-l-application-qui-permet-de-simuler-wordpress\" data-block-type=\"core\"><a href=\"https://developer.wordpress.org/playground/\" target=\"_blank\" rel=\"noreferrer noopener\">WP Playground</a>, l’application qui permet de simuler WordPress</h3>\n\n\n\n<figure class=\"wp-block-image size-large\" data-block-type=\"core\"><img loading=\"lazy\" width=\"1080\" height=\"341\" src=\"https://www.whodunit.fr/wp-content/uploads/2023/02/capture-decran-2023-01-24-a-11-09-24-1080x341.png\" alt=\"\" class=\"wp-image-75429\" //></figure>\n\n\n\n<p>Cette initiative présentée récemment par <a href=\"https://fr.wikipedia.org/wiki/Matthew_Mullenweg\" target=\"_blank\" rel=\"noreferrer noopener\">Matt Mullenweg</a> est en fait une application qui va se charger directement dans un onglet du navigateur et permettre de simuler un WordPress vierge dans lequel nous pourrons installer des extensions, installer des thèmes, créer du contenu et le publier…</p>\n\n\n\n<p>C&#8217;est bien sûr une installation provisoire c&#8217;est à dire que tout le contenu qui aura été rédigé sera détruit au moment où le navigateur sera fermé mais d’un point de vue pédagogique, la possibilité de pouvoir faire une démonstration de WordPress est grandement appréciée.</p>\n\n\n\n<p>Il y a également une application de WP playground encore en développement qui donnera la possibilité d’avoir ce mini WordPress sur la page du répertoire des extensions et thème.</p>\n\n\n\n<p>En clair, on pourra tester la compatibilité des extensions qui nous intéressent.</p>\n\n\n\n<h3 id=\"h-create-block-theme\" data-block-type=\"core\">Create Block Theme</h3>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/create-block-theme/\" target=\"_blank\" rel=\"noreferrer noopener\">Create Block Theme</a> est vraiment d&#8217;actualité. Créée par les équipes de développement de <a href=\"http://wordpress.org\" target=\"_blank\" rel=\"noreferrer noopener\">wordpress.org</a>, elle permet de paramétrer un thème basé sur des blocs utilisant le full set editing et de le paramétrer entièrement depuis l’administration.</p>\n\n\n\n<p>C’est vraiment un outil no code c&#8217;est à dire que l’on créé un thème directement depuis notre administration sans créer la moindre ligne de code. Ça va vraiment créer les fichiers physiques sur le serveur, on pourra les zipper et les récupérer pour notre site donc c’est une extension très prometteuse !</p>\n\n\n\n<p>Pour en savoir plus, n’hésitez pas à écouter notre <a href=\"https://www.whodunit.fr/woa-20-le-no-code-avec-stephane-menet/\" target=\"_blank\" rel=\"noreferrer noopener\">dernier podcast</a>.</p>\n\n\n\n<h3 id=\"h-openverse\" data-block-type=\"core\">Openverse</h3>\n\n\n\n<p><a href=\"https://wordpress.org/openverse/\" target=\"_blank\" rel=\"noreferrer noopener\">Openverse</a> est un projet qui appartenait à Godzilla mais faute d’équipes pour s’en occuper, c’est <a href=\"http://wordpress.org\" target=\"_blank\" rel=\"noreferrer noopener\">wordpress.org</a> qui a souhaité le récupérer. Il s’agit une bibliothèque de partage de médias libres de droit. Que ce soit des images, des vidéos ou des fichiers audio. Ce qui en fait pour être très clair un concurrent de unsplash par exemple. Openverse est vraiment un projet 100% open source et ici c&#8217;est pas de code dont il est question mais de médias et de création artistique et graphique.</p>\n\n\n\n<h2 id=\"h-roadmap-2023\" data-block-type=\"core\">RoadMap 2023</h2>\n\n\n\n<h3 id=\"h-les-differentes-phases-du-projet-gutenberg\" data-block-type=\"core\">Les différentes phases du projet Gutenberg</h3>\n\n\n\n<p><strong><span style=\"color: var(--paletteColor1, #ff3475)\" class=\"stk-highlight\">Phase 1</span></strong></p>\n\n\n\n<p>Pour rappel c&#8217;était vraiment l&#8217;éditeur de bloc donc l’édition de la zone de contenu d&#8217;une page d&#8217;un article ou de n&#8217;importe quel type de publication avec des blocs</p>\n\n\n\n<p><strong><span style=\"color: var(--paletteColor1, #ff3475)\" class=\"stk-highlight\">Phase 2</span></strong></p>\n\n\n\n<p>C’était le Full Site Editing qui d&#8217;ailleurs a été renommé en Site Editor tout simplement. Il fonctionne bien et permet donc d’éditer l&#8217;ensemble du site.</p>\n\n\n\n<p><strong><span style=\"color: var(--paletteColor1, #ff3475)\" class=\"stk-highlight\">Phase 3</span></strong></p>\n\n\n\n<p>C&#8217;est la phase collaborative alors c&#8217;est la phase qui parle le moins finalement aux gens de la communauté WordPress pourquoi parce que la plupart des gens de la communauté WordPress utilisent WordPress pour créer un site vitrine, une boutique et l’administrer.</p>\n\n\n\n<p>Il faut se souvenir que le Projet Gutenberg est un projet qui est un petit peu séparé de WordPress c&#8217;est-à-dire qu&#8217;il est développé pour WordPress évidemment puisqu’il est son premier lieu d&#8217;expression et depuis le début il est dit que Gutenberg doit pouvoir être utilisé en dehors de WordPress, pour n&#8217;importe quel CMS, n&#8217;importe quel usage.</p>\n\n\n\n<p>L’idée du Projet Gutenberg est bien d’en faire l&#8217;éditeur universel de contenus sur le web.</p>\n\n\n\n<p>Mais l&#8217;édition de contenu n’est pas réservée aux sites internet et ce que fait WordPress avec Gutenberg c&#8217;est clairement lorgner sur des outils comme Google Docs par exemple.</p>\n\n\n\n<p>Gutenberg a donc besoin d&#8217;outils de workflow éditorial, de workflow de flux collaboratif et c’est vraiment cette phase 3 qui va être lancée en 2023.</p>\n\n\n\n<p>Elle commence dès janvier avec des travaux en cours sur la gestion des flux éditoriaux, donc de la collaboration dans l&#8217;éditeur, une collaboration asynchrone ou en temps réel avec la possibilité sur du contenu de laisser des notes et des commentaires.</p>\n\n\n\n<p>En cours également une refonte complète du système de révision WordPress : Le système de révision c&#8217;est ce qui permet de revenir en arrière sur ce qui a été fait. Très utile lorsqu&#8217;on a fait une bêtise&#8230;</p>\n\n\n\n<p>A noter aussi que Gutenberg a désormais la double licence. A la fois <a href=\"https://www.gnu.org/licenses/gpl-3.0.html\">GPL</a> et <a href=\"https://www.mozilla.org/en-US/MPL/\">MPL</a> (Mozilla Public Licence) Cette deuxième licence était obligatoire au Projet Gutenberg pour qu&#8217;il puisse être porté sur de l&#8217;applicatif mobile comme sur les stores Google sur les Apple Store.</p>\n\n\n\n<p><strong><span style=\"color: var(--paletteColor1, #ff3475)\" class=\"stk-highlight\">Phase 4</span></strong></p>\n\n\n\n<p>C&#8217;est le multilingue. Cette phase 4 était censée arriver une fois que la phase 3 serait en place mais en réalité ça va probablement arriver un peu en même temps. Il va y avoir des développements en parallèle donc on peut attendre effectivement le multilingue avec des premiers développements en 2023 puis des premiers déploiements in situ en 2024.</p>\n\n\n\n<p>En tout cas le multilingue va être intégré directement dans l&#8217;éditeur donc ça sera pas du tout le même fonctionnement que les extensions qu&#8217;on connaît toutes et tous comme <a href=\"https://fr.wordpress.org/plugins/polylang/\">polylang</a> notre petite extension favorite de multilingue. Il va y avoir quelque chose de complémentaire et qui permettra d&#8217;aller encore un peu plus loin sur cette partie là et de façon simplifiée, sans extension.</p>\n\n\n\n<p><strong><span style=\"color: var(--paletteColor1, #ff3475)\" class=\"stk-highlight\">Avant la phase 5</span></strong></p>\n\n\n\n<ul data-block-type=\"core\">\n<li data-block-type=\"core\">On se dirige vers une refonte complète de la médiathèque, la bibliothèque de médias de WordPress. Ce sujet est très attendu car beaucoup de personnes se plaignent depuis maintenant des années du fait qu&#8217;on ne puisse pas catégoriser les médias, qu&#8217;on puisse pas les ranger dans des dossiers… L’autre souci c’est qu’en voulant insérer une image, Gutenberg va charger la médiathèque qui est lourde et très lente alors que Gutenberg lui est plutôt rapide. On a hâte !</li>\n\n\n\n<li data-block-type=\"core\">D’autres petites choses aussi qui vont être développées en 2023 sont l&#8217;affichage des blocs en fonction du contexte mobile, comptes connectés ou non…</li>\n\n\n\n<li data-block-type=\"core\">On va retrouver l&#8217;éditeur de composition c&#8217;est à dire le fait de pouvoir créer des patterns directement, les exporter et ainsi de suite. C&#8217;est quelque chose que nous proposons dans une petite extension développée début 2022 pour nos clients : <a href=\"https://fr.wordpress.org/plugins/mywp-custom-patterns/\" target=\"_blank\" rel=\"noreferrer noopener\">myWP Custom Patterns</a></li>\n\n\n\n<li data-block-type=\"core\">On aura un nouveau type d&#8217;extension sur le répertoire des extensions <a href=\"http://wordpress.org\" target=\"_blank\" rel=\"noreferrer noopener\">wordpress.org</a> ce sont les canonical plugins (les extensions canoniques en français). Ce sont des extensions qui seront maintenues par <a href=\"http://WordPress.org\" target=\"_blank\" rel=\"noreferrer noopener\">WordPress.org</a> officiellement. Gutenberg est déjà une extension de ce type mais aussi toutes les extensions d&#8217;import et d&#8217;export de contenu seront des extensions canoniques. C’est à la fois un gage de sécurité et un gage de performance parce que c&#8217;est maintenu par les équipes du cœur mais en même temps tout le monde peut y contribuer.</li>\n\n\n\n<li data-block-type=\"core\">On a aussi l’extension <a href=\"https://fr.wordpress.org/plugins/performance-lab/\" target=\"_blank\" rel=\"noreferrer noopener\">performance lab</a> (le laboratoire d’amélioration des performances de WordPress) Toutes ces améliorations sont développées sous la forme d’une extension canonique, certaines fonctionnalités sont portées dans le coeur de WordPress tandis que les autres restent dans l’extension.</li>\n</ul>\n\n\n\n<p>L’idée c’est que ces extensions puissent servir de laboratoire.</p>\n\n\n\n<h3 id=\"h-les-20-ans-de-wordpress\" data-block-type=\"core\">Les 20 ans de WordPress</h3>\n\n\n\n<p>Une équipe travaille sur les festivités des 20 ans de WordPress, on peut s&#8217;attendre à beaucoup de surprises au printemps 2023 !</p>\n\n\n\n<p>Plus de détails à venir ici : <a href=\"https://wp20.wordpress.net/\" target=\"_blank\" rel=\"noreferrer noopener\">WordPress turns 20 in 2023</a></p>\n\n\n\n<p>A noter également que WordPress, qui ne serait rien sans sa communauté, connaît une reprise de ses fameux WordCamps, un WordCamp Paris est d’ailleurs attendu courant 2023. </p>\n<p>L’article <a rel=\"nofollow\" href=\"https://www.whodunit.fr/wordpress-le-point-sur-ce-qui-vous-attend-en-2023/\">WordPress : le point sur ce qui vous attend en 2023</a> est apparu en premier sur <a rel=\"nofollow\" href=\"https://www.whodunit.fr\">Agence WordPress Whodunit</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Gaelle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"https://www.whodunit.fr/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Whodunit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:7;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://vincentdubroeucq.com/10-choses-simples-a-ne-pas-oublier-quand-vous-developpez-vos-themes-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"10 choses simples à ne pas oublier quand vous développez vos thèmes WordPress\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:107:\"https://vincentdubroeucq.com/10-choses-simples-a-ne-pas-oublier-quand-vous-developpez-vos-themes-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2023-01-25T15:39:14.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2023-01-25T15:39:14.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:660:\"Vous avez reçu une maquette pour un site vitrine simple, et vous devez maintenant développer le thème pour le client. La maquette ne contient que quelques pages (4 ou 5) et vous vous dites donc que ça ne va pas être très long ni très compliqué. Doucement ! Ce n’est pas parce que 5 pages sont maquettées que votre travail s’arrête à ces 5 pages ! Si c’était le cas, vous pourriez livrer 5 pages HTML en dur et ce serait réglé ! Non ? Dans cette article, on va voir ensemble quelques éléments “pièges” qu’on a tendance à oublier […]Lire la suite : 10 choses simples à ne pas oublier quand vous développez vos thèmes WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:845:\"\n        Vous avez reçu une maquette pour un site vitrine simple, et vous devez maintenant développer le thème pour le client. La maquette ne contient que quelques pages (4 ou 5) et vous vous dites donc que ça ne va pas être très long ni très compliqué. Doucement ! Ce n&#8217;est pas parce que 5 pages sont maquettées que votre travail s&#8217;arrête à ces 5 pages ! Si c&#8217;était le cas, vous pourriez livrer 5 pages HTML en dur et ce serait réglé ! Non ? Dans cette article, on va voir ensemble quelques éléments &#8220;pièges&#8221; qu&#8217;on a tendance à oublier [&#8230;]<br><strong>Lire la suite :</strong> <a href=\"https://vincentdubroeucq.com/10-choses-simples-a-ne-pas-oublier-quand-vous-developpez-vos-themes-wordpress/\">10 choses simples à ne pas oublier quand vous développez vos thèmes WordPress</a>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Vincent\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://vincentdubroeucq.com/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Vincent Dubroeucq\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:8;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://21douze.fr/robohash-votre-nouvel-avatar-6462026.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"RoboHash : Votre nouvel avatar ?\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:60:\"https://21douze.fr/robohash-votre-nouvel-avatar-6462026.html\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2023-01-19T11:59:03.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2023-01-19T11:59:03.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:348:\"Vous avez surement déjà un avatar associé à votre adresse email via Gravatar. Ce service permet d’avoir un avatar facilement sans devoir à chaque fois uploader une photo. Si l’adresse mails que vous utilisez n’est pas liée à Gravatar, un avatar par défaut sera alors affiché. WordPress utilisant Gravatar (les 2 ont un lien avec …\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:378:\"\n        Vous avez surement déjà un avatar associé à votre adresse email via Gravatar. Ce service permet d&#8217;avoir un avatar facilement sans devoir à chaque fois uploader une photo. Si l&#8217;adresse mails que vous utilisez n&#8217;est pas liée à Gravatar, un avatar par défaut sera alors affiché. WordPress utilisant Gravatar (les 2 ont un lien avec&#160;…\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Julio Potier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://21douze.fr/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"21douze\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:9;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://beapi.fr/blog/debuter-dans-le-developpement-de-blocs-gutenberg-en-react-un-retour-dexperience/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"Débuter dans le développement de blocs Gutenberg en React : un retour d’expérience  \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:102:\"https://beapi.fr/blog/debuter-dans-le-developpement-de-blocs-gutenberg-en-react-un-retour-dexperience/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2022-12-09T09:38:55.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2022-12-09T09:38:55.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:509:\"Introduction Cet été, chez Be API, nous avons démarré un projet interne nommé Blocks party dans le but de créer une collection de blocs Gutenberg complémentaire à la liste de blocs natifs de WordPress. Ces blocs seront faits-maison, et seront également bien évidemment open-source pour rester fidèle à l’ADN de WordPress. Dans un premier temps, […]\nThe post Débuter dans le développement de blocs Gutenberg en React : un retour d’expérience   appeared first on Be API, agence WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:11787:\"\n        \n<h2>Introduction</h2>\n\n\n\n<p>Cet été, chez Be API, nous avons démarré<strong> un projet interne nommé <em>Blocks party</em> </strong>dans le but de créer une collection de blocs Gutenberg complémentaire à la liste de blocs natifs de WordPress. Ces blocs seront faits-maison, et seront également bien évidemment <em>open-source</em> pour rester fidèle à l&rsquo;ADN de WordPress.</p>\n\n\n\n<p>Dans un premier temps, nous avons identifié <strong>les mises en forme / fonctionnalités les plus récurrentes dans nos projets</strong>, à partir desquelles nous avons produit une liste de blocs candidats pour le développement. Sans le savoir, j&rsquo;allais commencer par le bloc le plus difficile et le plus complexe de la liste.&nbsp;</p>\n\n\n\n<p>Je suis Paolo Tesei, développeur de thèmes WordPress depuis 15 ans, et je vous propose ci-dessous <strong>un retour d’expérience </strong>sur la création de mon premier bloc Gutenberg natif.</p>\n\n\n\n<h2>Un parcours en forte pente</h2>\n\n\n\n<p>Tout est difficile quand on entame quelque chose de nouveau !</p>\n\n\n\n<p>Pour commencer du bon pied, j’ai <strong>utilisé le paquet </strong><a href=\"https://www.npmjs.com/package/@wordpress/create-block\"><strong>create-block</strong></a><strong> </strong>de WordPress pour initialiser le projet, sous forme d’extension WordPress. J’ai ensuite<strong> ajouté nos </strong><strong><em>coding standards</em></strong><strong> </strong>habituels pour les langages JavaScript, CSS et PHP, puis je suis passé <strong>en mode </strong><strong><em>multi-blocks</em></strong> (une extension permettant d’enregistrer plusieurs blocs à fois).</p>\n\n\n\n<p>Personnellement, j’avais déjà commencé à prendre mes marques avec React en développant un site sous Gatsby.js. Avec Gutenberg l&rsquo;expérience est similaire, comparable au développement à l’aide d’un Framework JavaScript : <strong>il faut s’adapter à ses règles et sa façon de fonctionner</strong>.&nbsp;</p>\n\n\n\n<p>Pour bien démarrer, la documentation (qui, à date, n&rsquo;est pas encore optimale) reste la première pièce du puzzle, bien qu’il n’y est pas encore beaucoup d&rsquo;exemples. Pour compenser ce manque, vu que tout est en <em>open-source</em>, il est plus facile de trouver et d’aller jeter un œil à l’utilisation que d’autres développeurs ont pu en faire (et de constater, ou non, s’ils sont également tombés dans les mêmes pièges que moi).</p>\n\n\n\n<h3>L’origine du mal</h3>\n\n\n\n<p>Le premier bloc que l’équipe projet a décidé de développer a été <strong>le bloc “Tabs”</strong>. Très demandé/utilisé dans nos projets, il s&rsquo;agit d&rsquo;un bloc composé <strong>d’une barre d&rsquo;onglets (</strong><strong><em>tabs list</em></strong><strong>) </strong>et <strong>de panneaux de contenus (</strong><strong><em>panels</em></strong><strong>)</strong> avec un petit bonus permettant à l&rsquo;utilisateur de choisir une icone pour chaque onglet.&nbsp;</p>\n\n\n\n<p>Comme nous avions déjà développé un bloc “Icons” qui permet de charger des collections d&rsquo;icônes, j’ai préféré exploiter <strong>le système d’</strong><strong><em>innerBlocks</em></strong><strong> natif (blocs imbriqués) </strong>pour bien respecter le concept de modularité et d’indépendance des fonctionnalités, plutôt que de transformer ce bloc en composant.</p>\n\n\n\n<h3>Le Bloc “Tabs”</h3>\n\n\n<div class=\"wp-block-image\">\n<figure class=\"aligncenter size-large\"><img width=\"1024\" height=\"490\" src=\"https://beapi.fr/wp-content/uploads/2022/12/beapi-tabs-block-1024x490.png\" alt=\"Capture d\'écran de l\'interface utilisateur du block tabs\" class=\"wp-image-1780\" //><figcaption>UI du Be API Tabs Block</figcaption></figure></div>\n\n\n<p>Après quelques jours passés à essayer de concevoir ce bloc à partir d’un seul bloc enfant, j’ai fini par réaliser <strong>qu&rsquo;il n’en fallait pas moins de 4 </strong>pour faire le bloc de la manière la plus logique et cohérente !</p>\n\n\n\n<p>Pour être plus précis, dans ce bloc “Tabs”, nous retrouvons les deux premiers blocs de niveau 1, un qui contient <strong>tous les onglets (</strong><strong><em>tabs list</em></strong><strong>) </strong>et un autre qui contient <strong>tous les panneaux (</strong><strong><em>panels</em></strong><strong>)</strong>. Les enfants (niveau 2) de ces derniers sont synchronisés, ce qui veut dire que si je déplace le premier onglet (<em>tab item</em>) en deuxième position, le contenu<em> </em>(<em>panel item</em>) correspondant suivra et se positionnera <strong>dans le même ordre dans la liste des </strong><strong><em>panels</em></strong>.</p>\n\n\n\n<p>Dans cette phase, le plus difficile a été de comprendre comment faire parler les blocs entre eux. Dans Gutenberg, de base, chaque bloc vit sa vie, mais il existe plusieurs solutions pour permettre à ces blocs d’interagir. Bien sûr, il a fallu essayer chacune de ces méthodes pour déterminer celle qui serait la plus performante. J’ai donc utilisé <strong>les contextes</strong> (l&rsquo;équivalent de Redux pour Gutenberg) et <strong>les </strong><strong><em>Select</em></strong><strong> et </strong><strong><em>Dispatch</em></strong> pour récupérer la donnée dans le registre des blocks. Une autre piste était de créer un <em>Store</em> dédié, mais c’était clairement une solution surdimensionnée, donc vite abandonnée.</p>\n\n\n\n<p>Petite contrainte (et astuce) : pendant toute la phase de développement, on casse souvent le block (autant de fois qu’on change la logique de développement) et une recontribution régulière est nécessaire pour le faire (re)fonctionner. Passage obligé, le message “Ce bloc a rencontré une erreur et ne peut pas être prévisualisé.” devient ton meilleur ami. Le message n’étant pas très explicite, il n’est pas évident de comprendre d&rsquo;où vient l’erreur. Je conseille donc de <strong>développer petit à petit et de tester en continu </strong>pour éviter une frustration trop grande liée à des changements trop importants !</p>\n\n\n\n<p>Si dans la majorité des cas, l&rsquo;erreur vient d’un changement de markup, cette <em>feature</em> (non non, ce n’est pas un <em>bug</em>) met avant tout en évidence la fragilité des blocs. Il faut donc garder à l’esprit que si vous faites évoluer votre bloc dans le futur, <strong>il faudra prendre en compte sa rétrocompatibilité</strong>.</p>\n\n\n\n<p>Nous avons commencé par établir (pour ce bloc, mais pour les suivants également) <strong>des règles générales de nommage</strong> pour préfixer nos blocs, nos classes et variables CSS et le <em>namespace</em> de nos plugins.</p>\n\n\n\n<p>Pour rendre l’ensemble plus flexible et <em>developer-friendly,</em> nous avons rendu possible le fait de paramétrer <strong>quels types de bloc nous pouvons ajouter </strong>à l’intérieur des onglets (<em>tabs</em>) et de&nbsp; la zone de contenu (<em>panels</em>), avec une<strong> liste de blocs autorisés</strong> (<em>allowed blocks</em>).&nbsp;</p>\n\n\n\n<p>Globalement, il faut réfléchir à comment rendre chaque bloc assez<strong> souple et ouvert</strong> pour qu&rsquo;il puisse interagir avec les autres extensions/blocs de l’écosystème.</p>\n\n\n\n<p>En parallèle, il faut également faire en sorte de <strong>brider l’interface </strong>efficacement<strong>,</strong> pour offrir aux contributeurs les moins expérimentés seulement les options qui leur seront utiles, ou bien tout simplement pour adapter l’édition du bloc à une direction artistique bien cadrée.&nbsp;</p>\n\n\n\n<p>Pour le bloc “Tabs”, j’ai désactivé l’édition de certains éléments (<em>locking</em>) pour <strong>éviter des erreurs de contribution</strong> et j’ai également rendu possible le fait de limiter et personnaliser la liste des alignements possibles.</p>\n\n\n\n<p>En modifiant la configuration du <em>blockSupport,</em> il est également possible <strong>d’activer ou de désactiver l&rsquo;affichage des options natives</strong> comme le sélecteur de couleurs ou la gestion des marges.</p>\n\n\n\n<p>Une dernière source de réflexion concerne le CSS. En préparation de l’arrivée massive du FSE (Full Site Editing, plutôt Site editor (<em>renaming</em> récent)), il faut identifier <strong>quels sont les paramètres de styles</strong> qui permettent d’éditer l’aspect visuel du bloc, et ensuite créer <strong>les variables CSS associées</strong>.</p>\n\n\n\n<h2>Les trois règles</h2>\n\n\n\n<p>Dans le théâtre classique de 1500 inspiré par Aristote, la pièce parfaite devait être conçue en suivant les trois règles suivantes :<strong>&nbsp;</strong></p>\n\n\n\n<ul><li><strong>l&rsquo;unité de temps</strong> : tout se doit passer à l&rsquo;intérieur d&rsquo;une journée ;</li><li><strong>l&rsquo;unité de lieu</strong> : tout se doit dérouler dans les mêmes lieux/espaces ;</li><li><strong>l&rsquo;unité d&rsquo;action</strong> : tous les événements principaux nécessaires à l&rsquo;histoire doivent commencer et terminer à l&rsquo;intérieur de la pièce.&nbsp;</li></ul>\n\n\n\n<p>J&rsquo;ai trouvé assez amusant de pouvoir appliquer ces « unités aristotéliques” dans le développement des blocs Gutenberg.</p>\n\n\n\n<h3>Unité de temps.</h3>\n\n\n\n<p>La vie d’un bloc s’étire d’une phase d&rsquo;édition (<em>edit</em>) à une phase de sauvegarde (<em>save</em>), et <strong>ces deux phases sont intimement interconnectées</strong>. Il est fondamental de rendre l’interface d&rsquo;édition fidèle au rendu front-office. C&rsquo;est particulièrement vrai quand on développe un bloc qui n&rsquo;a pas un rendu dynamique. <strong>Le markup de sa partie </strong><strong><em>save</em></strong><strong> impose aussi la structure de sa partie </strong><strong><em>edit</em></strong><em>.</em></p>\n\n\n\n<h3>Unité de lieu</h3>\n\n\n\n<p>Ce concept est important pour la modularité : quand toutes les fonctionnalités ne peuvent pas être portées par un bloc seul, nous sommes contraints de <strong>décomposer ce dernier dans une structure parent &gt; enfants</strong>. Cette règle est imposée par le fait que dans un bloc Gutenberg, nous avons le droit d’utiliser un seul <em>innerBlock</em>. Par exemple, le bloc natif “Buttons” (un wrapper <em>innerBlock</em>) est parent du bloc natif “Button”.</p>\n\n\n\n<h3>Unité d&rsquo;action</h3>\n\n\n\n<p>Toutes les manipulations modifient les attributs du bloc simultanément. On doit donc essayer de <strong>privilégier un certain ordre d&rsquo;interaction </strong>pour permettre une contribution la plus logique et naturelle possible :</p>\n\n\n\n<ol><li>dans le contenu de la page (<em>editor</em>)</li><li>dans la barre d’outils (<em>toolbar</em>) ou on accède à ces réglages principaux&nbsp;</li><li>dans la barre latérale (<em>sidebar</em>) ou on trouve ses options plus avancées.&nbsp;</li></ol>\n\n\n\n<h2>Conclusion</h2>\n\n\n\n<p>Même si au début, la mise en place a été un peu compliquée, j’ai pris énormément de plaisir à créer ce bloc.</p>\n\n\n\n<p>En étudiant de plus près les blocs natifs (<em>core blocks</em>) de WordPress, j’ai pris conscience du soin et de l’importante réflexion derrière chaque bloc, ainsi que la quantité et la qualité de travail qu’il y a derrière le projet Gutenberg.&nbsp;</p>\n\n\n\n<p>Pour tout ce que j&rsquo;ai appris/découvert, chapeau bas et merci à la communauté !</p>\n<p>The post <a rel=\"nofollow\" href=\"https://beapi.fr/blog/debuter-dans-le-developpement-de-blocs-gutenberg-en-react-un-retour-dexperience/\">Débuter dans le développement de blocs Gutenberg en React : un retour d&rsquo;expérience  </a> appeared first on <a rel=\"nofollow\" href=\"https://beapi.fr\">Be API, agence WordPress</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Paolo Tesei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://beapi.fr/blog/categories/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BeAPI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:512;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:12:\"nginx/1.21.4\";s:4:\"date\";s:29:\"Tue, 25 Apr 2023 17:28:39 GMT\";s:12:\"content-type\";s:20:\"application/atom+xml\";s:12:\"x-powered-by\";s:10:\"PHP/8.0.13\";s:13:\"last-modified\";s:29:\"Wed, 15 Dec 2021 21:33:54 GMT\";s:4:\"etag\";s:34:\"\"2ffe8d75591b5b1ed5ca7f66d3c037d3\"\";s:4:\"link\";s:57:\"<https://rss.wpfr.net/wp-json/>; rel=\"https://api.w.org/\"\";s:13:\"cache-control\";s:35:\"no-cache, no-store, must-revalidate\";s:6:\"pragma\";s:8:\"no-cache\";s:7:\"expires\";s:1:\"0\";s:25:\"strict-transport-security\";s:16:\"max-age=63072000\";}}s:5:\"build\";s:14:\"20230424172636\";}", "no");
INSERT INTO `bd_options` VALUES("2574", "_transient_timeout_feed_mod_48c2a7450ae14f12ef8a9b58ca9f0748", "1682486852", "no");
INSERT INTO `bd_options` VALUES("2575", "_transient_feed_mod_48c2a7450ae14f12ef8a9b58ca9f0748", "1682443652", "no");
INSERT INTO `bd_options` VALUES("2576", "_transient_timeout_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "1682486852", "no");
INSERT INTO `bd_options` VALUES("2577", "_transient_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://fr.wordpress.org/2023/03/30/wordpress-6-2-dolphy/\'>WordPress 6.2 « Dolphy »</a></li><li><a class=\'rsswidget\' href=\'https://fr.wordpress.org/2023/03/10/guide-des-changements-techniques-de-wordpress-6-2/\'>Guide des changements techniques de WordPress 6.2</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wpmarmite.com/changer-identifiant-wordpress/?utm_source=rss&#038;utm_medium=rss&#038;%23038;utm_campaign=changer-identifiant-wordpress\'>Comment changer votre identifiant WordPress ?</a></li><li><a class=\'rsswidget\' href=\'https://www.seomix.fr/optimiser-arborescence-site-web/\'>Arborescence d’un site web : comment bien l’optimiser ?</a></li><li><a class=\'rsswidget\' href=\'https://wpchannel.com/woocommerce/plugins-woocommerce/configurer-prix-remises-dynamiques-woocommerce-dynamic-pricing-discounts/\'>Comment configurer des prix et des remises dynamiques avec WooCommerce Dynamic Pricing &amp; Discounts</a></li></ul></div>", "no");
INSERT INTO `bd_options` VALUES("2578", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-04-25 17:28:39\";s:7:\"Version\";s:7:\"1.5.3.1\";s:9:\"VersionWP\";s:3:\"6.2\";s:9:\"VersionDB\";s:6:\"5.7.41\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:32:\"20230425_locationdevoituredeluxe\";s:4:\"Hash\";s:35:\"be689cc76328c5568622_20230425172839\";s:8:\"NameHash\";s:68:\"20230425_locationdevoituredeluxe_be689cc76328c5568622_20230425172839\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:78:\"20230425_locationdevoituredeluxe_be689cc76328c5568622_20230425172839_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:18:\"/home/jrmaour/test\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:623;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:4488;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-04-25 17:28:39\";s:7:\"Version\";s:7:\"1.5.3.1\";s:9:\"VersionWP\";s:3:\"6.2\";s:9:\"VersionDB\";s:6:\"5.7.41\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:32:\"20230425_locationdevoituredeluxe\";s:4:\"Hash\";s:35:\"be689cc76328c5568622_20230425172839\";s:8:\"NameHash\";s:68:\"20230425_locationdevoituredeluxe_be689cc76328c5568622_20230425172839\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:32:\"/home/jrmaour/test/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":14:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:18:\"varLowerCaseTables\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:27:\"/home/jrmaour/test/wp-admin\";i:1;s:30:\"/home/jrmaour/test/wp-includes\";i:2;s:39:\"/home/jrmaour/test/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:18:\"/home/jrmaour/test\";i:1;s:18:\"/home/jrmaour/test\";i:2;s:29:\"/home/jrmaour/test/wp-content\";i:3;s:37:\"/home/jrmaour/test/wp-content/uploads\";i:4;s:37:\"/home/jrmaour/test/wp-content/plugins\";i:5;s:40:\"/home/jrmaour/test/wp-content/mu-plugins\";i:6;s:36:\"/home/jrmaour/test/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:50:\"/home/jrmaour/test/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:143;}", "yes");

/* INSERT TABLE DATA: bd_postmeta */
INSERT INTO `bd_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `bd_postmeta` VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO `bd_postmeta` VALUES("3", "5", "_edit_lock", "1674243920:1");
INSERT INTO `bd_postmeta` VALUES("4", "5", "_wp_page_template", "contact.php");
INSERT INTO `bd_postmeta` VALUES("5", "23", "_edit_last", "1");
INSERT INTO `bd_postmeta` VALUES("6", "23", "_edit_lock", "1674247967:1");
INSERT INTO `bd_postmeta` VALUES("7", "24", "_wp_attached_file", "2023/01/mercedes_a_45_s_jaune.png");
INSERT INTO `bd_postmeta` VALUES("8", "24", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:4117;s:6:\"height\";i:1799;s:4:\"file\";s:33:\"2023/01/mercedes_a_45_s_jaune.png\";s:8:\"filesize\";i:2445361;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:33:\"mercedes_a_45_s_jaune-300x131.png\";s:5:\"width\";i:300;s:6:\"height\";i:131;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:32694;}s:5:\"large\";a:5:{s:4:\"file\";s:34:\"mercedes_a_45_s_jaune-1024x447.png\";s:5:\"width\";i:1024;s:6:\"height\";i:447;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:263053;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:33:\"mercedes_a_45_s_jaune-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:27029;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:33:\"mercedes_a_45_s_jaune-768x336.png\";s:5:\"width\";i:768;s:6:\"height\";i:336;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:159376;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:34:\"mercedes_a_45_s_jaune-1536x671.png\";s:5:\"width\";i:1536;s:6:\"height\";i:671;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:528945;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:34:\"mercedes_a_45_s_jaune-2048x895.png\";s:5:\"width\";i:2048;s:6:\"height\";i:895;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:846799;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bd_postmeta` VALUES("9", "23", "photo_classique", "37");
INSERT INTO `bd_postmeta` VALUES("10", "23", "_photo_classique", "field_60296f18d3509");
INSERT INTO `bd_postmeta` VALUES("11", "23", "video_voiture", "37");
INSERT INTO `bd_postmeta` VALUES("12", "23", "_video_voiture", "field_5c9150f2ad5e2");
INSERT INTO `bd_postmeta` VALUES("13", "23", "prix_test_drive", "2250");
INSERT INTO `bd_postmeta` VALUES("14", "23", "_prix_test_drive", "field_5c914feac25b6");
INSERT INTO `bd_postmeta` VALUES("15", "23", "prix_journee", "345");
INSERT INTO `bd_postmeta` VALUES("16", "23", "_prix_journee", "field_5c915bab15cc7");
INSERT INTO `bd_postmeta` VALUES("17", "23", "prix_wkend", "1250");
INSERT INTO `bd_postmeta` VALUES("18", "23", "_prix_wkend", "field_5c915bb915cc8");
INSERT INTO `bd_postmeta` VALUES("19", "23", "marque_de_la_voiture", "Mercedes");
INSERT INTO `bd_postmeta` VALUES("20", "23", "_marque_de_la_voiture", "field_5c914f81c25b4");
INSERT INTO `bd_postmeta` VALUES("21", "23", "places", "5");
INSERT INTO `bd_postmeta` VALUES("22", "23", "_places", "field_5c915147ad5e3");
INSERT INTO `bd_postmeta` VALUES("23", "23", "boite_de_vitesse", "automatique");
INSERT INTO `bd_postmeta` VALUES("24", "23", "_boite_de_vitesse", "field_5c915161ad5e4");
INSERT INTO `bd_postmeta` VALUES("25", "23", "vitesse_max", "270");
INSERT INTO `bd_postmeta` VALUES("26", "23", "_vitesse_max", "field_5c9151dbad5e5");
INSERT INTO `bd_postmeta` VALUES("27", "23", "chevaux", "420");
INSERT INTO `bd_postmeta` VALUES("28", "23", "_chevaux", "field_5c915aae15cc6");
INSERT INTO `bd_postmeta` VALUES("29", "23", "formulaire_contact", "");
INSERT INTO `bd_postmeta` VALUES("30", "23", "_formulaire_contact", "field_5c915c8d15cca");
INSERT INTO `bd_postmeta` VALUES("31", "23", "photo-gallery-1", "");
INSERT INTO `bd_postmeta` VALUES("32", "23", "_photo-gallery-1", "field_5d8b566efc2ef");
INSERT INTO `bd_postmeta` VALUES("33", "23", "photo-gallery-2", "");
INSERT INTO `bd_postmeta` VALUES("34", "23", "_photo-gallery-2", "field_5d8b7bc6fd7e0");
INSERT INTO `bd_postmeta` VALUES("35", "23", "photo-gallery-3", "");
INSERT INTO `bd_postmeta` VALUES("36", "23", "_photo-gallery-3", "field_5d8b7be4fd7e1");
INSERT INTO `bd_postmeta` VALUES("37", "23", "photo-gallery-4", "");
INSERT INTO `bd_postmeta` VALUES("38", "23", "_photo-gallery-4", "field_5d8b7becfd7e2");
INSERT INTO `bd_postmeta` VALUES("39", "25", "photo_classique", "24");
INSERT INTO `bd_postmeta` VALUES("40", "25", "_photo_classique", "field_60296f18d3509");
INSERT INTO `bd_postmeta` VALUES("41", "25", "video_voiture", "");
INSERT INTO `bd_postmeta` VALUES("42", "25", "_video_voiture", "field_5c9150f2ad5e2");
INSERT INTO `bd_postmeta` VALUES("43", "25", "prix_test_drive", "2250");
INSERT INTO `bd_postmeta` VALUES("44", "25", "_prix_test_drive", "field_5c914feac25b6");
INSERT INTO `bd_postmeta` VALUES("45", "25", "prix_journee", "345");
INSERT INTO `bd_postmeta` VALUES("46", "25", "_prix_journee", "field_5c915bab15cc7");
INSERT INTO `bd_postmeta` VALUES("47", "25", "prix_wkend", "1250");
INSERT INTO `bd_postmeta` VALUES("48", "25", "_prix_wkend", "field_5c915bb915cc8");
INSERT INTO `bd_postmeta` VALUES("49", "25", "marque_de_la_voiture", "Mercedes");
INSERT INTO `bd_postmeta` VALUES("50", "25", "_marque_de_la_voiture", "field_5c914f81c25b4");
INSERT INTO `bd_postmeta` VALUES("51", "25", "places", "5");
INSERT INTO `bd_postmeta` VALUES("52", "25", "_places", "field_5c915147ad5e3");
INSERT INTO `bd_postmeta` VALUES("53", "25", "boite_de_vitesse", "automatique");
INSERT INTO `bd_postmeta` VALUES("54", "25", "_boite_de_vitesse", "field_5c915161ad5e4");
INSERT INTO `bd_postmeta` VALUES("55", "25", "vitesse_max", "270");
INSERT INTO `bd_postmeta` VALUES("56", "25", "_vitesse_max", "field_5c9151dbad5e5");
INSERT INTO `bd_postmeta` VALUES("57", "25", "chevaux", "420");
INSERT INTO `bd_postmeta` VALUES("58", "25", "_chevaux", "field_5c915aae15cc6");
INSERT INTO `bd_postmeta` VALUES("59", "25", "formulaire_contact", "");
INSERT INTO `bd_postmeta` VALUES("60", "25", "_formulaire_contact", "field_5c915c8d15cca");
INSERT INTO `bd_postmeta` VALUES("61", "25", "photo-gallery-1", "");
INSERT INTO `bd_postmeta` VALUES("62", "25", "_photo-gallery-1", "field_5d8b566efc2ef");
INSERT INTO `bd_postmeta` VALUES("63", "25", "photo-gallery-2", "");
INSERT INTO `bd_postmeta` VALUES("64", "25", "_photo-gallery-2", "field_5d8b7bc6fd7e0");
INSERT INTO `bd_postmeta` VALUES("65", "25", "photo-gallery-3", "");
INSERT INTO `bd_postmeta` VALUES("66", "25", "_photo-gallery-3", "field_5d8b7be4fd7e1");
INSERT INTO `bd_postmeta` VALUES("67", "25", "photo-gallery-4", "");
INSERT INTO `bd_postmeta` VALUES("68", "25", "_photo-gallery-4", "field_5d8b7becfd7e2");
INSERT INTO `bd_postmeta` VALUES("71", "27", "_edit_last", "1");
INSERT INTO `bd_postmeta` VALUES("72", "27", "_edit_lock", "1674244708:1");
INSERT INTO `bd_postmeta` VALUES("73", "28", "_wp_attached_file", "2023/01/7434-min.png");
INSERT INTO `bd_postmeta` VALUES("74", "28", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:20:\"2023/01/7434-min.png\";s:8:\"filesize\";i:891928;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"7434-min-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:67862;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"7434-min-1024x683.png\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:612900;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"7434-min-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:28995;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"7434-min-768x512.png\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:363577;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bd_postmeta` VALUES("75", "27", "photo_classique", "28");
INSERT INTO `bd_postmeta` VALUES("76", "27", "_photo_classique", "field_60296f18d3509");
INSERT INTO `bd_postmeta` VALUES("77", "27", "video_voiture", "28");
INSERT INTO `bd_postmeta` VALUES("78", "27", "_video_voiture", "field_5c9150f2ad5e2");
INSERT INTO `bd_postmeta` VALUES("79", "27", "prix_test_drive", "2250");
INSERT INTO `bd_postmeta` VALUES("80", "27", "_prix_test_drive", "field_5c914feac25b6");
INSERT INTO `bd_postmeta` VALUES("81", "27", "prix_journee", "345");
INSERT INTO `bd_postmeta` VALUES("82", "27", "_prix_journee", "field_5c915bab15cc7");
INSERT INTO `bd_postmeta` VALUES("83", "27", "prix_wkend", "1250");
INSERT INTO `bd_postmeta` VALUES("84", "27", "_prix_wkend", "field_5c915bb915cc8");
INSERT INTO `bd_postmeta` VALUES("85", "27", "marque_de_la_voiture", "Audi");
INSERT INTO `bd_postmeta` VALUES("86", "27", "_marque_de_la_voiture", "field_5c914f81c25b4");
INSERT INTO `bd_postmeta` VALUES("87", "27", "places", "5");
INSERT INTO `bd_postmeta` VALUES("88", "27", "_places", "field_5c915147ad5e3");
INSERT INTO `bd_postmeta` VALUES("89", "27", "boite_de_vitesse", "automatique");
INSERT INTO `bd_postmeta` VALUES("90", "27", "_boite_de_vitesse", "field_5c915161ad5e4");
INSERT INTO `bd_postmeta` VALUES("91", "27", "vitesse_max", "270");
INSERT INTO `bd_postmeta` VALUES("92", "27", "_vitesse_max", "field_5c9151dbad5e5");
INSERT INTO `bd_postmeta` VALUES("93", "27", "chevaux", "400");
INSERT INTO `bd_postmeta` VALUES("94", "27", "_chevaux", "field_5c915aae15cc6");
INSERT INTO `bd_postmeta` VALUES("95", "27", "formulaire_contact", "");
INSERT INTO `bd_postmeta` VALUES("96", "27", "_formulaire_contact", "field_5c915c8d15cca");
INSERT INTO `bd_postmeta` VALUES("97", "27", "photo-gallery-1", "");
INSERT INTO `bd_postmeta` VALUES("98", "27", "_photo-gallery-1", "field_5d8b566efc2ef");
INSERT INTO `bd_postmeta` VALUES("99", "27", "photo-gallery-2", "");
INSERT INTO `bd_postmeta` VALUES("100", "27", "_photo-gallery-2", "field_5d8b7bc6fd7e0");
INSERT INTO `bd_postmeta` VALUES("101", "27", "photo-gallery-3", "");
INSERT INTO `bd_postmeta` VALUES("102", "27", "_photo-gallery-3", "field_5d8b7be4fd7e1");
INSERT INTO `bd_postmeta` VALUES("103", "27", "photo-gallery-4", "");
INSERT INTO `bd_postmeta` VALUES("104", "27", "_photo-gallery-4", "field_5d8b7becfd7e2");
INSERT INTO `bd_postmeta` VALUES("105", "29", "photo_classique", "28");
INSERT INTO `bd_postmeta` VALUES("106", "29", "_photo_classique", "field_60296f18d3509");
INSERT INTO `bd_postmeta` VALUES("107", "29", "video_voiture", "28");
INSERT INTO `bd_postmeta` VALUES("108", "29", "_video_voiture", "field_5c9150f2ad5e2");
INSERT INTO `bd_postmeta` VALUES("109", "29", "prix_test_drive", "2250");
INSERT INTO `bd_postmeta` VALUES("110", "29", "_prix_test_drive", "field_5c914feac25b6");
INSERT INTO `bd_postmeta` VALUES("111", "29", "prix_journee", "345");
INSERT INTO `bd_postmeta` VALUES("112", "29", "_prix_journee", "field_5c915bab15cc7");
INSERT INTO `bd_postmeta` VALUES("113", "29", "prix_wkend", "1250");
INSERT INTO `bd_postmeta` VALUES("114", "29", "_prix_wkend", "field_5c915bb915cc8");
INSERT INTO `bd_postmeta` VALUES("115", "29", "marque_de_la_voiture", "Audi");
INSERT INTO `bd_postmeta` VALUES("116", "29", "_marque_de_la_voiture", "field_5c914f81c25b4");
INSERT INTO `bd_postmeta` VALUES("117", "29", "places", "5");
INSERT INTO `bd_postmeta` VALUES("118", "29", "_places", "field_5c915147ad5e3");
INSERT INTO `bd_postmeta` VALUES("119", "29", "boite_de_vitesse", "automatique");
INSERT INTO `bd_postmeta` VALUES("120", "29", "_boite_de_vitesse", "field_5c915161ad5e4");
INSERT INTO `bd_postmeta` VALUES("121", "29", "vitesse_max", "270");
INSERT INTO `bd_postmeta` VALUES("122", "29", "_vitesse_max", "field_5c9151dbad5e5");
INSERT INTO `bd_postmeta` VALUES("123", "29", "chevaux", "400");
INSERT INTO `bd_postmeta` VALUES("124", "29", "_chevaux", "field_5c915aae15cc6");
INSERT INTO `bd_postmeta` VALUES("125", "29", "formulaire_contact", "");
INSERT INTO `bd_postmeta` VALUES("126", "29", "_formulaire_contact", "field_5c915c8d15cca");
INSERT INTO `bd_postmeta` VALUES("127", "29", "photo-gallery-1", "");
INSERT INTO `bd_postmeta` VALUES("128", "29", "_photo-gallery-1", "field_5d8b566efc2ef");
INSERT INTO `bd_postmeta` VALUES("129", "29", "photo-gallery-2", "");
INSERT INTO `bd_postmeta` VALUES("130", "29", "_photo-gallery-2", "field_5d8b7bc6fd7e0");
INSERT INTO `bd_postmeta` VALUES("131", "29", "photo-gallery-3", "");
INSERT INTO `bd_postmeta` VALUES("132", "29", "_photo-gallery-3", "field_5d8b7be4fd7e1");
INSERT INTO `bd_postmeta` VALUES("133", "29", "photo-gallery-4", "");
INSERT INTO `bd_postmeta` VALUES("134", "29", "_photo-gallery-4", "field_5d8b7becfd7e2");
INSERT INTO `bd_postmeta` VALUES("138", "31", "_cdp_origin", "27");
INSERT INTO `bd_postmeta` VALUES("139", "31", "_cdp_origin_site", "-1");
INSERT INTO `bd_postmeta` VALUES("140", "31", "_cdp_origin_title", " RSQ3 #[Counter]");
INSERT INTO `bd_postmeta` VALUES("141", "31", "_cdp_counter", "2");
INSERT INTO `bd_postmeta` VALUES("142", "31", "_edit_lock", "1674244877:1");
INSERT INTO `bd_postmeta` VALUES("143", "32", "_wp_attached_file", "2023/01/911.png");
INSERT INTO `bd_postmeta` VALUES("144", "32", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:15:\"2023/01/911.png\";s:8:\"filesize\";i:445328;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"911-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:45254;}s:5:\"large\";a:5:{s:4:\"file\";s:16:\"911-1024x683.png\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:315301;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"911-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:20868;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:15:\"911-768x512.png\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:199037;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bd_postmeta` VALUES("145", "31", "_edit_last", "1");
INSERT INTO `bd_postmeta` VALUES("146", "31", "_wp_old_slug", "rsq3");
INSERT INTO `bd_postmeta` VALUES("147", "31", "photo_classique", "32");
INSERT INTO `bd_postmeta` VALUES("148", "31", "_photo_classique", "field_60296f18d3509");
INSERT INTO `bd_postmeta` VALUES("149", "31", "video_voiture", "32");
INSERT INTO `bd_postmeta` VALUES("150", "31", "_video_voiture", "field_5c9150f2ad5e2");
INSERT INTO `bd_postmeta` VALUES("151", "31", "prix_test_drive", "2450");
INSERT INTO `bd_postmeta` VALUES("152", "31", "_prix_test_drive", "field_5c914feac25b6");
INSERT INTO `bd_postmeta` VALUES("153", "31", "prix_journee", "395");
INSERT INTO `bd_postmeta` VALUES("154", "31", "_prix_journee", "field_5c915bab15cc7");
INSERT INTO `bd_postmeta` VALUES("155", "31", "prix_wkend", "1500");
INSERT INTO `bd_postmeta` VALUES("156", "31", "_prix_wkend", "field_5c915bb915cc8");
INSERT INTO `bd_postmeta` VALUES("157", "31", "marque_de_la_voiture", "Porsche");
INSERT INTO `bd_postmeta` VALUES("158", "31", "_marque_de_la_voiture", "field_5c914f81c25b4");
INSERT INTO `bd_postmeta` VALUES("159", "31", "places", "4");
INSERT INTO `bd_postmeta` VALUES("160", "31", "_places", "field_5c915147ad5e3");
INSERT INTO `bd_postmeta` VALUES("161", "31", "boite_de_vitesse", "automatique");
INSERT INTO `bd_postmeta` VALUES("162", "31", "_boite_de_vitesse", "field_5c915161ad5e4");
INSERT INTO `bd_postmeta` VALUES("163", "31", "vitesse_max", "304");
INSERT INTO `bd_postmeta` VALUES("164", "31", "_vitesse_max", "field_5c9151dbad5e5");
INSERT INTO `bd_postmeta` VALUES("165", "31", "chevaux", "450");
INSERT INTO `bd_postmeta` VALUES("166", "31", "_chevaux", "field_5c915aae15cc6");
INSERT INTO `bd_postmeta` VALUES("167", "31", "formulaire_contact", "");
INSERT INTO `bd_postmeta` VALUES("168", "31", "_formulaire_contact", "field_5c915c8d15cca");
INSERT INTO `bd_postmeta` VALUES("169", "31", "photo-gallery-1", "");
INSERT INTO `bd_postmeta` VALUES("170", "31", "_photo-gallery-1", "field_5d8b566efc2ef");
INSERT INTO `bd_postmeta` VALUES("171", "31", "photo-gallery-2", "");
INSERT INTO `bd_postmeta` VALUES("172", "31", "_photo-gallery-2", "field_5d8b7bc6fd7e0");
INSERT INTO `bd_postmeta` VALUES("173", "31", "photo-gallery-3", "");
INSERT INTO `bd_postmeta` VALUES("174", "31", "_photo-gallery-3", "field_5d8b7be4fd7e1");
INSERT INTO `bd_postmeta` VALUES("175", "31", "photo-gallery-4", "");
INSERT INTO `bd_postmeta` VALUES("176", "31", "_photo-gallery-4", "field_5d8b7becfd7e2");
INSERT INTO `bd_postmeta` VALUES("177", "33", "photo_classique", "32");
INSERT INTO `bd_postmeta` VALUES("178", "33", "_photo_classique", "field_60296f18d3509");
INSERT INTO `bd_postmeta` VALUES("179", "33", "video_voiture", "32");
INSERT INTO `bd_postmeta` VALUES("180", "33", "_video_voiture", "field_5c9150f2ad5e2");
INSERT INTO `bd_postmeta` VALUES("181", "33", "prix_test_drive", "2450");
INSERT INTO `bd_postmeta` VALUES("182", "33", "_prix_test_drive", "field_5c914feac25b6");
INSERT INTO `bd_postmeta` VALUES("183", "33", "prix_journee", "395");
INSERT INTO `bd_postmeta` VALUES("184", "33", "_prix_journee", "field_5c915bab15cc7");
INSERT INTO `bd_postmeta` VALUES("185", "33", "prix_wkend", "1500");
INSERT INTO `bd_postmeta` VALUES("186", "33", "_prix_wkend", "field_5c915bb915cc8");
INSERT INTO `bd_postmeta` VALUES("187", "33", "marque_de_la_voiture", "Porsche");
INSERT INTO `bd_postmeta` VALUES("188", "33", "_marque_de_la_voiture", "field_5c914f81c25b4");
INSERT INTO `bd_postmeta` VALUES("189", "33", "places", "4");
INSERT INTO `bd_postmeta` VALUES("190", "33", "_places", "field_5c915147ad5e3");
INSERT INTO `bd_postmeta` VALUES("191", "33", "boite_de_vitesse", "automatique");
INSERT INTO `bd_postmeta` VALUES("192", "33", "_boite_de_vitesse", "field_5c915161ad5e4");
INSERT INTO `bd_postmeta` VALUES("193", "33", "vitesse_max", "304");
INSERT INTO `bd_postmeta` VALUES("194", "33", "_vitesse_max", "field_5c9151dbad5e5");
INSERT INTO `bd_postmeta` VALUES("195", "33", "chevaux", "450");
INSERT INTO `bd_postmeta` VALUES("196", "33", "_chevaux", "field_5c915aae15cc6");
INSERT INTO `bd_postmeta` VALUES("197", "33", "formulaire_contact", "");
INSERT INTO `bd_postmeta` VALUES("198", "33", "_formulaire_contact", "field_5c915c8d15cca");
INSERT INTO `bd_postmeta` VALUES("199", "33", "photo-gallery-1", "");
INSERT INTO `bd_postmeta` VALUES("200", "33", "_photo-gallery-1", "field_5d8b566efc2ef");
INSERT INTO `bd_postmeta` VALUES("201", "33", "photo-gallery-2", "");
INSERT INTO `bd_postmeta` VALUES("202", "33", "_photo-gallery-2", "field_5d8b7bc6fd7e0");
INSERT INTO `bd_postmeta` VALUES("203", "33", "photo-gallery-3", "");
INSERT INTO `bd_postmeta` VALUES("204", "33", "_photo-gallery-3", "field_5d8b7be4fd7e1");
INSERT INTO `bd_postmeta` VALUES("205", "33", "photo-gallery-4", "");
INSERT INTO `bd_postmeta` VALUES("206", "33", "_photo-gallery-4", "field_5d8b7becfd7e2");
INSERT INTO `bd_postmeta` VALUES("207", "34", "_edit_last", "1");
INSERT INTO `bd_postmeta` VALUES("208", "34", "_edit_lock", "1682363012:1");
INSERT INTO `bd_postmeta` VALUES("209", "35", "_wp_attached_file", "2023/01/rsq8.png");
INSERT INTO `bd_postmeta` VALUES("210", "35", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:16:\"2023/01/rsq8.png\";s:8:\"filesize\";i:932511;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:16:\"rsq8-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:73745;}s:5:\"large\";a:5:{s:4:\"file\";s:17:\"rsq8-1024x683.png\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:642266;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:16:\"rsq8-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:30699;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:16:\"rsq8-768x512.png\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:389172;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bd_postmeta` VALUES("211", "34", "photo_classique", "35");
INSERT INTO `bd_postmeta` VALUES("212", "34", "_photo_classique", "field_60296f18d3509");
INSERT INTO `bd_postmeta` VALUES("213", "34", "video_voiture", "35");
INSERT INTO `bd_postmeta` VALUES("214", "34", "_video_voiture", "field_5c9150f2ad5e2");
INSERT INTO `bd_postmeta` VALUES("215", "34", "prix_test_drive", "2950");
INSERT INTO `bd_postmeta` VALUES("216", "34", "_prix_test_drive", "field_5c914feac25b6");
INSERT INTO `bd_postmeta` VALUES("217", "34", "prix_journee", "450");
INSERT INTO `bd_postmeta` VALUES("218", "34", "_prix_journee", "field_5c915bab15cc7");
INSERT INTO `bd_postmeta` VALUES("219", "34", "prix_wkend", "2000");
INSERT INTO `bd_postmeta` VALUES("220", "34", "_prix_wkend", "field_5c915bb915cc8");
INSERT INTO `bd_postmeta` VALUES("221", "34", "marque_de_la_voiture", "Audi");
INSERT INTO `bd_postmeta` VALUES("222", "34", "_marque_de_la_voiture", "field_5c914f81c25b4");
INSERT INTO `bd_postmeta` VALUES("223", "34", "places", "5");
INSERT INTO `bd_postmeta` VALUES("224", "34", "_places", "field_5c915147ad5e3");
INSERT INTO `bd_postmeta` VALUES("225", "34", "boite_de_vitesse", "automatique");
INSERT INTO `bd_postmeta` VALUES("226", "34", "_boite_de_vitesse", "field_5c915161ad5e4");
INSERT INTO `bd_postmeta` VALUES("227", "34", "vitesse_max", "250");
INSERT INTO `bd_postmeta` VALUES("228", "34", "_vitesse_max", "field_5c9151dbad5e5");
INSERT INTO `bd_postmeta` VALUES("229", "34", "chevaux", "600");
INSERT INTO `bd_postmeta` VALUES("230", "34", "_chevaux", "field_5c915aae15cc6");
INSERT INTO `bd_postmeta` VALUES("231", "34", "formulaire_contact", "");
INSERT INTO `bd_postmeta` VALUES("232", "34", "_formulaire_contact", "field_5c915c8d15cca");
INSERT INTO `bd_postmeta` VALUES("233", "34", "photo-gallery-1", "");
INSERT INTO `bd_postmeta` VALUES("234", "34", "_photo-gallery-1", "field_5d8b566efc2ef");
INSERT INTO `bd_postmeta` VALUES("235", "34", "photo-gallery-2", "");
INSERT INTO `bd_postmeta` VALUES("236", "34", "_photo-gallery-2", "field_5d8b7bc6fd7e0");
INSERT INTO `bd_postmeta` VALUES("237", "34", "photo-gallery-3", "");
INSERT INTO `bd_postmeta` VALUES("238", "34", "_photo-gallery-3", "field_5d8b7be4fd7e1");
INSERT INTO `bd_postmeta` VALUES("239", "34", "photo-gallery-4", "");
INSERT INTO `bd_postmeta` VALUES("240", "34", "_photo-gallery-4", "field_5d8b7becfd7e2");
INSERT INTO `bd_postmeta` VALUES("241", "36", "photo_classique", "35");
INSERT INTO `bd_postmeta` VALUES("242", "36", "_photo_classique", "field_60296f18d3509");
INSERT INTO `bd_postmeta` VALUES("243", "36", "video_voiture", "35");
INSERT INTO `bd_postmeta` VALUES("244", "36", "_video_voiture", "field_5c9150f2ad5e2");
INSERT INTO `bd_postmeta` VALUES("245", "36", "prix_test_drive", "2950");
INSERT INTO `bd_postmeta` VALUES("246", "36", "_prix_test_drive", "field_5c914feac25b6");
INSERT INTO `bd_postmeta` VALUES("247", "36", "prix_journee", "450");
INSERT INTO `bd_postmeta` VALUES("248", "36", "_prix_journee", "field_5c915bab15cc7");
INSERT INTO `bd_postmeta` VALUES("249", "36", "prix_wkend", "2000");
INSERT INTO `bd_postmeta` VALUES("250", "36", "_prix_wkend", "field_5c915bb915cc8");
INSERT INTO `bd_postmeta` VALUES("251", "36", "marque_de_la_voiture", "Audi");
INSERT INTO `bd_postmeta` VALUES("252", "36", "_marque_de_la_voiture", "field_5c914f81c25b4");
INSERT INTO `bd_postmeta` VALUES("253", "36", "places", "5");
INSERT INTO `bd_postmeta` VALUES("254", "36", "_places", "field_5c915147ad5e3");
INSERT INTO `bd_postmeta` VALUES("255", "36", "boite_de_vitesse", "automatique");
INSERT INTO `bd_postmeta` VALUES("256", "36", "_boite_de_vitesse", "field_5c915161ad5e4");
INSERT INTO `bd_postmeta` VALUES("257", "36", "vitesse_max", "250");
INSERT INTO `bd_postmeta` VALUES("258", "36", "_vitesse_max", "field_5c9151dbad5e5");
INSERT INTO `bd_postmeta` VALUES("259", "36", "chevaux", "600");
INSERT INTO `bd_postmeta` VALUES("260", "36", "_chevaux", "field_5c915aae15cc6");
INSERT INTO `bd_postmeta` VALUES("261", "36", "formulaire_contact", "");
INSERT INTO `bd_postmeta` VALUES("262", "36", "_formulaire_contact", "field_5c915c8d15cca");
INSERT INTO `bd_postmeta` VALUES("263", "36", "photo-gallery-1", "");
INSERT INTO `bd_postmeta` VALUES("264", "36", "_photo-gallery-1", "field_5d8b566efc2ef");
INSERT INTO `bd_postmeta` VALUES("265", "36", "photo-gallery-2", "");
INSERT INTO `bd_postmeta` VALUES("266", "36", "_photo-gallery-2", "field_5d8b7bc6fd7e0");
INSERT INTO `bd_postmeta` VALUES("267", "36", "photo-gallery-3", "");
INSERT INTO `bd_postmeta` VALUES("268", "36", "_photo-gallery-3", "field_5d8b7be4fd7e1");
INSERT INTO `bd_postmeta` VALUES("269", "36", "photo-gallery-4", "");
INSERT INTO `bd_postmeta` VALUES("270", "36", "_photo-gallery-4", "field_5d8b7becfd7e2");
INSERT INTO `bd_postmeta` VALUES("271", "37", "_wp_attached_file", "2023/01/mercedes_a_45_s_jaune2.png");
INSERT INTO `bd_postmeta` VALUES("272", "37", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:34:\"2023/01/mercedes_a_45_s_jaune2.png\";s:8:\"filesize\";i:728467;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:34:\"mercedes_a_45_s_jaune2-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:57245;}s:5:\"large\";a:5:{s:4:\"file\";s:35:\"mercedes_a_45_s_jaune2-1024x683.png\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:496407;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:34:\"mercedes_a_45_s_jaune2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:25335;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:34:\"mercedes_a_45_s_jaune2-768x512.png\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:296629;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bd_postmeta` VALUES("273", "38", "photo_classique", "37");
INSERT INTO `bd_postmeta` VALUES("274", "38", "_photo_classique", "field_60296f18d3509");
INSERT INTO `bd_postmeta` VALUES("275", "38", "video_voiture", "37");
INSERT INTO `bd_postmeta` VALUES("276", "38", "_video_voiture", "field_5c9150f2ad5e2");
INSERT INTO `bd_postmeta` VALUES("277", "38", "prix_test_drive", "2250");
INSERT INTO `bd_postmeta` VALUES("278", "38", "_prix_test_drive", "field_5c914feac25b6");
INSERT INTO `bd_postmeta` VALUES("279", "38", "prix_journee", "345");
INSERT INTO `bd_postmeta` VALUES("280", "38", "_prix_journee", "field_5c915bab15cc7");
INSERT INTO `bd_postmeta` VALUES("281", "38", "prix_wkend", "1250");
INSERT INTO `bd_postmeta` VALUES("282", "38", "_prix_wkend", "field_5c915bb915cc8");
INSERT INTO `bd_postmeta` VALUES("283", "38", "marque_de_la_voiture", "Mercedes");
INSERT INTO `bd_postmeta` VALUES("284", "38", "_marque_de_la_voiture", "field_5c914f81c25b4");
INSERT INTO `bd_postmeta` VALUES("285", "38", "places", "5");
INSERT INTO `bd_postmeta` VALUES("286", "38", "_places", "field_5c915147ad5e3");
INSERT INTO `bd_postmeta` VALUES("287", "38", "boite_de_vitesse", "automatique");
INSERT INTO `bd_postmeta` VALUES("288", "38", "_boite_de_vitesse", "field_5c915161ad5e4");
INSERT INTO `bd_postmeta` VALUES("289", "38", "vitesse_max", "270");
INSERT INTO `bd_postmeta` VALUES("290", "38", "_vitesse_max", "field_5c9151dbad5e5");
INSERT INTO `bd_postmeta` VALUES("291", "38", "chevaux", "420");
INSERT INTO `bd_postmeta` VALUES("292", "38", "_chevaux", "field_5c915aae15cc6");
INSERT INTO `bd_postmeta` VALUES("293", "38", "formulaire_contact", "");
INSERT INTO `bd_postmeta` VALUES("294", "38", "_formulaire_contact", "field_5c915c8d15cca");
INSERT INTO `bd_postmeta` VALUES("295", "38", "photo-gallery-1", "");
INSERT INTO `bd_postmeta` VALUES("296", "38", "_photo-gallery-1", "field_5d8b566efc2ef");
INSERT INTO `bd_postmeta` VALUES("297", "38", "photo-gallery-2", "");
INSERT INTO `bd_postmeta` VALUES("298", "38", "_photo-gallery-2", "field_5d8b7bc6fd7e0");
INSERT INTO `bd_postmeta` VALUES("299", "38", "photo-gallery-3", "");
INSERT INTO `bd_postmeta` VALUES("300", "38", "_photo-gallery-3", "field_5d8b7be4fd7e1");
INSERT INTO `bd_postmeta` VALUES("301", "38", "photo-gallery-4", "");
INSERT INTO `bd_postmeta` VALUES("302", "38", "_photo-gallery-4", "field_5d8b7becfd7e2");
INSERT INTO `bd_postmeta` VALUES("303", "39", "_wp_attached_file", "2023/01/Sans-titre-2.jpg");
INSERT INTO `bd_postmeta` VALUES("304", "39", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:24:\"2023/01/Sans-titre-2.jpg\";s:8:\"filesize\";i:20739;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:24:\"Sans-titre-2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9879;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:24:\"Sans-titre-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6382;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bd_postmeta` VALUES("305", "40", "_wp_attached_file", "2023/01/cropped-Sans-titre-2.jpg");
INSERT INTO `bd_postmeta` VALUES("306", "40", "_wp_attachment_context", "site-icon");
INSERT INTO `bd_postmeta` VALUES("307", "40", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:32:\"2023/01/cropped-Sans-titre-2.jpg\";s:8:\"filesize\";i:17370;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:32:\"cropped-Sans-titre-2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9898;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"cropped-Sans-titre-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6381;}s:13:\"site_icon-270\";a:5:{s:4:\"file\";s:32:\"cropped-Sans-titre-2-270x270.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9260;}s:13:\"site_icon-192\";a:5:{s:4:\"file\";s:32:\"cropped-Sans-titre-2-192x192.jpg\";s:5:\"width\";i:192;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7162;}s:13:\"site_icon-180\";a:5:{s:4:\"file\";s:32:\"cropped-Sans-titre-2-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6899;}s:12:\"site_icon-32\";a:5:{s:4:\"file\";s:30:\"cropped-Sans-titre-2-32x32.jpg\";s:5:\"width\";i:32;s:6:\"height\";i:32;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3929;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bd_postmeta` VALUES("310", "43", "_wp_attached_file", "2023/02/logo-.png");
INSERT INTO `bd_postmeta` VALUES("311", "43", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:300;s:6:\"height\";i:110;s:4:\"file\";s:17:\"2023/02/logo-.png\";s:8:\"filesize\";i:18803;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"logo--150x110.png\";s:5:\"width\";i:150;s:6:\"height\";i:110;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9059;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bd_postmeta` VALUES("331", "53", "_wp_attached_file", "2023/02/cla-bg.jpg");
INSERT INTO `bd_postmeta` VALUES("332", "53", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:563;s:4:\"file\";s:18:\"2023/02/cla-bg.jpg\";s:8:\"filesize\";i:319056;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"cla-bg-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14229;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"cla-bg-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8424;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"cla-bg-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:60229;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bd_postmeta` VALUES("341", "58", "_wp_attached_file", "2023/02/cla-bg-2.jpg");
INSERT INTO `bd_postmeta` VALUES("342", "58", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1310;s:6:\"height\";i:634;s:4:\"file\";s:20:\"2023/02/cla-bg-2.jpg\";s:8:\"filesize\";i:280150;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"cla-bg-2-300x145.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:145;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7429;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"cla-bg-2-1024x496.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:496;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:44760;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"cla-bg-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4776;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"cla-bg-2-768x372.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:372;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29083;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bd_postmeta` VALUES("345", "60", "_wp_attached_file", "2023/01/cropped-911.png");
INSERT INTO `bd_postmeta` VALUES("346", "60", "_wp_attachment_context", "custom-logo");
INSERT INTO `bd_postmeta` VALUES("347", "60", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:800;s:6:\"height\";i:386;s:4:\"file\";s:23:\"2023/01/cropped-911.png\";s:8:\"filesize\";i:222531;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:23:\"cropped-911-300x145.png\";s:5:\"width\";i:300;s:6:\"height\";i:145;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:44955;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:23:\"cropped-911-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:27443;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:23:\"cropped-911-768x371.png\";s:5:\"width\";i:768;s:6:\"height\";i:371;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:199106;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bd_postmeta` VALUES("357", "65", "_edit_lock", "1676563327:1");
INSERT INTO `bd_postmeta` VALUES("358", "65", "_wp_page_template", "mention-legal.php");
INSERT INTO `bd_postmeta` VALUES("359", "68", "_wp_attached_file", "2023/02/faviconefd.jpg");
INSERT INTO `bd_postmeta` VALUES("360", "68", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:22:\"2023/02/faviconefd.jpg\";s:8:\"filesize\";i:31022;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"faviconefd-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11283;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"faviconefd-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6072;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bd_postmeta` VALUES("361", "69", "_wp_attached_file", "2023/02/cropped-faviconefd.jpg");
INSERT INTO `bd_postmeta` VALUES("362", "69", "_wp_attachment_context", "site-icon");
INSERT INTO `bd_postmeta` VALUES("363", "69", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:30:\"2023/02/cropped-faviconefd.jpg\";s:8:\"filesize\";i:23483;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"cropped-faviconefd-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11298;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"cropped-faviconefd-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6074;}s:13:\"site_icon-270\";a:5:{s:4:\"file\";s:30:\"cropped-faviconefd-270x270.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10086;}s:13:\"site_icon-192\";a:5:{s:4:\"file\";s:30:\"cropped-faviconefd-192x192.jpg\";s:5:\"width\";i:192;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7299;}s:13:\"site_icon-180\";a:5:{s:4:\"file\";s:30:\"cropped-faviconefd-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7009;}s:12:\"site_icon-32\";a:5:{s:4:\"file\";s:28:\"cropped-faviconefd-32x32.jpg\";s:5:\"width\";i:32;s:6:\"height\";i:32;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3716;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bd_postmeta` VALUES("366", "71", "_wp_trash_meta_status", "publish");
INSERT INTO `bd_postmeta` VALUES("367", "71", "_wp_trash_meta_time", "1682357982");
INSERT INTO `bd_postmeta` VALUES("368", "72", "_wp_trash_meta_status", "publish");
INSERT INTO `bd_postmeta` VALUES("369", "72", "_wp_trash_meta_time", "1682358013");
INSERT INTO `bd_postmeta` VALUES("370", "74", "_wp_trash_meta_status", "publish");
INSERT INTO `bd_postmeta` VALUES("371", "74", "_wp_trash_meta_time", "1682358799");
INSERT INTO `bd_postmeta` VALUES("372", "75", "_wp_trash_meta_status", "publish");
INSERT INTO `bd_postmeta` VALUES("373", "75", "_wp_trash_meta_time", "1682358807");
INSERT INTO `bd_postmeta` VALUES("374", "76", "_wp_trash_meta_status", "publish");
INSERT INTO `bd_postmeta` VALUES("375", "76", "_wp_trash_meta_time", "1682358928");
INSERT INTO `bd_postmeta` VALUES("376", "77", "_wp_attached_file", "2023/02/cropped-faviconefd-1.jpg");
INSERT INTO `bd_postmeta` VALUES("377", "77", "_wp_attachment_context", "custom-logo");
INSERT INTO `bd_postmeta` VALUES("378", "77", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:32:\"2023/02/cropped-faviconefd-1.jpg\";s:8:\"filesize\";i:23483;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:32:\"cropped-faviconefd-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11298;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"cropped-faviconefd-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6074;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bd_postmeta` VALUES("379", "78", "_wp_attached_file", "2023/02/cropped-cla-bg.jpg");
INSERT INTO `bd_postmeta` VALUES("380", "78", "_wp_attachment_context", "custom-logo");
INSERT INTO `bd_postmeta` VALUES("381", "78", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:563;s:6:\"height\";i:563;s:4:\"file\";s:26:\"2023/02/cropped-cla-bg.jpg\";s:8:\"filesize\";i:67753;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"cropped-cla-bg-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23976;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"cropped-cla-bg-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8429;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bd_postmeta` VALUES("382", "79", "_wp_trash_meta_status", "publish");
INSERT INTO `bd_postmeta` VALUES("383", "79", "_wp_trash_meta_time", "1682360261");
INSERT INTO `bd_postmeta` VALUES("384", "80", "_wp_trash_meta_status", "publish");
INSERT INTO `bd_postmeta` VALUES("385", "80", "_wp_trash_meta_time", "1682360295");
INSERT INTO `bd_postmeta` VALUES("386", "81", "_edit_lock", "1682360395:1");
INSERT INTO `bd_postmeta` VALUES("387", "81", "_wp_trash_meta_status", "publish");
INSERT INTO `bd_postmeta` VALUES("388", "81", "_wp_trash_meta_time", "1682360423");
INSERT INTO `bd_postmeta` VALUES("389", "82", "_edit_lock", "1682360455:1");
INSERT INTO `bd_postmeta` VALUES("390", "82", "_wp_trash_meta_status", "publish");
INSERT INTO `bd_postmeta` VALUES("391", "82", "_wp_trash_meta_time", "1682360458");
INSERT INTO `bd_postmeta` VALUES("392", "83", "_wp_trash_meta_status", "publish");
INSERT INTO `bd_postmeta` VALUES("393", "83", "_wp_trash_meta_time", "1682360476");

/* INSERT TABLE DATA: bd_posts */
INSERT INTO `bd_posts` VALUES("2", "1", "2023-01-20 19:50:55", "2023-01-20 18:50:55", "<!-- wp:paragraph -->\n<p>Ceci est une page d’exemple. C’est différent d’un article de blog parce qu’elle restera au même endroit et apparaîtra dans la navigation de votre site (dans la plupart des thèmes). La plupart des gens commencent par une page « À propos » qui les présente aux personnes visitant le site. Cela pourrait ressembler à quelque chose comme cela :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>Bonjour ! Je suis un mécanicien qui aspire à devenir acteur, et voici mon site. J’habite à Bordeaux, j’ai un super chien baptisé Russell, et j’aime la vodka (ainsi qu’être surpris par la pluie soudaine lors de longues balades sur la plage au coucher du soleil).</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>…ou quelque chose comme cela :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>La société 123 Machin Truc a été créée en 1971, et n’a cessé de proposer au public des machins-trucs de qualité depuis lors. Située à Saint-Remy-en-Bouzemont-Saint-Genest-et-Isson, 123 Machin Truc emploie 2 000 personnes, et fabrique toutes sortes de bidules supers pour la communauté bouzemontoise.</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>En tant que nouvel utilisateur ou utilisatrice de WordPress, vous devriez vous rendre sur <a href=\"http://yomi-avis.fr/wp-admin/\">votre tableau de bord</a> pour supprimer cette page et créer de nouvelles pages pour votre contenu. Amusez-vous bien !</p>\n<!-- /wp:paragraph -->", "Page d’exemple", "", "publish", "closed", "open", "", "page-d-exemple", "", "", "2023-01-20 19:50:55", "2023-01-20 18:50:55", "", "0", "http://yomi-avis.fr/?page_id=2", "0", "page", "", "0");
INSERT INTO `bd_posts` VALUES("3", "1", "2023-01-20 19:50:55", "2023-01-20 18:50:55", "<!-- wp:heading --><h2>Qui sommes-nous ?</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>L’adresse de notre site est : http://bdprestige.fr.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Commentaires</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Quand vous laissez un commentaire sur notre site, les données inscrites dans le formulaire de commentaire, ainsi que votre adresse IP et l’agent utilisateur de votre navigateur sont collectés pour nous aider à la détection des commentaires indésirables.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Une chaîne anonymisée créée à partir de votre adresse e-mail (également appelée hash) peut être envoyée au service Gravatar pour vérifier si vous utilisez ce dernier. Les clauses de confidentialité du service Gravatar sont disponibles ici : https://automattic.com/privacy/. Après validation de votre commentaire, votre photo de profil sera visible publiquement à coté de votre commentaire.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Médias</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous téléversez des images sur le site, nous vous conseillons d’éviter de téléverser des images contenant des données EXIF de coordonnées GPS. Les personnes visitant votre site peuvent télécharger et extraire des données de localisation depuis ces images.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Cookies</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous déposez un commentaire sur notre site, il vous sera proposé d’enregistrer votre nom, adresse e-mail et site dans des cookies. C’est uniquement pour votre confort afin de ne pas avoir à saisir ces informations si vous déposez un autre commentaire plus tard. Ces cookies expirent au bout d’un an.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Si vous vous rendez sur la page de connexion, un cookie temporaire sera créé afin de déterminer si votre navigateur accepte les cookies. Il ne contient pas de données personnelles et sera supprimé automatiquement à la fermeture de votre navigateur.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorsque vous vous connecterez, nous mettrons en place un certain nombre de cookies pour enregistrer vos informations de connexion et vos préférences d’écran. La durée de vie d’un cookie de connexion est de deux jours, celle d’un cookie d’option d’écran est d’un an. Si vous cochez « Se souvenir de moi », votre cookie de connexion sera conservé pendant deux semaines. Si vous vous déconnectez de votre compte, le cookie de connexion sera effacé.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>En modifiant ou en publiant une publication, un cookie supplémentaire sera enregistré dans votre navigateur. Ce cookie ne comprend aucune donnée personnelle. Il indique simplement l’ID de la publication que vous venez de modifier. Il expire au bout d’un jour.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Contenu embarqué depuis d’autres sites</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Les articles de ce site peuvent inclure des contenus intégrés (par exemple des vidéos, images, articles…). Le contenu intégré depuis d’autres sites se comporte de la même manière que si le visiteur se rendait sur cet autre site.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Ces sites web pourraient collecter des données sur vous, utiliser des cookies, embarquer des outils de suivis tiers, suivre vos interactions avec ces contenus embarqués si vous disposez d’un compte connecté sur leur site web.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Utilisation et transmission de vos données personnelles</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous demandez une réinitialisation de votre mot de passe, votre adresse IP sera incluse dans l’e-mail de réinitialisation.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Durées de stockage de vos données</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous laissez un commentaire, le commentaire et ses métadonnées sont conservés indéfiniment. Cela permet de reconnaître et approuver automatiquement les commentaires suivants au lieu de les laisser dans la file de modération.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Pour les comptes qui s’inscrivent sur notre site (le cas échéant), nous stockons également les données personnelles indiquées dans leur profil. Tous les comptes peuvent voir, modifier ou supprimer leurs informations personnelles à tout moment (à l’exception de leur identifiant). Les gestionnaires du site peuvent aussi voir et modifier ces informations.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Les droits que vous avez sur vos données</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous avez un compte ou si vous avez laissé des commentaires sur le site, vous pouvez demander à recevoir un fichier contenant toutes les données personnelles que nous possédons à votre sujet, incluant celles que vous nous avez fournies. Vous pouvez également demander la suppression des données personnelles vous concernant. Cela ne prend pas en compte les données stockées à des fins administratives, légales ou pour des raisons de sécurité.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Où vos données sont envoyées</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Les commentaires des visiteurs peuvent être vérifiés à l’aide d’un service automatisé de détection des commentaires indésirables.</p><!-- /wp:paragraph -->", "Politique de confidentialité", "", "draft", "closed", "open", "", "politique-de-confidentialite", "", "", "2023-01-20 19:50:55", "2023-01-20 18:50:55", "", "0", "http://yomi-avis.fr/?page_id=3", "0", "page", "", "0");
INSERT INTO `bd_posts` VALUES("5", "1", "2023-01-20 20:44:58", "2023-01-20 19:44:58", "", "Contact", "", "publish", "closed", "closed", "", "contact", "", "", "2023-01-20 20:44:58", "2023-01-20 19:44:58", "", "0", "http://yomi-avis.fr/?page_id=5", "0", "page", "", "0");
INSERT INTO `bd_posts` VALUES("6", "1", "2023-01-20 20:44:58", "2023-01-20 19:44:58", "", "Contact", "", "inherit", "closed", "closed", "", "5-revision-v1", "", "", "2023-01-20 20:44:58", "2023-01-20 19:44:58", "", "5", "http://yomi-avis.fr/?p=6", "0", "revision", "", "0");
INSERT INTO `bd_posts` VALUES("7", "1", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "a:8:{s:8:\"location\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"param\";s:9:\"post_type\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:7:\"voiture\";}}}s:8:\"position\";s:6:\"normal\";s:5:\"style\";s:7:\"default\";s:15:\"label_placement\";s:3:\"top\";s:21:\"instruction_placement\";s:5:\"label\";s:14:\"hide_on_screen\";a:9:{i:0;s:7:\"excerpt\";i:1;s:10:\"discussion\";i:2;s:8:\"comments\";i:3;s:9:\"revisions\";i:4;s:6:\"author\";i:5;s:6:\"format\";i:6;s:14:\"featured_image\";i:7;s:10:\"categories\";i:8;s:15:\"send-trackbacks\";}s:11:\"description\";s:0:\"\";s:12:\"show_in_rest\";b:0;}", "voiture", "voiture", "publish", "closed", "closed", "", "group_5c914f77bea17", "", "", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "", "0", "http://yomi-avis.fr/?p=7", "1", "acf-field-group", "", "0");
INSERT INTO `bd_posts` VALUES("8", "1", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "a:15:{s:4:\"type\";s:5:\"image\";s:12:\"instructions\";s:18:\"La photo de profil\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"return_format\";s:5:\"array\";s:12:\"preview_size\";s:9:\"thumbnail\";s:7:\"library\";s:3:\"all\";s:9:\"min_width\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:8:\"min_size\";s:0:\"\";s:9:\"max_width\";s:0:\"\";s:10:\"max_height\";s:0:\"\";s:8:\"max_size\";s:0:\"\";s:10:\"mime_types\";s:0:\"\";}", "photo classique", "photo_classique", "publish", "closed", "closed", "", "field_60296f18d3509", "", "", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "", "7", "http://yomi-avis.fr/?post_type=acf-field&p=8", "0", "acf-field", "", "0");
INSERT INTO `bd_posts` VALUES("9", "1", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "a:15:{s:4:\"type\";s:5:\"image\";s:12:\"instructions\";s:40:\"video de la voiture pour la page produit\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"return_format\";s:3:\"url\";s:12:\"preview_size\";s:9:\"thumbnail\";s:7:\"library\";s:3:\"all\";s:9:\"min_width\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:8:\"min_size\";s:0:\"\";s:9:\"max_width\";s:0:\"\";s:10:\"max_height\";s:0:\"\";s:8:\"max_size\";s:0:\"\";s:10:\"mime_types\";s:0:\"\";}", "photo de couverture voiture", "video_voiture", "publish", "closed", "closed", "", "field_5c9150f2ad5e2", "", "", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "", "7", "http://yomi-avis.fr/?post_type=acf-field&p=9", "1", "acf-field", "", "0");
INSERT INTO `bd_posts` VALUES("10", "1", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";i:49;s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "Semaine 7j", "prix_test_drive", "publish", "closed", "closed", "", "field_5c914feac25b6", "", "", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "", "7", "http://yomi-avis.fr/?post_type=acf-field&p=10", "2", "acf-field", "", "0");
INSERT INTO `bd_posts` VALUES("11", "1", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "prix journée", "prix_journee", "publish", "closed", "closed", "", "field_5c915bab15cc7", "", "", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "", "7", "http://yomi-avis.fr/?post_type=acf-field&p=11", "3", "acf-field", "", "0");
INSERT INTO `bd_posts` VALUES("12", "1", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "prix week end", "prix_wkend", "publish", "closed", "closed", "", "field_5c915bb915cc8", "", "", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "", "7", "http://yomi-avis.fr/?post_type=acf-field&p=12", "4", "acf-field", "", "0");
INSERT INTO `bd_posts` VALUES("13", "1", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "Marque de la voiture", "marque_de_la_voiture", "publish", "closed", "closed", "", "field_5c914f81c25b4", "", "", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "", "7", "http://yomi-avis.fr/?post_type=acf-field&p=13", "5", "acf-field", "", "0");
INSERT INTO `bd_posts` VALUES("14", "1", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:31:\"nombre de place dans la voiture\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";i:2;s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "places", "places", "publish", "closed", "closed", "", "field_5c915147ad5e3", "", "", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "", "7", "http://yomi-avis.fr/?post_type=acf-field&p=14", "6", "acf-field", "", "0");
INSERT INTO `bd_posts` VALUES("15", "1", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "a:13:{s:4:\"type\";s:6:\"select\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:7:\"choices\";a:2:{s:8:\"Manuelle\";s:8:\"Manuelle\";s:11:\"automatique\";s:11:\"automatique\";}s:13:\"default_value\";b:0;s:10:\"allow_null\";i:0;s:8:\"multiple\";i:0;s:2:\"ui\";i:0;s:13:\"return_format\";s:5:\"value\";s:4:\"ajax\";i:0;s:11:\"placeholder\";s:0:\"\";}", "boite de vitesse", "boite_de_vitesse", "publish", "closed", "closed", "", "field_5c915161ad5e4", "", "", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "", "7", "http://yomi-avis.fr/?post_type=acf-field&p=15", "7", "acf-field", "", "0");
INSERT INTO `bd_posts` VALUES("16", "1", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "vitesse max", "vitesse_max", "publish", "closed", "closed", "", "field_5c9151dbad5e5", "", "", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "", "7", "http://yomi-avis.fr/?post_type=acf-field&p=16", "8", "acf-field", "", "0");
INSERT INTO `bd_posts` VALUES("17", "1", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "chevaux", "chevaux", "publish", "closed", "closed", "", "field_5c915aae15cc6", "", "", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "", "7", "http://yomi-avis.fr/?post_type=acf-field&p=17", "9", "acf-field", "", "0");
INSERT INTO `bd_posts` VALUES("18", "1", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "a:10:{s:4:\"type\";s:7:\"wysiwyg\";s:12:\"instructions\";s:37:\"rentre l\'id du forumulaire de contact\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:4:\"tabs\";s:3:\"all\";s:7:\"toolbar\";s:4:\"full\";s:12:\"media_upload\";i:1;s:5:\"delay\";i:0;}", "formulaire contact", "formulaire_contact", "publish", "closed", "closed", "", "field_5c915c8d15cca", "", "", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "", "7", "http://yomi-avis.fr/?post_type=acf-field&p=18", "10", "acf-field", "", "0");
INSERT INTO `bd_posts` VALUES("19", "1", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "a:15:{s:4:\"type\";s:5:\"image\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"return_format\";s:2:\"id\";s:12:\"preview_size\";s:9:\"thumbnail\";s:7:\"library\";s:3:\"all\";s:9:\"min_width\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:8:\"min_size\";s:0:\"\";s:9:\"max_width\";s:0:\"\";s:10:\"max_height\";s:0:\"\";s:8:\"max_size\";s:0:\"\";s:10:\"mime_types\";s:0:\"\";}", "photo-gallery-1", "photo-gallery-1", "publish", "closed", "closed", "", "field_5d8b566efc2ef", "", "", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "", "7", "http://yomi-avis.fr/?post_type=acf-field&p=19", "11", "acf-field", "", "0");
INSERT INTO `bd_posts` VALUES("20", "1", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "a:15:{s:4:\"type\";s:5:\"image\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"return_format\";s:2:\"id\";s:12:\"preview_size\";s:9:\"thumbnail\";s:7:\"library\";s:3:\"all\";s:9:\"min_width\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:8:\"min_size\";s:0:\"\";s:9:\"max_width\";s:0:\"\";s:10:\"max_height\";s:0:\"\";s:8:\"max_size\";s:0:\"\";s:10:\"mime_types\";s:0:\"\";}", "photo-gallery-2", "photo-gallery-2", "publish", "closed", "closed", "", "field_5d8b7bc6fd7e0", "", "", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "", "7", "http://yomi-avis.fr/?post_type=acf-field&p=20", "12", "acf-field", "", "0");
INSERT INTO `bd_posts` VALUES("21", "1", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "a:15:{s:4:\"type\";s:5:\"image\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"return_format\";s:2:\"id\";s:12:\"preview_size\";s:9:\"thumbnail\";s:7:\"library\";s:3:\"all\";s:9:\"min_width\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:8:\"min_size\";s:0:\"\";s:9:\"max_width\";s:0:\"\";s:10:\"max_height\";s:0:\"\";s:8:\"max_size\";s:0:\"\";s:10:\"mime_types\";s:0:\"\";}", "photo-gallery-3", "photo-gallery-3", "publish", "closed", "closed", "", "field_5d8b7be4fd7e1", "", "", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "", "7", "http://yomi-avis.fr/?post_type=acf-field&p=21", "13", "acf-field", "", "0");
INSERT INTO `bd_posts` VALUES("22", "1", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "a:15:{s:4:\"type\";s:5:\"image\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"return_format\";s:2:\"id\";s:12:\"preview_size\";s:9:\"thumbnail\";s:7:\"library\";s:3:\"all\";s:9:\"min_width\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:8:\"min_size\";s:0:\"\";s:9:\"max_width\";s:0:\"\";s:10:\"max_height\";s:0:\"\";s:8:\"max_size\";s:0:\"\";s:10:\"mime_types\";s:0:\"\";}", "photo-gallery-4", "photo-gallery-4", "publish", "closed", "closed", "", "field_5d8b7becfd7e2", "", "", "2023-01-20 20:52:20", "2023-01-20 19:52:20", "", "7", "http://yomi-avis.fr/?post_type=acf-field&p=22", "14", "acf-field", "", "0");
INSERT INTO `bd_posts` VALUES("23", "1", "2023-01-20 20:54:02", "2023-01-20 19:54:02", "", "A45s", "", "publish", "closed", "open", "", "a45s", "", "", "2023-01-20 21:07:14", "2023-01-20 20:07:14", "", "0", "http://yomi-avis.fr/?post_type=voiture&#038;p=23", "0", "voiture", "", "0");
INSERT INTO `bd_posts` VALUES("24", "1", "2023-01-20 20:52:54", "2023-01-20 19:52:54", "", "mercedes_a_45_s_jaune", "", "inherit", "open", "closed", "", "mercedes_a_45_s_jaune", "", "", "2023-01-20 20:52:54", "2023-01-20 19:52:54", "", "23", "http://yomi-avis.fr/wp-content/uploads/2023/01/mercedes_a_45_s_jaune.png", "0", "attachment", "image/png", "0");
INSERT INTO `bd_posts` VALUES("25", "1", "2023-01-20 20:54:02", "2023-01-20 19:54:02", "", "A45s", "", "inherit", "closed", "closed", "", "23-revision-v1", "", "", "2023-01-20 20:54:02", "2023-01-20 19:54:02", "", "23", "http://yomi-avis.fr/?p=25", "0", "revision", "", "0");
INSERT INTO `bd_posts` VALUES("27", "1", "2023-01-20 20:56:54", "2023-01-20 19:56:54", "", "RSQ3", "", "publish", "closed", "open", "", "rsq3", "", "", "2023-01-20 21:00:49", "2023-01-20 20:00:49", "", "0", "http://yomi-avis.fr/?post_type=voiture&#038;p=27", "0", "voiture", "", "0");
INSERT INTO `bd_posts` VALUES("28", "1", "2023-01-20 20:56:48", "2023-01-20 19:56:48", "", "7434-min", "", "inherit", "open", "closed", "", "7434-min", "", "", "2023-01-20 20:56:48", "2023-01-20 19:56:48", "", "27", "http://yomi-avis.fr/wp-content/uploads/2023/01/7434-min.png", "0", "attachment", "image/png", "0");
INSERT INTO `bd_posts` VALUES("29", "1", "2023-01-20 20:56:54", "2023-01-20 19:56:54", "", "RSQ3", "", "inherit", "closed", "closed", "", "27-revision-v1", "", "", "2023-01-20 20:56:54", "2023-01-20 19:56:54", "", "27", "http://yomi-avis.fr/?p=29", "0", "revision", "", "0");
INSERT INTO `bd_posts` VALUES("31", "1", "2023-01-20 21:03:39", "2023-01-20 20:03:39", "", "911 4s", "", "publish", "closed", "open", "", "rsq3-2", "", "", "2023-01-20 21:03:39", "2023-01-20 20:03:39", "", "0", "http://yomi-avis.fr/?post_type=voiture&#038;p=31", "0", "voiture", "", "0");
INSERT INTO `bd_posts` VALUES("32", "1", "2023-01-20 21:02:00", "2023-01-20 20:02:00", "", "911", "", "inherit", "open", "closed", "", "911", "", "", "2023-01-20 21:02:00", "2023-01-20 20:02:00", "", "31", "http://yomi-avis.fr/wp-content/uploads/2023/01/911.png", "0", "attachment", "image/png", "0");
INSERT INTO `bd_posts` VALUES("33", "1", "2023-01-20 21:03:39", "2023-01-20 20:03:39", "", "911 4s", "", "inherit", "closed", "closed", "", "31-revision-v1", "", "", "2023-01-20 21:03:39", "2023-01-20 20:03:39", "", "31", "http://yomi-avis.fr/?p=33", "0", "revision", "", "0");
INSERT INTO `bd_posts` VALUES("34", "1", "2023-01-20 21:05:02", "2023-01-20 20:05:02", "", "RSQ8", "", "publish", "closed", "open", "", "rsq8", "", "", "2023-01-20 21:05:02", "2023-01-20 20:05:02", "", "0", "http://yomi-avis.fr/?post_type=voiture&#038;p=34", "0", "voiture", "", "0");
INSERT INTO `bd_posts` VALUES("35", "1", "2023-01-20 21:03:56", "2023-01-20 20:03:56", "", "rsq8", "", "inherit", "open", "closed", "", "rsq8", "", "", "2023-01-20 21:03:56", "2023-01-20 20:03:56", "", "34", "http://yomi-avis.fr/wp-content/uploads/2023/01/rsq8.png", "0", "attachment", "image/png", "0");
INSERT INTO `bd_posts` VALUES("36", "1", "2023-01-20 21:05:02", "2023-01-20 20:05:02", "", "RSQ8", "", "inherit", "closed", "closed", "", "34-revision-v1", "", "", "2023-01-20 21:05:02", "2023-01-20 20:05:02", "", "34", "http://yomi-avis.fr/?p=36", "0", "revision", "", "0");
INSERT INTO `bd_posts` VALUES("37", "1", "2023-01-20 21:05:18", "2023-01-20 20:05:18", "", "mercedes_a_45_s_jaune2", "", "inherit", "open", "closed", "", "mercedes_a_45_s_jaune2", "", "", "2023-01-20 21:05:18", "2023-01-20 20:05:18", "", "23", "http://yomi-avis.fr/wp-content/uploads/2023/01/mercedes_a_45_s_jaune2.png", "0", "attachment", "image/png", "0");
INSERT INTO `bd_posts` VALUES("38", "1", "2023-01-20 21:05:26", "2023-01-20 20:05:26", "", "A45s", "", "inherit", "closed", "closed", "", "23-revision-v1", "", "", "2023-01-20 21:05:26", "2023-01-20 20:05:26", "", "23", "http://yomi-avis.fr/?p=38", "0", "revision", "", "0");
INSERT INTO `bd_posts` VALUES("39", "1", "2023-01-20 21:07:01", "2023-01-20 20:07:01", "", "Sans titre-2", "", "inherit", "open", "closed", "", "sans-titre-2", "", "", "2023-01-20 21:07:01", "2023-01-20 20:07:01", "", "0", "http://yomi-avis.fr/wp-content/uploads/2023/01/Sans-titre-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `bd_posts` VALUES("40", "1", "2023-01-20 21:07:04", "2023-01-20 20:07:04", "http://yomi-avis.fr/wp-content/uploads/2023/01/cropped-Sans-titre-2.jpg", "cropped-Sans-titre-2.jpg", "", "inherit", "open", "closed", "", "cropped-sans-titre-2-jpg", "", "", "2023-01-20 21:07:04", "2023-01-20 20:07:04", "", "0", "http://yomi-avis.fr/wp-content/uploads/2023/01/cropped-Sans-titre-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `bd_posts` VALUES("43", "1", "2023-02-10 19:49:14", "2023-02-10 18:49:14", "", "logo-", "", "inherit", "open", "closed", "", "logo", "", "", "2023-02-10 19:49:14", "2023-02-10 18:49:14", "", "0", "http://yomi-avis.fr/wp-content/uploads/2023/02/logo-.png", "0", "attachment", "image/png", "0");
INSERT INTO `bd_posts` VALUES("53", "1", "2023-02-10 20:23:38", "2023-02-10 19:23:38", "", "cla-bg", "", "inherit", "open", "closed", "", "cla-bg", "", "", "2023-02-10 20:23:38", "2023-02-10 19:23:38", "", "0", "http://yomi-avis.fr/wp-content/uploads/2023/02/cla-bg.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `bd_posts` VALUES("58", "1", "2023-02-10 20:31:56", "2023-02-10 19:31:56", "", "cla-bg-2", "", "inherit", "open", "closed", "", "cla-bg-2", "", "", "2023-02-10 20:31:56", "2023-02-10 19:31:56", "", "0", "http://yomi-avis.fr/wp-content/uploads/2023/02/cla-bg-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `bd_posts` VALUES("60", "1", "2023-02-10 20:56:52", "2023-02-10 19:56:52", "http://yomi-avis.fr/wp-content/uploads/2023/01/cropped-911.png", "cropped-911.png", "", "inherit", "open", "closed", "", "cropped-911-png", "", "", "2023-02-10 20:56:52", "2023-02-10 19:56:52", "", "0", "http://yomi-avis.fr/wp-content/uploads/2023/01/cropped-911.png", "0", "attachment", "image/png", "0");
INSERT INTO `bd_posts` VALUES("65", "1", "2023-02-16 17:01:27", "2023-02-16 16:01:27", "", "Mentions légales", "", "publish", "closed", "closed", "", "mentions-legales", "", "", "2023-02-16 17:01:27", "2023-02-16 16:01:27", "", "0", "http://yomi-avis.fr/?page_id=65", "0", "page", "", "0");
INSERT INTO `bd_posts` VALUES("66", "1", "2023-02-16 17:01:27", "2023-02-16 16:01:27", "", "Mentions légales", "", "inherit", "closed", "closed", "", "65-revision-v1", "", "", "2023-02-16 17:01:27", "2023-02-16 16:01:27", "", "65", "http://yomi-avis.fr/?p=66", "0", "revision", "", "0");
INSERT INTO `bd_posts` VALUES("68", "1", "2023-02-27 15:58:29", "2023-02-27 14:58:29", "", "faviconefd", "", "inherit", "open", "closed", "", "faviconefd", "", "", "2023-02-27 15:58:29", "2023-02-27 14:58:29", "", "0", "http://yomi-avis.fr/wp-content/uploads/2023/02/faviconefd.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `bd_posts` VALUES("69", "1", "2023-02-27 15:58:31", "2023-02-27 14:58:31", "http://yomi-avis.fr/wp-content/uploads/2023/02/cropped-faviconefd.jpg", "cropped-faviconefd.jpg", "", "inherit", "open", "closed", "", "cropped-faviconefd-jpg", "", "", "2023-02-27 15:58:31", "2023-02-27 14:58:31", "", "0", "http://yomi-avis.fr/wp-content/uploads/2023/02/cropped-faviconefd.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `bd_posts` VALUES("71", "1", "2023-04-24 19:39:42", "2023-04-24 17:39:42", "{\n    \"theme mngt-MODIFABLE - Copie/location-de-voiture-de-luxe::mon_theme_couleur_principale\": {\n        \"value\": \"#8224e3\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 17:39:42\"\n    }\n}", "", "", "trash", "closed", "closed", "", "46562c28-101b-4032-80d1-3be299640eba", "", "", "2023-04-24 19:39:42", "2023-04-24 17:39:42", "", "0", "http://yomi-avis.fr/2023/04/24/46562c28-101b-4032-80d1-3be299640eba/", "0", "customize_changeset", "", "0");
INSERT INTO `bd_posts` VALUES("72", "1", "2023-04-24 19:40:13", "2023-04-24 17:40:13", "{\n    \"theme mngt-MODIFABLE - Copie/location-de-voiture-de-luxe::mon_theme_couleur_principale\": {\n        \"value\": \"#2453e2\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 17:40:13\"\n    },\n    \"theme mngt-MODIFABLE - Copie/location-de-voiture-de-luxe::mon_theme_couleur_secondaire\": {\n        \"value\": \"#a5319e\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 17:40:13\"\n    },\n    \"theme mngt-MODIFABLE - Copie/location-de-voiture-de-luxe::mon_theme_couleur_tertiaire\": {\n        \"value\": \"#e27f34\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 17:40:13\"\n    }\n}", "", "", "trash", "closed", "closed", "", "c5331481-cb83-40f6-ba5d-bd4b08163dc6", "", "", "2023-04-24 19:40:13", "2023-04-24 17:40:13", "", "0", "http://yomi-avis.fr/2023/04/24/c5331481-cb83-40f6-ba5d-bd4b08163dc6/", "0", "customize_changeset", "", "0");
INSERT INTO `bd_posts` VALUES("73", "1", "2023-04-24 19:48:39", "0000-00-00 00:00:00", "", "Brouillon auto", "", "auto-draft", "open", "open", "", "", "", "", "2023-04-24 19:48:39", "0000-00-00 00:00:00", "", "0", "http://yomi-avis.fr/?p=73", "0", "post", "", "0");
INSERT INTO `bd_posts` VALUES("74", "1", "2023-04-24 19:53:19", "2023-04-24 17:53:19", "{\n    \"theme location luxe/location-de-voiture-de-luxe::ma_image_de_fond_1\": {\n        \"value\": \"http://yomi-avis.fr/wp-content/uploads/2023/02/cla-bg.jpg\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 17:53:19\"\n    }\n}", "", "", "trash", "closed", "closed", "", "882c04c3-9e68-4c24-a98d-f88eafd929dd", "", "", "2023-04-24 19:53:19", "2023-04-24 17:53:19", "", "0", "http://yomi-avis.fr/2023/04/24/882c04c3-9e68-4c24-a98d-f88eafd929dd/", "0", "customize_changeset", "", "0");
INSERT INTO `bd_posts` VALUES("75", "1", "2023-04-24 19:53:27", "2023-04-24 17:53:27", "{\n    \"theme location luxe/location-de-voiture-de-luxe::ma_image_de_fond_2\": {\n        \"value\": \"http://yomi-avis.fr/wp-content/uploads/2023/02/cla-bg-2.jpg\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 17:53:27\"\n    }\n}", "", "", "trash", "closed", "closed", "", "8b54f927-7517-4e99-b8b0-67f8ad9b2d81", "", "", "2023-04-24 19:53:27", "2023-04-24 17:53:27", "", "0", "http://yomi-avis.fr/2023/04/24/8b54f927-7517-4e99-b8b0-67f8ad9b2d81/", "0", "customize_changeset", "", "0");
INSERT INTO `bd_posts` VALUES("76", "1", "2023-04-24 19:55:28", "2023-04-24 17:55:28", "{\n    \"theme location luxe/location-de-voiture-de-luxe::mon_theme_couleur_principale\": {\n        \"value\": \"#81d742\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 17:55:28\"\n    },\n    \"theme location luxe/location-de-voiture-de-luxe::mon_theme_couleur_secondaire\": {\n        \"value\": \"#1e73be\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 17:55:28\"\n    },\n    \"theme location luxe/location-de-voiture-de-luxe::mon_theme_couleur_tertiaire\": {\n        \"value\": \"#dd9933\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 17:55:28\"\n    }\n}", "", "", "trash", "closed", "closed", "", "3413c52c-adc4-4b95-b94a-c67216aef4a7", "", "", "2023-04-24 19:55:28", "2023-04-24 17:55:28", "", "0", "http://yomi-avis.fr/2023/04/24/3413c52c-adc4-4b95-b94a-c67216aef4a7/", "0", "customize_changeset", "", "0");
INSERT INTO `bd_posts` VALUES("77", "1", "2023-04-24 20:17:21", "2023-04-24 18:17:21", "http://yomi-avis.fr/wp-content/uploads/2023/02/cropped-faviconefd-1.jpg", "cropped-faviconefd-1.jpg", "", "inherit", "open", "closed", "", "cropped-faviconefd-1-jpg", "", "", "2023-04-24 20:17:21", "2023-04-24 18:17:21", "", "0", "http://yomi-avis.fr/wp-content/uploads/2023/02/cropped-faviconefd-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `bd_posts` VALUES("78", "1", "2023-04-24 20:17:39", "2023-04-24 18:17:39", "http://yomi-avis.fr/wp-content/uploads/2023/02/cropped-cla-bg.jpg", "cropped-cla-bg.jpg", "", "inherit", "open", "closed", "", "cropped-cla-bg-jpg", "", "", "2023-04-24 20:17:39", "2023-04-24 18:17:39", "", "0", "http://yomi-avis.fr/wp-content/uploads/2023/02/cropped-cla-bg.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `bd_posts` VALUES("79", "1", "2023-04-24 20:17:41", "2023-04-24 18:17:41", "{\n    \"theme location luxe/location-de-voiture-de-luxe::custom_logo\": {\n        \"value\": 78,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 18:17:41\"\n    }\n}", "", "", "trash", "closed", "closed", "", "8bb128d4-60e1-4700-9cc3-14b8318fdded", "", "", "2023-04-24 20:17:41", "2023-04-24 18:17:41", "", "0", "https://yomi-avis.fr/2023/04/24/8bb128d4-60e1-4700-9cc3-14b8318fdded/", "0", "customize_changeset", "", "0");
INSERT INTO `bd_posts` VALUES("80", "1", "2023-04-24 20:18:15", "2023-04-24 18:18:15", "{\n    \"theme location luxe/location-de-voiture-de-luxe::custom_logo\": {\n        \"value\": 43,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 18:18:15\"\n    }\n}", "", "", "trash", "closed", "closed", "", "cc9e26cd-e606-41fc-91e6-09bde029aff7", "", "", "2023-04-24 20:18:15", "2023-04-24 18:18:15", "", "0", "https://yomi-avis.fr/2023/04/24/cc9e26cd-e606-41fc-91e6-09bde029aff7/", "0", "customize_changeset", "", "0");
INSERT INTO `bd_posts` VALUES("81", "1", "2023-04-24 20:20:23", "2023-04-24 18:20:23", "{\n    \"theme location luxe/location-de-voiture-de-luxe::nomsociete\": {\n        \"value\": \"MOTORS INDUS\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 18:19:55\"\n    },\n    \"theme location luxe/location-de-voiture-de-luxe::villenamelong\": {\n        \"value\": \"\\u00e0 Lyon\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 18:19:55\"\n    },\n    \"theme location luxe/location-de-voiture-de-luxe::villenamecourt\": {\n        \"value\": \"Lyon\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 18:19:55\"\n    },\n    \"theme location luxe/location-de-voiture-de-luxe::numtela0e\": {\n        \"value\": \"07 65 77 44 77\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 18:19:55\"\n    },\n    \"theme location luxe/location-de-voiture-de-luxe::numtels0\": {\n        \"value\": \"765774477\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 18:19:55\"\n    },\n    \"theme location luxe/location-de-voiture-de-luxe::mail\": {\n        \"value\": \"motorsindus@indus.fr\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 18:19:55\"\n    },\n    \"theme location luxe/location-de-voiture-de-luxe::snaplink\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 18:19:55\"\n    },\n    \"theme location luxe/location-de-voiture-de-luxe::snapname\": {\n        \"value\": \"motorsindus\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 18:20:23\"\n    },\n    \"theme location luxe/location-de-voiture-de-luxe::snapmenu\": {\n        \"value\": \"motorsindus\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 18:20:23\"\n    },\n    \"theme location luxe/location-de-voiture-de-luxe::instalink\": {\n        \"value\": \"https://www.instagram.com/\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 18:20:23\"\n    }\n}", "", "", "trash", "closed", "closed", "", "206a14b6-effa-4ba5-a485-959aa368d5c6", "", "", "2023-04-24 20:20:23", "2023-04-24 18:20:23", "", "0", "https://yomi-avis.fr/?p=81", "0", "customize_changeset", "", "0");
INSERT INTO `bd_posts` VALUES("82", "1", "2023-04-24 20:20:58", "2023-04-24 18:20:58", "{\n    \"theme location luxe/location-de-voiture-de-luxe::nom_director\": {\n        \"value\": \"Cronou Henrique\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 18:20:55\"\n    },\n    \"theme location luxe/location-de-voiture-de-luxe::formjuridique\": {\n        \"value\": \"SAS\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 18:20:55\"\n    },\n    \"theme location luxe/location-de-voiture-de-luxe::adressesiegesocial\": {\n        \"value\": \"20 rue des chanisih LYON 69000\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 18:20:58\"\n    }\n}", "", "", "trash", "closed", "closed", "", "f85be678-7317-4de6-8f09-477d81eed83a", "", "", "2023-04-24 20:20:58", "2023-04-24 18:20:58", "", "0", "https://yomi-avis.fr/?p=82", "0", "customize_changeset", "", "0");
INSERT INTO `bd_posts` VALUES("83", "1", "2023-04-24 20:21:16", "2023-04-24 18:21:16", "{\n    \"theme location luxe/location-de-voiture-de-luxe::selected_font\": {\n        \"value\": \"Georgia\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2023-04-24 18:21:16\"\n    }\n}", "", "", "trash", "closed", "closed", "", "417385d1-4e5c-4d40-8fb0-69dee6da53c7", "", "", "2023-04-24 20:21:16", "2023-04-24 18:21:16", "", "0", "https://yomi-avis.fr/2023/04/24/417385d1-4e5c-4d40-8fb0-69dee6da53c7/", "0", "customize_changeset", "", "0");

/* INSERT TABLE DATA: bd_term_relationships */
INSERT INTO `bd_term_relationships` VALUES("7", "1", "0");

/* INSERT TABLE DATA: bd_term_taxonomy */
INSERT INTO `bd_term_taxonomy` VALUES("1", "1", "category", "", "0", "0");

/* INSERT TABLE DATA: bd_terms */
INSERT INTO `bd_terms` VALUES("1", "Non classé", "non-classe", "0");

/* INSERT TABLE DATA: bd_usermeta */
INSERT INTO `bd_usermeta` VALUES("1", "1", "nickname", "Location de voiture de luxe");
INSERT INTO `bd_usermeta` VALUES("2", "1", "first_name", "");
INSERT INTO `bd_usermeta` VALUES("3", "1", "last_name", "");
INSERT INTO `bd_usermeta` VALUES("4", "1", "description", "");
INSERT INTO `bd_usermeta` VALUES("5", "1", "rich_editing", "true");
INSERT INTO `bd_usermeta` VALUES("6", "1", "syntax_highlighting", "true");
INSERT INTO `bd_usermeta` VALUES("7", "1", "comment_shortcuts", "false");
INSERT INTO `bd_usermeta` VALUES("8", "1", "admin_color", "fresh");
INSERT INTO `bd_usermeta` VALUES("9", "1", "use_ssl", "0");
INSERT INTO `bd_usermeta` VALUES("10", "1", "show_admin_bar_front", "false");
INSERT INTO `bd_usermeta` VALUES("11", "1", "locale", "");
INSERT INTO `bd_usermeta` VALUES("12", "1", "bd_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `bd_usermeta` VALUES("13", "1", "bd_user_level", "10");
INSERT INTO `bd_usermeta` VALUES("14", "1", "dismissed_wp_pointers", "");
INSERT INTO `bd_usermeta` VALUES("15", "1", "show_welcome_panel", "1");
INSERT INTO `bd_usermeta` VALUES("17", "1", "bd_dashboard_quick_press_last_post_id", "73");
INSERT INTO `bd_usermeta` VALUES("18", "1", "community-events-location", "a:1:{s:2:\"ip\";s:11:\"90.59.117.0\";}");
INSERT INTO `bd_usermeta` VALUES("19", "1", "bd_persisted_preferences", "a:2:{s:14:\"core/edit-post\";a:3:{s:26:\"isComplementaryAreaVisible\";b:1;s:12:\"welcomeGuide\";b:0;s:10:\"openPanels\";a:4:{i:0;s:11:\"post-status\";i:1;s:14:\"featured-image\";i:2;s:16:\"discussion-panel\";i:3;s:15:\"page-attributes\";}}s:9:\"_modified\";s:24:\"2023-01-20T19:44:32.273Z\";}");
INSERT INTO `bd_usermeta` VALUES("20", "1", "bd_user-settings", "libraryContent=browse");
INSERT INTO `bd_usermeta` VALUES("21", "1", "bd_user-settings-time", "1674244437");
INSERT INTO `bd_usermeta` VALUES("23", "1", "session_tokens", "a:11:{s:64:\"9a75f460798614c9aca52800a31c29107e962d4f0c1da5fb3d2055d6f105bd2d\";a:4:{s:10:\"expiration\";i:1683567073;s:2:\"ip\";s:13:\"90.59.117.218\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36\";s:5:\"login\";i:1682357473;}s:64:\"33b4191528e92c0a84ab2588fec3a9a2e2f28c936e822f3988fe7be603fa4d8a\";a:4:{s:10:\"expiration\";i:1682531235;s:2:\"ip\";s:13:\"90.59.117.218\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36\";s:5:\"login\";i:1682358435;}s:64:\"6f0dfc6206e398224406de75f36f2ce251b7a0743169733732c7d8e898df0e5c\";a:4:{s:10:\"expiration\";i:1682531241;s:2:\"ip\";s:13:\"90.59.117.218\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36\";s:5:\"login\";i:1682358441;}s:64:\"7173091eda57858b3c41286f944245c7d57ac9e27f2efcccb8e7434f57053b1e\";a:4:{s:10:\"expiration\";i:1682531279;s:2:\"ip\";s:13:\"90.59.117.218\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36\";s:5:\"login\";i:1682358479;}s:64:\"6d644582b2600dc9121a858202788c2f103422588c9ddd0a0a7c091226d1a610\";a:4:{s:10:\"expiration\";i:1682531319;s:2:\"ip\";s:13:\"90.59.117.218\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36\";s:5:\"login\";i:1682358519;}s:64:\"e40188b5a67d33c6633bff068cf95540d1907f5b5a9bbbd9e26a3a1ba059fd74\";a:4:{s:10:\"expiration\";i:1683568368;s:2:\"ip\";s:13:\"90.59.117.218\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36\";s:5:\"login\";i:1682358768;}s:64:\"d82899f2740b8d78e66ac3a990da1d96ad088d296982200bfa37c801d964699c\";a:4:{s:10:\"expiration\";i:1683569161;s:2:\"ip\";s:13:\"90.59.117.218\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36\";s:5:\"login\";i:1682359561;}s:64:\"1da6254c60be04d91fa30c1e2be10265d0fb65f05b91fb40ed235f376ec6c186\";a:4:{s:10:\"expiration\";i:1683572741;s:2:\"ip\";s:13:\"90.59.117.218\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36\";s:5:\"login\";i:1682363141;}s:64:\"eced49526386abd3da5cc41d0b22d0dbc0a4a9bc9d9f829ec35d149e11e529fe\";a:4:{s:10:\"expiration\";i:1683572751;s:2:\"ip\";s:13:\"90.59.117.218\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36\";s:5:\"login\";i:1682363151;}s:64:\"0afcdbe2582f94449054a7c6f266410206bc071120847533024032e7b5b57e7b\";a:4:{s:10:\"expiration\";i:1683574687;s:2:\"ip\";s:13:\"90.59.117.218\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36\";s:5:\"login\";i:1682365087;}s:64:\"39100d2c466e686991f69151c29173b10f0a5b1588e88022c32dd41b6ee4cfab\";a:4:{s:10:\"expiration\";i:1683653237;s:2:\"ip\";s:13:\"90.59.117.218\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36\";s:5:\"login\";i:1682443637;}}");
INSERT INTO `bd_usermeta` VALUES("26", "1", "jetpack_tracks_wpcom_id", "234512714");

/* INSERT TABLE DATA: bd_users */
INSERT INTO `bd_users` VALUES("1", "us88766765323", "$P$BuicIF6dHJwe9UoElVVPVtV3XyUQaw/", "us88766765323", "webclient.locationluxe@gmail.com", "", "2023-01-20 18:50:55", "", "0", "Location de voiture de luxe");

/* INSERT TABLE DATA: bd_wfconfig */
INSERT INTO `bd_wfconfig` VALUES("activatingIP", "90.59.117.218", "yes");
INSERT INTO `bd_wfconfig` VALUES("actUpdateInterval", "2", "yes");
INSERT INTO `bd_wfconfig` VALUES("addCacheComment", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("adminUserList", "b:0;", "yes");
INSERT INTO `bd_wfconfig` VALUES("advancedCommentScanning", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("ajaxWatcherDisabled_admin", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("ajaxWatcherDisabled_front", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("alertEmails", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("alertOn_adminLogin", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("alertOn_block", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("alertOn_breachLogin", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("alertOn_firstAdminLoginOnly", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("alertOn_firstNonAdminLoginOnly", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("alertOn_loginLockout", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("alertOn_lostPasswdForm", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("alertOn_nonAdminLogin", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("alertOn_scanIssues", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("alertOn_severityLevel", "25", "yes");
INSERT INTO `bd_wfconfig` VALUES("alertOn_throttle", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("alertOn_update", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("alertOn_wafDeactivated", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("alertOn_wordfenceDeactivated", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("alert_maxHourly", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("allowed404s", "/favicon.ico\n/apple-touch-icon*.png\n/*@2x.png\n/browserconfig.xml", "yes");
INSERT INTO `bd_wfconfig` VALUES("allowed404s6116Migration", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("allowHTTPSCaching", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("allowLegacy2FA", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("allowMySQLi", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("allScansScheduled", "a:0:{}", "yes");
INSERT INTO `bd_wfconfig` VALUES("apiKey", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("autoBlockScanners", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("autoUpdate", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("autoUpdateAttempts", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("bannedURLs", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("blockCustomText", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("blockedTime", "300", "yes");
INSERT INTO `bd_wfconfig` VALUES("blocks702Migration", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("cacheType", "disabled", "yes");
INSERT INTO `bd_wfconfig` VALUES("cbl_action", "block", "yes");
INSERT INTO `bd_wfconfig` VALUES("cbl_bypassRedirDest", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("cbl_bypassRedirURL", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("cbl_bypassViewURL", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("cbl_cookieVal", "6446d6a73e80d", "yes");
INSERT INTO `bd_wfconfig` VALUES("cbl_loggedInBlocked", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("cbl_redirURL", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("cbl_restOfSiteBlocked", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("checkSpamIP", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("config701Migration", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("config720Migration", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("dashboardData", "a:4:{s:9:\"generated\";i:1682360802;s:3:\"tdf\";a:3:{s:9:\"community\";i:5343;s:7:\"premium\";i:5413;s:9:\"blacklist\";i:13327;}s:10:\"attackdata\";a:3:{s:3:\"24h\";a:24:{i:0;a:2:{s:1:\"t\";i:1682272800;s:1:\"c\";i:7419656;}i:1;a:2:{s:1:\"t\";i:1682276400;s:1:\"c\";i:7281828;}i:2;a:2:{s:1:\"t\";i:1682280000;s:1:\"c\";i:7302364;}i:3;a:2:{s:1:\"t\";i:1682283600;s:1:\"c\";i:10129858;}i:4;a:2:{s:1:\"t\";i:1682287200;s:1:\"c\";i:11727909;}i:5;a:2:{s:1:\"t\";i:1682290800;s:1:\"c\";i:11603590;}i:6;a:2:{s:1:\"t\";i:1682294400;s:1:\"c\";i:12109501;}i:7;a:2:{s:1:\"t\";i:1682298000;s:1:\"c\";i:10417861;}i:8;a:2:{s:1:\"t\";i:1682301600;s:1:\"c\";i:8209779;}i:9;a:2:{s:1:\"t\";i:1682305200;s:1:\"c\";i:8442776;}i:10;a:2:{s:1:\"t\";i:1682308800;s:1:\"c\";i:8729083;}i:11;a:2:{s:1:\"t\";i:1682312400;s:1:\"c\";i:9246871;}i:12;a:2:{s:1:\"t\";i:1682316000;s:1:\"c\";i:12887227;}i:13;a:2:{s:1:\"t\";i:1682319600;s:1:\"c\";i:14332220;}i:14;a:2:{s:1:\"t\";i:1682323200;s:1:\"c\";i:11006268;}i:15;a:2:{s:1:\"t\";i:1682326800;s:1:\"c\";i:10644923;}i:16;a:2:{s:1:\"t\";i:1682330400;s:1:\"c\";i:10085105;}i:17;a:2:{s:1:\"t\";i:1682334000;s:1:\"c\";i:9120182;}i:18;a:2:{s:1:\"t\";i:1682337600;s:1:\"c\";i:10464938;}i:19;a:2:{s:1:\"t\";i:1682341200;s:1:\"c\";i:9201470;}i:20;a:2:{s:1:\"t\";i:1682344800;s:1:\"c\";i:8830839;}i:21;a:2:{s:1:\"t\";i:1682348400;s:1:\"c\";i:7566510;}i:22;a:2:{s:1:\"t\";i:1682352000;s:1:\"c\";i:7689430;}i:23;a:2:{s:1:\"t\";i:1682355600;s:1:\"c\";i:7368915;}}s:2:\"7d\";a:7:{i:0;a:2:{s:1:\"t\";i:1681689600;s:1:\"c\";i:325152117;}i:1;a:2:{s:1:\"t\";i:1681776000;s:1:\"c\";i:129579020;}i:2;a:2:{s:1:\"t\";i:1681862400;s:1:\"c\";i:88273739;}i:3;a:2:{s:1:\"t\";i:1681948800;s:1:\"c\";i:307335778;}i:4;a:2:{s:1:\"t\";i:1682035200;s:1:\"c\";i:256028859;}i:5;a:2:{s:1:\"t\";i:1682121600;s:1:\"c\";i:281730751;}i:6;a:2:{s:1:\"t\";i:1682208000;s:1:\"c\";i:245035153;}}s:3:\"30d\";a:30:{i:0;a:2:{s:1:\"t\";i:1679702400;s:1:\"c\";i:277211294;}i:1;a:2:{s:1:\"t\";i:1679788800;s:1:\"c\";i:346875344;}i:2;a:2:{s:1:\"t\";i:1679875200;s:1:\"c\";i:342000787;}i:3;a:2:{s:1:\"t\";i:1679961600;s:1:\"c\";i:325906393;}i:4;a:2:{s:1:\"t\";i:1680048000;s:1:\"c\";i:302296370;}i:5;a:2:{s:1:\"t\";i:1680134400;s:1:\"c\";i:291423504;}i:6;a:2:{s:1:\"t\";i:1680220800;s:1:\"c\";i:274092235;}i:7;a:2:{s:1:\"t\";i:1680307200;s:1:\"c\";i:261937741;}i:8;a:2:{s:1:\"t\";i:1680393600;s:1:\"c\";i:355404347;}i:9;a:2:{s:1:\"t\";i:1680480000;s:1:\"c\";i:443134187;}i:10;a:2:{s:1:\"t\";i:1680566400;s:1:\"c\";i:383034584;}i:11;a:2:{s:1:\"t\";i:1680652800;s:1:\"c\";i:135905616;}i:12;a:2:{s:1:\"t\";i:1680739200;s:1:\"c\";i:558024156;}i:13;a:2:{s:1:\"t\";i:1680825600;s:1:\"c\";i:540550129;}i:14;a:2:{s:1:\"t\";i:1680912000;s:1:\"c\";i:331391509;}i:15;a:2:{s:1:\"t\";i:1680998400;s:1:\"c\";i:363725703;}i:16;a:2:{s:1:\"t\";i:1681084800;s:1:\"c\";i:137095735;}i:17;a:2:{s:1:\"t\";i:1681171200;s:1:\"c\";i:96967715;}i:18;a:2:{s:1:\"t\";i:1681257600;s:1:\"c\";i:101778754;}i:19;a:2:{s:1:\"t\";i:1681344000;s:1:\"c\";i:306266506;}i:20;a:2:{s:1:\"t\";i:1681430400;s:1:\"c\";i:292736006;}i:21;a:2:{s:1:\"t\";i:1681516800;s:1:\"c\";i:319367641;}i:22;a:2:{s:1:\"t\";i:1681603200;s:1:\"c\";i:319784830;}i:23;a:2:{s:1:\"t\";i:1681689600;s:1:\"c\";i:325152117;}i:24;a:2:{s:1:\"t\";i:1681776000;s:1:\"c\";i:129579020;}i:25;a:2:{s:1:\"t\";i:1681862400;s:1:\"c\";i:88273739;}i:26;a:2:{s:1:\"t\";i:1681948800;s:1:\"c\";i:307335778;}i:27;a:2:{s:1:\"t\";i:1682035200;s:1:\"c\";i:256028859;}i:28;a:2:{s:1:\"t\";i:1682121600;s:1:\"c\";i:281730751;}i:29;a:2:{s:1:\"t\";i:1682208000;s:1:\"c\";i:245035153;}}}s:9:\"countries\";a:1:{s:2:\"7d\";a:10:{i:0;a:2:{s:2:\"cd\";s:2:\"US\";s:2:\"ct\";i:466098774;}i:1;a:2:{s:2:\"cd\";s:2:\"SG\";s:2:\"ct\";i:206480618;}i:2;a:2:{s:2:\"cd\";s:2:\"IN\";s:2:\"ct\";i:144302006;}i:3;a:2:{s:2:\"cd\";s:2:\"DE\";s:2:\"ct\";i:136285865;}i:4;a:2:{s:2:\"cd\";s:2:\"TR\";s:2:\"ct\";i:134707671;}i:5;a:2:{s:2:\"cd\";s:2:\"FR\";s:2:\"ct\";i:119258083;}i:6;a:2:{s:2:\"cd\";s:2:\"CN\";s:2:\"ct\";i:95375902;}i:7;a:2:{s:2:\"cd\";s:2:\"RU\";s:2:\"ct\";i:81201283;}i:8;a:2:{s:2:\"cd\";s:2:\"NL\";s:2:\"ct\";i:70070050;}i:9;a:2:{s:2:\"cd\";s:2:\"VN\";s:2:\"ct\";i:60911278;}}}}", "yes");
INSERT INTO `bd_wfconfig` VALUES("dbTest", "a:1:{s:5:\"nonce\";s:64:\"28ac0cbe624478749181a9f29619ed78a1ed78afe25faae1c5a8d3622195a286\";}", "no");
INSERT INTO `bd_wfconfig` VALUES("dbVersion", "5.7.41-log", "yes");
INSERT INTO `bd_wfconfig` VALUES("debugOn", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("deleteTablesOnDeact", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("detectProxyNextCheck", "1682968870", "no");
INSERT INTO `bd_wfconfig` VALUES("detectProxyNonce", "89a9c1f93c8a753e60f9adbf1a7310a51370154f9569ee6cf314d89cf121c6db", "no");
INSERT INTO `bd_wfconfig` VALUES("detectProxyRecommendation", "", "no");
INSERT INTO `bd_wfconfig` VALUES("diagnosticsWflogsRemovalHistory", "[]", "no");
INSERT INTO `bd_wfconfig` VALUES("disableCodeExecutionUploads", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("disableConfigCaching", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("disableWAFIPBlocking", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("dismissAutoPrependNotice", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("displayAutomaticBlocks", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("displayTopLevelBlocking", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("displayTopLevelLiveTraffic", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("displayTopLevelOptions", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("email_summary_dashboard_widget_enabled", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("email_summary_enabled", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("email_summary_excluded_directories", "wp-content/cache,wp-content/wflogs", "yes");
INSERT INTO `bd_wfconfig` VALUES("email_summary_interval", "weekly", "yes");
INSERT INTO `bd_wfconfig` VALUES("enableRemoteIpLookup", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("encKey", "22c72bf6c839d05e", "yes");
INSERT INTO `bd_wfconfig` VALUES("fileContentsGSB6315Migration", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("firewallEnabled", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("hasKeyConflict", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("howGetIPs", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("howGetIPs_trusted_proxies", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("isPaid", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("keyType", "free", "yes");
INSERT INTO `bd_wfconfig` VALUES("lastBlockAggregation", "1682364069", "yes");
INSERT INTO `bd_wfconfig` VALUES("lastDailyCron", "1682364099", "yes");
INSERT INTO `bd_wfconfig` VALUES("lastDashboardCheck", "1682364079", "yes");
INSERT INTO `bd_wfconfig` VALUES("lastPermissionsTemplateCheck", "1682364131", "yes");
INSERT INTO `bd_wfconfig` VALUES("liveActivityPauseEnabled", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("liveTrafficEnabled", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("liveTraf_displayExpandedRecords", "0", "no");
INSERT INTO `bd_wfconfig` VALUES("liveTraf_ignoreIPs", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("liveTraf_ignorePublishers", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("liveTraf_ignoreUA", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("liveTraf_ignoreUsers", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("liveTraf_maxAge", "30", "yes");
INSERT INTO `bd_wfconfig` VALUES("liveTraf_maxRows", "2000", "yes");
INSERT INTO `bd_wfconfig` VALUES("loginSecurityEnabled", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("loginSec_blockAdminReg", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("loginSec_breachPasswds", "admins", "yes");
INSERT INTO `bd_wfconfig` VALUES("loginSec_breachPasswds_enabled", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("loginSec_countFailMins", "240", "yes");
INSERT INTO `bd_wfconfig` VALUES("loginSec_disableApplicationPasswords", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("loginSec_disableAuthorScan", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("loginSec_disableOEmbedAuthor", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("loginSec_enableSeparateTwoFactor", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("loginSec_lockInvalidUsers", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("loginSec_lockoutMins", "240", "yes");
INSERT INTO `bd_wfconfig` VALUES("loginSec_maskLoginErrors", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("loginSec_maxFailures", "20", "yes");
INSERT INTO `bd_wfconfig` VALUES("loginSec_maxForgotPasswd", "20", "yes");
INSERT INTO `bd_wfconfig` VALUES("loginSec_requireAdminTwoFactor", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("loginSec_strongPasswds", "pubs", "yes");
INSERT INTO `bd_wfconfig` VALUES("loginSec_strongPasswds_enabled", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("loginSec_userBlacklist", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("longEncKey", "05dbc41f32cdcc8fcd8618df8fd47405a28c783d9180649c73e8eab9cd2b4b33", "yes");
INSERT INTO `bd_wfconfig` VALUES("lowResourceScansEnabled", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("manualScanType", "onceDaily", "yes");
INSERT INTO `bd_wfconfig` VALUES("max404Crawlers", "DISABLED", "yes");
INSERT INTO `bd_wfconfig` VALUES("max404Crawlers_action", "throttle", "yes");
INSERT INTO `bd_wfconfig` VALUES("max404Humans", "DISABLED", "yes");
INSERT INTO `bd_wfconfig` VALUES("max404Humans_action", "throttle", "yes");
INSERT INTO `bd_wfconfig` VALUES("maxExecutionTime", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("maxGlobalRequests", "DISABLED", "yes");
INSERT INTO `bd_wfconfig` VALUES("maxGlobalRequests_action", "throttle", "yes");
INSERT INTO `bd_wfconfig` VALUES("maxMem", "256", "yes");
INSERT INTO `bd_wfconfig` VALUES("maxRequestsCrawlers", "DISABLED", "yes");
INSERT INTO `bd_wfconfig` VALUES("maxRequestsCrawlers_action", "throttle", "yes");
INSERT INTO `bd_wfconfig` VALUES("maxRequestsHumans", "DISABLED", "yes");
INSERT INTO `bd_wfconfig` VALUES("maxRequestsHumans_action", "throttle", "yes");
INSERT INTO `bd_wfconfig` VALUES("migration636_email_summary_excluded_directories", "1", "no");
INSERT INTO `bd_wfconfig` VALUES("needsNewTour_blocking", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("needsNewTour_dashboard", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("needsNewTour_firewall", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("needsNewTour_livetraffic", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("needsNewTour_loginsecurity", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("needsNewTour_scan", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("needsUpgradeTour_blocking", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("needsUpgradeTour_dashboard", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("needsUpgradeTour_firewall", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("needsUpgradeTour_livetraffic", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("needsUpgradeTour_loginsecurity", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("needsUpgradeTour_scan", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("neverBlockBG", "neverBlockVerified", "yes");
INSERT INTO `bd_wfconfig` VALUES("notification_blogHighlights", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("notification_productUpdates", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("notification_promotions", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("notification_scanStatus", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("notification_securityAlerts", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("notification_updatesNeeded", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("onboardingAttempt1", "skipped", "yes");
INSERT INTO `bd_wfconfig` VALUES("onboardingAttempt2", "", "no");
INSERT INTO `bd_wfconfig` VALUES("onboardingAttempt3", "", "no");
INSERT INTO `bd_wfconfig` VALUES("onboardingAttempt3Initial", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("onboardingDelayedAt", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("other_blockBadPOST", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("other_bypassLitespeedNoabort", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("other_hideWPVersion", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("other_pwStrengthOnUpdate", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("other_scanComments", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("other_scanOutside", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("other_WFNet", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("previousWflogsFileList", "[\"config-synced.php\",\"GeoLite2-Country.mmdb\",\".htaccess\",\"ips.php\",\"config.php\",\"config-livewaf.php\",\"config-transient.php\",\"attack-data.php\",\"template.php\",\"rules.php\"]", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_checkGSB", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_checkHowGetIPs", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_checkReadableConfig", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_comments", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_core", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_coreUnknown", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_diskSpace", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_fileContents", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_fileContentsGSB", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_geoipSupport", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_highSense", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_malware", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_oldVersions", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_options", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_passwds", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_plugins", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_posts", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_scanImages", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_suspectedFiles", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_suspiciousAdminUsers", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_suspiciousOptions", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_themes", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_wafStatus", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_wpscan_directoryListingEnabled", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scansEnabled_wpscan_fullPathDisclosure", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("scanType", "standard", "yes");
INSERT INTO `bd_wfconfig` VALUES("scan_exclude", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("scan_force_ipv4_start", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("scan_include_extra", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("scan_maxDuration", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("scan_maxIssues", "1000", "yes");
INSERT INTO `bd_wfconfig` VALUES("scan_max_resume_attempts", "2", "yes");
INSERT INTO `bd_wfconfig` VALUES("schedMode", "auto", "yes");
INSERT INTO `bd_wfconfig` VALUES("schedStartHour", "21", "yes");
INSERT INTO `bd_wfconfig` VALUES("scheduledScansEnabled", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("serverDNS", "1682364072;100;54.36.91.62", "yes");
INSERT INTO `bd_wfconfig` VALUES("showAdminBarMenu", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("spamvertizeCheck", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("ssl_verify", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("startScansRemotely", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("supportContent", "{}", "no");
INSERT INTO `bd_wfconfig` VALUES("supportHash", "", "no");
INSERT INTO `bd_wfconfig` VALUES("timeoffset_wf", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("timeoffset_wf_updated", "1682364080", "yes");
INSERT INTO `bd_wfconfig` VALUES("totalAlertsSent", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("touppBypassNextCheck", "0", "yes");
INSERT INTO `bd_wfconfig` VALUES("touppPromptNeeded", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("vulnerabilities_plugin", "a:4:{i:0;a:3:{s:4:\"slug\";s:22:\"advanced-custom-fields\";s:11:\"fromVersion\";s:5:\"6.1.4\";s:10:\"vulnerable\";b:0;}i:1;a:3:{s:4:\"slug\";s:10:\"duplicator\";s:11:\"fromVersion\";s:7:\"1.5.3.1\";s:10:\"vulnerable\";b:0;}i:2;a:3:{s:4:\"slug\";s:17:\"really-simple-ssl\";s:11:\"fromVersion\";s:5:\"6.2.4\";s:10:\"vulnerable\";b:0;}i:3;a:3:{s:4:\"slug\";s:9:\"wordfence\";s:11:\"fromVersion\";s:5:\"7.9.2\";s:10:\"vulnerable\";b:0;}}", "yes");
INSERT INTO `bd_wfconfig` VALUES("wafAlertInterval", "600", "yes");
INSERT INTO `bd_wfconfig` VALUES("wafAlertOnAttacks", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("wafAlertThreshold", "100", "yes");
INSERT INTO `bd_wfconfig` VALUES("wafAlertWhitelist", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("waf_status", "learning-mode", "yes");
INSERT INTO `bd_wfconfig` VALUES("whitelisted", "", "yes");
INSERT INTO `bd_wfconfig` VALUES("whitelistedServices", "{}", "yes");
INSERT INTO `bd_wfconfig` VALUES("whitelistHash", "", "no");
INSERT INTO `bd_wfconfig` VALUES("whitelistPresets", "{}", "no");
INSERT INTO `bd_wfconfig` VALUES("wordfenceI18n", "1", "yes");
INSERT INTO `bd_wfconfig` VALUES("wordpressPluginVersions", "a:4:{s:22:\"advanced-custom-fields\";s:5:\"6.1.4\";s:10:\"duplicator\";s:7:\"1.5.3.1\";s:17:\"really-simple-ssl\";s:5:\"6.2.4\";s:9:\"wordfence\";s:5:\"7.9.2\";}", "yes");
INSERT INTO `bd_wfconfig` VALUES("wordpressThemeVersions", "a:1:{s:47:\"theme location luxe/location-de-voiture-de-luxe\";s:5:\"1.0.0\";}", "yes");
INSERT INTO `bd_wfconfig` VALUES("wordpressVersion", "6.2", "yes");
INSERT INTO `bd_wfconfig` VALUES("wp_home_url", "https://yomi-avis.fr", "yes");
INSERT INTO `bd_wfconfig` VALUES("wp_site_url", "https://yomi-avis.fr", "yes");

/* INSERT TABLE DATA: bd_wfls_settings */
INSERT INTO `bd_wfls_settings` VALUES("2fa-user-grace-period", "10", "yes");
INSERT INTO `bd_wfls_settings` VALUES("allow-disabling-ntp", "1", "yes");
INSERT INTO `bd_wfls_settings` VALUES("allow-xml-rpc", "1", "yes");
INSERT INTO `bd_wfls_settings` VALUES("captcha-stats", "{\"counts\":[0,0,0,0,0,0,0,0,0,0,0],\"avg\":0}", "yes");
INSERT INTO `bd_wfls_settings` VALUES("delete-deactivation", "", "yes");
INSERT INTO `bd_wfls_settings` VALUES("disable-temporary-tables", "0", "yes");
INSERT INTO `bd_wfls_settings` VALUES("enable-auth-captcha", "", "yes");
INSERT INTO `bd_wfls_settings` VALUES("enable-login-history-columns", "1", "yes");
INSERT INTO `bd_wfls_settings` VALUES("enable-shortcode", "", "yes");
INSERT INTO `bd_wfls_settings` VALUES("enable-woocommerce-account-integration", "", "yes");
INSERT INTO `bd_wfls_settings` VALUES("enable-woocommerce-integration", "", "yes");
INSERT INTO `bd_wfls_settings` VALUES("global-notices", "[]", "yes");
INSERT INTO `bd_wfls_settings` VALUES("ip-source", "", "yes");
INSERT INTO `bd_wfls_settings` VALUES("ip-trusted-proxies", "", "yes");
INSERT INTO `bd_wfls_settings` VALUES("last-secret-refresh", "1682364069", "yes");
INSERT INTO `bd_wfls_settings` VALUES("recaptcha-threshold", "0.5", "yes");
INSERT INTO `bd_wfls_settings` VALUES("remember-device", "", "yes");
INSERT INTO `bd_wfls_settings` VALUES("remember-device-duration", "2592000", "yes");
INSERT INTO `bd_wfls_settings` VALUES("require-2fa-grace-period-enabled", "", "yes");
INSERT INTO `bd_wfls_settings` VALUES("require-2fa.administrator", "", "yes");
INSERT INTO `bd_wfls_settings` VALUES("schema-version", "2", "yes");
INSERT INTO `bd_wfls_settings` VALUES("shared-hash-secret", "2242b82d8b1afe3f1568be29cadd8952752b0e690d0b5b44277cbf2453bc36d2", "yes");
INSERT INTO `bd_wfls_settings` VALUES("shared-symmetric-secret", "0c60a185e039d48436b8ba8538d3f49be719114d3ca4d2f1f9f006edf7e8b944", "yes");
INSERT INTO `bd_wfls_settings` VALUES("stack-ui-columns", "1", "yes");
INSERT INTO `bd_wfls_settings` VALUES("user-count-query-state", "0", "yes");
INSERT INTO `bd_wfls_settings` VALUES("whitelisted", "", "yes");
INSERT INTO `bd_wfls_settings` VALUES("xmlrpc-enabled", "1", "yes");

/* INSERT TABLE DATA: bdp_comments */
INSERT INTO `bdp_comments` VALUES("1", "1", "Un commentateur WordPress", "wapuu@wordpress.example", "https://wordpress.org/", "", "2022-06-13 14:41:33", "2022-06-13 12:41:33", "Bonjour, ceci est un commentaire.\nPour débuter avec la modération, la modification et la suppression de commentaires, veuillez visiter l’écran des Commentaires dans le Tableau de bord.\nLes avatars des personnes qui commentent arrivent depuis <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: bdp_options */
INSERT INTO `bdp_options` VALUES("1", "siteurl", "http://yomi-avis.fr", "yes");
INSERT INTO `bdp_options` VALUES("2", "home", "http://yomi-avis.fr", "yes");
INSERT INTO `bdp_options` VALUES("3", "blogname", "BD Prestige", "yes");
INSERT INTO `bdp_options` VALUES("4", "blogdescription", "Agence de location de voiture de luxe", "yes");
INSERT INTO `bdp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `bdp_options` VALUES("6", "admin_email", "pepeconcept@gmail.com", "yes");
INSERT INTO `bdp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `bdp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `bdp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `bdp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `bdp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `bdp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `bdp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `bdp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `bdp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `bdp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `bdp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `bdp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `bdp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `bdp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `bdp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `bdp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `bdp_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `bdp_options` VALUES("24", "time_format", "G\\hi", "yes");
INSERT INTO `bdp_options` VALUES("25", "links_updated_date_format", "d F Y G\\hi", "yes");
INSERT INTO `bdp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `bdp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `bdp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `bdp_options` VALUES("29", "rewrite_rules", "a:116:{s:10:\"voiture/?$\";s:27:\"index.php?post_type=voiture\";s:40:\"voiture/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=voiture&feed=$matches[1]\";s:35:\"voiture/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=voiture&feed=$matches[1]\";s:27:\"voiture/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=voiture&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:35:\"voiture/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"voiture/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"voiture/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"voiture/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"voiture/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"voiture/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"voiture/([^/]+)/embed/?$\";s:40:\"index.php?voiture=$matches[1]&embed=true\";s:28:\"voiture/([^/]+)/trackback/?$\";s:34:\"index.php?voiture=$matches[1]&tb=1\";s:48:\"voiture/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?voiture=$matches[1]&feed=$matches[2]\";s:43:\"voiture/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?voiture=$matches[1]&feed=$matches[2]\";s:36:\"voiture/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?voiture=$matches[1]&paged=$matches[2]\";s:43:\"voiture/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?voiture=$matches[1]&cpage=$matches[2]\";s:32:\"voiture/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?voiture=$matches[1]&page=$matches[2]\";s:24:\"voiture/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"voiture/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"voiture/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"voiture/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"voiture/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"voiture/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `bdp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `bdp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `bdp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `bdp_options` VALUES("33", "active_plugins", "a:2:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";}", "yes");
INSERT INTO `bdp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `bdp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `bdp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `bdp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `bdp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `bdp_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `bdp_options` VALUES("40", "template", "theme mngt-MODIFABLE - Copie/mngt-wp-theme-v4-mtp", "yes");
INSERT INTO `bdp_options` VALUES("41", "stylesheet", "theme mngt-MODIFABLE - Copie/mngt-wp-theme-v4-mtp", "yes");
INSERT INTO `bdp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `bdp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `bdp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `bdp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `bdp_options` VALUES("46", "db_version", "53496", "yes");
INSERT INTO `bdp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `bdp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `bdp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `bdp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `bdp_options` VALUES("51", "show_on_front", "posts", "yes");
INSERT INTO `bdp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `bdp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `bdp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `bdp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `bdp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `bdp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `bdp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `bdp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `bdp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `bdp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `bdp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `bdp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `bdp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `bdp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `bdp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `bdp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `bdp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `bdp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `bdp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `bdp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `bdp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `bdp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `bdp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `bdp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `bdp_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bdp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bdp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bdp_options` VALUES("79", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `bdp_options` VALUES("80", "timezone_string", "Europe/Paris", "yes");
INSERT INTO `bdp_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `bdp_options` VALUES("82", "page_on_front", "0", "yes");
INSERT INTO `bdp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `bdp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `bdp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `bdp_options` VALUES("86", "site_icon", "22", "yes");
INSERT INTO `bdp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `bdp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `bdp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `bdp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `bdp_options` VALUES("91", "admin_email_lifespan", "1670676093", "yes");
INSERT INTO `bdp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `bdp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `bdp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `bdp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `bdp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `bdp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `bdp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `bdp_options` VALUES("99", "initial_db_version", "51917", "yes");
INSERT INTO `bdp_options` VALUES("100", "bdp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `bdp_options` VALUES("101", "fresh_site", "0", "yes");
INSERT INTO `bdp_options` VALUES("102", "WPLANG", "fr_FR", "yes");
INSERT INTO `bdp_options` VALUES("103", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Articles récents</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:233:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Commentaires récents</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:151:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Catégories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bdp_options` VALUES("104", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `bdp_options` VALUES("105", "cron", "a:8:{i:1668381939;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1668386494;a:4:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1668386524;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1668429694;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1668429701;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1668429702;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1668516094;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `bdp_options` VALUES("106", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bdp_options` VALUES("107", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bdp_options` VALUES("108", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bdp_options` VALUES("109", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bdp_options` VALUES("110", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bdp_options` VALUES("111", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bdp_options` VALUES("112", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bdp_options` VALUES("113", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bdp_options` VALUES("114", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bdp_options` VALUES("115", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bdp_options` VALUES("116", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bdp_options` VALUES("117", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bdp_options` VALUES("119", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `bdp_options` VALUES("124", "theme_mods_twentytwentytwo", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1655125685;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "yes");
INSERT INTO `bdp_options` VALUES("130", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `bdp_options` VALUES("155", "recently_activated", "a:0:{}", "yes");
INSERT INTO `bdp_options` VALUES("162", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:21:\"pepeconcept@gmail.com\";s:7:\"version\";s:3:\"6.1\";s:9:\"timestamp\";i:1667363705;}", "no");
INSERT INTO `bdp_options` VALUES("169", "rsssl_activated_plugin", "1", "yes");
INSERT INTO `bdp_options` VALUES("170", "rlrsssl_options", "a:16:{s:12:\"site_has_ssl\";b:0;s:4:\"hsts\";b:0;s:22:\"htaccess_warning_shown\";b:0;s:19:\"review_notice_shown\";b:0;s:25:\"ssl_success_message_shown\";b:0;s:26:\"autoreplace_insecure_links\";b:1;s:17:\"plugin_db_version\";s:5:\"5.3.1\";s:20:\"do_not_edit_htaccess\";b:0;s:17:\"htaccess_redirect\";b:0;s:11:\"ssl_enabled\";b:0;s:19:\"javascript_redirect\";b:0;s:11:\"wp_redirect\";b:0;s:31:\"switch_mixed_content_fixer_hook\";b:0;s:19:\"dismiss_all_notices\";b:0;s:13:\"high_contrast\";b:0;s:21:\"dismiss_review_notice\";b:0;}", "yes");
INSERT INTO `bdp_options` VALUES("171", "rsssl_remaining_tasks", "1", "yes");
INSERT INTO `bdp_options` VALUES("180", "rsssl_current_version", "5.3.1", "yes");
INSERT INTO `bdp_options` VALUES("185", "finished_updating_comment_type", "1", "yes");
INSERT INTO `bdp_options` VALUES("190", "acf_version", "5.12.2", "yes");
INSERT INTO `bdp_options` VALUES("193", "new_admin_email", "pepeconcept@gmail.com", "yes");
INSERT INTO `bdp_options` VALUES("202", "current_theme", "mngt", "yes");
INSERT INTO `bdp_options` VALUES("203", "theme_mods_theme mngt-MODIFABLE - Copie/mngt-wp-theme-v4-mtp", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO `bdp_options` VALUES("204", "theme_switched", "", "yes");
INSERT INTO `bdp_options` VALUES("205", "widget_recent-posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bdp_options` VALUES("207", "widget_recent-comments", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bdp_options` VALUES("212", "category_children", "a:0:{}", "yes");
INSERT INTO `bdp_options` VALUES("357", "_transient_health-check-site-status-result", "{\"good\":16,\"recommended\":4,\"critical\":1}", "yes");
INSERT INTO `bdp_options` VALUES("1155", "user_count", "1", "no");
INSERT INTO `bdp_options` VALUES("1156", "db_upgraded", "", "yes");
INSERT INTO `bdp_options` VALUES("2903", "_site_transient_timeout_php_check_96314025ffed7f9d1b2dac177cea1337", "1668518293", "no");
INSERT INTO `bdp_options` VALUES("2904", "_site_transient_php_check_96314025ffed7f9d1b2dac177cea1337", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "no");
INSERT INTO `bdp_options` VALUES("3000", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:63:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.1.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:63:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.1.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:3:\"6.1\";s:7:\"version\";s:3:\"6.1\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1668378682;s:15:\"version_checked\";s:3:\"6.1\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `bdp_options` VALUES("3026", "_site_transient_timeout_theme_roots", "1668380482", "no");
INSERT INTO `bdp_options` VALUES("3027", "_site_transient_theme_roots", "a:6:{s:33:\"mngt-wp-theme-v4-mtp-clientcom-v2\";s:7:\"/themes\";s:49:\"theme mngt-MODIFABLE - Copie/mngt-wp-theme-v4-mtp\";s:7:\"/themes\";s:12:\"twentytwenty\";s:7:\"/themes\";s:15:\"twentytwentyone\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";s:15:\"twentytwentytwo\";s:7:\"/themes\";}", "no");
INSERT INTO `bdp_options` VALUES("3028", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1668378683;s:7:\"checked\";a:6:{s:33:\"mngt-wp-theme-v4-mtp-clientcom-v2\";s:5:\"1.0.0\";s:49:\"theme mngt-MODIFABLE - Copie/mngt-wp-theme-v4-mtp\";s:5:\"1.0.0\";s:12:\"twentytwenty\";s:3:\"1.9\";s:15:\"twentytwentyone\";s:3:\"1.5\";s:17:\"twentytwentythree\";s:3:\"1.0\";s:15:\"twentytwentytwo\";s:3:\"1.1\";}s:8:\"response\";a:3:{s:12:\"twentytwenty\";a:6:{s:5:\"theme\";s:12:\"twentytwenty\";s:11:\"new_version\";s:3:\"2.1\";s:3:\"url\";s:42:\"https://wordpress.org/themes/twentytwenty/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/twentytwenty.2.1.zip\";s:8:\"requires\";s:3:\"4.7\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:15:\"twentytwentyone\";a:6:{s:5:\"theme\";s:15:\"twentytwentyone\";s:11:\"new_version\";s:3:\"1.7\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentyone/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentyone.1.7.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.6\";}s:15:\"twentytwentytwo\";a:6:{s:5:\"theme\";s:15:\"twentytwentytwo\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentytwo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentytwo.1.3.zip\";s:8:\"requires\";s:3:\"5.9\";s:12:\"requires_php\";s:3:\"5.6\";}}s:9:\"no_update\";a:1:{s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.0\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.0.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `bdp_options` VALUES("3029", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1668378683;s:8:\"response\";a:3:{s:30:\"advanced-custom-fields/acf.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:36:\"w.org/plugins/advanced-custom-fields\";s:4:\"slug\";s:22:\"advanced-custom-fields\";s:6:\"plugin\";s:30:\"advanced-custom-fields/acf.php\";s:11:\"new_version\";s:5:\"6.0.4\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/advanced-custom-fields/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/advanced-custom-fields.6.0.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:75:\"https://ps.w.org/advanced-custom-fields/assets/icon-256x256.png?rev=1082746\";s:2:\"1x\";s:75:\"https://ps.w.org/advanced-custom-fields/assets/icon-128x128.png?rev=1082746\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:78:\"https://ps.w.org/advanced-custom-fields/assets/banner-1544x500.jpg?rev=1729099\";s:2:\"1x\";s:77:\"https://ps.w.org/advanced-custom-fields/assets/banner-772x250.jpg?rev=1729102\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.7\";s:6:\"tested\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:19:\"akismet/akismet.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"5.0.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.5.0.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.2\";}s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:31:\"w.org/plugins/really-simple-ssl\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:6:\"plugin\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:11:\"new_version\";s:5:\"6.0.9\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/really-simple-ssl/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/really-simple-ssl.6.0.9.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-256x256.png?rev=2810060\";s:2:\"1x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-128x128.png?rev=2810049\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/really-simple-ssl/assets/banner-1544x500.png?rev=2810049\";s:2:\"1x\";s:72:\"https://ps.w.org/really-simple-ssl/assets/banner-772x250.png?rev=2810049\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.7\";s:6:\"tested\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"7.2\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:1:{s:9:\"hello.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:5:\"1.7.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/hello-dolly.1.7.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855\";s:2:\"1x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/hello-dolly/assets/banner-1544x500.jpg?rev=2645582\";s:2:\"1x\";s:66:\"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";}}s:7:\"checked\";a:4:{s:30:\"advanced-custom-fields/acf.php\";s:6:\"5.12.2\";s:19:\"akismet/akismet.php\";s:5:\"4.2.2\";s:9:\"hello.php\";s:5:\"1.7.2\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:5:\"5.3.2\";}}", "no");
INSERT INTO `bdp_options` VALUES("3030", "_transient_doing_cron", "1674243057.5376119613647460937500", "yes");
INSERT INTO `bdp_options` VALUES("7970", "_transient_timeout_global_styles_theme mngt-MODIFABLE - Copie/mngt-wp-theme-v4-mtp", "1674243117", "no");
INSERT INTO `bdp_options` VALUES("7971", "_transient_global_styles_theme mngt-MODIFABLE - Copie/mngt-wp-theme-v4-mtp", "body{--wp--preset--color--black: #000000;--wp--preset--color--cyan-bluish-gray: #abb8c3;--wp--preset--color--white: #ffffff;--wp--preset--color--pale-pink: #f78da7;--wp--preset--color--vivid-red: #cf2e2e;--wp--preset--color--luminous-vivid-orange: #ff6900;--wp--preset--color--luminous-vivid-amber: #fcb900;--wp--preset--color--light-green-cyan: #7bdcb5;--wp--preset--color--vivid-green-cyan: #00d084;--wp--preset--color--pale-cyan-blue: #8ed1fc;--wp--preset--color--vivid-cyan-blue: #0693e3;--wp--preset--color--vivid-purple: #9b51e0;--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple: linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%);--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan: linear-gradient(135deg,rgb(122,220,180) 0%,rgb(0,208,130) 100%);--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange: linear-gradient(135deg,rgba(252,185,0,1) 0%,rgba(255,105,0,1) 100%);--wp--preset--gradient--luminous-vivid-orange-to-vivid-red: linear-gradient(135deg,rgba(255,105,0,1) 0%,rgb(207,46,46) 100%);--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray: linear-gradient(135deg,rgb(238,238,238) 0%,rgb(169,184,195) 100%);--wp--preset--gradient--cool-to-warm-spectrum: linear-gradient(135deg,rgb(74,234,220) 0%,rgb(151,120,209) 20%,rgb(207,42,186) 40%,rgb(238,44,130) 60%,rgb(251,105,98) 80%,rgb(254,248,76) 100%);--wp--preset--gradient--blush-light-purple: linear-gradient(135deg,rgb(255,206,236) 0%,rgb(152,150,240) 100%);--wp--preset--gradient--blush-bordeaux: linear-gradient(135deg,rgb(254,205,165) 0%,rgb(254,45,45) 50%,rgb(107,0,62) 100%);--wp--preset--gradient--luminous-dusk: linear-gradient(135deg,rgb(255,203,112) 0%,rgb(199,81,192) 50%,rgb(65,88,208) 100%);--wp--preset--gradient--pale-ocean: linear-gradient(135deg,rgb(255,245,203) 0%,rgb(182,227,212) 50%,rgb(51,167,181) 100%);--wp--preset--gradient--electric-grass: linear-gradient(135deg,rgb(202,248,128) 0%,rgb(113,206,126) 100%);--wp--preset--gradient--midnight: linear-gradient(135deg,rgb(2,3,129) 0%,rgb(40,116,252) 100%);--wp--preset--duotone--dark-grayscale: url(\'#wp-duotone-dark-grayscale\');--wp--preset--duotone--grayscale: url(\'#wp-duotone-grayscale\');--wp--preset--duotone--purple-yellow: url(\'#wp-duotone-purple-yellow\');--wp--preset--duotone--blue-red: url(\'#wp-duotone-blue-red\');--wp--preset--duotone--midnight: url(\'#wp-duotone-midnight\');--wp--preset--duotone--magenta-yellow: url(\'#wp-duotone-magenta-yellow\');--wp--preset--duotone--purple-green: url(\'#wp-duotone-purple-green\');--wp--preset--duotone--blue-orange: url(\'#wp-duotone-blue-orange\');--wp--preset--font-size--small: 13px;--wp--preset--font-size--medium: 20px;--wp--preset--font-size--large: 36px;--wp--preset--font-size--x-large: 42px;--wp--preset--spacing--20: 0.44rem;--wp--preset--spacing--30: 0.67rem;--wp--preset--spacing--40: 1rem;--wp--preset--spacing--50: 1.5rem;--wp--preset--spacing--60: 2.25rem;--wp--preset--spacing--70: 3.38rem;--wp--preset--spacing--80: 5.06rem;}:where(.is-layout-flex){gap: 0.5em;}body .is-layout-flow > .alignleft{float: left;margin-inline-start: 0;margin-inline-end: 2em;}body .is-layout-flow > .alignright{float: right;margin-inline-start: 2em;margin-inline-end: 0;}body .is-layout-flow > .aligncenter{margin-left: auto !important;margin-right: auto !important;}body .is-layout-constrained > .alignleft{float: left;margin-inline-start: 0;margin-inline-end: 2em;}body .is-layout-constrained > .alignright{float: right;margin-inline-start: 2em;margin-inline-end: 0;}body .is-layout-constrained > .aligncenter{margin-left: auto !important;margin-right: auto !important;}body .is-layout-constrained > :where(:not(.alignleft):not(.alignright):not(.alignfull)){max-width: var(--wp--style--global--content-size);margin-left: auto !important;margin-right: auto !important;}body .is-layout-constrained > .alignwide{max-width: var(--wp--style--global--wide-size);}body .is-layout-flex{display: flex;}body .is-layout-flex{flex-wrap: wrap;align-items: center;}body .is-layout-flex > *{margin: 0;}:where(.wp-block-columns.is-layout-flex){gap: 2em;}.has-black-color{color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-color{color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-color{color: var(--wp--preset--color--white) !important;}.has-pale-pink-color{color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-color{color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-color{color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-color{color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-color{color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-color{color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-color{color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-color{color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-color{color: var(--wp--preset--color--vivid-purple) !important;}.has-black-background-color{background-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-background-color{background-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-background-color{background-color: var(--wp--preset--color--white) !important;}.has-pale-pink-background-color{background-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-background-color{background-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-background-color{background-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-background-color{background-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-background-color{background-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-background-color{background-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-background-color{background-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-background-color{background-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-background-color{background-color: var(--wp--preset--color--vivid-purple) !important;}.has-black-border-color{border-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-border-color{border-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-border-color{border-color: var(--wp--preset--color--white) !important;}.has-pale-pink-border-color{border-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-border-color{border-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-border-color{border-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-border-color{border-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-border-color{border-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-border-color{border-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-border-color{border-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-border-color{border-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-border-color{border-color: var(--wp--preset--color--vivid-purple) !important;}.has-vivid-cyan-blue-to-vivid-purple-gradient-background{background: var(--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple) !important;}.has-light-green-cyan-to-vivid-green-cyan-gradient-background{background: var(--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan) !important;}.has-luminous-vivid-amber-to-luminous-vivid-orange-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange) !important;}.has-luminous-vivid-orange-to-vivid-red-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-orange-to-vivid-red) !important;}.has-very-light-gray-to-cyan-bluish-gray-gradient-background{background: var(--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray) !important;}.has-cool-to-warm-spectrum-gradient-background{background: var(--wp--preset--gradient--cool-to-warm-spectrum) !important;}.has-blush-light-purple-gradient-background{background: var(--wp--preset--gradient--blush-light-purple) !important;}.has-blush-bordeaux-gradient-background{background: var(--wp--preset--gradient--blush-bordeaux) !important;}.has-luminous-dusk-gradient-background{background: var(--wp--preset--gradient--luminous-dusk) !important;}.has-pale-ocean-gradient-background{background: var(--wp--preset--gradient--pale-ocean) !important;}.has-electric-grass-gradient-background{background: var(--wp--preset--gradient--electric-grass) !important;}.has-midnight-gradient-background{background: var(--wp--preset--gradient--midnight) !important;}.has-small-font-size{font-size: var(--wp--preset--font-size--small) !important;}.has-medium-font-size{font-size: var(--wp--preset--font-size--medium) !important;}.has-large-font-size{font-size: var(--wp--preset--font-size--large) !important;}.has-x-large-font-size{font-size: var(--wp--preset--font-size--x-large) !important;}", "no");
INSERT INTO `bdp_options` VALUES("7972", "_site_transient_timeout_available_translations", "1674253858", "no");
INSERT INTO `bdp_options` VALUES("7973", "_site_transient_available_translations", "a:129:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.1/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-04 13:58:35\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.1/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.21/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-09-08 17:57:56\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.8.6/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-12 20:34:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2019-10-29 07:54:22\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.22/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-15 12:10:01\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-10-31 08:48:37\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.12/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-08-09 10:47:25\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-13 14:46:37\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.1/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-12 17:43:13\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-14 15:48:08\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.1/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-09 12:50:25\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-02 17:33:39\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.1/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-13 12:54:56\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.1/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-13 01:36:21\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-02 17:31:02\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-03-17 12:58:14\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.1/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-08 21:06:49\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.1/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-10-21 02:51:54\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-09 10:47:19\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-10 21:58:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-04-01 22:35:34\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2021-12-24 12:36:39\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-09-29 20:39:44\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.1/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-07-22 14:08:10\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-07-07 20:37:41\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-10 18:26:21\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-10 19:19:07\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-11 23:25:26\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-10-04 20:53:18\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.6/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.6/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-06-14 16:02:22\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.12/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.17\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.17/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-06 17:58:56\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-14 21:16:08\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-08-12 08:38:59\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-15 05:47:03\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.1/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-07 02:53:22\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-14 06:24:45\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-10-26 17:27:26\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.1/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-06 16:00:35\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-11 22:13:08\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-22 13:54:46\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2018-01-29 17:32:35\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.21/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-11 06:07:46\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2018-09-14 12:33:48\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.22/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:31:\"ચાલુ રાખવું\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.29\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.29/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-02 09:16:06\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-11-06 12:34:38\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.12/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-11 10:30:04\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.1/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-07-18 19:40:10\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.1/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-14 20:05:53\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-15 14:49:50\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.22/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-15 15:36:12\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-15 02:07:47\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.1/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.22/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-24 08:01:09\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-04 12:58:16\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.1/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2018-07-10 11:35:44\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.22/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.17\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.17/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-10-20 17:15:28\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.1/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-10-26 10:32:24\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-12-07 16:32:30\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.6/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-01 13:10:23\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-03 17:14:10\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.1/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:43:32\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-12 07:29:35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2019-11-22 15:32:08\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.22/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.11\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.11/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.34\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.34/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-11 01:42:08\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-15 04:37:11\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-07 11:49:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-09-30 06:51:35\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.1/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-15 10:30:34\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.21/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-14 12:13:04\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.30\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.30/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-10-01 12:16:29\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-11 11:26:05\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-15 02:57:28\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-08-09 12:26:21\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/6.1/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-10 18:05:47\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-10 18:05:12\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.12/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-11 19:49:47\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-06 09:43:42\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.1/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-11 12:48:55\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-10-30 08:43:36\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.1/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-08-01 21:21:06\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.6/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-10 18:05:14\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:6:\"5.3.14\";s:7:\"updated\";s:19:\"2019-10-13 15:35:35\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.3.14/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.34\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.34/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.8.6/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.21/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-04 23:05:35\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2021-07-03 18:41:33\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.22/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-09-11 15:51:48\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.12/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-15 08:46:22\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.1/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-13 17:31:17\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:3:\"6.1\";s:7:\"updated\";s:19:\"2022-11-01 09:56:00\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "no");

/* INSERT TABLE DATA: bdp_postmeta */
INSERT INTO `bdp_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `bdp_postmeta` VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO `bdp_postmeta` VALUES("3", "21", "_wp_attached_file", "2022/06/BDPRESTIGE-512-×-512-px.png");
INSERT INTO `bdp_postmeta` VALUES("4", "21", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:36:\"2022/06/BDPRESTIGE-512-×-512-px.png\";s:8:\"filesize\";i:13554;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:36:\"BDPRESTIGE-512-×-512-px-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9650;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:36:\"BDPRESTIGE-512-×-512-px-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4307;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bdp_postmeta` VALUES("5", "21", "_wp_attachment_image_alt", "Favicon-BDPrestige");
INSERT INTO `bdp_postmeta` VALUES("6", "22", "_wp_attached_file", "2022/06/cropped-BDPRESTIGE-512-×-512-px.png");
INSERT INTO `bdp_postmeta` VALUES("7", "22", "_wp_attachment_context", "site-icon");
INSERT INTO `bdp_postmeta` VALUES("8", "22", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:44:\"2022/06/cropped-BDPRESTIGE-512-×-512-px.png\";s:8:\"filesize\";i:13778;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:44:\"cropped-BDPRESTIGE-512-×-512-px-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9650;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:44:\"cropped-BDPRESTIGE-512-×-512-px-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4307;}s:13:\"site_icon-270\";a:5:{s:4:\"file\";s:44:\"cropped-BDPRESTIGE-512-×-512-px-270x270.png\";s:5:\"width\";i:270;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8542;}s:13:\"site_icon-192\";a:5:{s:4:\"file\";s:44:\"cropped-BDPRESTIGE-512-×-512-px-192x192.png\";s:5:\"width\";i:192;s:6:\"height\";i:192;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5954;}s:13:\"site_icon-180\";a:5:{s:4:\"file\";s:44:\"cropped-BDPRESTIGE-512-×-512-px-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5559;}s:12:\"site_icon-32\";a:5:{s:4:\"file\";s:42:\"cropped-BDPRESTIGE-512-×-512-px-32x32.png\";s:5:\"width\";i:32;s:6:\"height\";i:32;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:623;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bdp_postmeta` VALUES("11", "24", "_edit_lock", "1655125607:1");
INSERT INTO `bdp_postmeta` VALUES("12", "24", "_wp_page_template", "contact.php");
INSERT INTO `bdp_postmeta` VALUES("13", "27", "_edit_last", "1");
INSERT INTO `bdp_postmeta` VALUES("14", "27", "_edit_lock", "1655125716:1");
INSERT INTO `bdp_postmeta` VALUES("15", "28", "_wp_attached_file", "2022/06/Voiture-Site-2.png");
INSERT INTO `bdp_postmeta` VALUES("16", "28", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:480;s:6:\"height\";i:220;s:4:\"file\";s:26:\"2022/06/Voiture-Site-2.png\";s:8:\"filesize\";i:83530;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"Voiture-Site-2-300x138.png\";s:5:\"width\";i:300;s:6:\"height\";i:138;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:35300;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"Voiture-Site-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:23732;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bdp_postmeta` VALUES("17", "28", "_wp_attachment_image_alt", "Mercedes-A45S");
INSERT INTO `bdp_postmeta` VALUES("18", "27", "photo_classique", "28");
INSERT INTO `bdp_postmeta` VALUES("19", "27", "_photo_classique", "field_60296f18d3509");
INSERT INTO `bdp_postmeta` VALUES("20", "27", "video_voiture", "28");
INSERT INTO `bdp_postmeta` VALUES("21", "27", "_video_voiture", "field_5c9150f2ad5e2");
INSERT INTO `bdp_postmeta` VALUES("22", "27", "prix_test_drive", "1499");
INSERT INTO `bdp_postmeta` VALUES("23", "27", "_prix_test_drive", "field_5c914feac25b6");
INSERT INTO `bdp_postmeta` VALUES("24", "27", "prix_journee", "349");
INSERT INTO `bdp_postmeta` VALUES("25", "27", "_prix_journee", "field_5c915bab15cc7");
INSERT INTO `bdp_postmeta` VALUES("26", "27", "prix_wkend", "999");
INSERT INTO `bdp_postmeta` VALUES("27", "27", "_prix_wkend", "field_5c915bb915cc8");
INSERT INTO `bdp_postmeta` VALUES("28", "27", "marque_de_la_voiture", "Mercedes");
INSERT INTO `bdp_postmeta` VALUES("29", "27", "_marque_de_la_voiture", "field_5c914f81c25b4");
INSERT INTO `bdp_postmeta` VALUES("30", "27", "places", "5");
INSERT INTO `bdp_postmeta` VALUES("31", "27", "_places", "field_5c915147ad5e3");
INSERT INTO `bdp_postmeta` VALUES("32", "27", "boite_de_vitesse", "automatique");
INSERT INTO `bdp_postmeta` VALUES("33", "27", "_boite_de_vitesse", "field_5c915161ad5e4");
INSERT INTO `bdp_postmeta` VALUES("34", "27", "vitesse_max", "250");
INSERT INTO `bdp_postmeta` VALUES("35", "27", "_vitesse_max", "field_5c9151dbad5e5");
INSERT INTO `bdp_postmeta` VALUES("36", "27", "chevaux", "421");
INSERT INTO `bdp_postmeta` VALUES("37", "27", "_chevaux", "field_5c915aae15cc6");
INSERT INTO `bdp_postmeta` VALUES("38", "27", "formulaire_contact", "");
INSERT INTO `bdp_postmeta` VALUES("39", "27", "_formulaire_contact", "field_5c915c8d15cca");
INSERT INTO `bdp_postmeta` VALUES("40", "27", "photo-gallery-1", "");
INSERT INTO `bdp_postmeta` VALUES("41", "27", "_photo-gallery-1", "field_5d8b566efc2ef");
INSERT INTO `bdp_postmeta` VALUES("42", "27", "photo-gallery-2", "");
INSERT INTO `bdp_postmeta` VALUES("43", "27", "_photo-gallery-2", "field_5d8b7bc6fd7e0");
INSERT INTO `bdp_postmeta` VALUES("44", "27", "photo-gallery-3", "");
INSERT INTO `bdp_postmeta` VALUES("45", "27", "_photo-gallery-3", "field_5d8b7be4fd7e1");
INSERT INTO `bdp_postmeta` VALUES("46", "27", "photo-gallery-4", "");
INSERT INTO `bdp_postmeta` VALUES("47", "27", "_photo-gallery-4", "field_5d8b7becfd7e2");
INSERT INTO `bdp_postmeta` VALUES("48", "29", "photo_classique", "28");
INSERT INTO `bdp_postmeta` VALUES("49", "29", "_photo_classique", "field_60296f18d3509");
INSERT INTO `bdp_postmeta` VALUES("50", "29", "video_voiture", "28");
INSERT INTO `bdp_postmeta` VALUES("51", "29", "_video_voiture", "field_5c9150f2ad5e2");
INSERT INTO `bdp_postmeta` VALUES("52", "29", "prix_test_drive", "1499");
INSERT INTO `bdp_postmeta` VALUES("53", "29", "_prix_test_drive", "field_5c914feac25b6");
INSERT INTO `bdp_postmeta` VALUES("54", "29", "prix_journee", "349");
INSERT INTO `bdp_postmeta` VALUES("55", "29", "_prix_journee", "field_5c915bab15cc7");
INSERT INTO `bdp_postmeta` VALUES("56", "29", "prix_wkend", "999");
INSERT INTO `bdp_postmeta` VALUES("57", "29", "_prix_wkend", "field_5c915bb915cc8");
INSERT INTO `bdp_postmeta` VALUES("58", "29", "marque_de_la_voiture", "Mercedes");
INSERT INTO `bdp_postmeta` VALUES("59", "29", "_marque_de_la_voiture", "field_5c914f81c25b4");
INSERT INTO `bdp_postmeta` VALUES("60", "29", "places", "5");
INSERT INTO `bdp_postmeta` VALUES("61", "29", "_places", "field_5c915147ad5e3");
INSERT INTO `bdp_postmeta` VALUES("62", "29", "boite_de_vitesse", "automatique");
INSERT INTO `bdp_postmeta` VALUES("63", "29", "_boite_de_vitesse", "field_5c915161ad5e4");
INSERT INTO `bdp_postmeta` VALUES("64", "29", "vitesse_max", "250");
INSERT INTO `bdp_postmeta` VALUES("65", "29", "_vitesse_max", "field_5c9151dbad5e5");
INSERT INTO `bdp_postmeta` VALUES("66", "29", "chevaux", "421");
INSERT INTO `bdp_postmeta` VALUES("67", "29", "_chevaux", "field_5c915aae15cc6");
INSERT INTO `bdp_postmeta` VALUES("68", "29", "formulaire_contact", "");
INSERT INTO `bdp_postmeta` VALUES("69", "29", "_formulaire_contact", "field_5c915c8d15cca");
INSERT INTO `bdp_postmeta` VALUES("70", "29", "photo-gallery-1", "");
INSERT INTO `bdp_postmeta` VALUES("71", "29", "_photo-gallery-1", "field_5d8b566efc2ef");
INSERT INTO `bdp_postmeta` VALUES("72", "29", "photo-gallery-2", "");
INSERT INTO `bdp_postmeta` VALUES("73", "29", "_photo-gallery-2", "field_5d8b7bc6fd7e0");
INSERT INTO `bdp_postmeta` VALUES("74", "29", "photo-gallery-3", "");
INSERT INTO `bdp_postmeta` VALUES("75", "29", "_photo-gallery-3", "field_5d8b7be4fd7e1");
INSERT INTO `bdp_postmeta` VALUES("76", "29", "photo-gallery-4", "");
INSERT INTO `bdp_postmeta` VALUES("77", "29", "_photo-gallery-4", "field_5d8b7becfd7e2");
INSERT INTO `bdp_postmeta` VALUES("78", "30", "_edit_last", "1");
INSERT INTO `bdp_postmeta` VALUES("79", "30", "_edit_lock", "1655125786:1");
INSERT INTO `bdp_postmeta` VALUES("80", "31", "_wp_attached_file", "2022/06/Voiture-Site-1.png");
INSERT INTO `bdp_postmeta` VALUES("81", "31", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:480;s:6:\"height\";i:220;s:4:\"file\";s:26:\"2022/06/Voiture-Site-1.png\";s:8:\"filesize\";i:82106;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"Voiture-Site-1-300x138.png\";s:5:\"width\";i:300;s:6:\"height\";i:138;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:35472;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"Voiture-Site-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:25689;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bdp_postmeta` VALUES("82", "31", "_wp_attachment_image_alt", "Audi-RS3");
INSERT INTO `bdp_postmeta` VALUES("83", "30", "photo_classique", "31");
INSERT INTO `bdp_postmeta` VALUES("84", "30", "_photo_classique", "field_60296f18d3509");
INSERT INTO `bdp_postmeta` VALUES("85", "30", "video_voiture", "31");
INSERT INTO `bdp_postmeta` VALUES("86", "30", "_video_voiture", "field_5c9150f2ad5e2");
INSERT INTO `bdp_postmeta` VALUES("87", "30", "prix_test_drive", "1490");
INSERT INTO `bdp_postmeta` VALUES("88", "30", "_prix_test_drive", "field_5c914feac25b6");
INSERT INTO `bdp_postmeta` VALUES("89", "30", "prix_journee", "349");
INSERT INTO `bdp_postmeta` VALUES("90", "30", "_prix_journee", "field_5c915bab15cc7");
INSERT INTO `bdp_postmeta` VALUES("91", "30", "prix_wkend", "990");
INSERT INTO `bdp_postmeta` VALUES("92", "30", "_prix_wkend", "field_5c915bb915cc8");
INSERT INTO `bdp_postmeta` VALUES("93", "30", "marque_de_la_voiture", "Audi");
INSERT INTO `bdp_postmeta` VALUES("94", "30", "_marque_de_la_voiture", "field_5c914f81c25b4");
INSERT INTO `bdp_postmeta` VALUES("95", "30", "places", "5");
INSERT INTO `bdp_postmeta` VALUES("96", "30", "_places", "field_5c915147ad5e3");
INSERT INTO `bdp_postmeta` VALUES("97", "30", "boite_de_vitesse", "automatique");
INSERT INTO `bdp_postmeta` VALUES("98", "30", "_boite_de_vitesse", "field_5c915161ad5e4");
INSERT INTO `bdp_postmeta` VALUES("99", "30", "vitesse_max", "250");
INSERT INTO `bdp_postmeta` VALUES("100", "30", "_vitesse_max", "field_5c9151dbad5e5");
INSERT INTO `bdp_postmeta` VALUES("101", "30", "chevaux", "400");
INSERT INTO `bdp_postmeta` VALUES("102", "30", "_chevaux", "field_5c915aae15cc6");
INSERT INTO `bdp_postmeta` VALUES("103", "30", "formulaire_contact", "");
INSERT INTO `bdp_postmeta` VALUES("104", "30", "_formulaire_contact", "field_5c915c8d15cca");
INSERT INTO `bdp_postmeta` VALUES("105", "30", "photo-gallery-1", "");
INSERT INTO `bdp_postmeta` VALUES("106", "30", "_photo-gallery-1", "field_5d8b566efc2ef");
INSERT INTO `bdp_postmeta` VALUES("107", "30", "photo-gallery-2", "");
INSERT INTO `bdp_postmeta` VALUES("108", "30", "_photo-gallery-2", "field_5d8b7bc6fd7e0");
INSERT INTO `bdp_postmeta` VALUES("109", "30", "photo-gallery-3", "");
INSERT INTO `bdp_postmeta` VALUES("110", "30", "_photo-gallery-3", "field_5d8b7be4fd7e1");
INSERT INTO `bdp_postmeta` VALUES("111", "30", "photo-gallery-4", "");
INSERT INTO `bdp_postmeta` VALUES("112", "30", "_photo-gallery-4", "field_5d8b7becfd7e2");
INSERT INTO `bdp_postmeta` VALUES("113", "32", "photo_classique", "31");
INSERT INTO `bdp_postmeta` VALUES("114", "32", "_photo_classique", "field_60296f18d3509");
INSERT INTO `bdp_postmeta` VALUES("115", "32", "video_voiture", "31");
INSERT INTO `bdp_postmeta` VALUES("116", "32", "_video_voiture", "field_5c9150f2ad5e2");
INSERT INTO `bdp_postmeta` VALUES("117", "32", "prix_test_drive", "1490");
INSERT INTO `bdp_postmeta` VALUES("118", "32", "_prix_test_drive", "field_5c914feac25b6");
INSERT INTO `bdp_postmeta` VALUES("119", "32", "prix_journee", "349");
INSERT INTO `bdp_postmeta` VALUES("120", "32", "_prix_journee", "field_5c915bab15cc7");
INSERT INTO `bdp_postmeta` VALUES("121", "32", "prix_wkend", "990");
INSERT INTO `bdp_postmeta` VALUES("122", "32", "_prix_wkend", "field_5c915bb915cc8");
INSERT INTO `bdp_postmeta` VALUES("123", "32", "marque_de_la_voiture", "Audi");
INSERT INTO `bdp_postmeta` VALUES("124", "32", "_marque_de_la_voiture", "field_5c914f81c25b4");
INSERT INTO `bdp_postmeta` VALUES("125", "32", "places", "5");
INSERT INTO `bdp_postmeta` VALUES("126", "32", "_places", "field_5c915147ad5e3");
INSERT INTO `bdp_postmeta` VALUES("127", "32", "boite_de_vitesse", "automatique");
INSERT INTO `bdp_postmeta` VALUES("128", "32", "_boite_de_vitesse", "field_5c915161ad5e4");
INSERT INTO `bdp_postmeta` VALUES("129", "32", "vitesse_max", "250");
INSERT INTO `bdp_postmeta` VALUES("130", "32", "_vitesse_max", "field_5c9151dbad5e5");
INSERT INTO `bdp_postmeta` VALUES("131", "32", "chevaux", "400");
INSERT INTO `bdp_postmeta` VALUES("132", "32", "_chevaux", "field_5c915aae15cc6");
INSERT INTO `bdp_postmeta` VALUES("133", "32", "formulaire_contact", "");
INSERT INTO `bdp_postmeta` VALUES("134", "32", "_formulaire_contact", "field_5c915c8d15cca");
INSERT INTO `bdp_postmeta` VALUES("135", "32", "photo-gallery-1", "");
INSERT INTO `bdp_postmeta` VALUES("136", "32", "_photo-gallery-1", "field_5d8b566efc2ef");
INSERT INTO `bdp_postmeta` VALUES("137", "32", "photo-gallery-2", "");
INSERT INTO `bdp_postmeta` VALUES("138", "32", "_photo-gallery-2", "field_5d8b7bc6fd7e0");
INSERT INTO `bdp_postmeta` VALUES("139", "32", "photo-gallery-3", "");
INSERT INTO `bdp_postmeta` VALUES("140", "32", "_photo-gallery-3", "field_5d8b7be4fd7e1");
INSERT INTO `bdp_postmeta` VALUES("141", "32", "photo-gallery-4", "");
INSERT INTO `bdp_postmeta` VALUES("142", "32", "_photo-gallery-4", "field_5d8b7becfd7e2");
INSERT INTO `bdp_postmeta` VALUES("143", "33", "_edit_last", "1");
INSERT INTO `bdp_postmeta` VALUES("144", "33", "_edit_lock", "1655125905:1");
INSERT INTO `bdp_postmeta` VALUES("145", "34", "_wp_attached_file", "2022/06/Voiture-Site-6.png");
INSERT INTO `bdp_postmeta` VALUES("146", "34", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:480;s:6:\"height\";i:220;s:4:\"file\";s:26:\"2022/06/Voiture-Site-6.png\";s:8:\"filesize\";i:115765;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"Voiture-Site-6-300x138.png\";s:5:\"width\";i:300;s:6:\"height\";i:138;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:49283;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"Voiture-Site-6-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:34003;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `bdp_postmeta` VALUES("147", "34", "_wp_attachment_image_alt", "Audi-RSQ3");
INSERT INTO `bdp_postmeta` VALUES("148", "33", "photo_classique", "34");
INSERT INTO `bdp_postmeta` VALUES("149", "33", "_photo_classique", "field_60296f18d3509");
INSERT INTO `bdp_postmeta` VALUES("150", "33", "video_voiture", "34");
INSERT INTO `bdp_postmeta` VALUES("151", "33", "_video_voiture", "field_5c9150f2ad5e2");
INSERT INTO `bdp_postmeta` VALUES("152", "33", "prix_test_drive", "2200");
INSERT INTO `bdp_postmeta` VALUES("153", "33", "_prix_test_drive", "field_5c914feac25b6");
INSERT INTO `bdp_postmeta` VALUES("154", "33", "prix_journee", "400");
INSERT INTO `bdp_postmeta` VALUES("155", "33", "_prix_journee", "field_5c915bab15cc7");
INSERT INTO `bdp_postmeta` VALUES("156", "33", "prix_wkend", "1200");
INSERT INTO `bdp_postmeta` VALUES("157", "33", "_prix_wkend", "field_5c915bb915cc8");
INSERT INTO `bdp_postmeta` VALUES("158", "33", "marque_de_la_voiture", "Audi");
INSERT INTO `bdp_postmeta` VALUES("159", "33", "_marque_de_la_voiture", "field_5c914f81c25b4");
INSERT INTO `bdp_postmeta` VALUES("160", "33", "places", "5");
INSERT INTO `bdp_postmeta` VALUES("161", "33", "_places", "field_5c915147ad5e3");
INSERT INTO `bdp_postmeta` VALUES("162", "33", "boite_de_vitesse", "automatique");
INSERT INTO `bdp_postmeta` VALUES("163", "33", "_boite_de_vitesse", "field_5c915161ad5e4");
INSERT INTO `bdp_postmeta` VALUES("164", "33", "vitesse_max", "320");
INSERT INTO `bdp_postmeta` VALUES("165", "33", "_vitesse_max", "field_5c9151dbad5e5");
INSERT INTO `bdp_postmeta` VALUES("166", "33", "chevaux", "400");
INSERT INTO `bdp_postmeta` VALUES("167", "33", "_chevaux", "field_5c915aae15cc6");
INSERT INTO `bdp_postmeta` VALUES("168", "33", "formulaire_contact", "");
INSERT INTO `bdp_postmeta` VALUES("169", "33", "_formulaire_contact", "field_5c915c8d15cca");
INSERT INTO `bdp_postmeta` VALUES("170", "33", "photo-gallery-1", "");
INSERT INTO `bdp_postmeta` VALUES("171", "33", "_photo-gallery-1", "field_5d8b566efc2ef");
INSERT INTO `bdp_postmeta` VALUES("172", "33", "photo-gallery-2", "");
INSERT INTO `bdp_postmeta` VALUES("173", "33", "_photo-gallery-2", "field_5d8b7bc6fd7e0");
INSERT INTO `bdp_postmeta` VALUES("174", "33", "photo-gallery-3", "");
INSERT INTO `bdp_postmeta` VALUES("175", "33", "_photo-gallery-3", "field_5d8b7be4fd7e1");
INSERT INTO `bdp_postmeta` VALUES("176", "33", "photo-gallery-4", "");
INSERT INTO `bdp_postmeta` VALUES("177", "33", "_photo-gallery-4", "field_5d8b7becfd7e2");
INSERT INTO `bdp_postmeta` VALUES("178", "35", "photo_classique", "34");
INSERT INTO `bdp_postmeta` VALUES("179", "35", "_photo_classique", "field_60296f18d3509");
INSERT INTO `bdp_postmeta` VALUES("180", "35", "video_voiture", "34");
INSERT INTO `bdp_postmeta` VALUES("181", "35", "_video_voiture", "field_5c9150f2ad5e2");
INSERT INTO `bdp_postmeta` VALUES("182", "35", "prix_test_drive", "2200");
INSERT INTO `bdp_postmeta` VALUES("183", "35", "_prix_test_drive", "field_5c914feac25b6");
INSERT INTO `bdp_postmeta` VALUES("184", "35", "prix_journee", "400");
INSERT INTO `bdp_postmeta` VALUES("185", "35", "_prix_journee", "field_5c915bab15cc7");
INSERT INTO `bdp_postmeta` VALUES("186", "35", "prix_wkend", "1200");
INSERT INTO `bdp_postmeta` VALUES("187", "35", "_prix_wkend", "field_5c915bb915cc8");
INSERT INTO `bdp_postmeta` VALUES("188", "35", "marque_de_la_voiture", "Audi");
INSERT INTO `bdp_postmeta` VALUES("189", "35", "_marque_de_la_voiture", "field_5c914f81c25b4");
INSERT INTO `bdp_postmeta` VALUES("190", "35", "places", "5");
INSERT INTO `bdp_postmeta` VALUES("191", "35", "_places", "field_5c915147ad5e3");
INSERT INTO `bdp_postmeta` VALUES("192", "35", "boite_de_vitesse", "automatique");
INSERT INTO `bdp_postmeta` VALUES("193", "35", "_boite_de_vitesse", "field_5c915161ad5e4");
INSERT INTO `bdp_postmeta` VALUES("194", "35", "vitesse_max", "320");
INSERT INTO `bdp_postmeta` VALUES("195", "35", "_vitesse_max", "field_5c9151dbad5e5");
INSERT INTO `bdp_postmeta` VALUES("196", "35", "chevaux", "400");
INSERT INTO `bdp_postmeta` VALUES("197", "35", "_chevaux", "field_5c915aae15cc6");
INSERT INTO `bdp_postmeta` VALUES("198", "35", "formulaire_contact", "");
INSERT INTO `bdp_postmeta` VALUES("199", "35", "_formulaire_contact", "field_5c915c8d15cca");
INSERT INTO `bdp_postmeta` VALUES("200", "35", "photo-gallery-1", "");
INSERT INTO `bdp_postmeta` VALUES("201", "35", "_photo-gallery-1", "field_5d8b566efc2ef");
INSERT INTO `bdp_postmeta` VALUES("202", "35", "photo-gallery-2", "");
INSERT INTO `bdp_postmeta` VALUES("203", "35", "_photo-gallery-2", "field_5d8b7bc6fd7e0");
INSERT INTO `bdp_postmeta` VALUES("204", "35", "photo-gallery-3", "");
INSERT INTO `bdp_postmeta` VALUES("205", "35", "_photo-gallery-3", "field_5d8b7be4fd7e1");
INSERT INTO `bdp_postmeta` VALUES("206", "35", "photo-gallery-4", "");
INSERT INTO `bdp_postmeta` VALUES("207", "35", "_photo-gallery-4", "field_5d8b7becfd7e2");
INSERT INTO `bdp_postmeta` VALUES("208", "22", "_oembed_f710c328712d2b792b983410b61e54ad", "{{unknown}}");

/* INSERT TABLE DATA: bdp_posts */
INSERT INTO `bdp_posts` VALUES("1", "1", "2022-06-13 14:41:33", "2022-06-13 12:41:33", "<!-- wp:paragraph -->\n<p>Bienvenue sur WordPress. Ceci est votre premier article. Modifiez-le ou supprimez-le, puis commencez à écrire !</p>\n<!-- /wp:paragraph -->", "Bonjour tout le monde !", "", "publish", "open", "open", "", "bonjour-tout-le-monde", "", "", "2022-06-13 14:41:33", "2022-06-13 12:41:33", "", "0", "http://yomi-avis.fr/?p=1", "0", "post", "", "1");
INSERT INTO `bdp_posts` VALUES("2", "1", "2022-06-13 14:41:33", "2022-06-13 12:41:33", "<!-- wp:paragraph -->\n<p>Ceci est une page d’exemple. C’est différent d’un article de blog parce qu’elle restera au même endroit et apparaîtra dans la navigation de votre site (dans la plupart des thèmes). La plupart des gens commencent par une page « À propos » qui les présente aux personnes visitant le site. Cela pourrait ressembler à quelque chose comme cela :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>Bonjour ! Je suis un mécanicien qui aspire à devenir acteur, et voici mon site. J’habite à Bordeaux, j’ai un super chien baptisé Russell, et j’aime la vodka (ainsi qu’être surpris par la pluie soudaine lors de longues balades sur la plage au coucher du soleil).</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>…ou quelque chose comme cela :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>La société 123 Machin Truc a été créée en 1971, et n’a cessé de proposer au public des machins-trucs de qualité depuis lors. Située à Saint-Remy-en-Bouzemont-Saint-Genest-et-Isson, 123 Machin Truc emploie 2 000 personnes, et fabrique toutes sortes de bidules supers pour la communauté bouzemontoise.</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>En tant que nouvel utilisateur ou utilisatrice de WordPress, vous devriez vous rendre sur <a href=\"http://yomi-avis.fr/wp-admin/\">votre tableau de bord</a> pour supprimer cette page et créer de nouvelles pages pour votre contenu. Amusez-vous bien !</p>\n<!-- /wp:paragraph -->", "Page d’exemple", "", "publish", "closed", "open", "", "page-d-exemple", "", "", "2022-06-13 14:41:33", "2022-06-13 12:41:33", "", "0", "http://yomi-avis.fr/?page_id=2", "0", "page", "", "0");
INSERT INTO `bdp_posts` VALUES("3", "1", "2022-06-13 14:41:33", "2022-06-13 12:41:33", "<!-- wp:heading --><h2>Qui sommes-nous ?</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>L’adresse de notre site est : http://bdprestige.fr.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Commentaires</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Quand vous laissez un commentaire sur notre site, les données inscrites dans le formulaire de commentaire, ainsi que votre adresse IP et l’agent utilisateur de votre navigateur sont collectés pour nous aider à la détection des commentaires indésirables.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Une chaîne anonymisée créée à partir de votre adresse e-mail (également appelée hash) peut être envoyée au service Gravatar pour vérifier si vous utilisez ce dernier. Les clauses de confidentialité du service Gravatar sont disponibles ici : https://automattic.com/privacy/. Après validation de votre commentaire, votre photo de profil sera visible publiquement à coté de votre commentaire.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Médias</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous téléversez des images sur le site, nous vous conseillons d’éviter de téléverser des images contenant des données EXIF de coordonnées GPS. Les personnes visitant votre site peuvent télécharger et extraire des données de localisation depuis ces images.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Cookies</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous déposez un commentaire sur notre site, il vous sera proposé d’enregistrer votre nom, adresse e-mail et site dans des cookies. C’est uniquement pour votre confort afin de ne pas avoir à saisir ces informations si vous déposez un autre commentaire plus tard. Ces cookies expirent au bout d’un an.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Si vous vous rendez sur la page de connexion, un cookie temporaire sera créé afin de déterminer si votre navigateur accepte les cookies. Il ne contient pas de données personnelles et sera supprimé automatiquement à la fermeture de votre navigateur.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorsque vous vous connecterez, nous mettrons en place un certain nombre de cookies pour enregistrer vos informations de connexion et vos préférences d’écran. La durée de vie d’un cookie de connexion est de deux jours, celle d’un cookie d’option d’écran est d’un an. Si vous cochez « Se souvenir de moi », votre cookie de connexion sera conservé pendant deux semaines. Si vous vous déconnectez de votre compte, le cookie de connexion sera effacé.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>En modifiant ou en publiant une publication, un cookie supplémentaire sera enregistré dans votre navigateur. Ce cookie ne comprend aucune donnée personnelle. Il indique simplement l’ID de la publication que vous venez de modifier. Il expire au bout d’un jour.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Contenu embarqué depuis d’autres sites</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Les articles de ce site peuvent inclure des contenus intégrés (par exemple des vidéos, images, articles…). Le contenu intégré depuis d’autres sites se comporte de la même manière que si le visiteur se rendait sur cet autre site.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Ces sites web pourraient collecter des données sur vous, utiliser des cookies, embarquer des outils de suivis tiers, suivre vos interactions avec ces contenus embarqués si vous disposez d’un compte connecté sur leur site web.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Utilisation et transmission de vos données personnelles</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous demandez une réinitialisation de votre mot de passe, votre adresse IP sera incluse dans l’e-mail de réinitialisation.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Durées de stockage de vos données</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous laissez un commentaire, le commentaire et ses métadonnées sont conservés indéfiniment. Cela permet de reconnaître et approuver automatiquement les commentaires suivants au lieu de les laisser dans la file de modération.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Pour les comptes qui s’inscrivent sur notre site (le cas échéant), nous stockons également les données personnelles indiquées dans leur profil. Tous les comptes peuvent voir, modifier ou supprimer leurs informations personnelles à tout moment (à l’exception de leur identifiant). Les gestionnaires du site peuvent aussi voir et modifier ces informations.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Les droits que vous avez sur vos données</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous avez un compte ou si vous avez laissé des commentaires sur le site, vous pouvez demander à recevoir un fichier contenant toutes les données personnelles que nous possédons à votre sujet, incluant celles que vous nous avez fournies. Vous pouvez également demander la suppression des données personnelles vous concernant. Cela ne prend pas en compte les données stockées à des fins administratives, légales ou pour des raisons de sécurité.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Transmission de vos données personnelles</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Les commentaires des visiteurs peuvent être vérifiés à l’aide d’un service automatisé de détection des commentaires indésirables.</p><!-- /wp:paragraph -->", "Politique de confidentialité", "", "draft", "closed", "open", "", "politique-de-confidentialite", "", "", "2022-06-13 14:41:33", "2022-06-13 12:41:33", "", "0", "http://yomi-avis.fr/?page_id=3", "0", "page", "", "0");
INSERT INTO `bdp_posts` VALUES("5", "1", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "a:8:{s:8:\"location\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"param\";s:9:\"post_type\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:7:\"voiture\";}}}s:8:\"position\";s:6:\"normal\";s:5:\"style\";s:7:\"default\";s:15:\"label_placement\";s:3:\"top\";s:21:\"instruction_placement\";s:5:\"label\";s:14:\"hide_on_screen\";a:9:{i:0;s:7:\"excerpt\";i:1;s:10:\"discussion\";i:2;s:8:\"comments\";i:3;s:9:\"revisions\";i:4;s:6:\"author\";i:5;s:6:\"format\";i:6;s:14:\"featured_image\";i:7;s:10:\"categories\";i:8;s:15:\"send-trackbacks\";}s:11:\"description\";s:0:\"\";s:12:\"show_in_rest\";b:0;}", "voiture", "voiture", "publish", "closed", "closed", "", "group_5c914f77bea17", "", "", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "", "0", "http://yomi-avis.fr/?p=5", "1", "acf-field-group", "", "0");
INSERT INTO `bdp_posts` VALUES("6", "1", "2022-06-13 14:43:14", "2022-06-13 12:43:14", "a:15:{s:4:\"type\";s:5:\"image\";s:12:\"instructions\";s:18:\"La photo de profil\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"return_format\";s:5:\"array\";s:12:\"preview_size\";s:9:\"thumbnail\";s:7:\"library\";s:3:\"all\";s:9:\"min_width\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:8:\"min_size\";s:0:\"\";s:9:\"max_width\";s:0:\"\";s:10:\"max_height\";s:0:\"\";s:8:\"max_size\";s:0:\"\";s:10:\"mime_types\";s:0:\"\";}", "photo classique", "photo_classique", "publish", "closed", "closed", "", "field_60296f18d3509", "", "", "2022-06-13 14:43:14", "2022-06-13 12:43:14", "", "5", "http://yomi-avis.fr/?post_type=acf-field&p=6", "0", "acf-field", "", "0");
INSERT INTO `bdp_posts` VALUES("7", "1", "2022-06-13 14:43:14", "2022-06-13 12:43:14", "a:15:{s:4:\"type\";s:5:\"image\";s:12:\"instructions\";s:40:\"video de la voiture pour la page produit\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"return_format\";s:3:\"url\";s:12:\"preview_size\";s:9:\"thumbnail\";s:7:\"library\";s:3:\"all\";s:9:\"min_width\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:8:\"min_size\";s:0:\"\";s:9:\"max_width\";s:0:\"\";s:10:\"max_height\";s:0:\"\";s:8:\"max_size\";s:0:\"\";s:10:\"mime_types\";s:0:\"\";}", "photo de couverture voiture", "video_voiture", "publish", "closed", "closed", "", "field_5c9150f2ad5e2", "", "", "2022-06-13 14:43:14", "2022-06-13 12:43:14", "", "5", "http://yomi-avis.fr/?post_type=acf-field&p=7", "1", "acf-field", "", "0");
INSERT INTO `bdp_posts` VALUES("8", "1", "2022-06-13 14:43:14", "2022-06-13 12:43:14", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";i:49;s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "Semaine 7j", "prix_test_drive", "publish", "closed", "closed", "", "field_5c914feac25b6", "", "", "2022-06-13 14:43:14", "2022-06-13 12:43:14", "", "5", "http://yomi-avis.fr/?post_type=acf-field&p=8", "2", "acf-field", "", "0");
INSERT INTO `bdp_posts` VALUES("9", "1", "2022-06-13 14:43:14", "2022-06-13 12:43:14", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "prix journée", "prix_journee", "publish", "closed", "closed", "", "field_5c915bab15cc7", "", "", "2022-06-13 14:43:14", "2022-06-13 12:43:14", "", "5", "http://yomi-avis.fr/?post_type=acf-field&p=9", "3", "acf-field", "", "0");
INSERT INTO `bdp_posts` VALUES("10", "1", "2022-06-13 14:43:14", "2022-06-13 12:43:14", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "prix week end", "prix_wkend", "publish", "closed", "closed", "", "field_5c915bb915cc8", "", "", "2022-06-13 14:43:14", "2022-06-13 12:43:14", "", "5", "http://yomi-avis.fr/?post_type=acf-field&p=10", "4", "acf-field", "", "0");
INSERT INTO `bdp_posts` VALUES("11", "1", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "Marque de la voiture", "marque_de_la_voiture", "publish", "closed", "closed", "", "field_5c914f81c25b4", "", "", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "", "5", "http://yomi-avis.fr/?post_type=acf-field&p=11", "5", "acf-field", "", "0");
INSERT INTO `bdp_posts` VALUES("12", "1", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:31:\"nombre de place dans la voiture\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";i:2;s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "places", "places", "publish", "closed", "closed", "", "field_5c915147ad5e3", "", "", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "", "5", "http://yomi-avis.fr/?post_type=acf-field&p=12", "6", "acf-field", "", "0");
INSERT INTO `bdp_posts` VALUES("13", "1", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "a:13:{s:4:\"type\";s:6:\"select\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:7:\"choices\";a:2:{s:8:\"Manuelle\";s:8:\"Manuelle\";s:11:\"automatique\";s:11:\"automatique\";}s:13:\"default_value\";b:0;s:10:\"allow_null\";i:0;s:8:\"multiple\";i:0;s:2:\"ui\";i:0;s:13:\"return_format\";s:5:\"value\";s:4:\"ajax\";i:0;s:11:\"placeholder\";s:0:\"\";}", "boite de vitesse", "boite_de_vitesse", "publish", "closed", "closed", "", "field_5c915161ad5e4", "", "", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "", "5", "http://yomi-avis.fr/?post_type=acf-field&p=13", "7", "acf-field", "", "0");
INSERT INTO `bdp_posts` VALUES("14", "1", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "vitesse max", "vitesse_max", "publish", "closed", "closed", "", "field_5c9151dbad5e5", "", "", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "", "5", "http://yomi-avis.fr/?post_type=acf-field&p=14", "8", "acf-field", "", "0");
INSERT INTO `bdp_posts` VALUES("15", "1", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "chevaux", "chevaux", "publish", "closed", "closed", "", "field_5c915aae15cc6", "", "", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "", "5", "http://yomi-avis.fr/?post_type=acf-field&p=15", "9", "acf-field", "", "0");
INSERT INTO `bdp_posts` VALUES("16", "1", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "a:10:{s:4:\"type\";s:7:\"wysiwyg\";s:12:\"instructions\";s:37:\"rentre l\'id du forumulaire de contact\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:4:\"tabs\";s:3:\"all\";s:7:\"toolbar\";s:4:\"full\";s:12:\"media_upload\";i:1;s:5:\"delay\";i:0;}", "formulaire contact", "formulaire_contact", "publish", "closed", "closed", "", "field_5c915c8d15cca", "", "", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "", "5", "http://yomi-avis.fr/?post_type=acf-field&p=16", "10", "acf-field", "", "0");
INSERT INTO `bdp_posts` VALUES("17", "1", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "a:15:{s:4:\"type\";s:5:\"image\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"return_format\";s:2:\"id\";s:12:\"preview_size\";s:9:\"thumbnail\";s:7:\"library\";s:3:\"all\";s:9:\"min_width\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:8:\"min_size\";s:0:\"\";s:9:\"max_width\";s:0:\"\";s:10:\"max_height\";s:0:\"\";s:8:\"max_size\";s:0:\"\";s:10:\"mime_types\";s:0:\"\";}", "photo-gallery-1", "photo-gallery-1", "publish", "closed", "closed", "", "field_5d8b566efc2ef", "", "", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "", "5", "http://yomi-avis.fr/?post_type=acf-field&p=17", "11", "acf-field", "", "0");
INSERT INTO `bdp_posts` VALUES("18", "1", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "a:15:{s:4:\"type\";s:5:\"image\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"return_format\";s:2:\"id\";s:12:\"preview_size\";s:9:\"thumbnail\";s:7:\"library\";s:3:\"all\";s:9:\"min_width\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:8:\"min_size\";s:0:\"\";s:9:\"max_width\";s:0:\"\";s:10:\"max_height\";s:0:\"\";s:8:\"max_size\";s:0:\"\";s:10:\"mime_types\";s:0:\"\";}", "photo-gallery-2", "photo-gallery-2", "publish", "closed", "closed", "", "field_5d8b7bc6fd7e0", "", "", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "", "5", "http://yomi-avis.fr/?post_type=acf-field&p=18", "12", "acf-field", "", "0");
INSERT INTO `bdp_posts` VALUES("19", "1", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "a:15:{s:4:\"type\";s:5:\"image\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"return_format\";s:2:\"id\";s:12:\"preview_size\";s:9:\"thumbnail\";s:7:\"library\";s:3:\"all\";s:9:\"min_width\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:8:\"min_size\";s:0:\"\";s:9:\"max_width\";s:0:\"\";s:10:\"max_height\";s:0:\"\";s:8:\"max_size\";s:0:\"\";s:10:\"mime_types\";s:0:\"\";}", "photo-gallery-3", "photo-gallery-3", "publish", "closed", "closed", "", "field_5d8b7be4fd7e1", "", "", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "", "5", "http://yomi-avis.fr/?post_type=acf-field&p=19", "13", "acf-field", "", "0");
INSERT INTO `bdp_posts` VALUES("20", "1", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "a:15:{s:4:\"type\";s:5:\"image\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"return_format\";s:2:\"id\";s:12:\"preview_size\";s:9:\"thumbnail\";s:7:\"library\";s:3:\"all\";s:9:\"min_width\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:8:\"min_size\";s:0:\"\";s:9:\"max_width\";s:0:\"\";s:10:\"max_height\";s:0:\"\";s:8:\"max_size\";s:0:\"\";s:10:\"mime_types\";s:0:\"\";}", "photo-gallery-4", "photo-gallery-4", "publish", "closed", "closed", "", "field_5d8b7becfd7e2", "", "", "2022-06-13 14:43:15", "2022-06-13 12:43:15", "", "5", "http://yomi-avis.fr/?post_type=acf-field&p=20", "14", "acf-field", "", "0");
INSERT INTO `bdp_posts` VALUES("21", "1", "2022-06-13 15:08:23", "2022-06-13 13:08:23", "", "Favicon BDPrestige", "", "inherit", "open", "closed", "", "bdprestige-512-x-512-px", "", "", "2022-06-13 15:08:37", "2022-06-13 13:08:37", "", "0", "http://yomi-avis.fr/wp-content/uploads/2022/06/BDPRESTIGE-512-×-512-px.png", "0", "attachment", "image/png", "0");
INSERT INTO `bdp_posts` VALUES("22", "1", "2022-06-13 15:08:37", "2022-06-13 13:08:37", "http://yomi-avis.fr/wp-content/uploads/2022/06/cropped-BDPRESTIGE-512-×-512-px.png", "cropped-BDPRESTIGE-512-×-512-px.png", "", "inherit", "open", "closed", "", "cropped-bdprestige-512-x-512-px-png", "", "", "2022-06-13 15:08:37", "2022-06-13 13:08:37", "", "0", "http://yomi-avis.fr/wp-content/uploads/2022/06/cropped-BDPRESTIGE-512-×-512-px.png", "0", "attachment", "image/png", "0");
INSERT INTO `bdp_posts` VALUES("24", "1", "2022-06-13 15:09:09", "2022-06-13 13:09:09", "", "Contact", "", "publish", "closed", "closed", "", "contact", "", "", "2022-06-13 15:09:09", "2022-06-13 13:09:09", "", "0", "http://yomi-avis.fr/?page_id=24", "0", "page", "", "0");
INSERT INTO `bdp_posts` VALUES("25", "1", "2022-06-13 15:09:00", "2022-06-13 13:09:00", "{\"version\": 2, \"isGlobalStylesUserThemeJSON\": true }", "Custom Styles", "", "publish", "closed", "closed", "", "wp-global-styles-thememngt-modifable-copie%2fmngt-wp-theme-v4-mtp", "", "", "2022-06-13 15:09:00", "2022-06-13 13:09:00", "", "0", "http://yomi-avis.fr/wp-global-styles-thememngt-modifable-copie%2fmngt-wp-theme-v4-mtp/", "0", "wp_global_styles", "", "0");
INSERT INTO `bdp_posts` VALUES("26", "1", "2022-06-13 15:09:09", "2022-06-13 13:09:09", "", "Contact", "", "inherit", "closed", "closed", "", "24-revision-v1", "", "", "2022-06-13 15:09:09", "2022-06-13 13:09:09", "", "24", "http://yomi-avis.fr/?p=26", "0", "revision", "", "0");
INSERT INTO `bdp_posts` VALUES("27", "1", "2022-06-13 15:10:59", "2022-06-13 13:10:59", "", "A45S", "", "publish", "closed", "open", "", "a45s", "", "", "2022-06-13 15:10:59", "2022-06-13 13:10:59", "", "0", "http://yomi-avis.fr/?post_type=voiture&#038;p=27", "0", "voiture", "", "0");
INSERT INTO `bdp_posts` VALUES("28", "1", "2022-06-13 15:10:00", "2022-06-13 13:10:00", "", "Mercedes A45S", "", "inherit", "open", "closed", "", "voiture-site-2", "", "", "2022-06-13 15:10:11", "2022-06-13 13:10:11", "", "27", "http://yomi-avis.fr/wp-content/uploads/2022/06/Voiture-Site-2.png", "0", "attachment", "image/png", "0");
INSERT INTO `bdp_posts` VALUES("29", "1", "2022-06-13 15:10:59", "2022-06-13 13:10:59", "", "A45S", "", "inherit", "closed", "closed", "", "27-revision-v1", "", "", "2022-06-13 15:10:59", "2022-06-13 13:10:59", "", "27", "http://yomi-avis.fr/?p=29", "0", "revision", "", "0");
INSERT INTO `bdp_posts` VALUES("30", "1", "2022-06-13 15:12:05", "2022-06-13 13:12:05", "", "RS3", "", "publish", "closed", "open", "", "rs3", "", "", "2022-06-13 15:12:05", "2022-06-13 13:12:05", "", "0", "http://yomi-avis.fr/?post_type=voiture&#038;p=30", "0", "voiture", "", "0");
INSERT INTO `bdp_posts` VALUES("31", "1", "2022-06-13 15:11:27", "2022-06-13 13:11:27", "", "Audi RS3", "", "inherit", "open", "closed", "", "voiture-site-1", "", "", "2022-06-13 15:11:40", "2022-06-13 13:11:40", "", "30", "http://yomi-avis.fr/wp-content/uploads/2022/06/Voiture-Site-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `bdp_posts` VALUES("32", "1", "2022-06-13 15:12:05", "2022-06-13 13:12:05", "", "RS3", "", "inherit", "closed", "closed", "", "30-revision-v1", "", "", "2022-06-13 15:12:05", "2022-06-13 13:12:05", "", "30", "http://yomi-avis.fr/?p=32", "0", "revision", "", "0");
INSERT INTO `bdp_posts` VALUES("33", "1", "2022-06-13 15:14:07", "2022-06-13 13:14:07", "", "RSQ3", "", "publish", "closed", "open", "", "rsq3", "", "", "2022-06-13 15:14:07", "2022-06-13 13:14:07", "", "0", "http://yomi-avis.fr/?post_type=voiture&#038;p=33", "0", "voiture", "", "0");
INSERT INTO `bdp_posts` VALUES("34", "1", "2022-06-13 15:13:06", "2022-06-13 13:13:06", "", "Audi RSQ3", "", "inherit", "open", "closed", "", "voiture-site-6", "", "", "2022-06-13 15:13:18", "2022-06-13 13:13:18", "", "33", "http://yomi-avis.fr/wp-content/uploads/2022/06/Voiture-Site-6.png", "0", "attachment", "image/png", "0");
INSERT INTO `bdp_posts` VALUES("35", "1", "2022-06-13 15:14:07", "2022-06-13 13:14:07", "", "RSQ3", "", "inherit", "closed", "closed", "", "33-revision-v1", "", "", "2022-06-13 15:14:07", "2022-06-13 13:14:07", "", "33", "http://yomi-avis.fr/?p=35", "0", "revision", "", "0");

/* INSERT TABLE DATA: bdp_term_relationships */
INSERT INTO `bdp_term_relationships` VALUES("1", "1", "0");
INSERT INTO `bdp_term_relationships` VALUES("5", "1", "0");
INSERT INTO `bdp_term_relationships` VALUES("25", "2", "0");

/* INSERT TABLE DATA: bdp_term_taxonomy */
INSERT INTO `bdp_term_taxonomy` VALUES("1", "1", "category", "", "0", "1");
INSERT INTO `bdp_term_taxonomy` VALUES("2", "2", "wp_theme", "", "0", "1");

/* INSERT TABLE DATA: bdp_terms */
INSERT INTO `bdp_terms` VALUES("1", "Non classé", "non-classe", "0");
INSERT INTO `bdp_terms` VALUES("2", "theme mngt-MODIFABLE - Copie/mngt-wp-theme-v4-mtp", "theme-mngt-modifable-copie-mngt-wp-theme-v4-mtp", "0");

/* INSERT TABLE DATA: bdp_usermeta */
INSERT INTO `bdp_usermeta` VALUES("1", "1", "nickname", "pepeconcept");
INSERT INTO `bdp_usermeta` VALUES("2", "1", "first_name", "");
INSERT INTO `bdp_usermeta` VALUES("3", "1", "last_name", "");
INSERT INTO `bdp_usermeta` VALUES("4", "1", "description", "");
INSERT INTO `bdp_usermeta` VALUES("5", "1", "rich_editing", "true");
INSERT INTO `bdp_usermeta` VALUES("6", "1", "syntax_highlighting", "true");
INSERT INTO `bdp_usermeta` VALUES("7", "1", "comment_shortcuts", "false");
INSERT INTO `bdp_usermeta` VALUES("8", "1", "admin_color", "fresh");
INSERT INTO `bdp_usermeta` VALUES("9", "1", "use_ssl", "0");
INSERT INTO `bdp_usermeta` VALUES("10", "1", "show_admin_bar_front", "false");
INSERT INTO `bdp_usermeta` VALUES("11", "1", "locale", "");
INSERT INTO `bdp_usermeta` VALUES("12", "1", "bdp_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `bdp_usermeta` VALUES("13", "1", "bdp_user_level", "10");
INSERT INTO `bdp_usermeta` VALUES("14", "1", "dismissed_wp_pointers", "");
INSERT INTO `bdp_usermeta` VALUES("15", "1", "show_welcome_panel", "1");
INSERT INTO `bdp_usermeta` VALUES("16", "1", "session_tokens", "a:1:{s:64:\"9a3718c8e6ed9c3ca321cc98068a86d2c580548955641017224b3937ea5e649b\";a:4:{s:10:\"expiration\";i:1655296901;s:2:\"ip\";s:36:\"2a02:a03f:c981:0:bd62:459b:8d76:4f7c\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/102.0.0.0 Safari/537.36\";s:5:\"login\";i:1655124101;}}");
INSERT INTO `bdp_usermeta` VALUES("17", "1", "bdp_dashboard_quick_press_last_post_id", "4");
INSERT INTO `bdp_usermeta` VALUES("18", "1", "community-events-location", "a:1:{s:2:\"ip\";s:16:\"2a02:a03f:c981::\";}");
INSERT INTO `bdp_usermeta` VALUES("19", "1", "bdp_user-settings", "libraryContent=browse");
INSERT INTO `bdp_usermeta` VALUES("20", "1", "bdp_user-settings-time", "1655125719");

/* INSERT TABLE DATA: bdp_users */
INSERT INTO `bdp_users` VALUES("1", "pepeconcept", "$P$B04S52lBjZPSou2TZFDQyi4tLZpbOp1", "pepeconcept", "pepeconcept@gmail.com", "http://yomi-avis.fr", "2022-06-13 12:41:33", "", "0", "pepeconcept");

SET FOREIGN_KEY_CHECKS = 1; 

/* Duplicator WordPress Timestamp: 2023-04-25 17:28:54*/
/* DUPLICATOR_MYSQLDUMP_EOF */
